/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.biomes.metztli;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zollerngalaxy.biomes.metztli.BiomeHarranBase;
import zollerngalaxy.core.enums.EnumBiomeTypeZG;

public class BiomeHarranHills
extends BiomeHarranBase {
    private final WorldGenerator silverfishSpawner = new WorldGenMinable(Blocks.field_150418_aU.func_176223_P().func_177226_a((IProperty)BlockSilverfish.field_176378_a, (Comparable)BlockSilverfish.EnumType.STONE), 9);
    private final WorldGenTaiga2 spruceGenerator = new WorldGenTaiga2(false);

    public BiomeHarranHills(Biome.BiomeProperties props) {
        super("harran_hills", props);
        this.setupBiome(props);
    }

    public BiomeHarranHills(String singleName, Biome.BiomeProperties props) {
        super(singleName, props);
        this.setupBiome(props);
    }

    private void setupBiome(Biome.BiomeProperties props) {
        this.setTempCategory(Biome.TempCategory.MEDIUM);
        props.func_185398_c(2.6f);
        props.func_185400_d(0.2f);
        props.func_185410_a(5.6f);
        this.setTemp(34.0f);
        this.setBiomeHeight(128);
        this.setBiomeType(EnumBiomeTypeZG.LUSH);
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityLlama.class, 5, 4, 6));
        this.field_76766_R = true;
        this.biomeDecor.field_76808_K = true;
        this.biomeDecor.waterLakesPerChunk = 0;
        this.biomeDecor.lavaLakesPerChunk = 0;
        this.biomeDecor.field_76803_B = 4;
        this.biomeDecor.field_76802_A = 8;
        this.biomeDecor.field_76832_z = 1;
        grassFoliageColor = 35584;
        this.field_76759_H = 0x8B008B;
        this.field_76752_A = Blocks.field_150349_c.func_176223_P();
        this.field_76753_B = Blocks.field_150348_b.func_176223_P();
        this.stoneBlock = Blocks.field_150348_b;
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        return rand.nextInt(3) > 0 ? this.spruceGenerator : super.func_150567_a(rand);
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        super.func_180624_a(worldIn, rand, pos);
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Pre(worldIn, rand, pos));
        EmeraldGenerator emeralds = new EmeraldGenerator();
        if (TerrainGen.generateOre((World)worldIn, (Random)rand, (WorldGenerator)emeralds, (BlockPos)pos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.EMERALD)) {
            emeralds.func_180709_b(worldIn, rand, pos);
        }
        for (int j1 = 0; j1 < 7; ++j1) {
            int k1 = rand.nextInt(16);
            int l1 = rand.nextInt(64);
            int i2 = rand.nextInt(16);
            if (!TerrainGen.generateOre((World)worldIn, (Random)rand, (WorldGenerator)this.silverfishSpawner, (BlockPos)pos.func_177982_a(j1, k1, l1), (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.SILVERFISH)) continue;
            this.silverfishSpawner.func_180709_b(worldIn, rand, pos.func_177982_a(k1, l1, i2));
        }
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Post(worldIn, rand, pos));
    }

    @Override
    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        this.field_76752_A = Blocks.field_150349_c.func_176223_P();
        this.field_76753_B = Blocks.field_150346_d.func_176223_P();
        if (noiseVal < -1.0 || noiseVal > 2.0) {
            this.field_76752_A = Blocks.field_150351_n.func_176223_P();
            this.field_76753_B = Blocks.field_150351_n.func_176223_P();
        } else if (noiseVal > 1.0) {
            this.field_76752_A = Blocks.field_150348_b.func_176223_P();
            this.field_76753_B = Blocks.field_150348_b.func_176223_P();
        }
        this.generateMetztliTerrain(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float p_76731_1_) {
        return 14923;
    }

    private static class EmeraldGenerator
    extends WorldGenerator {
        private EmeraldGenerator() {
        }

        public boolean func_180709_b(World worldIn, Random rand, BlockPos pos) {
            int count = 3 + rand.nextInt(6);
            for (int i = 0; i < count; ++i) {
                int offset = ForgeModContainer.fixVanillaCascading ? 8 : 0;
                BlockPos blockpos = pos.func_177982_a(rand.nextInt(16) + offset, rand.nextInt(28) + 4, rand.nextInt(16) + offset);
                IBlockState state = worldIn.func_180495_p(blockpos);
                if (!state.func_177230_c().isReplaceableOreGen(state, (IBlockAccess)worldIn, blockpos, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b))) continue;
                worldIn.func_180501_a(blockpos, Blocks.field_150412_bA.func_176223_P(), 18);
            }
            return true;
        }
    }
}

