/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.biomes.metztli;

import java.util.Random;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraft.world.gen.feature.WorldGenBirchTree;
import net.minecraft.world.gen.feature.WorldGenCanopyTree;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zollerngalaxy.biomes.metztli.BiomeHarranBase;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.core.enums.EnumBiomeTypeZG;

public class BiomeHarranForest
extends BiomeHarranBase {
    protected static final IBlockState CHERRY_LOG = ZGBlocks.cherryWoodLog.func_176223_P();
    protected static final IBlockState CHERRY_LEAVES = ZGBlocks.cherryWoodLeaves.func_176223_P();
    protected static final WorldGenBirchTree SUPER_BIRCH_TREE = new WorldGenBirchTree(false, true);
    protected static final WorldGenBirchTree BIRCH_TREE = new WorldGenBirchTree(false, false);
    protected static final WorldGenCanopyTree ROOF_TREE = new WorldGenCanopyTree(false);
    protected static final WorldGenAbstractTree CHERRY_TREE = ZGBlocks.cherryWoodGen;
    private final Type type;

    public BiomeHarranForest(Type typeIn, Biome.BiomeProperties props) {
        super("harran_forest1", props);
        this.setupBiome(props, typeIn);
        this.type = typeIn;
    }

    public BiomeHarranForest(String singleName, Type typeIn, Biome.BiomeProperties props) {
        super(singleName, props);
        this.setupBiome(props, typeIn);
        this.type = typeIn;
    }

    private void setupBiome(Biome.BiomeProperties props, Type typeIn) {
        this.setTempCategory(Biome.TempCategory.MEDIUM);
        props.func_185398_c(0.6f);
        props.func_185400_d(0.2f);
        props.func_185410_a(5.6f);
        this.setTemp(24.0f);
        this.setBiomeHeight(18);
        this.setBiomeType(EnumBiomeTypeZG.FOREST);
        this.field_76766_R = false;
        this.biomeDecor.field_76808_K = true;
        this.biomeDecor.waterLakesPerChunk = 2;
        this.biomeDecor.lavaLakesPerChunk = 0;
        this.biomeDecor.field_76803_B = 8;
        this.biomeDecor.tallGrassPerChunk = 6;
        this.biomeDecor.field_76802_A = 4;
        if (typeIn == Type.CHERRY) {
            grassFoliageColor = 16204235;
            this.grassColor = 16204235;
            this.biomeDecor.field_76832_z = 75;
        } else {
            grassFoliageColor = 52224;
            this.grassColor = 52224;
            this.biomeDecor.field_76832_z = 10;
        }
        this.field_76759_H = 255;
        this.field_76752_A = typeIn != Type.CHERRY ? Blocks.field_150349_c.func_176223_P() : ZGBlocks.harranGrassCherry.func_176223_P();
        this.field_76753_B = typeIn != Type.CHERRY ? Blocks.field_150346_d.func_176223_P() : ZGBlocks.harranSoil.func_176223_P();
        this.stoneBlock = Blocks.field_150348_b;
        if (this.type == Type.FLOWER) {
            this.biomeDecor.field_76832_z = 6;
            this.biomeDecor.field_76802_A = 100;
            this.biomeDecor.field_76803_B = 1;
            this.field_76762_K.add(new Biome.SpawnListEntry(EntityRabbit.class, 4, 2, 3));
        }
        if (this.type == Type.NORMAL) {
            this.field_76762_K.add(new Biome.SpawnListEntry(EntityWolf.class, 5, 4, 4));
        }
        if (this.type == Type.ROOFED) {
            this.biomeDecor.field_76832_z = -999;
        }
        if (this.type == Type.FLOWER) {
            this.flowers.clear();
            for (BlockFlower.EnumFlowerType type : BlockFlower.EnumFlowerType.values()) {
                if (type.func_176964_a() == BlockFlower.EnumFlowerColor.YELLOW) continue;
                if (type == BlockFlower.EnumFlowerType.BLUE_ORCHID) {
                    type = BlockFlower.EnumFlowerType.POPPY;
                }
                this.addFlower(Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)type), 10);
            }
        }
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        if (this.type == Type.ROOFED && rand.nextInt(3) > 0) {
            return ROOF_TREE;
        }
        if (this.type != Type.BIRCH && rand.nextInt(5) != 0) {
            return rand.nextInt(5) == 0 ? field_76758_O : field_76757_N;
        }
        if (this.type == Type.CHERRY && rand.nextInt(3) == 0) {
            return CHERRY_TREE;
        }
        return BIRCH_TREE;
    }

    public BlockFlower.EnumFlowerType func_180623_a(Random rand, BlockPos pos) {
        if (this.type == Type.FLOWER) {
            double d0 = MathHelper.func_151237_a((double)((1.0 + field_180281_af.func_151601_a((double)pos.func_177958_n() / 48.0, (double)pos.func_177952_p() / 48.0)) / 2.0), (double)0.0, (double)0.9999);
            BlockFlower.EnumFlowerType blockflower$enumflowertype = BlockFlower.EnumFlowerType.values()[(int)(d0 * (double)BlockFlower.EnumFlowerType.values().length)];
            return blockflower$enumflowertype == BlockFlower.EnumFlowerType.BLUE_ORCHID ? BlockFlower.EnumFlowerType.POPPY : blockflower$enumflowertype;
        }
        return super.func_180623_a(rand, pos);
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        if (this.type == Type.ROOFED) {
            this.addMushrooms(worldIn, rand, pos);
        }
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (ChunkPos)new ChunkPos(pos), (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FLOWERS)) {
            int i = rand.nextInt(5) - 3;
            if (this.type == Type.FLOWER) {
                i += 2;
            }
            this.addDoublePlants(worldIn, rand, pos, i);
        }
        super.func_180624_a(worldIn, rand, pos);
    }

    public void addMushrooms(World world, Random rand, BlockPos pos) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                int k = i * 4 + 1 + 8 + rand.nextInt(3);
                int l = j * 4 + 1 + 8 + rand.nextInt(3);
                BlockPos blockpos = world.func_175645_m(pos.func_177982_a(k, 0, l));
                if (rand.nextInt(20) == 0 && TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)new ChunkPos(pos), (BlockPos)blockpos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.BIG_SHROOM)) {
                    WorldGenBigMushroom worldgenbigmushroom = new WorldGenBigMushroom();
                    worldgenbigmushroom.func_180709_b(world, rand, blockpos);
                    continue;
                }
                if (!TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)new ChunkPos(pos), (BlockPos)blockpos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE)) continue;
                WorldGenAbstractTree worldgenabstracttree = this.func_150567_a(rand);
                worldgenabstracttree.func_175904_e();
                if (!worldgenabstracttree.func_180709_b(world, rand, blockpos)) continue;
                worldgenabstracttree.func_180711_a(world, rand, blockpos);
            }
        }
    }

    public void addDoublePlants(World world, Random rand, BlockPos pos, int iter) {
        block0: for (int i = 0; i < iter; ++i) {
            int j = rand.nextInt(3);
            if (j == 0) {
                field_180280_ag.func_180710_a(BlockDoublePlant.EnumPlantType.SYRINGA);
            } else if (j == 1) {
                field_180280_ag.func_180710_a(BlockDoublePlant.EnumPlantType.ROSE);
            } else if (j == 2) {
                field_180280_ag.func_180710_a(BlockDoublePlant.EnumPlantType.PAEONIA);
            }
            for (int k = 0; k < 5; ++k) {
                int l = rand.nextInt(16) + 8;
                int i1 = rand.nextInt(16) + 8;
                int j1 = rand.nextInt(world.func_175645_m(pos.func_177982_a(l, 0, i1)).func_177956_o() + 32);
                if (field_180280_ag.func_180709_b(world, rand, new BlockPos(pos.func_177958_n() + l, j1, pos.func_177952_p() + i1))) continue block0;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float p_76731_1_) {
        return 43339;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos pos) {
        int j;
        int i = super.func_180627_b(pos);
        int n = j = this.type == Type.ROOFED ? (i & 0xFEFEFE) + 2634762 >> 1 : i;
        return this.type == Type.CHERRY ? grassFoliageColor : j;
    }

    public static enum Type {
        NORMAL,
        FLOWER,
        BIRCH,
        ROOFED,
        CHERRY;

    }
}

