/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.biomes.kronos;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.chunk.ChunkPrimer;
import zollerngalaxy.biomes.BiomeSpace;
import zollerngalaxy.biomes.decorators.BiomeDecoratorKronos;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.celestial.ZGPlanets;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.enums.EnumBiomeTypeZG;
import zollerngalaxy.mobs.entities.EntityHelleton;
import zollerngalaxy.mobs.entities.EntityMagmos;
import zollerngalaxy.mobs.entities.villagers.EntityKronosVillager;
import zollerngalaxy.util.BiomeUtils;

public abstract class BiomeKronosBase
extends BiomeSpace {
    protected static final IBlockState STONE = Blocks.field_150424_aL.func_176223_P();
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState BEDROCK = Blocks.field_150357_h.func_176223_P();
    protected static final IBlockState MAGMA = Blocks.field_189877_df.func_176223_P();
    protected static final IBlockState DIRT = ZGBlocks.netherDirt.func_176223_P();
    protected static final IBlockState BLAZE_ROCK = ZGBlocks.blazeRock.func_176223_P();
    protected static final IBlockState LAVA = Blocks.field_150353_l.func_176223_P();
    protected static final IBlockState SOUL_SAND = Blocks.field_150425_aM.func_176223_P();
    protected static final int SEA_LEVEL = 47;
    protected static final int SEA_FLOOR_LEVEL = 26;
    public BiomeDecoratorKronos biomeDecor = this.getBiomeDecorator();

    public BiomeKronosBase(String singleName, Biome.BiomeProperties props) {
        super(singleName, props);
        this.setTempCategory(Biome.TempCategory.WARM);
        this.setStoneBlock(STONE.func_177230_c());
        this.clearAllSpawning();
        this.setTemp(100.0f);
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityMagmos.class, 25, 1, 2));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityBlaze.class, 25, 1, 2));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityMagmaCube.class, 25, 1, 2));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityWitherSkeleton.class, 25, 1, 2));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityGhast.class, 35, 1, 2));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityPigZombie.class, 25, 1, 2));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityHelleton.class, 25, 1, 4));
        if (ConfigManagerZG.enableAlienVillagerSpawn) {
            this.field_76762_K.add(new Biome.SpawnListEntry(EntityKronosVillager.class, this.villagerSpawnRate, this.villagerMinSpawnRate, this.villagerMaxSpawnRate));
        }
        grassFoliageColor = 0;
        this.setPlanetForBiome(ZGPlanets.planetKronos);
    }

    public BiomeDecorator func_76729_a() {
        return new BiomeDecoratorKronos();
    }

    protected BiomeDecoratorKronos getBiomeDecorator() {
        return (BiomeDecoratorKronos)this.field_76760_I;
    }

    public final void generateKronosTerrain(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        int i = worldIn.func_181545_F();
        float biomeHeight = this.getBiomeHeight();
        IBlockState topState = this.field_76752_A;
        IBlockState fillState = this.field_76753_B;
        int j = -1;
        int k = (int)(noiseVal / 2.0 + 2.5 + rand.nextDouble() * 0.35);
        int l = x & 0xF;
        int i1 = z & 0xF;
        for (int j1 = 255; j1 >= 0; --j1) {
            if (j1 == 0) {
                chunkPrimerIn.func_177855_a(i1, j1, l, BEDROCK);
                continue;
            }
            if (j1 > 128) {
                chunkPrimerIn.func_177855_a(i1, j1, l, AIR);
                continue;
            }
            IBlockState iblockstate2 = chunkPrimerIn.func_177856_a(i1, j1, l);
            if (this.getBiomeType() == EnumBiomeTypeZG.OCEAN) {
                if (j1 < 47 && j1 > 26) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, LAVA);
                    continue;
                }
                if (j1 < 26) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, STONE);
                    continue;
                }
                if (j1 == 26) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, DIRT);
                    continue;
                }
                if (j1 < 47) continue;
                chunkPrimerIn.func_177855_a(i1, j1, l, AIR);
                continue;
            }
            if (iblockstate2.func_185904_a() == Material.field_151579_a) {
                j = -1;
                continue;
            }
            if (iblockstate2.func_177230_c() != STONE.func_177230_c()) continue;
            if (j == -1) {
                if (k <= 0) {
                    topState = AIR;
                    fillState = STONE;
                } else if (j1 >= i - 4 && j1 <= i + 1) {
                    topState = this.field_76752_A;
                    fillState = this.field_76753_B;
                }
                if (j1 < i && (topState == null || topState.func_185904_a() == Material.field_151579_a)) {
                    topState = BiomeUtils.isHotBiome((Biome)this) ? BLAZE_ROCK : LAVA;
                }
                j = k;
                if (j1 >= i - 1) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, topState);
                    continue;
                }
                if (j1 < i - 7 - k) {
                    topState = AIR;
                    fillState = STONE;
                    chunkPrimerIn.func_177855_a(i1, j1, l, MAGMA);
                    continue;
                }
                chunkPrimerIn.func_177855_a(i1, j1, l, fillState);
                continue;
            }
            if (j <= 0) continue;
            --j;
            chunkPrimerIn.func_177855_a(i1, j1, l, fillState);
        }
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        this.generateKronosTerrain(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
    }

    public int getModdedBiomeFoliageColor(int original) {
        return grassFoliageColor;
    }

    public int getModdedBiomeGrassColor(int original) {
        return grassFoliageColor;
    }
}

