/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.biomes.eden;

import java.util.Random;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedEnderman;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedWitch;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import zollerngalaxy.biomes.BiomeSpace;
import zollerngalaxy.biomes.decorators.BiomeDecoratorEden;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.celestial.ZGPlanets;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.enums.EnumBiomeTypeZG;
import zollerngalaxy.lib.helpers.ZGHelper;
import zollerngalaxy.mobs.entities.EntityEdenCow;
import zollerngalaxy.mobs.entities.EntityOinkus;
import zollerngalaxy.mobs.entities.robots.sentinels.EntitySentinelDrone;
import zollerngalaxy.mobs.entities.villagers.EntityEdenVillager;
import zollerngalaxy.util.BiomeUtils;
import zollerngalaxy.worldgen.eden.WorldGenEdenTrees;

public abstract class BiomeEdenBase
extends BiomeSpace {
    protected static final IBlockState STONE = ZGBlocks.edenStone.func_176223_P();
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState BEDROCK = Blocks.field_150357_h.func_176223_P();
    protected static final IBlockState GRAVEL = ZGBlocks.edenGravel.func_176223_P();
    protected static final IBlockState DIRT = ZGBlocks.edenSoil.func_176223_P();
    protected static final IBlockState ICE = Blocks.field_150432_aD.func_176223_P();
    protected static final IBlockState WATER = Blocks.field_150355_j.func_176223_P();
    protected static final int SEA_LEVEL = 63;
    protected static final int SEA_FLOOR_LEVEL = 42;
    public BiomeDecoratorEden biomeDecor = this.getBiomeDecorator();
    public boolean generateVines = false;
    protected WorldGenAbstractTree edenTreeGen = new WorldGenEdenTrees(false, ZGHelper.rngInt(5, 10), ZGBlocks.edenWoodLog.func_176223_P(), ZGBlocks.edenWoodLeaves.func_176223_P(), this.generateVines);

    public BiomeEdenBase(String singleName, Biome.BiomeProperties props) {
        super(singleName, props);
        this.setTempCategory(Biome.TempCategory.MEDIUM);
        this.setTemp(62.46f);
        this.biomeDecor.field_76802_A = -999;
        this.biomeDecor.field_76832_z = -999;
        this.biomeDecor.field_76803_B = -999;
        this.biomeDecor.field_76798_D = -999;
        this.biomeDecor.field_76802_A = 4;
        this.biomeDecor.tallGrassPerChunk = 2;
        this.biomeDecor.field_76832_z = 1;
        this.clearAllSpawning();
        if (ConfigManagerZG.canEarthAnimalsSpawnOnEden) {
            this.field_76762_K.add(new Biome.SpawnListEntry(EntityChicken.class, 100, 1, 1));
            this.field_76762_K.add(new Biome.SpawnListEntry(EntitySheep.class, 100, 3, 4));
            this.field_76762_K.add(new Biome.SpawnListEntry(EntityWolf.class, 100, 5, 7));
            this.field_76762_K.add(new Biome.SpawnListEntry(EntityCow.class, 100, 2, 3));
            this.field_76762_K.add(new Biome.SpawnListEntry(EntityPig.class, 100, 1, 2));
            this.field_76762_K.add(new Biome.SpawnListEntry(EntityHorse.class, 100, 1, 2));
        }
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityEdenCow.class, 80, 2, 4));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityOinkus.class, 80, 2, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEvolvedZombie.class, 100, 4, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEvolvedSpider.class, 100, 4, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEvolvedSkeleton.class, 100, 4, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEvolvedCreeper.class, 100, 4, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEvolvedEnderman.class, 100, 4, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEvolvedWitch.class, 100, 4, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityZombie.class, 100, 4, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntitySpider.class, 100, 4, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntitySkeleton.class, 100, 4, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityCreeper.class, 100, 4, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEnderman.class, 100, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityWitch.class, 5, 1, 1));
        if (ConfigManagerZG.enableSentinels) {
            this.field_76761_J.add(new Biome.SpawnListEntry(EntitySentinelDrone.class, 10, 1, 2));
        }
        if (ConfigManagerZG.enableAlienVillagerSpawn) {
            this.field_76762_K.add(new Biome.SpawnListEntry(EntityEdenVillager.class, this.villagerSpawnRate, this.villagerMinSpawnRate, this.villagerMaxSpawnRate));
        }
        this.setStoneBlock(ZGBlocks.edenStone);
        this.setPlanetForBiome(ZGPlanets.planetEden);
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        return this.edenTreeGen;
    }

    public BiomeDecorator func_76729_a() {
        return new BiomeDecoratorEden();
    }

    protected BiomeDecoratorEden getBiomeDecorator() {
        return (BiomeDecoratorEden)this.field_76760_I;
    }

    public final void generateEdenTerrain(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        int i = worldIn.func_181545_F();
        float biomeHeight = this.getBiomeHeight();
        IBlockState topState = this.field_76752_A;
        IBlockState fillState = this.field_76753_B;
        int j = -1;
        int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int l = x & 0xF;
        int i1 = z & 0xF;
        for (int j1 = 255; j1 >= 0; --j1) {
            if (j1 == 0) {
                chunkPrimerIn.func_177855_a(i1, j1, l, BEDROCK);
                continue;
            }
            if (j1 >= 128) {
                chunkPrimerIn.func_177855_a(i1, j1, l, AIR);
                continue;
            }
            IBlockState iblockstate2 = chunkPrimerIn.func_177856_a(i1, j1, l);
            if (this.getBiomeType() == EnumBiomeTypeZG.OCEAN) {
                if (j1 < 63 && j1 > 42) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, WATER);
                    continue;
                }
                if (j1 < 42) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, STONE);
                    continue;
                }
                if (j1 == 42) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, DIRT);
                    continue;
                }
                if (j1 < 63) continue;
                chunkPrimerIn.func_177855_a(i1, j1, l, AIR);
                continue;
            }
            if (iblockstate2.func_185904_a() == Material.field_151579_a) {
                j = -1;
                continue;
            }
            if (iblockstate2.func_177230_c() != STONE.func_177230_c()) continue;
            if (j == -1) {
                if (k <= 0) {
                    topState = AIR;
                    fillState = STONE;
                } else if (j1 >= i - 4 && j1 <= i + 1) {
                    topState = this.field_76752_A;
                    fillState = this.field_76753_B;
                }
                if (j1 < i && (topState == null || topState.func_185904_a() == Material.field_151579_a)) {
                    topState = BiomeUtils.isColdBiome((Biome)this) ? ICE : WATER;
                }
                j = k;
                if (j1 >= i - 1) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, topState);
                    continue;
                }
                if (j1 < i - 7 - k) {
                    topState = AIR;
                    fillState = STONE;
                    chunkPrimerIn.func_177855_a(i1, j1, l, GRAVEL);
                    continue;
                }
                chunkPrimerIn.func_177855_a(i1, j1, l, fillState);
                continue;
            }
            if (j <= 0) continue;
            --j;
            chunkPrimerIn.func_177855_a(i1, j1, l, fillState);
        }
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        this.generateEdenTerrain(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
    }

    public int getModdedBiomeFoliageColor(int original) {
        return grassFoliageColor;
    }

    public int getModdedBiomeGrassColor(int original) {
        return grassFoliageColor;
    }
}

