/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.biomes.decorators;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import zollerngalaxy.biomes.BiomeSpace;
import zollerngalaxy.biomes.decorators.BiomeDecoratorZG;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.blocks.fluids.ZGFluids;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.enums.EnumBiomeTypeZG;
import zollerngalaxy.core.enums.EnumOreGenZG;
import zollerngalaxy.lib.helpers.ZGDecorateHelper;
import zollerngalaxy.lib.helpers.ZGHelper;
import zollerngalaxy.worldgen.WorldGenLakesZG;
import zollerngalaxy.worldgen.WorldGenMinableZG;
import zollerngalaxy.worldgen.WorldGenOutpost;
import zollerngalaxy.worldgen.WorldGenZGCrystals;

public class BiomeDecoratorVortex
extends BiomeDecoratorZG {
    private WorldGenerator ironGen;
    private WorldGenerator goldGen;
    private WorldGenerator copperGen;
    private WorldGenerator redstoneGen;
    private WorldGenerator diamondGen;
    private WorldGenerator superChargedCoalGen;
    private WorldGenerator fueltoniumGen;
    private WorldGenerator eveniumGen;
    public int stormCrystalsPerChunk = 2;
    public int chargiumLakesPerChunk = this.enableExtremeMode ? 2 : 1;
    public boolean generateStormCrystals = true;
    public boolean generateChargiumLakes = ConfigManagerZG.enableChargiumLakesOnVortex;
    private WorldGenerator stormCrystalsGen = new WorldGenZGCrystals(ZGBlocks.blockCrystalsStorm.func_176223_P());
    private WorldGenerator chargiumLakeGen = new WorldGenLakesZG((Block)ZGFluids.blockChargiumFluid, ZGBlocks.vortexStone);

    public BiomeDecoratorVortex() {
        this.ironGen = new WorldGenMinableZG(ZGBlocks.vortexIronOre, ZGBlocks.vortexStone, EnumOreGenZG.IRON);
        this.goldGen = new WorldGenMinableZG(ZGBlocks.vortexGoldOre, ZGBlocks.vortexStone, EnumOreGenZG.GOLD);
        this.copperGen = new WorldGenMinableZG(ZGBlocks.vortexCopperOre, ZGBlocks.vortexStone, EnumOreGenZG.COPPER);
        this.redstoneGen = new WorldGenMinableZG(ZGBlocks.vortexRedstoneOre, ZGBlocks.vortexStone, EnumOreGenZG.REDSTONE);
        this.diamondGen = new WorldGenMinableZG(ZGBlocks.vortexDiamondOre, ZGBlocks.vortexStone, EnumOreGenZG.DIAMOND);
        this.superChargedCoalGen = new WorldGenMinableZG(ZGBlocks.vortexSuperChargedCoalOre, ZGBlocks.vortexStone, EnumOreGenZG.SUPER_CHARGED_COAL.setGenCount(15));
        this.fueltoniumGen = new WorldGenMinableZG(ZGBlocks.vortexFueltoniumOre, ZGBlocks.vortexStone, EnumOreGenZG.FUELTONIUM.setBlockCount(10));
        this.eveniumGen = new WorldGenMinableZG(ZGBlocks.vortexEveniumOre, ZGBlocks.vortexStone, EnumOreGenZG.EVENIUM);
    }

    @Override
    protected void generate(Biome biome, World world, Random rand) {
        BiomeSpace spaceBiome;
        int genY;
        int x = rand.nextInt(16) + 8;
        int z = rand.nextInt(16) + 8;
        ChunkPrimer chunkPrimer = new ChunkPrimer();
        ChunkPos forgeChunkPos = new ChunkPos(this.field_180294_c);
        int y = genY = 248;
        this.generateOre(this.ironGen, EnumOreGenZG.IRON, world, rand);
        this.generateOre(this.goldGen, EnumOreGenZG.GOLD, world, rand);
        this.generateOre(this.copperGen, EnumOreGenZG.COPPER, world, rand);
        this.generateOre(this.redstoneGen, EnumOreGenZG.REDSTONE, world, rand);
        this.generateOre(this.diamondGen, EnumOreGenZG.DIAMOND, world, rand);
        this.generateOre(this.superChargedCoalGen, EnumOreGenZG.SUPER_CHARGED_COAL, world, rand);
        this.generateOre(this.fueltoniumGen, EnumOreGenZG.FUELTONIUM, world, rand);
        this.generateOre(this.eveniumGen, EnumOreGenZG.EVENIUM, world, rand);
        if (biome instanceof BiomeSpace) {
            spaceBiome = (BiomeSpace)biome;
            genY = spaceBiome.getBiomeHeight();
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_LAVA) && this.generateChargiumLakes && this.chargiumLakesPerChunk > 0) {
            for (int i = 0; i < this.chargiumLakesPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                if (rand.nextInt(this.enableExtremeMode ? 80 : 100) > 10 || y > 82) continue;
                this.chargiumLakeGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        if (this.generateStormCrystals && this.stormCrystalsPerChunk > 0 && ZGHelper.rngInt(1, 100) <= 55) {
            for (int i = 0; i < this.stormCrystalsPerChunk; ++i) {
                ZGDecorateHelper.generateCrystals(this.stormCrystalsGen, world, rand, this.field_180294_c);
            }
        }
        if (this.generateOutposts && this.outpostsPerChunk > 0) {
            if (biome instanceof BiomeSpace && (spaceBiome = (BiomeSpace)biome).getBiomeType() == EnumBiomeTypeZG.OCEAN) {
                return;
            }
            y = rand.nextInt(rand.nextInt(genY) + 8);
            if (y >= 62) {
                IBlockState OUTPOST_STATE = ZGBlocks.blockOutpost.func_176223_P();
                WorldGenOutpost outpostGen = new WorldGenOutpost(OUTPOST_STATE, OUTPOST_STATE);
                for (int i = 0; i < this.outpostsPerChunk; ++i) {
                    if (rand.nextInt(this.enableExtremeMode ? 200 : 100) > ConfigManagerZG.outpostGenChance) continue;
                    outpostGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
                }
            }
        }
    }
}

