/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.biomes.decorators;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenerator;
import zollerngalaxy.biomes.BiomeSpace;
import zollerngalaxy.biomes.decorators.BiomeDecoratorZG;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.dimensions.chunkproviders.ChunkProviderToci;
import zollerngalaxy.core.enums.EnumBiomeTypeZG;
import zollerngalaxy.core.enums.EnumOreGenZG;
import zollerngalaxy.lib.helpers.ZGHelper;
import zollerngalaxy.worldgen.WorldGenMinableZG;
import zollerngalaxy.worldgen.WorldGenOutpost;
import zollerngalaxy.worldgen.WorldGenSmallCraterZG;
import zollerngalaxy.worldgen.WorldGenSmallHouse;
import zollerngalaxy.worldgen.WorldGenTunnel;

public class BiomeDecoratorToci
extends BiomeDecoratorZG {
    private static final Block STONE = ZGBlocks.tociStone;
    private static final Block SAND = ZGBlocks.tociSand;
    private static final Block STAR_SAND = ZGBlocks.tociStarSand;
    private static final Block GRAVEL = ZGBlocks.tociGravel;
    private static final Block COBBLESTONE = ZGBlocks.tociCobblestone;
    private static final Block STONE_BRICKS = ZGBlocks.tociStoneBricks;
    private static final Block WOOD_PLANKS = ZGBlocks.perdWoodPlanks;
    private WorldGenerator nickelGen;
    private WorldGenerator tinGen;
    private WorldGenerator bronzeGen;
    private WorldGenerator silverGen;
    private WorldGenerator leadGen;
    private WorldGenerator copperGen;
    private WorldGenerator zincGen;
    private WorldGenerator superChargedCoalGen;
    private WorldGenerator redstoneGen;
    private WorldGenerator goldGen;
    private WorldGenerator amaranthGen;
    private WorldGenerator emeraldGen;
    private WorldGenerator coalGen;
    private WorldGenerator fueltoniumGen;
    private WorldGenerator ironGen;
    private WorldGenerator diamondGen;
    private WorldGenerator quartzGen;
    private WorldGenerator gravelGen;
    public int tunnelsPerChunk = 8;
    public int cratersPerChunk = 4;
    public int housesPerChunk = 2;
    public boolean generateCraters = true;
    public boolean generateTunnels = true;
    public boolean generateHouses = true;
    private WorldGenerator tunnelGen = new WorldGenTunnel();
    private WorldGenerator craterGen = new WorldGenSmallCraterZG();
    private WorldGenerator houseGen = new WorldGenSmallHouse(COBBLESTONE.func_176223_P(), STONE_BRICKS.func_176223_P(), WOOD_PLANKS.func_176223_P());

    public BiomeDecoratorToci() {
        this.nickelGen = new WorldGenMinableZG(ZGBlocks.tociNickelOre, STONE, EnumOreGenZG.NICKEL);
        this.tinGen = new WorldGenMinableZG(ZGBlocks.tociTinOre, STONE, EnumOreGenZG.TIN);
        this.bronzeGen = new WorldGenMinableZG(ZGBlocks.tociBronzeOre, STONE, EnumOreGenZG.BRONZE);
        this.silverGen = new WorldGenMinableZG(ZGBlocks.tociSilverOre, STONE, EnumOreGenZG.SILVER);
        this.leadGen = new WorldGenMinableZG(ZGBlocks.tociLeadOre, STONE, EnumOreGenZG.LEAD);
        this.copperGen = new WorldGenMinableZG(ZGBlocks.tociCopperOre, STONE, EnumOreGenZG.COPPER);
        this.zincGen = new WorldGenMinableZG(ZGBlocks.tociZincOre, STONE, EnumOreGenZG.ZINC);
        this.superChargedCoalGen = new WorldGenMinableZG(ZGBlocks.tociSuperChargedCoalOre, STONE, EnumOreGenZG.SUPER_CHARGED_COAL);
        this.redstoneGen = new WorldGenMinableZG(ZGBlocks.tociRedstoneOre, STONE, EnumOreGenZG.REDSTONE);
        this.goldGen = new WorldGenMinableZG(ZGBlocks.tociGoldOre, STONE, EnumOreGenZG.GOLD);
        this.amaranthGen = new WorldGenMinableZG(ZGBlocks.tociAmaranthOre, STONE, EnumOreGenZG.AMARANTH);
        this.emeraldGen = new WorldGenMinableZG(ZGBlocks.tociEmeraldOre, STONE, EnumOreGenZG.EMERALD);
        this.coalGen = new WorldGenMinableZG(ZGBlocks.tociCoalOre, STONE, EnumOreGenZG.COAL);
        this.fueltoniumGen = new WorldGenMinableZG(ZGBlocks.tociFueltoniumOre, STONE, EnumOreGenZG.FUELTONIUM);
        this.ironGen = new WorldGenMinableZG(ZGBlocks.tociIronOre, STONE, EnumOreGenZG.IRON);
        this.diamondGen = new WorldGenMinableZG(ZGBlocks.tociDiamondOre, STONE, EnumOreGenZG.DIAMOND);
        this.quartzGen = new WorldGenMinableZG(ZGBlocks.tociQuartzOre, STONE, EnumOreGenZG.QUARTZ);
        this.gravelGen = new WorldGenMinableZG(ZGBlocks.tociGravel, STONE, EnumOreGenZG.GRAVEL.setGenCount(10));
    }

    @Override
    protected void generate(Biome biome, World world, Random rand) {
        BiomeSpace spaceBiome;
        int genY;
        int x = rand.nextInt(16) + 8;
        int z = rand.nextInt(16) + 8;
        ChunkPrimer chunkPrimer = new ChunkPrimer();
        int y = genY = 248;
        if (biome instanceof BiomeSpace) {
            spaceBiome = (BiomeSpace)biome;
            genY = spaceBiome.getBiomeHeight();
        }
        this.generateOre(this.nickelGen, EnumOreGenZG.NICKEL, world, rand);
        this.generateOre(this.tinGen, EnumOreGenZG.TIN, world, rand);
        this.generateOre(this.bronzeGen, EnumOreGenZG.BRONZE, world, rand);
        this.generateOre(this.silverGen, EnumOreGenZG.SILVER, world, rand);
        this.generateOre(this.leadGen, EnumOreGenZG.LEAD, world, rand);
        this.generateOre(this.copperGen, EnumOreGenZG.COPPER, world, rand);
        this.generateOre(this.zincGen, EnumOreGenZG.ZINC, world, rand);
        this.generateOre(this.superChargedCoalGen, EnumOreGenZG.SUPER_CHARGED_COAL, world, rand);
        this.generateOre(this.redstoneGen, EnumOreGenZG.REDSTONE, world, rand);
        this.generateOre(this.goldGen, EnumOreGenZG.GOLD, world, rand);
        this.generateOre(this.amaranthGen, EnumOreGenZG.AMARANTH, world, rand);
        this.generateOre(this.emeraldGen, EnumOreGenZG.EMERALD, world, rand);
        this.generateOre(this.coalGen, EnumOreGenZG.COAL, world, rand);
        this.generateOre(this.fueltoniumGen, EnumOreGenZG.FUELTONIUM, world, rand);
        this.generateOre(this.ironGen, EnumOreGenZG.IRON, world, rand);
        this.generateOre(this.diamondGen, EnumOreGenZG.DIAMOND, world, rand);
        this.generateOre(this.quartzGen, EnumOreGenZG.QUARTZ, world, rand);
        this.generateOre(this.gravelGen, EnumOreGenZG.GRAVEL, world, rand);
        if (this.generateTunnels && this.tunnelsPerChunk > 0 && ZGHelper.rngInt(1, 100) <= 45) {
            for (int i = 0; i < this.tunnelsPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                if (y > 60) continue;
                this.tunnelGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        if (this.generateHouses && this.housesPerChunk > 0 && ZGHelper.rngInt(1, 100) <= 32) {
            for (int i = 0; i < this.housesPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                if (y < 60) continue;
                this.houseGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        if (this.generateCraters && this.cratersPerChunk > 0) {
            ChunkProviderToci.INSTANCE.createCraters(x, z, chunkPrimer);
            y = rand.nextInt(rand.nextInt(genY) + 8);
            if (ZGHelper.rngInt(1, 100) <= 50) {
                for (int i = 0; i < this.cratersPerChunk; ++i) {
                    if (y > 80) continue;
                    this.craterGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
                }
            }
        }
        if (this.generateOutposts && this.outpostsPerChunk > 0) {
            if (biome instanceof BiomeSpace && (spaceBiome = (BiomeSpace)biome).getBiomeType() == EnumBiomeTypeZG.OCEAN) {
                return;
            }
            if (y >= 62) {
                IBlockState OUTPOST_STATE = ZGBlocks.blockOutpost.func_176223_P();
                WorldGenOutpost outpostGen = new WorldGenOutpost(OUTPOST_STATE, OUTPOST_STATE);
                for (int i = 0; i < this.outpostsPerChunk; ++i) {
                    y = rand.nextInt(rand.nextInt(genY) + 8);
                    if (rand.nextInt(this.enableExtremeMode ? 200 : 100) > ConfigManagerZG.outpostGenChance) continue;
                    outpostGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
                }
            }
        }
    }
}

