/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.biomes.decorators;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import zollerngalaxy.biomes.BiomeSpace;
import zollerngalaxy.biomes.decorators.BiomeDecoratorZG;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.enums.EnumBiomeTypeZG;
import zollerngalaxy.core.enums.EnumOreGenZG;
import zollerngalaxy.worldgen.WorldGenMinableZG;
import zollerngalaxy.worldgen.WorldGenOutpost;

public class BiomeDecoratorPurgot
extends BiomeDecoratorZG {
    private WorldGenerator dirtGen = new WorldGenMinableZG(ZGBlocks.purgDirt, ZGBlocks.purgSurfaceRock, EnumOreGenZG.DIRT);
    private WorldGenerator ironGen;
    private WorldGenerator goldGen;
    private WorldGenerator tinGen = new WorldGenMinableZG(ZGBlocks.purgTinOre, ZGBlocks.purgStone, EnumOreGenZG.TIN);
    private WorldGenerator copperGen = new WorldGenMinableZG(ZGBlocks.purgCopperOre, ZGBlocks.purgStone, EnumOreGenZG.COPPER);
    private WorldGenerator leadGen;
    private WorldGenerator aluminumGen;
    private WorldGenerator redstoneGen;
    private WorldGenerator diamondGen;
    private WorldGenerator emeraldGen;
    private WorldGenerator meteoricIronGen;
    private WorldGenerator eveniumGen;

    public BiomeDecoratorPurgot() {
        this.ironGen = new WorldGenMinableZG(ZGBlocks.purgIronOre, ZGBlocks.purgStone, EnumOreGenZG.IRON);
        this.goldGen = new WorldGenMinableZG(ZGBlocks.purgGoldOre, ZGBlocks.purgStone, EnumOreGenZG.GOLD);
        this.leadGen = new WorldGenMinableZG(ZGBlocks.purgLeadOre, ZGBlocks.purgStone, EnumOreGenZG.LEAD);
        this.aluminumGen = new WorldGenMinableZG(ZGBlocks.purgAluminumOre, ZGBlocks.purgStone, EnumOreGenZG.ALUMINUM);
        this.redstoneGen = new WorldGenMinableZG(ZGBlocks.purgRedstoneOre, ZGBlocks.purgStone, EnumOreGenZG.REDSTONE);
        this.diamondGen = new WorldGenMinableZG(ZGBlocks.purgDiamondOre, ZGBlocks.purgStone, EnumOreGenZG.DIAMOND);
        this.emeraldGen = new WorldGenMinableZG(ZGBlocks.purgEmeraldOre, ZGBlocks.purgStone, EnumOreGenZG.EMERALD);
        this.meteoricIronGen = new WorldGenMinableZG(ZGBlocks.purgMeteoricIronOre, ZGBlocks.purgStone, EnumOreGenZG.METEORIC_IRON);
        this.eveniumGen = new WorldGenMinableZG(ZGBlocks.purgEveniumOre, ZGBlocks.purgStone, EnumOreGenZG.EVENIUM.setGenCount(11));
    }

    @Override
    protected void generate(Biome biome, World world, Random rand) {
        BiomeSpace spaceBiome;
        int x = rand.nextInt(16) + 8;
        int z = rand.nextInt(16) + 8;
        int y = rand.nextInt(248) + 8;
        this.generateOre(this.dirtGen, EnumOreGenZG.DIRT, world, rand);
        this.generateOre(this.ironGen, EnumOreGenZG.IRON, world, rand);
        this.generateOre(this.goldGen, EnumOreGenZG.GOLD, world, rand);
        this.generateOre(this.tinGen, EnumOreGenZG.TIN, world, rand);
        this.generateOre(this.copperGen, EnumOreGenZG.COPPER, world, rand);
        this.generateOre(this.leadGen, EnumOreGenZG.LEAD, world, rand);
        this.generateOre(this.aluminumGen, EnumOreGenZG.ALUMINUM, world, rand);
        this.generateOre(this.redstoneGen, EnumOreGenZG.REDSTONE, world, rand);
        this.generateOre(this.diamondGen, EnumOreGenZG.DIAMOND, world, rand);
        this.generateOre(this.emeraldGen, EnumOreGenZG.EMERALD, world, rand);
        this.generateOre(this.meteoricIronGen, EnumOreGenZG.METEORIC_IRON, world, rand);
        this.generateOre(this.eveniumGen, EnumOreGenZG.EVENIUM, world, rand);
        int genY = y;
        if (biome instanceof BiomeSpace) {
            spaceBiome = (BiomeSpace)biome;
            genY = spaceBiome.getBiomeHeight();
        }
        if (this.generateOutposts && this.outpostsPerChunk > 0) {
            if (biome instanceof BiomeSpace && (spaceBiome = (BiomeSpace)biome).getBiomeType() == EnumBiomeTypeZG.OCEAN) {
                return;
            }
            y = rand.nextInt(rand.nextInt(genY) + 8);
            if (y >= 62) {
                IBlockState OUTPOST_STATE = ZGBlocks.blockOutpost.func_176223_P();
                WorldGenOutpost outpostGen = new WorldGenOutpost(OUTPOST_STATE, OUTPOST_STATE);
                for (int i = 0; i < this.outpostsPerChunk; ++i) {
                    if (rand.nextInt(this.enableExtremeMode ? 200 : 100) > ConfigManagerZG.outpostGenChance) continue;
                    outpostGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
                }
            }
        }
    }
}

