/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.biomes.decorators;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import zollerngalaxy.biomes.BiomeSpace;
import zollerngalaxy.biomes.decorators.BiomeDecoratorZG;
import zollerngalaxy.blocks.ZGBlockTallGrass;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.blocks.fluids.ZGFluids;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.ZGLootTables;
import zollerngalaxy.core.enums.EnumBiomeTypeZG;
import zollerngalaxy.core.enums.EnumOreGenZG;
import zollerngalaxy.lib.helpers.ZGHelper;
import zollerngalaxy.worldgen.WorldGenLakesZG;
import zollerngalaxy.worldgen.WorldGenMinableZG;
import zollerngalaxy.worldgen.WorldGenOutpost;
import zollerngalaxy.worldgen.WorldGenTallGrassZG;
import zollerngalaxy.worldgen.WorldGenTreasure;
import zollerngalaxy.worldgen.perdita.WorldGenLostCactus;
import zollerngalaxy.worldgen.perdita.WorldGenLostDeadBush;
import zollerngalaxy.worldgen.perdita.WorldGenLostReeds;
import zollerngalaxy.worldgen.perdita.WorldGenPalmwoodTrees;

public class BiomeDecoratorPerdita
extends BiomeDecoratorZG {
    private static final Block SAND = ZGBlocks.perdSand;
    private static final Block STONE = ZGBlocks.perdStone;
    private static final Block ROCK = ZGBlocks.perdRock;
    public int lostCactiPerChunk = 10;
    public int lostDeadBushPerChunk = 5;
    public int lostTallGrassPerChunk = 0;
    public int lostPalmWoodTreesPerChunk = 0;
    public int lostLakesPerChunk = 0;
    public int lostReedsPerChunk = 0;
    public int lostFueltoniumLakesPerChunk = 0;
    public int lostTreasurePerChunk = 1;
    private WorldGenerator creepstoneGen;
    private WorldGenerator creepdirtGen;
    private WorldGenerator cavestoneGen;
    private WorldGenerator perdDiamondOreGen;
    private WorldGenerator perdEtriumOreGen;
    private WorldGenerator perdIronOreGen;
    private WorldGenerator perdGoldOreGen;
    private WorldGenerator perdZollerniumOreGen;
    private WorldGenerator perdFueltoniumOreGen;
    private WorldGenerator lostCactusGen = new WorldGenLostCactus();
    private WorldGenerator lostDeadBushGen = new WorldGenLostDeadBush();
    private WorldGenerator lostLakeGen = new WorldGenLakesZG((Block)Blocks.field_150355_j, ZGBlocks.perdGrass);
    private WorldGenerator lostTallGrassGen = new WorldGenTallGrassZG((ZGBlockTallGrass)ZGBlocks.perdTallGrass);
    private WorldGenerator lostReedGen = new WorldGenLostReeds();
    private WorldGenerator lostPalmWoodTreeGen = new WorldGenPalmwoodTrees(true, ZGHelper.rngInt(5, 15), ZGBlocks.perdWoodLogs.func_176223_P(), ZGBlocks.perdWoodLeaves.func_176223_P(), false);
    private WorldGenerator lostFueltoniumLakeGen = new WorldGenLakesZG((Block)ZGFluids.blockFueltoniumFluid, ZGBlocks.perdSand);
    private WorldGenerator lostTreasureGen = new WorldGenTreasure(ZGLootTables.CHEST_BURIED_TREASURE);

    public BiomeDecoratorPerdita() {
        this.creepstoneGen = new WorldGenMinableZG(ZGBlocks.perdCreepStone, STONE, EnumOreGenZG.SPECIAL_STONE);
        this.creepdirtGen = new WorldGenMinableZG(ZGBlocks.perdCreepDirt, STONE, EnumOreGenZG.DIRT.setMaxHeight(32));
        this.cavestoneGen = new WorldGenMinableZG(ZGBlocks.perdCaveStone, STONE, EnumOreGenZG.SPECIAL_STONE);
        this.perdDiamondOreGen = new WorldGenMinableZG(ZGBlocks.perdDiamondOre, STONE, EnumOreGenZG.DIAMOND);
        this.perdEtriumOreGen = new WorldGenMinableZG(ZGBlocks.perdEtriumOre, STONE, EnumOreGenZG.EMERALD);
        this.perdIronOreGen = new WorldGenMinableZG(ZGBlocks.perdIronOre, STONE, EnumOreGenZG.IRON);
        this.perdGoldOreGen = new WorldGenMinableZG(ZGBlocks.perdGoldOre, STONE, EnumOreGenZG.GOLD);
        this.perdZollerniumOreGen = new WorldGenMinableZG(ZGBlocks.perdZollerniumOre, STONE, EnumOreGenZG.ZOLLERNIUM);
        this.perdFueltoniumOreGen = new WorldGenMinableZG(ZGBlocks.perdFueltoniumOre, STONE, EnumOreGenZG.FUELTONIUM);
    }

    @Override
    protected void generate(Biome biome, World world, Random rand) {
        int y2;
        int y1;
        int z1;
        int x1;
        int i;
        int y;
        int x = rand.nextInt(16) + 8;
        int z = rand.nextInt(16) + 8;
        int genY = y = rand.nextInt(248) + 8;
        if (biome instanceof BiomeSpace) {
            BiomeSpace spaceBiome = (BiomeSpace)biome;
            genY = spaceBiome.getBiomeHeight();
        }
        this.generateOre(this.creepstoneGen, EnumOreGenZG.SPECIAL_STONE, world, rand);
        this.generateOre(this.creepdirtGen, EnumOreGenZG.SPECIAL_STONE, world, rand);
        this.generateOre(this.cavestoneGen, EnumOreGenZG.SPECIAL_STONE, world, rand);
        this.generateOre(this.perdDiamondOreGen, EnumOreGenZG.DIAMOND, world, rand);
        this.generateOre(this.perdEtriumOreGen, EnumOreGenZG.EMERALD, world, rand);
        this.generateOre(this.perdIronOreGen, EnumOreGenZG.IRON, world, rand);
        this.generateOre(this.perdGoldOreGen, EnumOreGenZG.GOLD, world, rand);
        this.generateOre(this.perdZollerniumOreGen, EnumOreGenZG.ZOLLERNIUM, world, rand);
        this.generateOre(this.perdFueltoniumOreGen, EnumOreGenZG.FUELTONIUM, world, rand);
        ChunkPos forgeChunkPos = new ChunkPos(this.field_180294_c);
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CACTUS) && rand.nextInt(12) == 0) {
            for (i = 0; i < this.lostCactiPerChunk; ++i) {
                x1 = rand.nextInt(16) + 8;
                y1 = world.func_175645_m(this.field_180294_c.func_177982_a(x1, 0, z1 = rand.nextInt(16) + 8)).func_177956_o() * 2;
                if (y1 <= 0) continue;
                y2 = rand.nextInt(y1);
                this.lostCactusGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x1, y2, z1));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.DEAD_BUSH) && rand.nextInt(6) == 0) {
            for (i = 0; i < this.lostDeadBushPerChunk; ++i) {
                x1 = rand.nextInt(16) + 8;
                y1 = world.func_175645_m(this.field_180294_c.func_177982_a(x1, 0, z1 = rand.nextInt(16) + 8)).func_177956_o() * 2;
                if (y1 <= 0) continue;
                y2 = rand.nextInt(y1);
                this.lostDeadBushGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x1, y2, z1));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE) && rand.nextInt(6) == 0) {
            for (i = 0; i < this.lostPalmWoodTreesPerChunk; ++i) {
                x1 = rand.nextInt(16) + 8;
                y1 = world.func_175645_m(this.field_180294_c.func_177982_a(x1, 0, z1 = rand.nextInt(16) + 8)).func_177956_o() * 2;
                if (y1 <= 0) continue;
                y2 = rand.nextInt(y1);
                this.lostPalmWoodTreeGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x1, y2, z1));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_WATER) && rand.nextInt(2) == 0) {
            for (i = 0; i < this.lostLakesPerChunk; ++i) {
                x1 = rand.nextInt(16) + 8;
                y1 = world.func_175645_m(this.field_180294_c.func_177982_a(x1, 0, z1 = rand.nextInt(16) + 8)).func_177956_o() * 2;
                if (y1 <= 0) continue;
                y2 = rand.nextInt(y1);
                this.lostLakeGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x1, y2, z1));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_LAVA) && rand.nextInt(5) == 0) {
            for (i = 0; i < this.lostFueltoniumLakesPerChunk; ++i) {
                x1 = rand.nextInt(16) + 8;
                y1 = world.func_175645_m(this.field_180294_c.func_177982_a(x1, 0, z1 = rand.nextInt(16) + 8)).func_177956_o() * 2;
                if (y1 <= 0) continue;
                y2 = rand.nextInt(y1);
                this.lostFueltoniumLakeGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x1, y2, z1));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.GRASS) && rand.nextInt(2) == 0) {
            for (i = 0; i < this.lostTallGrassPerChunk; ++i) {
                x1 = rand.nextInt(16) + 8;
                y1 = world.func_175645_m(this.field_180294_c.func_177982_a(x1, 0, z1 = rand.nextInt(16) + 8)).func_177956_o() * 2;
                if (y1 <= 0) continue;
                y2 = rand.nextInt(y1);
                this.lostTallGrassGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x1, y2, z1));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.REED) && rand.nextInt(3) == 0) {
            for (i = 0; i < this.lostReedsPerChunk; ++i) {
                x1 = rand.nextInt(16) + 8;
                y1 = world.func_175645_m(this.field_180294_c.func_177982_a(x1, 0, z1 = rand.nextInt(16) + 8)).func_177956_o() * 2;
                if (y1 <= 0) continue;
                y2 = rand.nextInt(y1);
                this.lostReedGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x1, y2, z1));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FOSSIL) && rand.nextInt(25) == 0) {
            for (i = 0; i < this.lostTreasurePerChunk; ++i) {
                x1 = rand.nextInt(16) + 8;
                y1 = world.func_175645_m(this.field_180294_c.func_177982_a(x1, 0, z1 = rand.nextInt(16) + 8)).func_177956_o() * 2;
                if (y1 <= 0) continue;
                y2 = rand.nextInt(y1);
                BlockPos chestPos = this.field_180294_c.func_177982_a(x1, y2, z1);
                chestPos = chestPos.func_177977_b();
                this.lostTreasureGen.func_180709_b(world, rand, chestPos);
            }
        }
        if (this.generateOutposts && this.outpostsPerChunk > 0) {
            BiomeSpace spaceBiome;
            if (biome instanceof BiomeSpace && (spaceBiome = (BiomeSpace)biome).getBiomeType() == EnumBiomeTypeZG.OCEAN) {
                return;
            }
            y = rand.nextInt(rand.nextInt(genY) + 8);
            if (y >= 62) {
                IBlockState OUTPOST_STATE = ZGBlocks.blockOutpost.func_176223_P();
                WorldGenOutpost outpostGen = new WorldGenOutpost(OUTPOST_STATE, OUTPOST_STATE);
                for (int i2 = 0; i2 < this.outpostsPerChunk; ++i2) {
                    if (rand.nextInt(this.enableExtremeMode ? 200 : 100) > ConfigManagerZG.outpostGenChance) continue;
                    outpostGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
                }
            }
        }
    }
}

