/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.biomes.decorators;

import java.util.Random;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.event.EventHandlerGC;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenLiquids;
import net.minecraft.world.gen.feature.WorldGenWaterlily;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import zollerngalaxy.biomes.BiomeSpace;
import zollerngalaxy.biomes.decorators.BiomeDecoratorZG;
import zollerngalaxy.blocks.ZGBlockTallGrass;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.enums.EnumBiomeTypeZG;
import zollerngalaxy.core.enums.EnumOreGenZG;
import zollerngalaxy.lib.helpers.ZGDecorateHelper;
import zollerngalaxy.lib.helpers.ZGHelper;
import zollerngalaxy.util.BiomeUtils;
import zollerngalaxy.worldgen.WorldGenBattleTower;
import zollerngalaxy.worldgen.WorldGenClayZG;
import zollerngalaxy.worldgen.WorldGenCrops;
import zollerngalaxy.worldgen.WorldGenFlowersZG;
import zollerngalaxy.worldgen.WorldGenLakesZG;
import zollerngalaxy.worldgen.WorldGenMinableZG;
import zollerngalaxy.worldgen.WorldGenOutpost;
import zollerngalaxy.worldgen.WorldGenSandZG;
import zollerngalaxy.worldgen.WorldGenTallGrassZG;

public class BiomeDecoratorOasis
extends BiomeDecoratorZG {
    public static final Block SURFACE_ROCK = ZGBlocks.oasisRock;
    public static final Block STONE = ZGBlocks.oasisStone;
    private WorldGenerator dirtOreGen;
    private WorldGenerator gravelOreGen;
    private WorldGenerator superChargedCoalGen;
    private WorldGenerator diamondGen;
    private WorldGenerator redstoneGen;
    private WorldGenerator coalGen;
    private WorldGenerator ironGen;
    private WorldGenerator goldGen;
    private WorldGenerator tinGen;
    private WorldGenerator leadGen;
    private WorldGenerator shinestoneGen;
    public WorldGenerator battleTowerGen = new WorldGenBattleTower(ZGBlocks.oasisCobble.func_176223_P(), ZGBlocks.blockOutpost.func_176223_P());
    public WorldGenerator field_76809_f = new WorldGenClayZG(ZGBlocks.mudClayBlock, 8);
    public WorldGenerator field_76822_h = new WorldGenSandZG(ZGBlocks.oasisGravel, 6);
    public WorldGenerator field_76810_g = new WorldGenSandZG(ZGBlocks.oasisSand, 7);
    public WorldGenerator field_150514_p = new WorldGenFlowersZG(ZGBlocks.oasisFlower.func_176223_P());
    public WorldGenerator treeGen;
    public WorldGenerator cropGen;
    public int waterLakesPerChunk = 4;
    public int lavaLakesPerChunk = this.enableExtremeMode ? 12 : 6;
    public int oilLakesPerChunk = 2;
    public int oasisTallGrassPerChunk = 3;
    public int oasisFlowersPerChunk = 4;
    public int battleTowersPerChunk = 2;
    public int field_76806_I = 2;
    public int cropsPerChunk = 2;
    public int field_76801_G = 2;
    public int field_76805_H = 3;
    public int field_76832_z = 1;
    public int field_76802_A = 6;
    public int field_76833_y = 0;
    public boolean generateLakes = true;
    public boolean generateVines = false;
    public boolean generateCraters = false;
    public boolean generateBattleTowers = true;
    public boolean generateCrops = true;
    public boolean generateClay = true;
    public boolean field_76808_K = true;
    public boolean generateTrees = true;
    public boolean generateTallGrass = true;
    public boolean generateFlowers = true;
    public boolean generateGravel = true;
    public boolean generateSand = true;

    public BiomeDecoratorOasis() {
        this.dirtOreGen = new WorldGenMinableZG(ZGBlocks.oasisDirt, STONE, EnumOreGenZG.DIRT);
        this.gravelOreGen = new WorldGenMinableZG(ZGBlocks.oasisGravel, STONE, EnumOreGenZG.GRAVEL);
        this.superChargedCoalGen = new WorldGenMinableZG(ZGBlocks.oasisSuperChargedCoalOre, STONE, EnumOreGenZG.SUPER_CHARGED_COAL);
        this.diamondGen = new WorldGenMinableZG(ZGBlocks.oasisDiamondOre, STONE, EnumOreGenZG.DIAMOND);
        this.redstoneGen = new WorldGenMinableZG(ZGBlocks.oasisRedstoneOre, STONE, EnumOreGenZG.REDSTONE);
        this.coalGen = new WorldGenMinableZG(ZGBlocks.oasisCoalOre, STONE, EnumOreGenZG.COAL);
        this.ironGen = new WorldGenMinableZG(ZGBlocks.oasisIronOre, STONE, EnumOreGenZG.IRON);
        this.goldGen = new WorldGenMinableZG(ZGBlocks.oasisGoldOre, STONE, EnumOreGenZG.GOLD);
        this.tinGen = new WorldGenMinableZG(ZGBlocks.oasisTinOre, STONE, EnumOreGenZG.TIN);
        this.leadGen = new WorldGenMinableZG(ZGBlocks.oasisLeadOre, STONE, EnumOreGenZG.LEAD);
        this.shinestoneGen = new WorldGenMinableZG(ZGBlocks.blockShinestone, STONE, EnumOreGenZG.SHINESTONE);
    }

    @Override
    protected void generate(Biome biome, World world, Random rand) {
        int genY;
        int x = rand.nextInt(16) + 8;
        int z = rand.nextInt(16) + 8;
        int y = genY = 248;
        Block BLOCK_TOP = biome.field_76752_A.func_177230_c();
        Block BLOCK_FILL = biome.field_76753_B.func_177230_c();
        Block BLOCK_STONE = STONE;
        this.generateOre(this.dirtOreGen, EnumOreGenZG.DIRT, world, rand);
        this.generateOre(this.gravelOreGen, EnumOreGenZG.GRAVEL, world, rand);
        this.generateOre(this.superChargedCoalGen, EnumOreGenZG.SUPER_CHARGED_COAL, world, rand);
        this.generateOre(this.diamondGen, EnumOreGenZG.DIAMOND, world, rand);
        this.generateOre(this.redstoneGen, EnumOreGenZG.REDSTONE, world, rand);
        this.generateOre(this.ironGen, EnumOreGenZG.IRON, world, rand);
        this.generateOre(this.coalGen, EnumOreGenZG.COAL, world, rand);
        this.generateOre(this.goldGen, EnumOreGenZG.GOLD, world, rand);
        this.generateOre(this.tinGen, EnumOreGenZG.TIN, world, rand);
        this.generateOre(this.leadGen, EnumOreGenZG.LEAD, world, rand);
        this.generateOre(this.shinestoneGen, EnumOreGenZG.SHINESTONE, world, rand);
        ChunkPrimer chunkPrimer = new ChunkPrimer();
        ChunkPos forgeChunkPos = new ChunkPos(this.field_180294_c);
        if (biome instanceof BiomeSpace) {
            BiomeSpace spaceBiome = (BiomeSpace)biome;
            genY = spaceBiome.getBiomeHeight();
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_WATER) && this.generateLakes && this.waterLakesPerChunk > 0) {
            int i;
            for (i = 0; i < this.waterLakesPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                Block blockToUse = biome.func_150561_m() == Biome.TempCategory.COLD ? Blocks.field_150432_aD : Blocks.field_150355_j;
                new WorldGenLakesZG(blockToUse, BLOCK_TOP).func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
            if (this.field_76833_y > 0) {
                for (i = 0; i < this.field_76833_y; ++i) {
                    new WorldGenWaterlily().func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
                }
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_LAVA) && this.generateLakes && this.lavaLakesPerChunk > 0) {
            for (int i = 0; i < this.lavaLakesPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                if (rand.nextInt(100) > 5) continue;
                new WorldGenLakesZG((Block)Blocks.field_150353_l, STONE).func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CUSTOM) && this.generateOil && this.oilPerChunk > 0 && ConfigManagerZG.enableOilLakes) {
            for (int i = 0; i < this.oilPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                new WorldGenLakesZG(GCBlocks.crudeOil, BLOCK_STONE).func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
                EventHandlerGC.generateOil((World)world, (Random)rand, (int)x, (int)z, (boolean)false);
            }
        }
        if (this.generateTallGrass && this.oasisTallGrassPerChunk > 0) {
            for (int i = 0; i < this.oasisTallGrassPerChunk + 4; ++i) {
                ZGDecorateHelper.generatePlants(new WorldGenTallGrassZG((ZGBlockTallGrass)ZGBlocks.oasisTallGrass), world, rand, this.field_180294_c);
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FLOWERS) && this.generateFlowers && this.field_76802_A > 0) {
            for (int l2 = 0; l2 < this.field_76802_A; ++l2) {
                int l10;
                int i7 = rand.nextInt(16) + 8;
                int j14 = world.func_175645_m(this.field_180294_c.func_177982_a(i7, 0, l10 = rand.nextInt(16) + 8)).func_177956_o() + 32;
                if (j14 <= 0) continue;
                int k17 = rand.nextInt(j14);
                BlockPos blockpos1 = this.field_180294_c.func_177982_a(i7, k17, l10);
                Block blockflower = ZGBlocks.oasisFlower;
                if (blockflower.func_176223_P().func_185904_a() == Material.field_151579_a) continue;
                this.field_150514_p.func_180709_b(world, rand, blockpos1);
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CLAY) && this.generateClay && this.field_76806_I > 0) {
            for (int i1 = 0; i1 < this.field_76806_I; ++i1) {
                int l1 = rand.nextInt(16) + 8;
                int i6 = rand.nextInt(16) + 8;
                this.field_76809_f.func_180709_b(world, rand, world.func_175672_r(this.field_180294_c.func_177982_a(l1, 0, i6)));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SAND_PASS2) && this.generateGravel && this.field_76801_G > 0) {
            for (int j1 = 0; j1 < this.field_76801_G; ++j1) {
                int i2 = rand.nextInt(16) + 8;
                int j6 = rand.nextInt(16) + 8;
                this.field_76822_h.func_180709_b(world, rand, world.func_175672_r(this.field_180294_c.func_177982_a(i2, 0, j6)));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SAND) && this.generateSand && this.field_76805_H > 0) {
            for (int i = 0; i < this.field_76805_H; ++i) {
                int j = rand.nextInt(16) + 8;
                int k = rand.nextInt(16) + 8;
                this.field_76810_g.func_180709_b(world, rand, world.func_175672_r(this.field_180294_c.func_177982_a(j, 0, k)));
            }
        }
        int k1 = this.field_76832_z;
        if (rand.nextFloat() < this.field_189870_A) {
            ++k1;
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE) && this.generateTrees && this.field_76832_z > 0) {
            for (int i = 0; i < k1; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                if (y < 64) {
                    y = ZGHelper.rngInt(64, 82);
                }
                if (rand.nextInt(100) > 45) continue;
                this.treeGen = ZGHelper.getRandomFruitTree(rand);
                this.treeGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        if (this.generateBattleTowers && this.battleTowersPerChunk > 0 && !BiomeUtils.isOceanBiome(biome) && ZGHelper.rngInt(1, 100) <= 35) {
            for (int i = 0; i < this.battleTowersPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                if (y < 60 || y >= 80) continue;
                this.battleTowerGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        if (this.generateCrops && this.cropsPerChunk > 0 && !BiomeUtils.isOceanBiome(biome) && ZGHelper.rngInt(1, 100) <= 35) {
            for (int i = 0; i < this.cropsPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                if (y < 60) continue;
                this.cropGen = new WorldGenCrops(ZGHelper.getRandomCrop(rand).func_176223_P());
                this.cropGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        if (this.field_76808_K) {
            if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_WATER)) {
                for (int k5 = 0; k5 < 50; ++k5) {
                    int i10 = rand.nextInt(16) + 8;
                    int l13 = rand.nextInt(16) + 8;
                    int i17 = rand.nextInt(120) + 8;
                    if (i17 <= 0) continue;
                    int k19 = rand.nextInt(i17);
                    BlockPos blockpos6 = this.field_180294_c.func_177982_a(i10, k19, l13);
                    new WorldGenLiquids((Block)Blocks.field_150358_i).func_180709_b(world, rand, blockpos6);
                }
            }
            if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_LAVA)) {
                for (int l5 = 0; l5 < 20; ++l5) {
                    int j10 = rand.nextInt(16) + 8;
                    int i14 = rand.nextInt(16) + 8;
                    int j17 = rand.nextInt(rand.nextInt(rand.nextInt(112) + 8) + 8);
                    BlockPos blockpos3 = this.field_180294_c.func_177982_a(j10, j17, i14);
                    new WorldGenLiquids((Block)Blocks.field_150356_k).func_180709_b(world, rand, blockpos3);
                }
            }
        }
        if (this.generateOutposts && this.outpostsPerChunk > 0) {
            BiomeSpace spaceBiome;
            if (biome instanceof BiomeSpace && (spaceBiome = (BiomeSpace)biome).getBiomeType() == EnumBiomeTypeZG.OCEAN) {
                return;
            }
            y = rand.nextInt(rand.nextInt(genY) + 8);
            if (y >= 62) {
                IBlockState OUTPOST_STATE = ZGBlocks.blockOutpost.func_176223_P();
                WorldGenOutpost outpostGen = new WorldGenOutpost(OUTPOST_STATE, OUTPOST_STATE);
                for (int i = 0; i < this.outpostsPerChunk; ++i) {
                    if (rand.nextInt(this.enableExtremeMode ? 200 : 100) > ConfigManagerZG.outpostGenChance) continue;
                    outpostGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
                }
            }
        }
    }
}

