/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.biomes.decorators;

import java.util.Random;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.event.EventHandlerGC;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import zollerngalaxy.biomes.BiomeSpace;
import zollerngalaxy.biomes.decorators.BiomeDecoratorZG;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.enums.EnumOreGenZG;
import zollerngalaxy.lib.helpers.ZGDecorateHelper;
import zollerngalaxy.lib.helpers.ZGHelper;
import zollerngalaxy.util.BiomeUtils;
import zollerngalaxy.worldgen.WorldGenBattleTower;
import zollerngalaxy.worldgen.WorldGenLakesZG;
import zollerngalaxy.worldgen.WorldGenMinableZG;
import zollerngalaxy.worldgen.WorldGenOutpost;
import zollerngalaxy.worldgen.WorldGenTunnel;
import zollerngalaxy.worldgen.kronos.WorldGenKronosCrops;
import zollerngalaxy.worldgen.kronos.WorldGenNetherWarts;

public class BiomeDecoratorKronos
extends BiomeDecoratorZG {
    private static final Block NETHERRACK = Blocks.field_150424_aL;
    private static final Block SOUL_SAND = Blocks.field_150425_aM;
    private static final Block OBSIDIAN = Blocks.field_150343_Z;
    private static final Block NETHER_BRICK = Blocks.field_150385_bj;
    private static final Block GLOWSTONE = Blocks.field_150426_aN;
    private static final Block LAVA = Blocks.field_150353_l;
    private static final Block GRAVEL = Blocks.field_150351_n;
    private static final Block MAGROCK = ZGBlocks.kriffMagmaRock;
    private WorldGenerator dirtGen;
    private WorldGenerator sandGen;
    private WorldGenerator gravelGen;
    private WorldGenerator obsidianGen;
    private WorldGenerator magrockGen;
    private WorldGenerator coalGen;
    private WorldGenerator fueltoniumGen;
    private WorldGenerator ironGen;
    private WorldGenerator shiniumGen;
    private WorldGenerator silverGen;
    private WorldGenerator nickleGen;
    private WorldGenerator leadGen;
    private WorldGenerator tinGen;
    private WorldGenerator copperGen;
    private WorldGenerator lapisGen;
    private WorldGenerator diamondGen;
    private WorldGenerator emeraldGen;
    private WorldGenerator redstoneGen;
    private WorldGenerator goldGen;
    private WorldGenerator steelGen;
    private WorldGenerator rubyGen;
    private WorldGenerator sapphireGen;
    private WorldGenerator zincGen;
    private WorldGenerator amaranthGen;
    private WorldGenerator superChargedCoalGen;
    private WorldGenerator zaniumGen;
    private WorldGenerator raditeGen;
    private WorldGenerator zogiteGen;
    private WorldGenerator azuriteGen;
    private WorldGenerator netherWartGen = new WorldGenNetherWarts();
    private WorldGenerator battleTowerGen = new WorldGenBattleTower(NETHER_BRICK.func_176223_P(), GLOWSTONE.func_176223_P());
    private WorldGenerator tunnelGen = new WorldGenTunnel();
    private WorldGenerator cropGen = new WorldGenKronosCrops(ZGBlocks.cropGhostPepper.func_176223_P());
    public boolean generateLakes = true;
    public boolean generateMushrooms = true;
    public boolean generateCraters = true;
    public boolean generateNetherWarts = false;
    public boolean generateBattleTowers = true;
    public boolean generateTunnels = true;
    public boolean generateOil = true;
    public boolean generateCrops = true;
    public int lavaLakesPerChunk = 8;
    public int obsidianLakesPerChunk = 2;
    public int field_76798_D = 5;
    public int field_76805_H = 4;
    public int netherWartsPerChunk = 0;
    public int battleTowersPerChunk = 1;
    public int tunnelsPerChunk = 4;
    public int oilPerChunk = 1;
    public int cropsPerChunk = 1;

    public BiomeDecoratorKronos() {
        this.dirtGen = new WorldGenMinableZG(ZGBlocks.netherDirt, NETHERRACK, EnumOreGenZG.DIRT);
        this.sandGen = new WorldGenMinableZG(SOUL_SAND, NETHERRACK, EnumOreGenZG.SAND);
        this.gravelGen = new WorldGenMinableZG(GRAVEL, NETHERRACK, EnumOreGenZG.GRAVEL);
        this.obsidianGen = new WorldGenMinableZG(OBSIDIAN, NETHERRACK, EnumOreGenZG.OBSIDIAN);
        this.magrockGen = new WorldGenMinableZG(ZGBlocks.kriffMagmaRock, NETHERRACK, EnumOreGenZG.MAGMA);
        this.coalGen = new WorldGenMinableZG(ZGBlocks.netherCoalOre, NETHERRACK, EnumOreGenZG.COAL);
        this.fueltoniumGen = new WorldGenMinableZG(ZGBlocks.netherFueltoniumOre, NETHERRACK, EnumOreGenZG.FUELTONIUM);
        this.ironGen = new WorldGenMinableZG(ZGBlocks.netherIronOre, NETHERRACK, EnumOreGenZG.IRON);
        this.shiniumGen = new WorldGenMinableZG(ZGBlocks.netherShiniumOre, NETHERRACK, EnumOreGenZG.SHINIUM);
        this.silverGen = new WorldGenMinableZG(ZGBlocks.netherSilverOre, NETHERRACK, EnumOreGenZG.SILVER);
        this.nickleGen = new WorldGenMinableZG(ZGBlocks.netherNickleOre, NETHERRACK, EnumOreGenZG.NICKEL);
        this.leadGen = new WorldGenMinableZG(ZGBlocks.netherLeadOre, NETHERRACK, EnumOreGenZG.LEAD);
        this.tinGen = new WorldGenMinableZG(ZGBlocks.netherTinOre, NETHERRACK, EnumOreGenZG.TIN);
        this.copperGen = new WorldGenMinableZG(ZGBlocks.netherCopperOre, NETHERRACK, EnumOreGenZG.COPPER);
        this.lapisGen = new WorldGenMinableZG(ZGBlocks.netherLapisOre, NETHERRACK, EnumOreGenZG.LAPIS);
        this.diamondGen = new WorldGenMinableZG(ZGBlocks.netherDiamondOre, NETHERRACK, EnumOreGenZG.DIAMOND);
        this.emeraldGen = new WorldGenMinableZG(ZGBlocks.netherEmeraldOre, NETHERRACK, EnumOreGenZG.EMERALD);
        this.redstoneGen = new WorldGenMinableZG(ZGBlocks.netherRedstoneOre, NETHERRACK, EnumOreGenZG.REDSTONE);
        this.goldGen = new WorldGenMinableZG(ZGBlocks.netherGoldOre, NETHERRACK, EnumOreGenZG.GOLD);
        this.steelGen = new WorldGenMinableZG(ZGBlocks.netherSteelOre, NETHERRACK, EnumOreGenZG.STEEL);
        this.rubyGen = new WorldGenMinableZG(ZGBlocks.netherRubyOre, NETHERRACK, EnumOreGenZG.RUBY);
        this.sapphireGen = new WorldGenMinableZG(ZGBlocks.netherSapphireOre, NETHERRACK, EnumOreGenZG.SAPPHIRE);
        this.zincGen = new WorldGenMinableZG(ZGBlocks.netherZincOre, NETHERRACK, EnumOreGenZG.ZINC);
        this.amaranthGen = new WorldGenMinableZG(ZGBlocks.netherAmaranthOre, NETHERRACK, EnumOreGenZG.AMARANTH);
        this.superChargedCoalGen = new WorldGenMinableZG(ZGBlocks.netherSuperChargedCoalOre, NETHERRACK, EnumOreGenZG.SUPER_CHARGED_COAL);
        this.zaniumGen = new WorldGenMinableZG(ZGBlocks.netherZaniumOre, NETHERRACK, EnumOreGenZG.ZANIUM);
        this.raditeGen = new WorldGenMinableZG(ZGBlocks.netherRaditeOre, NETHERRACK, EnumOreGenZG.RADITE);
        this.zogiteGen = new WorldGenMinableZG(ZGBlocks.netherZogiteOre, NETHERRACK, EnumOreGenZG.ZOGITE);
        this.azuriteGen = new WorldGenMinableZG(ZGBlocks.azuriteOre, OBSIDIAN, EnumOreGenZG.AZURITE);
    }

    @Override
    protected void generate(Biome biome, World world, Random rand) {
        BiomeSpace spaceBiome;
        int x = rand.nextInt(16) + 8;
        int z = rand.nextInt(16) + 8;
        int y = rand.nextInt(120) + 8;
        ChunkPrimer chunkPrimer = new ChunkPrimer();
        ChunkPos forgeChunkPos = new ChunkPos(this.field_180294_c);
        Block BLOCK_TOP = biome.field_76752_A.func_177230_c();
        Block BLOCK_FILL = biome.field_76753_B.func_177230_c();
        EnumOreGenZG.DIRT.setMaxHeight(128);
        EnumOreGenZG.SAND.setMaxHeight(128);
        EnumOreGenZG.GRAVEL.setMaxHeight(128);
        EnumOreGenZG.OBSIDIAN.setMaxHeight(128);
        EnumOreGenZG.MAGMA.setMaxHeight(128);
        EnumOreGenZG.COAL.setMaxHeight(128);
        EnumOreGenZG.FUELTONIUM.setMaxHeight(128);
        EnumOreGenZG.IRON.setMaxHeight(128);
        EnumOreGenZG.SHINIUM.setMaxHeight(128);
        EnumOreGenZG.SILVER.setMaxHeight(128);
        EnumOreGenZG.NICKEL.setMaxHeight(128);
        EnumOreGenZG.LEAD.setMaxHeight(128);
        EnumOreGenZG.TIN.setMaxHeight(128);
        EnumOreGenZG.COPPER.setMaxHeight(128);
        EnumOreGenZG.LAPIS.setMaxHeight(128);
        EnumOreGenZG.DIAMOND.setMaxHeight(128);
        EnumOreGenZG.EMERALD.setMaxHeight(128);
        EnumOreGenZG.REDSTONE.setMaxHeight(128);
        EnumOreGenZG.GOLD.setMaxHeight(128);
        EnumOreGenZG.STEEL.setMaxHeight(128);
        EnumOreGenZG.RUBY.setMaxHeight(128);
        EnumOreGenZG.SAPPHIRE.setMaxHeight(128);
        EnumOreGenZG.ZINC.setMaxHeight(128);
        EnumOreGenZG.AMARANTH.setMaxHeight(128);
        EnumOreGenZG.SUPER_CHARGED_COAL.setMaxHeight(128);
        EnumOreGenZG.ZANIUM.setMaxHeight(128);
        EnumOreGenZG.RADITE.setMaxHeight(128);
        EnumOreGenZG.ZOGITE.setMaxHeight(128);
        EnumOreGenZG.AZURITE.FactoryOreGen(25, 10, 128);
        this.generateOre(this.dirtGen, EnumOreGenZG.DIRT, world, rand);
        this.generateOre(this.sandGen, EnumOreGenZG.SAND, world, rand);
        this.generateOre(this.gravelGen, EnumOreGenZG.GRAVEL, world, rand);
        this.generateOre(this.obsidianGen, EnumOreGenZG.OBSIDIAN, world, rand);
        this.generateOre(this.magrockGen, EnumOreGenZG.MAGMA, world, rand);
        this.generateOre(this.coalGen, EnumOreGenZG.COAL, world, rand);
        this.generateOre(this.fueltoniumGen, EnumOreGenZG.FUELTONIUM, world, rand);
        this.generateOre(this.ironGen, EnumOreGenZG.IRON, world, rand);
        this.generateOre(this.shiniumGen, EnumOreGenZG.SHINIUM, world, rand);
        this.generateOre(this.silverGen, EnumOreGenZG.SILVER, world, rand);
        this.generateOre(this.nickleGen, EnumOreGenZG.NICKEL, world, rand);
        this.generateOre(this.leadGen, EnumOreGenZG.LEAD, world, rand);
        this.generateOre(this.tinGen, EnumOreGenZG.TIN, world, rand);
        this.generateOre(this.copperGen, EnumOreGenZG.COPPER, world, rand);
        this.generateOre(this.lapisGen, EnumOreGenZG.LAPIS, world, rand);
        this.generateOre(this.diamondGen, EnumOreGenZG.DIAMOND, world, rand);
        this.generateOre(this.emeraldGen, EnumOreGenZG.EMERALD, world, rand);
        this.generateOre(this.redstoneGen, EnumOreGenZG.REDSTONE, world, rand);
        this.generateOre(this.goldGen, EnumOreGenZG.GOLD, world, rand);
        this.generateOre(this.steelGen, EnumOreGenZG.STEEL, world, rand);
        this.generateOre(this.rubyGen, EnumOreGenZG.RUBY, world, rand);
        this.generateOre(this.sapphireGen, EnumOreGenZG.SAPPHIRE, world, rand);
        this.generateOre(this.zincGen, EnumOreGenZG.ZINC, world, rand);
        this.generateOre(this.amaranthGen, EnumOreGenZG.AMARANTH, world, rand);
        this.generateOre(this.superChargedCoalGen, EnumOreGenZG.SUPER_CHARGED_COAL, world, rand);
        this.generateOre(this.zaniumGen, EnumOreGenZG.ZANIUM, world, rand);
        this.generateOre(this.raditeGen, EnumOreGenZG.RADITE, world, rand);
        this.generateOre(this.zogiteGen, EnumOreGenZG.ZOGITE, world, rand);
        this.generateOre(this.azuriteGen, EnumOreGenZG.AZURITE, world, rand);
        int genY = y;
        if (biome instanceof BiomeSpace) {
            spaceBiome = (BiomeSpace)biome;
            genY = spaceBiome.getBiomeHeight();
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_LAVA) && this.generateLakes && this.lavaLakesPerChunk > 0) {
            for (int i = 0; i < this.lavaLakesPerChunk + 4; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                if (rand.nextInt(this.enableExtremeMode ? 75 : 100) > 50) continue;
                new WorldGenLakesZG(LAVA, NETHERRACK).func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CUSTOM) && this.generateLakes && this.obsidianLakesPerChunk > 0) {
            for (int i = 0; i < this.lavaLakesPerChunk + 4; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
            }
            if (rand.nextInt(100) <= 50 && rand.nextInt(3) == 0) {
                new WorldGenLakesZG(OBSIDIAN, NETHERRACK).func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CUSTOM) && this.generateOil && this.oilPerChunk > 0 && this.enableOilGen) {
            for (int i = 0; i < this.oilPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                new WorldGenLakesZG(GCBlocks.crudeOil, NETHERRACK).func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
                EventHandlerGC.generateOil((World)world, (Random)rand, (int)x, (int)z, (boolean)false);
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SHROOM) && this.generateMushrooms) {
            int l8;
            int j4;
            int k12;
            int k8;
            int i4;
            int j12;
            for (int l3 = 0; l3 < this.field_76798_D; ++l3) {
                int i12;
                int j8;
                int j15;
                if (rand.nextInt(4) == 0) {
                    int i8 = rand.nextInt(16) + 8;
                    int l11 = rand.nextInt(16) + 8;
                    BlockPos blockpos2 = world.func_175645_m(this.field_180294_c.func_177982_a(i8, 0, l11));
                    this.field_76828_s.func_180709_b(world, rand, blockpos2);
                }
                if (rand.nextInt(8) != 0 || (j15 = world.func_175645_m(this.field_180294_c.func_177982_a(j8 = rand.nextInt(16) + 8, 0, i12 = rand.nextInt(16) + 8)).func_177956_o() * 2) <= 0) continue;
                int k18 = rand.nextInt(j15);
                BlockPos blockpos5 = this.field_180294_c.func_177982_a(j8, k18, i12);
                this.field_76827_t.func_180709_b(world, rand, blockpos5);
            }
            if (rand.nextInt(4) == 0 && (j12 = world.func_175645_m(this.field_180294_c.func_177982_a(i4 = rand.nextInt(16) + 8, 0, k8 = rand.nextInt(16) + 8)).func_177956_o() * 2) > 0) {
                int k15 = rand.nextInt(j12);
                this.field_76828_s.func_180709_b(world, rand, this.field_180294_c.func_177982_a(i4, k15, k8));
            }
            if (rand.nextInt(8) == 0 && (k12 = world.func_175645_m(this.field_180294_c.func_177982_a(j4 = rand.nextInt(16) + 8, 0, l8 = rand.nextInt(16) + 8)).func_177956_o() * 2) > 0) {
                int l15 = rand.nextInt(k12);
                this.field_76827_t.func_180709_b(world, rand, this.field_180294_c.func_177982_a(j4, l15, l8));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SAND)) {
            for (int i = 0; i < this.field_76805_H; ++i) {
                int j = rand.nextInt(16) + 8;
                int k = rand.nextInt(16) + 8;
                this.sandGen.func_180709_b(world, rand, world.func_175672_r(this.field_180294_c.func_177982_a(j, 0, k)));
            }
        }
        if (this.netherWartsPerChunk > 0) {
            for (int i = 0; i < this.netherWartsPerChunk + 4; ++i) {
                ZGDecorateHelper.generatePlants(this.netherWartGen, world, rand, this.field_180294_c);
            }
        }
        if (this.generateBattleTowers && this.battleTowersPerChunk > 0 && !BiomeUtils.isOceanBiome(biome) && ZGHelper.rngInt(1, 100) <= 35 && rand.nextInt(6) == 0) {
            for (int i = 0; i < this.battleTowersPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                if (y < 20 || y >= 90) continue;
                this.battleTowerGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        if (this.generateTunnels && this.tunnelsPerChunk > 0 && ZGHelper.rngInt(1, 100) <= 45) {
            y = rand.nextInt(rand.nextInt(genY) + 8);
            for (int i = 0; i < this.tunnelsPerChunk; ++i) {
                if (y > 90) continue;
                this.tunnelGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        if (this.generateCrops && this.cropsPerChunk > 0 && !BiomeUtils.isOceanBiome(biome) && ZGHelper.rngInt(1, 100) <= 45 && rand.nextInt(4) == 0) {
            for (int i = 0; i < this.cropsPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                if (y < 10) continue;
                this.cropGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        if (this.generateOutposts && this.outpostsPerChunk > 0) {
            if (biome instanceof BiomeSpace && !BiomeUtils.isOceanBiome((Biome)(spaceBiome = (BiomeSpace)biome))) {
                return;
            }
            y = rand.nextInt(rand.nextInt(genY) + 8);
            if (y >= 62) {
                IBlockState OUTPOST_STATE = ZGBlocks.blockOutpost.func_176223_P();
                WorldGenOutpost outpostGen = new WorldGenOutpost(OUTPOST_STATE, OUTPOST_STATE);
                for (int i = 0; i < this.outpostsPerChunk; ++i) {
                    if (rand.nextInt(this.enableExtremeMode ? 200 : 100) > ConfigManagerZG.outpostGenChance) continue;
                    outpostGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
                }
            }
        }
    }
}

