/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.biomes.decorators;

import java.util.Random;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.event.EventHandlerGC;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenLiquids;
import net.minecraft.world.gen.feature.WorldGenWaterlily;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import zollerngalaxy.biomes.BiomeSpace;
import zollerngalaxy.biomes.decorators.BiomeDecoratorZG;
import zollerngalaxy.blocks.ZGBlockTallGrass;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.dimensions.chunkproviders.ChunkProviderEden;
import zollerngalaxy.core.enums.EnumBiomeTypeZG;
import zollerngalaxy.core.enums.EnumOreGenZG;
import zollerngalaxy.lib.helpers.ZGDecorateHelper;
import zollerngalaxy.lib.helpers.ZGHelper;
import zollerngalaxy.util.BiomeUtils;
import zollerngalaxy.worldgen.WorldGenBattleTower;
import zollerngalaxy.worldgen.WorldGenClayZG;
import zollerngalaxy.worldgen.WorldGenCrops;
import zollerngalaxy.worldgen.WorldGenCrystalTower;
import zollerngalaxy.worldgen.WorldGenDeadBushZG;
import zollerngalaxy.worldgen.WorldGenLakesZG;
import zollerngalaxy.worldgen.WorldGenMinableZG;
import zollerngalaxy.worldgen.WorldGenOutpost;
import zollerngalaxy.worldgen.WorldGenSandZG;
import zollerngalaxy.worldgen.WorldGenSmallCraterZG;
import zollerngalaxy.worldgen.WorldGenTallGrassZG;
import zollerngalaxy.worldgen.WorldGenZGMushroomTree;
import zollerngalaxy.worldgen.eden.WorldGenDropship;
import zollerngalaxy.worldgen.eden.WorldGenEdenFlowers;
import zollerngalaxy.worldgen.eden.WorldGenEdenPumpkins;
import zollerngalaxy.worldgen.eden.WorldGenEdenTrees;
import zollerngalaxy.worldgen.eden.WorldGenGiantBone;

public class BiomeDecoratorEden
extends BiomeDecoratorZG {
    private WorldGenerator dirtOreGen;
    private WorldGenerator gravelOreGen;
    private WorldGenerator coalGen;
    private WorldGenerator ironGen;
    private WorldGenerator goldGen;
    private WorldGenerator tinGen;
    private WorldGenerator leadGen;
    private WorldGenerator nickelGen;
    private WorldGenerator copperGen;
    private WorldGenerator silverGen;
    private WorldGenerator aluminumGen;
    private WorldGenerator redstoneGen;
    private WorldGenerator lapisGen;
    private WorldGenerator diamondGen;
    private WorldGenerator emeraldGen;
    private WorldGenerator meteoricIronGen;
    private WorldGenerator deshGen;
    private WorldGenerator viriGen;
    private WorldGenerator cobaltGen;
    private WorldGenerator eveniumGen;
    private WorldGenerator steelGen;
    private WorldGenerator bronzeGen;
    private WorldGenerator invarGen;
    private WorldGenerator electrumGen;
    private WorldGenerator platinumGen;
    private WorldGenerator heartiumGen;
    public int tallGrassPerChunk = 4;
    public int field_76802_A = 2;
    public int edenPumpkinsPerChunk = 0;
    public int field_76832_z = 1;
    public int mushroomTreesPerChunk = 0;
    public int lavaLakesPerChunk = this.enableExtremeMode ? 2 : 1;
    public int waterLakesPerChunk = 4;
    public int dropshipsPerChunk = 1;
    public int field_76801_G = 2;
    public int field_76805_H = 3;
    public int field_76806_I = 2;
    public int field_76798_D = 2;
    public int cropsPerChunk = 2;
    public int battleTowersPerChunk = 2;
    public int cratersPerChunk = 0;
    public int field_76804_C = 4;
    public float field_189870_A = 0.5f;
    private WorldGenerator pumpkinGen = new WorldGenEdenPumpkins();
    private WorldGenerator tallGrassGen = new WorldGenTallGrassZG((ZGBlockTallGrass)ZGBlocks.edenTallGrass);
    private WorldGenerator waterLilyGen = new WorldGenWaterlily();
    private WorldGenerator treeGenEden = new WorldGenEdenTrees(false, ZGHelper.rngInt(5, 10), ZGBlocks.edenWoodLog.func_176223_P(), ZGBlocks.edenWoodLeaves.func_176223_P(), this.generateVines);
    private WorldGenerator towerGen = new WorldGenCrystalTower(ZGBlocks.edenSacredStone.func_176223_P());
    private WorldGenerator giantBoneGen = new WorldGenGiantBone();
    private WorldGenerator treeGenMushroom = new WorldGenZGMushroomTree(false, ZGHelper.rngInt(3, 6));
    private WorldGenerator dropshipGen = new WorldGenDropship();
    private WorldGenerator clayGen = new WorldGenClayZG(ZGBlocks.mudClayBlock, 8);
    private WorldGenerator gravelGen = new WorldGenSandZG(ZGBlocks.edenGravel, 6);
    private WorldGenerator sandGen = new WorldGenSandZG(ZGBlocks.edenBloodSand, 7);
    private WorldGenerator battleTowerGen = new WorldGenBattleTower(ZGBlocks.edenCobbleRock.func_176223_P(), ZGBlocks.blockShinestone.func_176223_P());
    private WorldGenerator craterGen = new WorldGenSmallCraterZG();
    private WorldGenerator deadBushGen = new WorldGenDeadBushZG(Blocks.field_150330_I.func_176223_P());
    private WorldGenerator cropGen;
    public boolean generateVines = false;
    public boolean generateLakes = true;
    public boolean generateWitchHuts = false;
    public boolean generateTowers = true;
    public boolean generateGiantBones = false;
    public boolean generateMansions = false;
    public boolean generateTrees = true;
    public boolean generateMushroomTrees = false;
    public boolean generatePumpkins = false;
    public boolean generateOutposts = true;
    public boolean generateDropships = true;
    public boolean generateFlowers = true;
    public boolean generateTallGrass = true;
    public boolean generateGravel = true;
    public boolean generateSand = true;
    public boolean generateClay = true;
    public boolean generateMushrooms = true;
    public boolean generateCrops = true;
    public boolean generateBattleTowers = true;
    public boolean generateCraters = false;
    public boolean generateDeadBush = false;

    public BiomeDecoratorEden() {
        this.dirtOreGen = new WorldGenMinableZG(ZGBlocks.edenSoil, ZGBlocks.edenSurfaceRock, EnumOreGenZG.DIRT);
        this.gravelOreGen = new WorldGenMinableZG(ZGBlocks.edenGravel, ZGBlocks.edenStone, EnumOreGenZG.GRAVEL);
        this.coalGen = new WorldGenMinableZG(ZGBlocks.edenCoalOre, ZGBlocks.edenStone, EnumOreGenZG.COAL);
        this.tinGen = new WorldGenMinableZG(ZGBlocks.edenTinOre, ZGBlocks.edenStone, EnumOreGenZG.TIN);
        this.leadGen = new WorldGenMinableZG(ZGBlocks.edenLeadOre, ZGBlocks.edenStone, EnumOreGenZG.LEAD);
        this.nickelGen = new WorldGenMinableZG(ZGBlocks.edenNickelOre, ZGBlocks.edenStone, EnumOreGenZG.NICKEL);
        this.copperGen = new WorldGenMinableZG(ZGBlocks.edenCopperOre, ZGBlocks.edenStone, EnumOreGenZG.COPPER);
        this.silverGen = new WorldGenMinableZG(ZGBlocks.edenSilverOre, ZGBlocks.edenStone, EnumOreGenZG.SILVER);
        this.ironGen = new WorldGenMinableZG(ZGBlocks.edenIronOre, ZGBlocks.edenStone, EnumOreGenZG.IRON);
        this.goldGen = new WorldGenMinableZG(ZGBlocks.edenGoldOre, ZGBlocks.edenStone, EnumOreGenZG.GOLD);
        this.aluminumGen = new WorldGenMinableZG(ZGBlocks.edenAluminumOre, ZGBlocks.edenStone, EnumOreGenZG.ALUMINUM);
        this.redstoneGen = new WorldGenMinableZG(ZGBlocks.edenRedstoneOre, ZGBlocks.edenStone, EnumOreGenZG.REDSTONE);
        this.lapisGen = new WorldGenMinableZG(ZGBlocks.edenLapisOre, ZGBlocks.edenStone, EnumOreGenZG.LAPIS);
        this.diamondGen = new WorldGenMinableZG(ZGBlocks.edenDiamondOre, ZGBlocks.edenStone, EnumOreGenZG.DIAMOND);
        this.emeraldGen = new WorldGenMinableZG(ZGBlocks.edenEmeraldOre, ZGBlocks.edenStone, EnumOreGenZG.EMERALD);
        this.meteoricIronGen = new WorldGenMinableZG(ZGBlocks.edenMeteoricIronOre, ZGBlocks.edenStone, EnumOreGenZG.METEORIC_IRON);
        this.deshGen = new WorldGenMinableZG(ZGBlocks.edenDeshOre, ZGBlocks.edenStone, EnumOreGenZG.DESH);
        this.viriGen = new WorldGenMinableZG(ZGBlocks.edenViriniumOre, ZGBlocks.edenStone, EnumOreGenZG.VIRINIUM);
        this.cobaltGen = new WorldGenMinableZG(ZGBlocks.edenCobaltOre, ZGBlocks.edenStone, EnumOreGenZG.COBALT);
        this.eveniumGen = new WorldGenMinableZG(ZGBlocks.edenEveniumOre, ZGBlocks.edenStone, EnumOreGenZG.EVENIUM);
        this.steelGen = new WorldGenMinableZG(ZGBlocks.edenSteelOre, ZGBlocks.edenSteelOre, EnumOreGenZG.STEEL);
        this.bronzeGen = new WorldGenMinableZG(ZGBlocks.edenBronzeOre, ZGBlocks.edenStone, EnumOreGenZG.BRONZE);
        this.invarGen = new WorldGenMinableZG(ZGBlocks.edenInvarOre, ZGBlocks.edenStone, EnumOreGenZG.INVAR);
        this.electrumGen = new WorldGenMinableZG(ZGBlocks.edenElectrumOre, ZGBlocks.edenStone, EnumOreGenZG.ELECTRUM);
        this.platinumGen = new WorldGenMinableZG(ZGBlocks.edenPlatinumOre, ZGBlocks.edenStone, EnumOreGenZG.PLATINUM);
        this.heartiumGen = new WorldGenMinableZG(ZGBlocks.edenHeartiumOre, ZGBlocks.edenStone, EnumOreGenZG.HEARTIUM);
    }

    @Override
    protected void generate(Biome biome, World world, Random rand) {
        int genY;
        int x = rand.nextInt(16) + 8;
        int z = rand.nextInt(16) + 8;
        ChunkPrimer chunkPrimer = new ChunkPrimer();
        ChunkPos forgeChunkPos = new ChunkPos(this.field_180294_c);
        this.generateOre(this.dirtOreGen, EnumOreGenZG.DIRT, world, rand);
        this.generateOre(this.gravelOreGen, EnumOreGenZG.GRAVEL, world, rand);
        this.generateOre(this.coalGen, EnumOreGenZG.COAL, world, rand);
        this.generateOre(this.ironGen, EnumOreGenZG.IRON, world, rand);
        this.generateOre(this.goldGen, EnumOreGenZG.GOLD, world, rand);
        this.generateOre(this.tinGen, EnumOreGenZG.TIN, world, rand);
        this.generateOre(this.leadGen, EnumOreGenZG.LEAD, world, rand);
        this.generateOre(this.nickelGen, EnumOreGenZG.NICKEL, world, rand);
        this.generateOre(this.copperGen, EnumOreGenZG.COPPER, world, rand);
        this.generateOre(this.silverGen, EnumOreGenZG.SILVER, world, rand);
        this.generateOre(this.aluminumGen, EnumOreGenZG.ALUMINUM, world, rand);
        this.generateOre(this.redstoneGen, EnumOreGenZG.REDSTONE, world, rand);
        this.generateOre(this.lapisGen, EnumOreGenZG.LAPIS, world, rand);
        this.generateOre(this.diamondGen, EnumOreGenZG.DIAMOND, world, rand);
        this.generateOre(this.emeraldGen, EnumOreGenZG.EMERALD, world, rand);
        this.generateOre(this.meteoricIronGen, EnumOreGenZG.METEORIC_IRON, world, rand);
        this.generateOre(this.deshGen, EnumOreGenZG.DESH, world, rand);
        this.generateOre(this.viriGen, EnumOreGenZG.VIRINIUM, world, rand);
        this.generateOre(this.cobaltGen, EnumOreGenZG.COBALT, world, rand);
        this.generateOre(this.eveniumGen, EnumOreGenZG.EVENIUM, world, rand);
        this.generateOre(this.steelGen, EnumOreGenZG.STEEL, world, rand);
        this.generateOre(this.bronzeGen, EnumOreGenZG.BRONZE, world, rand);
        this.generateOre(this.invarGen, EnumOreGenZG.INVAR, world, rand);
        this.generateOre(this.electrumGen, EnumOreGenZG.ELECTRUM, world, rand);
        this.generateOre(this.platinumGen, EnumOreGenZG.PLATINUM, world, rand);
        this.generateOre(this.heartiumGen, EnumOreGenZG.HEARTIUM, world, rand);
        int y = genY = 248;
        Block BLOCK_TOP = biome.field_76752_A.func_177230_c();
        Block BLOCK_FILL = biome.field_76753_B.func_177230_c();
        Block BLOCK_STONE = ZGBlocks.edenStone;
        if (biome instanceof BiomeSpace) {
            BiomeSpace spaceBiome = (BiomeSpace)biome;
            genY = spaceBiome.getBiomeHeight();
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_LAVA) && this.generateLakes && this.lavaLakesPerChunk > 0) {
            for (int i = 0; i < this.lavaLakesPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                if (rand.nextInt(this.enableExtremeMode ? 75 : 100) > 50) continue;
                new WorldGenLakesZG((Block)Blocks.field_150353_l, BLOCK_STONE).func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_WATER) && this.generateLakes && this.waterLakesPerChunk > 0) {
            int i;
            for (i = 0; i < this.waterLakesPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                Block blockToUse = BiomeUtils.isColdBiome(biome) ? Blocks.field_150432_aD : Blocks.field_150355_j;
                new WorldGenLakesZG(blockToUse, BLOCK_TOP).func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
            if (this.field_76833_y > 0) {
                for (i = 0; i < this.field_76833_y; ++i) {
                    this.waterLilyGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
                }
            }
        }
        if (this.generateDeadBush && this.field_76804_C > 0 && TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.DEAD_BUSH)) {
            for (int j3 = 0; j3 < this.field_76804_C; ++j3) {
                int j11;
                int k7 = rand.nextInt(16) + 8;
                int l14 = world.func_175645_m(this.field_180294_c.func_177982_a(k7, 0, j11 = rand.nextInt(16) + 8)).func_177956_o() * 2;
                if (l14 <= 0) continue;
                int i18 = rand.nextInt(l14);
                this.deadBushGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(k7, i18, j11));
            }
        }
        if (this.generateTallGrass && this.tallGrassPerChunk > 0) {
            for (int i = 0; i < this.tallGrassPerChunk + 4; ++i) {
                ZGDecorateHelper.generatePlants(this.tallGrassGen, world, rand, this.field_180294_c);
            }
        }
        if (this.generatePumpkins && this.edenPumpkinsPerChunk > 0) {
            for (int i = 0; i < this.edenPumpkinsPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                if (y < 64) {
                    y = ZGHelper.rngInt(64, 82);
                }
                if (rand.nextInt(100) > 25) continue;
                this.pumpkinGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FLOWERS) && this.generateFlowers && this.field_76802_A > 0) {
            for (int l2 = 0; l2 < this.field_76802_A; ++l2) {
                int l10;
                int i7 = rand.nextInt(16) + 8;
                int j14 = world.func_175645_m(this.field_180294_c.func_177982_a(i7, 0, l10 = rand.nextInt(16) + 8)).func_177956_o() + 32;
                if (j14 <= 0) continue;
                int k17 = rand.nextInt(j14);
                BlockPos blockpos1 = this.field_180294_c.func_177982_a(i7, k17, l10);
                Block edenFlower = ZGBlocks.edenFlower;
                int r = rand.nextInt(30);
                if (r <= 5) {
                    edenFlower = ZGBlocks.edenFlowerBlue;
                } else if (r <= 7) {
                    edenFlower = ZGBlocks.edenFlowerCyan;
                } else if (r <= 10) {
                    edenFlower = ZGBlocks.edenFlowerGreen;
                } else if (r <= 13) {
                    edenFlower = ZGBlocks.edenFlowerOrange;
                } else if (r <= 15) {
                    edenFlower = ZGBlocks.edenFlowerPurple;
                } else if (r <= 17) {
                    edenFlower = ZGBlocks.edenFlowerRed;
                } else if (r <= 19) {
                    edenFlower = ZGBlocks.edenFlowerYellow;
                } else if (r <= 21) {
                    edenFlower = ZGBlocks.edenFlowerPink;
                } else if (r <= 23) {
                    edenFlower = ZGBlocks.edenFlowerBlack;
                } else if (r <= 26) {
                    edenFlower = ZGBlocks.edenFlowerWhite;
                }
                if (edenFlower.func_176223_P().func_185904_a() == Material.field_151579_a) continue;
                IBlockState flowerState = edenFlower.func_176223_P();
                new WorldGenEdenFlowers(flowerState).func_180709_b(world, rand, blockpos1);
            }
        }
        if (this.generateCraters) {
            ChunkProviderEden.INSTANCE.createCraters(x, z, chunkPrimer);
        }
        if (this.generateWitchHuts) {
            // empty if block
        }
        if (this.generateMansions) {
            // empty if block
        }
        if (this.generateTowers && (y = rand.nextInt(rand.nextInt(genY) + 8)) >= 24 && y <= 68 && rand.nextInt(100) <= 15) {
            this.towerGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y -= 2, z));
        }
        if (this.generateGiantBones && (y = rand.nextInt(rand.nextInt(genY) + 8)) >= 62 && rand.nextInt(100) <= 40) {
            this.giantBoneGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
        }
        if (this.generateDropships && this.dropshipsPerChunk > 0 && (y = rand.nextInt(rand.nextInt(genY) + 8)) >= 50) {
            for (int i = 0; i < this.dropshipsPerChunk; ++i) {
                if (rand.nextInt(this.enableExtremeMode ? 1000 : 600) > 15) continue;
                this.dropshipGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CUSTOM) && this.generateOil && this.oilPerChunk > 0 && this.enableOilGen) {
            for (int i = 0; i < this.oilPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                new WorldGenLakesZG(GCBlocks.crudeOil, ZGBlocks.edenStone).func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
                EventHandlerGC.generateOil((World)world, (Random)rand, (int)x, (int)z, (boolean)false);
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CLAY) && this.generateClay && this.field_76806_I > 0) {
            for (int i1 = 0; i1 < this.field_76806_I; ++i1) {
                int l1 = rand.nextInt(16) + 8;
                int i6 = rand.nextInt(16) + 8;
                this.clayGen.func_180709_b(world, rand, world.func_175672_r(this.field_180294_c.func_177982_a(l1, 0, i6)));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SAND_PASS2) && this.generateGravel && this.field_76801_G > 0) {
            for (int j1 = 0; j1 < this.field_76801_G; ++j1) {
                int i2 = rand.nextInt(16) + 8;
                int j6 = rand.nextInt(16) + 8;
                this.gravelGen.func_180709_b(world, rand, world.func_175672_r(this.field_180294_c.func_177982_a(i2, 0, j6)));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SAND) && this.generateSand && this.field_76805_H > 0) {
            for (int i = 0; i < this.field_76805_H; ++i) {
                int j = rand.nextInt(16) + 8;
                int k = rand.nextInt(16) + 8;
                this.sandGen.func_180709_b(world, rand, world.func_175672_r(this.field_180294_c.func_177982_a(j, 0, k)));
            }
        }
        int k1 = this.field_76832_z;
        if (rand.nextFloat() < this.field_189870_A) {
            ++k1;
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE) && rand.nextInt(4) == 0) {
            for (int j2 = 0; j2 < y; ++j2) {
                int k6 = rand.nextInt(16) + 8;
                int l = rand.nextInt(16) + 8;
                WorldGenAbstractTree worldgenabstracttree = biome.func_150567_a(rand);
                worldgenabstracttree.func_175904_e();
                BlockPos blockpos = world.func_175645_m(this.field_180294_c.func_177982_a(k6, 0, l));
                if (!worldgenabstracttree.func_180709_b(world, rand, blockpos)) continue;
                worldgenabstracttree.func_180711_a(world, rand, blockpos);
            }
        }
        if (this.generateCrops && this.cropsPerChunk > 0 && !BiomeUtils.isOceanBiome(biome) && ZGHelper.rngInt(1, 100) <= 45) {
            for (int i = 0; i < this.cropsPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                if (y < 62) continue;
                this.cropGen = new WorldGenCrops(ZGHelper.getRandomCrop(rand).func_176223_P());
                this.cropGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SHROOM) && this.generateMushrooms && this.field_76798_D > 0) {
            int l8;
            int j4;
            int k12;
            int k8;
            int i4;
            int j12;
            for (int l3 = 0; l3 < this.field_76798_D; ++l3) {
                int i12;
                int j8;
                int j15;
                if (rand.nextInt(4) == 0) {
                    int i8 = rand.nextInt(16) + 8;
                    int l11 = rand.nextInt(16) + 8;
                    BlockPos blockpos2 = world.func_175645_m(this.field_180294_c.func_177982_a(i8, 0, l11));
                    this.field_76828_s.func_180709_b(world, rand, blockpos2);
                }
                if (rand.nextInt(8) != 0 || (j15 = world.func_175645_m(this.field_180294_c.func_177982_a(j8 = rand.nextInt(16) + 8, 0, i12 = rand.nextInt(16) + 8)).func_177956_o() * 2) <= 0) continue;
                int k18 = rand.nextInt(j15);
                BlockPos blockpos5 = this.field_180294_c.func_177982_a(j8, k18, i12);
                this.field_76827_t.func_180709_b(world, rand, blockpos5);
            }
            if (rand.nextInt(4) == 0 && (j12 = world.func_175645_m(this.field_180294_c.func_177982_a(i4 = rand.nextInt(16) + 8, 0, k8 = rand.nextInt(16) + 8)).func_177956_o() * 2) > 0) {
                int k15 = rand.nextInt(j12);
                this.field_76828_s.func_180709_b(world, rand, this.field_180294_c.func_177982_a(i4, k15, k8));
            }
            if (rand.nextInt(8) == 0 && (k12 = world.func_175645_m(this.field_180294_c.func_177982_a(j4 = rand.nextInt(16) + 8, 0, l8 = rand.nextInt(16) + 8)).func_177956_o() * 2) > 0) {
                int l15 = rand.nextInt(k12);
                this.field_76827_t.func_180709_b(world, rand, this.field_180294_c.func_177982_a(j4, l15, l8));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.BIG_SHROOM) && this.generateMushroomTrees && this.mushroomTreesPerChunk > 0) {
            for (int i = 0; i < this.mushroomTreesPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                if (y < 64) {
                    y = ZGHelper.rngInt(64, 82);
                }
                if (rand.nextInt(100) > 45) continue;
                this.treeGenMushroom.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        if (this.field_76808_K) {
            if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_WATER)) {
                for (int k5 = 0; k5 < 50; ++k5) {
                    int i10 = rand.nextInt(16) + 8;
                    int l13 = rand.nextInt(16) + 8;
                    int i17 = rand.nextInt(120) + 8;
                    if (i17 <= 0) continue;
                    int k19 = rand.nextInt(i17);
                    BlockPos blockpos6 = this.field_180294_c.func_177982_a(i10, k19, l13);
                    new WorldGenLiquids((Block)Blocks.field_150358_i).func_180709_b(world, rand, blockpos6);
                }
            }
            if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_LAVA)) {
                for (int l5 = 0; l5 < 20; ++l5) {
                    int j10 = rand.nextInt(16) + 8;
                    int i14 = rand.nextInt(16) + 8;
                    int j17 = rand.nextInt(rand.nextInt(rand.nextInt(112) + 8) + 8);
                    BlockPos blockpos3 = this.field_180294_c.func_177982_a(j10, j17, i14);
                    new WorldGenLiquids((Block)Blocks.field_150356_k).func_180709_b(world, rand, blockpos3);
                }
            }
        }
        if (this.generateBattleTowers && this.battleTowersPerChunk > 0 && !BiomeUtils.isOceanBiome(biome) && ZGHelper.rngInt(1, 250) <= 35) {
            for (int i = 0; i < this.battleTowersPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                if (y < 60 || y >= 80) continue;
                this.battleTowerGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        int craterSpawnChance = ConfigManagerZG.craterSpawnChance;
        if (this.generateCraters && this.cratersPerChunk > 0 && craterSpawnChance > 0) {
            ChunkProviderEden.INSTANCE.createCraters(x, z, chunkPrimer);
            y = rand.nextInt(rand.nextInt(genY) + 8);
            if (ZGHelper.rngInt(1, 100) <= craterSpawnChance) {
                for (int i = 0; i < this.cratersPerChunk; ++i) {
                    if (y > 70) continue;
                    this.craterGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
                }
            }
        }
        if (this.generateOutposts && this.outpostsPerChunk > 0) {
            BiomeSpace spaceBiome;
            if (biome instanceof BiomeSpace && (spaceBiome = (BiomeSpace)biome).getBiomeType() == EnumBiomeTypeZG.OCEAN) {
                return;
            }
            y = rand.nextInt(rand.nextInt(genY) + 8);
            if (y >= 62) {
                IBlockState OUTPOST_STATE = ZGBlocks.blockOutpost.func_176223_P();
                WorldGenOutpost outpostGen = new WorldGenOutpost(OUTPOST_STATE, OUTPOST_STATE);
                for (int i = 0; i < this.outpostsPerChunk; ++i) {
                    if (rand.nextInt(this.enableExtremeMode ? 200 : 100) > ConfigManagerZG.outpostGenChance) continue;
                    outpostGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
                }
            }
        }
    }
}

