/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.biomes.decorators;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import zollerngalaxy.biomes.BiomeSpace;
import zollerngalaxy.biomes.decorators.BiomeDecoratorZG;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.blocks.fluids.ZGFluids;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.enums.EnumBiomeTypeZG;
import zollerngalaxy.core.enums.EnumOreGenZG;
import zollerngalaxy.worldgen.WorldGenLakesZG;
import zollerngalaxy.worldgen.WorldGenMinableZG;
import zollerngalaxy.worldgen.WorldGenOutpost;

public class BiomeDecoratorCandora
extends BiomeDecoratorZG {
    private WorldGenerator brownGen = new WorldGenMinableZG(ZGBlocks.candyCubeBrown, ZGBlocks.candyCubeGray, EnumOreGenZG.CANDY.setGenCount(35));
    private WorldGenerator redGen = new WorldGenMinableZG(ZGBlocks.candyCubeRed, ZGBlocks.candyCubeGray, EnumOreGenZG.CANDY.setGenCount(45));
    private WorldGenerator whiteGen = new WorldGenMinableZG(ZGBlocks.candyCubeWhite, ZGBlocks.candyCubeGray, EnumOreGenZG.CANDY.setGenCount(55));
    private WorldGenerator orangeGen = new WorldGenMinableZG(ZGBlocks.candyCubeOrange, ZGBlocks.candyCubeGray, EnumOreGenZG.CANDY.setGenCount(35));
    private WorldGenerator blackGen = new WorldGenMinableZG(ZGBlocks.candyCubeBlack, ZGBlocks.candyCubeGray, EnumOreGenZG.CANDY.setGenCount(30));
    private WorldGenerator purpleGen = new WorldGenMinableZG(ZGBlocks.candyCubePurple, ZGBlocks.candyCubePurple, EnumOreGenZG.CANDY.setGenCount(35));
    private WorldGenerator blueGen = new WorldGenMinableZG(ZGBlocks.candyCubeBlue, ZGBlocks.candyCubeGray, EnumOreGenZG.CANDY.setGenCount(30));
    private WorldGenerator yellowGen = new WorldGenMinableZG(ZGBlocks.candyCubeYellow, ZGBlocks.candyCubeGray, EnumOreGenZG.CANDY.setGenCount(25));
    private WorldGenerator cyanGen = new WorldGenMinableZG(ZGBlocks.candyCubeCyan, ZGBlocks.candyCubeGray, EnumOreGenZG.CANDY.setGenCount(15));
    private WorldGenerator greenGen = new WorldGenMinableZG(ZGBlocks.candyCubeGreen, ZGBlocks.candyCubeGray, EnumOreGenZG.CANDY.setGenCount(15));
    private WorldGenerator pinkGen = new WorldGenMinableZG(ZGBlocks.candyCubePink, ZGBlocks.candyCubeGray, EnumOreGenZG.CANDY.setGenCount(35));
    private WorldGenerator chocolateGen = new WorldGenMinableZG(ZGBlocks.blockCookie, ZGBlocks.candyCubeGray, EnumOreGenZG.SWEET.setGenCount(25));
    private WorldGenerator cookieGen = new WorldGenMinableZG(ZGBlocks.blockChocolate, ZGBlocks.candyCubeGray, EnumOreGenZG.SWEET.setGenCount(16));
    private WorldGenerator brownieGen = new WorldGenMinableZG(ZGBlocks.blockBrownie, ZGBlocks.candyCubeGray, EnumOreGenZG.SWEET.setGenCount(18));
    private WorldGenerator iceCreamSandwichGen;
    private WorldGenerator sugarCubeGen = new WorldGenMinableZG(ZGBlocks.blockSugarCube, ZGBlocks.candyCubeGray, EnumOreGenZG.SWEET.setGenCount(20));
    public int chocolateLakesPerChunk = 1;
    public boolean generateLakes = true;

    public BiomeDecoratorCandora() {
        this.iceCreamSandwichGen = new WorldGenMinableZG(ZGBlocks.blockIceCreamSandwich, ZGBlocks.candyCubeGray, EnumOreGenZG.SWEET.setGenCount(5));
    }

    @Override
    protected void generate(Biome biome, World world, Random rand) {
        int genY;
        int x = rand.nextInt(16) + 8;
        int z = rand.nextInt(16) + 8;
        int y = genY = 248;
        Block BLOCK_TOP = biome.field_76752_A.func_177230_c();
        Block BLOCK_FILL = biome.field_76753_B.func_177230_c();
        this.generateOre(this.brownGen, EnumOreGenZG.CANDY, world, rand);
        this.generateOre(this.redGen, EnumOreGenZG.CANDY, world, rand);
        this.generateOre(this.whiteGen, EnumOreGenZG.CANDY, world, rand);
        this.generateOre(this.orangeGen, EnumOreGenZG.CANDY, world, rand);
        this.generateOre(this.blackGen, EnumOreGenZG.CANDY, world, rand);
        this.generateOre(this.purpleGen, EnumOreGenZG.CANDY, world, rand);
        this.generateOre(this.blueGen, EnumOreGenZG.CANDY, world, rand);
        this.generateOre(this.yellowGen, EnumOreGenZG.CANDY, world, rand);
        this.generateOre(this.cyanGen, EnumOreGenZG.CANDY, world, rand);
        this.generateOre(this.greenGen, EnumOreGenZG.CANDY, world, rand);
        this.generateOre(this.pinkGen, EnumOreGenZG.CANDY, world, rand);
        this.generateOre(this.chocolateGen, EnumOreGenZG.SWEET, world, rand);
        this.generateOre(this.cookieGen, EnumOreGenZG.SWEET, world, rand);
        this.generateOre(this.brownieGen, EnumOreGenZG.SWEET, world, rand);
        this.generateOre(this.sugarCubeGen, EnumOreGenZG.SWEET, world, rand);
        this.generateOre(this.iceCreamSandwichGen, EnumOreGenZG.SWEET, world, rand);
        ChunkPrimer chunkPrimer = new ChunkPrimer();
        ChunkPos forgeChunkPos = new ChunkPos(this.field_180294_c);
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CUSTOM) && this.generateLakes && this.chocolateLakesPerChunk > 0) {
            for (int i = 0; i < this.chocolateLakesPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                Object blockToUse = biome.func_150561_m() == Biome.TempCategory.COLD ? ZGBlocks.candyCubeCyan : ZGFluids.blockChocolateFluid;
                new WorldGenLakesZG((Block)blockToUse, BLOCK_TOP).func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        if (this.generateOutposts && this.outpostsPerChunk > 0) {
            BiomeSpace spaceBiome;
            if (biome instanceof BiomeSpace && (spaceBiome = (BiomeSpace)biome).getBiomeType() == EnumBiomeTypeZG.OCEAN) {
                return;
            }
            y = rand.nextInt(rand.nextInt(genY) + 8);
            if (y >= 62) {
                IBlockState OUTPOST_STATE = ZGBlocks.blockOutpost.func_176223_P();
                WorldGenOutpost outpostGen = new WorldGenOutpost(OUTPOST_STATE, OUTPOST_STATE);
                for (int i = 0; i < this.outpostsPerChunk; ++i) {
                    if (rand.nextInt(this.enableExtremeMode ? 200 : 100) > ConfigManagerZG.outpostGenChance) continue;
                    outpostGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
                }
            }
        }
    }
}

