/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.biomes.decorators;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import zollerngalaxy.biomes.BiomeSpace;
import zollerngalaxy.biomes.decorators.BiomeDecoratorZG;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.blocks.ZGWaterGrass;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.ZGLootTables;
import zollerngalaxy.core.enums.EnumBiomeTypeZG;
import zollerngalaxy.core.enums.EnumOreGenZG;
import zollerngalaxy.worldgen.WorldGenLakesZG;
import zollerngalaxy.worldgen.WorldGenMinableZG;
import zollerngalaxy.worldgen.WorldGenOutpost;
import zollerngalaxy.worldgen.WorldGenWaterGrass;

public class BiomeDecoratorAltum
extends BiomeDecoratorZG {
    private static final Block STONE = ZGBlocks.altumStone;
    private WorldGenerator amaranthGen;
    private WorldGenerator redstoneGen;
    private WorldGenerator ironGen;
    private WorldGenerator diamondGen;
    private WorldGenerator zollerniumGen;
    private WorldGenerator goldGen;
    private WorldGenerator eveniumGen;
    private WorldGenerator rhodiumGen;
    private WorldGenerator coalGen;
    private WorldGenerator prismarineGen;
    public int waterLakesPerChunk = 2;
    public int treasurePerChunk = 1;
    public int seaweedPerChunk = 2;
    private ResourceLocation oceanLootTable = ZGLootTables.CHEST_OCEAN_TREASURE;
    private int seaLevel = 74;
    private WorldGenerator waterLakeGen = new WorldGenLakesZG((Block)Blocks.field_150355_j, ZGBlocks.altumSand);
    private WorldGenerator seaweedGen = new WorldGenWaterGrass((ZGWaterGrass)ZGBlocks.altumSeaweed);

    public BiomeDecoratorAltum() {
        this.amaranthGen = new WorldGenMinableZG(ZGBlocks.altumAmaranthOre, STONE, EnumOreGenZG.AMARANTH);
        this.redstoneGen = new WorldGenMinableZG(ZGBlocks.altumRedstoneOre, STONE, EnumOreGenZG.REDSTONE);
        this.diamondGen = new WorldGenMinableZG(ZGBlocks.altumDiamondOre, STONE, EnumOreGenZG.DIAMOND);
        this.zollerniumGen = new WorldGenMinableZG(ZGBlocks.altumZollerniumOre, STONE, EnumOreGenZG.ZOLLERNIUM);
        this.ironGen = new WorldGenMinableZG(ZGBlocks.altumIronOre, STONE, EnumOreGenZG.IRON);
        this.goldGen = new WorldGenMinableZG(ZGBlocks.altumGoldOre, STONE, EnumOreGenZG.GOLD);
        this.eveniumGen = new WorldGenMinableZG(ZGBlocks.altumEveniumOre, STONE, EnumOreGenZG.EVENIUM);
        this.rhodiumGen = new WorldGenMinableZG(ZGBlocks.altumRhodiumOre, STONE, EnumOreGenZG.RHODIUM);
        this.coalGen = new WorldGenMinableZG(ZGBlocks.altumCoalOre, STONE, EnumOreGenZG.COAL);
        this.prismarineGen = new WorldGenMinableZG(Blocks.field_180397_cI, STONE, EnumOreGenZG.PRISMARINE);
    }

    @Override
    protected void generate(Biome biome, World world, Random rand) {
        int y2;
        int y1;
        int z1;
        int x1;
        int i;
        int genY;
        int x = rand.nextInt(16) + 8;
        int z = rand.nextInt(16) + 8;
        int y = genY = 248;
        if (biome instanceof BiomeSpace) {
            BiomeSpace spaceBiome = (BiomeSpace)biome;
            genY = spaceBiome.getBiomeHeight();
        }
        this.generateOre(this.amaranthGen, EnumOreGenZG.AMARANTH, world, rand);
        this.generateOre(this.redstoneGen, EnumOreGenZG.REDSTONE, world, rand);
        this.generateOre(this.ironGen, EnumOreGenZG.IRON, world, rand);
        this.generateOre(this.diamondGen, EnumOreGenZG.DIAMOND, world, rand);
        this.generateOre(this.zollerniumGen, EnumOreGenZG.ZOLLERNIUM, world, rand);
        this.generateOre(this.goldGen, EnumOreGenZG.GOLD, world, rand);
        this.generateOre(this.eveniumGen, EnumOreGenZG.EVENIUM, world, rand);
        this.generateOre(this.rhodiumGen, EnumOreGenZG.RHODIUM, world, rand);
        this.generateOre(this.coalGen, EnumOreGenZG.COAL, world, rand);
        this.generateOre(this.prismarineGen, EnumOreGenZG.PRISMARINE, world, rand);
        ChunkPos forgeChunkPos = new ChunkPos(this.field_180294_c);
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_WATER) && rand.nextInt(2) == 0) {
            for (i = 0; i < this.waterLakesPerChunk; ++i) {
                x1 = rand.nextInt(16) + 8;
                y1 = world.func_175645_m(this.field_180294_c.func_177982_a(x1, 0, z1 = rand.nextInt(16) + 8)).func_177956_o() * 2;
                if (y1 <= 0) continue;
                y2 = rand.nextInt(y1);
                this.waterLakeGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x1, y2, z1));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.GRASS) && rand.nextInt(5) == 0) {
            for (i = 0; i < this.seaweedPerChunk; ++i) {
                x1 = rand.nextInt(16) + 8;
                y1 = world.func_175645_m(this.field_180294_c.func_177982_a(x1, 0, z1 = rand.nextInt(16) + 8)).func_177956_o() * 2;
                if (y1 <= 0) continue;
                y2 = rand.nextInt(y1);
                this.seaweedGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x1, y2, z1));
            }
        }
        if (this.generateOutposts && this.outpostsPerChunk > 0) {
            BiomeSpace spaceBiome;
            if (biome instanceof BiomeSpace && (spaceBiome = (BiomeSpace)biome).getBiomeType() == EnumBiomeTypeZG.OCEAN) {
                return;
            }
            y = rand.nextInt(rand.nextInt(genY) + 8);
            IBlockState OUTPOST_STATE = ZGBlocks.blockOutpost.func_176223_P();
            if (y >= 62) {
                WorldGenOutpost outpostGen = new WorldGenOutpost(OUTPOST_STATE, OUTPOST_STATE);
                for (int i2 = 0; i2 < this.outpostsPerChunk; ++i2) {
                    if (rand.nextInt(this.enableExtremeMode ? 200 : 100) > ConfigManagerZG.outpostGenChance) continue;
                    outpostGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
                }
            }
        }
    }
}

