/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.biomes.atheon;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.chunk.ChunkPrimer;
import zollerngalaxy.biomes.BiomeSpace;
import zollerngalaxy.biomes.decorators.BiomeDecoratorAtheon;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.blocks.fluids.ZGFluids;
import zollerngalaxy.celestial.ZGPlanets;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.enums.EnumBiomeTypeZG;
import zollerngalaxy.mobs.entities.EntityGrayAlien;
import zollerngalaxy.mobs.entities.robots.EntityVexBotGold;
import zollerngalaxy.mobs.entities.robots.sentinels.EntitySentinelDrone;
import zollerngalaxy.mobs.entities.villagers.EntityAtheonVillager;

public abstract class BiomeAtheonBase
extends BiomeSpace {
    protected static final IBlockState STONE = ZGBlocks.atheonStone.func_176223_P();
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState BEDROCK = Blocks.field_150357_h.func_176223_P();
    protected static final IBlockState CONSTRUCT = ZGBlocks.atheonConstructBlock.func_176223_P();
    protected static final IBlockState DIRT = ZGBlocks.atheonLuxrock.func_176223_P();
    protected static final IBlockState ICE = Blocks.field_150432_aD.func_176223_P();
    protected static final IBlockState WATER = Blocks.field_150355_j.func_176223_P();
    protected static final int SEA_LEVEL = 57;
    protected static final int SEA_FLOOR_LEVEL = 36;
    public BiomeDecoratorAtheon biomeDecor = this.getBiomeDecorator();

    public BiomeAtheonBase(String singleName, Biome.BiomeProperties props) {
        super(singleName, props);
        this.setTempCategory(Biome.TempCategory.MEDIUM);
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityGrayAlien.class, 1, 1, 1));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityVexBotGold.class, 100, 1, 2));
        if (ConfigManagerZG.enableSentinels) {
            this.field_76761_J.add(new Biome.SpawnListEntry(EntitySentinelDrone.class, 100, 1, 4));
        }
        if (ConfigManagerZG.enableAlienVillagerSpawn) {
            this.field_76762_K.add(new Biome.SpawnListEntry(EntityAtheonVillager.class, this.villagerSpawnRate, this.villagerMinSpawnRate, this.villagerMaxSpawnRate));
        }
        this.setStoneBlock(ZGBlocks.atheonStone);
        this.setPlanetForBiome(ZGPlanets.planetAtheon);
    }

    public BiomeDecorator func_76729_a() {
        return new BiomeDecoratorAtheon();
    }

    protected BiomeDecoratorAtheon getBiomeDecorator() {
        return (BiomeDecoratorAtheon)this.field_76760_I;
    }

    public final void generateAtheonTerrain(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        int i = worldIn.func_181545_F();
        float biomeHeight = this.getBiomeHeight();
        IBlockState topState = this.field_76752_A;
        IBlockState fillState = this.field_76753_B;
        int j = -1;
        int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int l = x & 0xF;
        int i1 = z & 0xF;
        for (int j1 = 255; j1 >= 0; --j1) {
            if (j1 == 0) {
                chunkPrimerIn.func_177855_a(i1, j1, l, BEDROCK);
                continue;
            }
            if (j1 >= 128) {
                chunkPrimerIn.func_177855_a(i1, j1, l, AIR);
                continue;
            }
            IBlockState iblockstate2 = chunkPrimerIn.func_177856_a(i1, j1, l);
            if (this.getBiomeType() == EnumBiomeTypeZG.OCEAN) {
                if (j1 < 57 && j1 > 36) {
                    IBlockState blockToUse = ZGFluids.blockWhiteLavaFluid.func_176223_P();
                    chunkPrimerIn.func_177855_a(i1, j1, l, blockToUse);
                    continue;
                }
                if (j1 < 36) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, STONE);
                    continue;
                }
                if (j1 == 36) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, DIRT);
                    continue;
                }
                if (j1 < 57) continue;
                chunkPrimerIn.func_177855_a(i1, j1, l, AIR);
                continue;
            }
            if (iblockstate2.func_185904_a() == Material.field_151579_a) {
                j = -1;
                continue;
            }
            if (iblockstate2.func_177230_c() != ZGBlocks.atheonStone) continue;
            if (j == -1) {
                if (k <= 0) {
                    topState = AIR;
                    fillState = STONE;
                } else if (j1 >= i - 4 && j1 <= i + 1) {
                    topState = this.field_76752_A;
                    fillState = this.field_76753_B;
                }
                if (j1 < i && (topState == null || topState.func_185904_a() == Material.field_151579_a)) {
                    topState = this.getIsColdBiome() ? ICE : WATER;
                }
                j = k;
                if (j1 >= i - 1) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, topState);
                    continue;
                }
                if (j1 < i - 7 - k) {
                    topState = AIR;
                    fillState = STONE;
                    chunkPrimerIn.func_177855_a(i1, j1, l, CONSTRUCT);
                    continue;
                }
                chunkPrimerIn.func_177855_a(i1, j1, l, fillState);
                continue;
            }
            if (j <= 0) continue;
            --j;
            chunkPrimerIn.func_177855_a(i1, j1, l, fillState);
        }
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        this.generateAtheonTerrain(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
    }

    public int getModdedBiomeFoliageColor(int original) {
        return grassFoliageColor;
    }

    public int getModdedBiomeGrassColor(int original) {
        return grassFoliageColor;
    }
}

