/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.biomes.astros;

import java.util.Random;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedEnderman;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedWitch;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.chunk.ChunkPrimer;
import zollerngalaxy.biomes.BiomeSpace;
import zollerngalaxy.biomes.decorators.BiomeDecoratorAstros;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.celestial.ZGPlanets;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.enums.EnumBiomeTypeZG;
import zollerngalaxy.mobs.entities.robots.sentinels.EntitySentinelDrone;
import zollerngalaxy.mobs.entities.villagers.EntityAstrosVillager;

public class BiomeAstrosBase
extends BiomeSpace {
    protected static final IBlockState STONE = ZGBlocks.astrosStone.func_176223_P();
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState BEDROCK = Blocks.field_150357_h.func_176223_P();
    protected static final IBlockState GRAVEL = ZGBlocks.astrosGravel.func_176223_P();
    protected static final IBlockState DIRT = ZGBlocks.astrosDirt.func_176223_P();
    protected static final IBlockState ICE = ZGBlocks.astrosIce.func_176223_P();
    protected static final IBlockState WATER = Blocks.field_150355_j.func_176223_P();
    protected static final int SEA_LEVEL = 57;
    protected static final int SEA_FLOOR_LEVEL = 36;
    public BiomeDecoratorAstros biomeDecor = this.getBiomeDecorator();

    public BiomeAstrosBase(String singleName, Biome.BiomeProperties props) {
        super(singleName, props);
        this.setTempCategory(Biome.TempCategory.COLD);
        this.setTemp(23.56f);
        this.biomeDecor.field_76802_A = -999;
        this.biomeDecor.field_76832_z = -999;
        this.biomeDecor.field_76803_B = -999;
        this.biomeDecor.field_76798_D = -999;
        this.clearAllSpawning();
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEvolvedZombie.class, 100, 4, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEvolvedSpider.class, 100, 4, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEvolvedSkeleton.class, 100, 4, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEvolvedCreeper.class, 100, 4, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEvolvedEnderman.class, 100, 4, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEvolvedWitch.class, 100, 4, 4));
        if (ConfigManagerZG.enableSentinels) {
            this.field_76761_J.add(new Biome.SpawnListEntry(EntitySentinelDrone.class, 100, 1, 4));
        }
        if (ConfigManagerZG.enableAlienVillagerSpawn) {
            this.field_76762_K.add(new Biome.SpawnListEntry(EntityAstrosVillager.class, this.villagerSpawnRate, this.villagerMinSpawnRate, this.villagerMaxSpawnRate));
        }
        this.setBodyForBiome(ZGPlanets.moonAstros);
    }

    public final void generateAstrosTerrain(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        int i = worldIn.func_181545_F();
        float biomeHeight = this.getBiomeHeight();
        IBlockState topState = this.field_76752_A;
        IBlockState fillState = this.field_76753_B;
        int j = -1;
        int k = (int)(noiseVal / 3.0 + 3.5 + rand.nextDouble() * 0.25);
        int l = x & 0xF;
        int i1 = z & 0xF;
        for (int j1 = 255; j1 >= 0; --j1) {
            if (j1 == 0) {
                chunkPrimerIn.func_177855_a(i1, j1, l, BEDROCK);
                continue;
            }
            if (j1 >= 128) {
                chunkPrimerIn.func_177855_a(i1, j1, l, AIR);
                continue;
            }
            IBlockState iblockstate2 = chunkPrimerIn.func_177856_a(i1, j1, l);
            if (this.getBiomeType() == EnumBiomeTypeZG.OCEAN) {
                if (j1 < 57 && j1 > 36) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, ICE);
                    continue;
                }
                if (j1 < 36) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, STONE);
                    continue;
                }
                if (j1 == 36) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, DIRT);
                    continue;
                }
                if (j1 < 57) continue;
                chunkPrimerIn.func_177855_a(i1, j1, l, AIR);
                continue;
            }
            if (iblockstate2.func_185904_a() == Material.field_151579_a) {
                j = -1;
                continue;
            }
            if (iblockstate2 != STONE) continue;
            if (j == -1) {
                if (k <= 0) {
                    topState = AIR;
                    fillState = STONE;
                } else if (j1 >= i - 4 && j1 <= i + 1) {
                    topState = this.field_76752_A;
                    fillState = this.field_76753_B;
                }
                if (j1 < i && (topState == null || topState.func_185904_a() == Material.field_151579_a)) {
                    topState = ICE;
                }
                j = k;
                if (j1 >= i - 1) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, topState);
                    continue;
                }
                if (j1 < i - 7 - k) {
                    topState = AIR;
                    fillState = STONE;
                    chunkPrimerIn.func_177855_a(i1, j1, l, GRAVEL);
                    continue;
                }
                chunkPrimerIn.func_177855_a(i1, j1, l, fillState);
                continue;
            }
            if (j <= 0) continue;
            --j;
            chunkPrimerIn.func_177855_a(i1, j1, l, fillState);
        }
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        this.generateAstrosTerrain(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
    }

    public float func_76741_f() {
        return 0.1f;
    }

    public BiomeDecorator func_76729_a() {
        return new BiomeDecoratorAstros();
    }

    protected BiomeDecoratorAstros getBiomeDecorator() {
        return (BiomeDecoratorAstros)this.field_76760_I;
    }

    public int getModdedBiomeFoliageColor(int original) {
        return grassFoliageColor;
    }

    public int getModdedBiomeGrassColor(int original) {
        return grassFoliageColor;
    }
}

