/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.events;

import asmodeuscore.api.dimension.IAdvancedSpace;
import asmodeuscore.api.space.IBookPage;
import asmodeuscore.core.astronomy.dimension.world.worldengine.WE_WorldProviderSpace;
import asmodeuscore.core.astronomy.gui.book.ACGuiGuideBook;
import asmodeuscore.core.handler.ColorBlockHandler;
import asmodeuscore.core.utils.BookUtils;
import asmodeuscore.core.utils.Utils;
import asmodeuscore.core.utils.worldengine.WE_ChunkProvider;
import asmodeuscore.core.utils.worldengine.WE_PerlinNoise;
import asmodeuscore.core.utils.worldengine.WE_WorldProvider;
import galaxyspace.GalaxySpace;
import galaxyspace.api.item.IJetpackArmor;
import galaxyspace.api.item.IModificationItem;
import galaxyspace.core.client.gui.GSGuiMainMenu;
import galaxyspace.core.client.gui.book.pages.general.Page_ActualUpdate;
import galaxyspace.core.client.gui.overlay.OverlaySpaceSuit;
import galaxyspace.core.configs.GSConfigCore;
import galaxyspace.core.events.GSEventHandler;
import galaxyspace.core.network.packet.GSPacketSimple;
import galaxyspace.core.util.GSThreadVersionCheck;
import galaxyspace.systems.SolarSystem.planets.overworld.items.ItemBasicGS;
import galaxyspace.systems.SolarSystem.planets.overworld.items.tools.ItemGeologicalScanner;
import galaxyspace.systems.SolarSystem.planets.overworld.items.tools.ItemMatterManipulator;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.event.ZeroGravityEvent;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class GSClientTickHandler {
    public Minecraft mc = FMLClientHandler.instance().getClient();
    public Random rand;
    public static Map<IBlockState, String> blocks = new HashMap<IBlockState, String>();
    public static int ticks;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onGuiOpenEvent(GuiOpenEvent event) {
        if (event.getGui() instanceof GuiMainMenu && GSConfigCore.enableNewMenu) {
            event.setGui((GuiScreen)new GSGuiMainMenu());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onToolTip(ItemTooltipEvent e) {
        IModificationItem mod;
        if (e.getItemStack().func_77973_b() instanceof IModificationItem && (mod = (IModificationItem)e.getItemStack().func_77973_b()).getType(e.getItemStack()) != null && mod.getAvailableModules() != null) {
            e.getToolTip().add(1, EnumColor.AQUA + GCCoreUtil.translate((String)"gui.module.caninstall"));
        }
        if (e.getItemStack().func_77969_a(new ItemStack(MarsItems.schematic, 1, 0)) && GSConfigCore.enableAdvancedRocketCraft) {
            e.getToolTip().add(1, EnumColor.RED + "Disabled. See new recipe in JEI/NEI!");
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        WorldClient world = this.mc.field_71441_e;
        if (event.phase == TickEvent.Phase.END && Side.CLIENT != null && player != null && world != null && GSThreadVersionCheck.newversion && this.mc.field_71415_G && GSConfigCore.enableCheckVersion) {
            GSThreadVersionCheck.newversion = false;
            Minecraft.func_71410_x().func_152344_a(() -> FMLClientHandler.instance().showGuiScreen((Object)new ACGuiGuideBook(ACGuiGuideBook.Mode.TEXT, BookUtils.Book_Cateroies.GENERAL.getName(), (IBookPage)new Page_ActualUpdate(true))));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=false)
    public void onLivingRender(RenderLivingEvent.Post event) {
        if (event.getEntity() instanceof EntityPlayer) {
            ModelBase mdl;
            EntityPlayer player = (EntityPlayer)event.getEntity();
            ItemStack mainhand = player.func_184614_ca();
            ItemStack offhand = player.func_184592_cb();
            if ((!mainhand.func_190926_b() && mainhand.func_77973_b() instanceof ItemMatterManipulator || !offhand.func_190926_b() && offhand.func_77973_b() instanceof ItemMatterManipulator) && (mdl = event.getRenderer().func_177087_b()) instanceof ModelPlayer) {
                ModelPlayer model = (ModelPlayer)mdl;
                if (player.func_184591_cq() == EnumHandSide.RIGHT) {
                    model.field_178723_h.field_78796_g = -0.1f + model.field_78116_c.field_78796_g;
                } else {
                    model.field_187075_l = ModelBiped.ArmPose.BOW_AND_ARROW;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    @SideOnly(value=Side.CLIENT)
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        Minecraft minecraft = FMLClientHandler.instance().getClient();
        EntityPlayerSP player = minecraft.field_71439_g;
        EntityPlayerSP playerBaseClient = PlayerUtil.getPlayerBaseClientFromPlayer((EntityPlayer)player, (boolean)false);
        if (event.phase == TickEvent.Phase.END && player != null) {
            if (minecraft.field_71462_r == null && GalaxySpace.debug) {
                WE_ChunkProvider chunk;
                long t1 = player.field_70170_p.field_73011_w instanceof WorldProviderSpace ? ((WorldProviderSpace)player.field_70170_p.field_73011_w).getDayLength() : 24000L;
                long time = player.field_70170_p.func_72820_D() % (t1 > 0L ? t1 : 1L);
                float temp = player.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider ? ((IGalacticraftWorldProvider)player.field_70170_p.field_73011_w).getThermalLevelModifier() : 1.0f;
                boolean isWE = player.func_130014_f_().field_73011_w instanceof WE_WorldProvider;
                double count = 0.0;
                World world = ColorBlockHandler.world;
                if (isWE && player.func_130014_f_().field_73011_w != null && (chunk = ((WE_WorldProvider)world.field_73011_w).chunk_provider) != null) {
                    double scaleX = chunk.biomemapScaleX;
                    double persistance = chunk.biomemapPersistence;
                    count = WE_PerlinNoise.PerlinNoise2D((long)(player.func_130014_f_().func_72905_C() * 11L ^ 6L), (double)((double)player.func_130014_f_().func_175726_f((BlockPos)player.func_180425_c()).field_76635_g / scaleX), (double)((double)player.func_130014_f_().func_175726_f((BlockPos)player.func_180425_c()).field_76647_h / scaleX), (double)persistance, (int)chunk.biomemapNumberOfOctaves) * chunk.biomemapScaleY;
                }
                String[] stringArray = new String[24];
                stringArray[0] = "GalaxySpace 2.0.17 DEBUG Mode";
                stringArray[1] = "MC Version: 1.12.2";
                stringArray[2] = "Celestial Body: " + (player.func_130014_f_().field_73011_w instanceof IGalacticraftWorldProvider ? ((IGalacticraftWorldProvider)player.func_130014_f_().field_73011_w).getCelestialBody().getLocalizedName() : "Unnamed");
                GSClientTickHandler gSClientTickHandler = this;
                stringArray[3] = "FPS: " + gSClientTickHandler.mc.func_175610_ah();
                stringArray[4] = "";
                stringArray[5] = "Player Data:";
                stringArray[6] = "X: " + (int)player.field_70165_t;
                stringArray[7] = "Y: " + (int)player.field_70163_u;
                stringArray[8] = "Z: " + (int)player.field_70161_v;
                stringArray[9] = "Current Item: " + (player.field_71071_by.func_70448_g() != null ? Item.field_150901_e.func_177774_c((Object)player.field_71071_by.func_70448_g().func_77973_b()) + ":" + player.field_71071_by.func_70448_g().func_77952_i() : "None");
                stringArray[10] = "";
                stringArray[11] = "World Data:";
                stringArray[12] = "Dimension: " + player.field_70170_p.field_73011_w.func_186058_p().func_186065_b() + " (ID: " + player.field_70170_p.field_73011_w.func_186058_p().func_186068_a() + ")";
                stringArray[13] = "Temperature: " + temp + "F";
                stringArray[14] = "Biome: " + player.field_70170_p.getBiomeForCoordsBody(new BlockPos((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v)).func_185359_l();
                stringArray[15] = "Current Time: " + time + " | Day Length: " + (player.field_70170_p.field_73011_w instanceof WorldProviderSpace ? Long.valueOf(((WorldProviderSpace)player.field_70170_p.field_73011_w).getDayLength()) : (player.field_70170_p.field_73011_w instanceof WE_WorldProviderSpace ? Long.valueOf(((WE_WorldProviderSpace)player.field_70170_p.field_73011_w).getDayLength()) : "24000")) + " | Total Time: " + player.field_70170_p.func_72820_D();
                stringArray[16] = "Moon Phase: " + player.field_70170_p.func_72853_d();
                stringArray[17] = "Chunk Pos: x" + player.func_130014_f_().func_175726_f((BlockPos)player.func_180425_c()).field_76635_g + " z" + player.func_130014_f_().func_175726_f((BlockPos)player.func_180425_c()).field_76647_h;
                stringArray[18] = "";
                stringArray[19] = "Is Galacticraft Provider: " + (player.func_130014_f_().field_73011_w instanceof IGalacticraftWorldProvider ? "Yes" : "No");
                stringArray[20] = "Is Advance Space Provider: " + (player.func_130014_f_().field_73011_w instanceof IAdvancedSpace ? "Yes" : "No");
                stringArray[21] = "Is Enable Oregen: " + (GSConfigCore.enableOresGeneration ? "Yes" : "No");
                stringArray[22] = "Is World Engine Provider: " + (isWE ? "Yes" : "No");
                stringArray[23] = "[WE] Biome Perlin Count: " + count;
                String[] s = stringArray;
                int k = 4;
                GameSettings cfr_ignored_0 = this.mc.field_71474_y;
                if (GameSettings.func_100015_a((KeyBinding)this.mc.field_71474_y.field_74311_E)) {
                    k = s.length;
                }
                GL11.glPushMatrix();
                for (int i = 0; i < k; ++i) {
                    if (minecraft.field_71474_y.field_74319_N) continue;
                    minecraft.field_71466_p.func_175063_a(s[i], 10.0f, (float)(28 + i * 10), ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                }
                GL11.glPopMatrix();
            }
            GlStateManager.func_179140_f();
            GlStateManager.func_179094_E();
            if (minecraft.field_71415_G && !minecraft.field_71474_y.field_74319_N && GSConfigCore.enableSpaceSuitHUD) {
                OverlaySpaceSuit.renderSpaceSuitOverlay((EntityPlayer)playerBaseClient);
            }
            GlStateManager.func_179121_F();
            ScaledResolution scaled = new ScaledResolution(this.mc);
            if (minecraft.field_71415_G && !minecraft.field_71474_y.field_74319_N && ticks > 0) {
                GlStateManager.func_179094_E();
                int xPos = 10;
                int yPos = scaled.func_78328_b() / 2 - 50;
                int color = Utils.getIntColorWHC((int)0, (int)0, (int)0, (int)(150 - ticks));
                int offsetY = 0;
                this.mc.field_71466_p.func_175063_a("Geological Scanner Data:", (float)xPos, (float)(yPos - 10), 0xFFFFFF);
                for (Map.Entry<IBlockState, String> block : blocks.entrySet()) {
                    ItemStack item = new ItemStack(Item.func_150898_a((Block)block.getKey().func_177230_c()), 1, block.getKey().func_177230_c().func_176201_c(block.getKey()));
                    GuiIngame cfr_ignored_1 = this.mc.field_71456_v;
                    GuiIngame.func_73734_a((int)xPos, (int)(yPos + 24 * offsetY), (int)(xPos + 180), (int)(yPos + 22 + 24 * offsetY), (int)color);
                    this.mc.func_175599_af().field_77023_b = -100.0f;
                    this.mc.func_175599_af().func_175042_a(item, xPos + 3, yPos + 24 * offsetY + 3);
                    this.mc.field_71466_p.func_175063_a(block.getValue(), (float)(xPos + 25), (float)(yPos + 24 * offsetY + 6), 0xFFFFFF);
                    ++offsetY;
                }
                GlStateManager.func_179121_F();
            }
            if (ticks > 0 && player.field_70173_aa % 10 == 0) {
                --ticks;
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onZeroGravity(ZeroGravityEvent.InFreefall event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (GSEventHandler.inGravityZone(entity.func_130014_f_(), entity, false)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderBlocks(RenderWorldLastEvent e) {
        RayTraceResult ray;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() instanceof ItemGeologicalScanner && stack.func_77952_i() < stack.func_77958_k() && stack.func_77978_p().func_74762_e("mode") == 0 && (ray = ItemBasicGS.getRay(player.func_130014_f_(), (EntityPlayer)player, false)) != null && ray.field_72307_f.func_72438_d(player.func_174791_d()) < 5.0) {
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilder worldRenderer = tess.func_178180_c();
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187441_d((float)2.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)false);
            BlockPos blockpos = ray.func_178782_a();
            IBlockState iblockstate = player.field_70170_p.func_180495_p(blockpos);
            if (iblockstate.func_185904_a() != Material.field_151579_a && player.field_70170_p.func_175723_af().func_177746_a(blockpos)) {
                double d3 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)player.field_70173_aa;
                double d4 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)player.field_70173_aa;
                double d5 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)player.field_70173_aa;
                RenderGlobal cfr_ignored_0 = Minecraft.func_71410_x().field_71438_f;
                RenderGlobal.func_189697_a((AxisAlignedBB)iblockstate.func_185918_c(player.field_70170_p, blockpos).func_186662_g(2.0).func_72317_d(-d3, -d4, -d5), (float)1.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            }
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
        }
        if (stack.func_77973_b() instanceof ItemMatterManipulator && (ray = ItemBasicGS.getRay(player.func_130014_f_(), (EntityPlayer)player, false)) != null && ray.field_72307_f.func_72438_d(player.func_174791_d()) < 15.0) {
            ItemMatterManipulator.drawLine(player.func_180425_c().func_177963_a(0.0, (double)player.func_70047_e(), 0.0), ray.func_178782_a(), player.field_70165_t, player.field_70163_u, player.field_70161_v);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerTick(TickEvent.PlayerTickEvent e) {
        ItemStack chest;
        if (e.phase == TickEvent.Phase.START && e.side == Side.CLIENT && (chest = e.player.func_184582_a(EntityEquipmentSlot.CHEST)) != null && chest.func_77973_b() instanceof IJetpackArmor && ((IJetpackArmor)chest.func_77973_b()).canFly(chest, e.player)) {
            this.parseKeybindings(e.player);
        }
    }

    private void parseKeybindings(EntityPlayer player) {
        float power = 1.0f;
        double y = player.field_70163_u;
        int worldHeight1 = player.func_130014_f_().func_72800_K();
        int maxFlightHeight1 = (int)((float)worldHeight1 / 1.28f);
        if (y > (double)(maxFlightHeight1 - 25)) {
            if (y > (double)maxFlightHeight1) {
                y = maxFlightHeight1;
            }
            power = (float)((double)power * (((double)maxFlightHeight1 - y) / 25.0));
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d()) {
            player.field_70181_x = Math.min(player.field_70181_x + (double)(power * 0.15f), (double)0.6f);
            GalaxySpace.packetPipeline.sendToServer((IPacket)new GSPacketSimple(GSPacketSimple.GSEnumSimplePacket.S_CHANGE_FLIGHT_STATE, player.field_70170_p, new Object[]{true}));
        } else {
            GalaxySpace.packetPipeline.sendToServer((IPacket)new GSPacketSimple(GSPacketSimple.GSEnumSimplePacket.S_CHANGE_FLIGHT_STATE, player.field_70170_p, new Object[]{false}));
        }
    }
}

