/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.client.render.entity;

import galaxyspace.core.util.GSTrace;
import galaxyspace.systems.SolarSystem.planets.overworld.items.tools.ItemMatterManipulator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderLaserBeam<T extends EntityLivingBase> {
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)1, (int)1, (int)0, (int)0);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-Minecraft.func_71410_x().field_71439_g.field_70165_t), (double)(-Minecraft.func_71410_x().field_71439_g.field_70163_u), (double)(-Minecraft.func_71410_x().field_71439_g.field_70161_v));
        this.renderClient(event.getPartialTicks());
        this.renderOthers(event.getPartialTicks());
        GlStateManager.func_179121_F();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179084_k();
        GlStateManager.func_179089_o();
    }

    public void renderOthers(float ticks) {
        Minecraft.func_71410_x().field_71441_e.func_72910_y().stream().filter(o -> o instanceof EntityPlayer).filter(player -> !player.equals((Object)Minecraft.func_71410_x().field_71439_g)).forEach(o -> {
            EntityPlayer player = (EntityPlayer)o;
            if (this.shouldRenderBeam(player)) {
                this.renderRaycastedBeam(player.func_174824_e(ticks).func_72441_c(0.0, (double)player.func_70047_e(), 0.0), player.func_70676_i(0.0f), new Vec3d(-0.5, -0.3, 1.0), player);
            }
        });
    }

    public void renderClient(float ticks) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (this.shouldRenderBeam((EntityPlayer)player)) {
            Vec3d pos = player.func_174824_e(1.0f);
            Vec3d look = player.func_70676_i(0.0f);
            this.renderRaycastedBeam(pos, look, new Vec3d(-0.1, -0.1, 0.15), (EntityPlayer)player);
        }
    }

    protected boolean shouldRenderBeam(EntityPlayer entity) {
        return entity.func_184587_cr() && entity.func_184607_cu() != null && entity.func_184607_cu().func_77973_b() instanceof ItemMatterManipulator;
    }

    protected void onBeamRaycastHit(RayTraceResult hit, EntityPlayer caster) {
        ItemStack weaponStack = caster.func_184607_cu();
        if (weaponStack != null && weaponStack.func_77973_b() instanceof ItemMatterManipulator && weaponStack.func_77973_b() instanceof ItemMatterManipulator && hit.field_72313_a == RayTraceResult.Type.BLOCK) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)((double)hit.func_178782_a().func_177958_n() + 0.5), (double)((double)hit.func_178782_a().func_177956_o() + 0.5), (double)((double)hit.func_178782_a().func_177952_p() + 0.5));
            GlStateManager.func_179137_b((double)((double)hit.field_178784_b.func_176730_m().func_177958_n() * 0.5), (double)((double)hit.field_178784_b.func_176730_m().func_177956_o() * 0.5), (double)((double)hit.field_178784_b.func_176730_m().func_177952_p() * 0.5));
            if (hit.field_178784_b == EnumFacing.SOUTH) {
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            } else if (hit.field_178784_b == EnumFacing.NORTH) {
                GlStateManager.func_179114_b((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
            } else if (hit.field_178784_b == EnumFacing.EAST) {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
            } else if (hit.field_178784_b == EnumFacing.WEST) {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            } else if (hit.field_178784_b == EnumFacing.DOWN) {
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GlStateManager.func_179139_a((double)1.0, (double)(1.5 + Math.sin((double)caster.field_70170_p.func_72820_D() * 0.5) * 0.5), (double)1.0);
            GlStateManager.func_179121_F();
        }
    }

    protected void onBeamRender(EntityPlayer caster) {
    }

    protected float getBeamMaxDistance(EntityPlayer caster) {
        return 15.0f;
    }

    protected float getBeamThickness(EntityPlayer caster) {
        return 0.05f;
    }

    protected boolean renderRaycastedBeam(Vec3d direction, Vec3d offset, EntityPlayer caster) {
        return this.renderRaycastedBeam(caster.func_174824_e(1.0f), direction, offset, caster);
    }

    protected boolean renderRaycastedBeam(Vec3d position, Vec3d direction, Vec3d offset, EntityPlayer caster) {
        double maxDistance = this.getBeamMaxDistance(caster);
        RayTraceResult hit = GSTrace.rayTrace(position, caster.field_70170_p, maxDistance, 0.0f, new Vec3d(0.0, 0.0, 0.0), false, true, direction, (EntityLivingBase)caster);
        if (hit != null && hit.field_72313_a != RayTraceResult.Type.MISS) {
            this.renderBeam(position, hit.field_72307_f, offset, null, this.getBeamThickness(caster), caster);
            this.onBeamRender(caster);
            this.onBeamRaycastHit(hit, caster);
            return true;
        }
        this.renderBeam(position, position.func_72441_c(direction.field_72450_a * maxDistance, direction.field_72448_b * maxDistance, direction.field_72449_c * maxDistance), offset, null, this.getBeamThickness(caster), caster);
        this.onBeamRender(caster);
        return false;
    }

    protected void renderBeam(Vec3d from, Vec3d to, Vec3d offest, ResourceLocation texture, float tickness, EntityPlayer viewer) {
        if (texture != null) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
        }
        GlStateManager.func_179124_c((float)0.0f, (float)1.0f, (float)1.0f);
        double distance = from.func_178788_d(to).func_72433_c();
        double v = (double)(-viewer.field_70170_p.func_72820_D()) * 0.2;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)from.field_72450_a, (double)from.field_72448_b, (double)from.field_72449_c);
        GlStateManager.func_179114_b((float)(-viewer.func_70079_am()), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)viewer.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)offest.field_72450_a, (double)offest.field_72448_b, (double)offest.field_72449_c);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder wr = tessellator.func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        wr.func_181662_b((double)tickness, 0.0, 0.0).func_187315_a(0.0, v).func_181675_d();
        wr.func_181662_b((double)tickness, 0.0, distance).func_187315_a(0.0, v + distance * 1.5).func_181675_d();
        wr.func_181662_b((double)(-tickness), 0.0, distance).func_187315_a(1.0, v + distance * 1.5).func_181675_d();
        wr.func_181662_b((double)(-tickness), 0.0, 0.0).func_187315_a(1.0, v).func_181675_d();
        wr.func_181662_b(0.0, (double)tickness, 0.0).func_187315_a(0.0, v).func_181675_d();
        wr.func_181662_b(0.0, (double)tickness, distance).func_187315_a(0.0, v + distance * 1.5).func_181675_d();
        wr.func_181662_b(0.0, (double)(-tickness), distance).func_187315_a(1.0, v + distance * 1.5).func_181675_d();
        wr.func_181662_b(0.0, (double)(-tickness), 0.0).func_187315_a(1.0, v).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179121_F();
    }
}

