/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.element;

import net.malisis.core.util.Point;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector4f;

public class Vertex {
    public static final int BRIGHTNESS_MAX = 0xF000F0;
    private String baseName;
    private double x = 0.0;
    private double y = 0.0;
    private double z = 0.0;
    private int brightness = 0;
    private int color = 0xFFFFFF;
    private int alpha = 255;
    private int normal = 0;
    private double u = 0.0;
    private double v = 0.0;
    private Vertex initialState;

    public Vertex(double x, double y, double z, int rgba, int brightness, double u, double v, int normal, boolean isInitialState) {
        this.set(x, y, z);
        this.setRGBA(rgba);
        this.setBrightness(brightness);
        this.setUV(u, v);
        this.x = x;
        this.y = y;
        this.z = z;
        this.u = u;
        this.v = v;
        this.normal = normal;
        this.baseName();
        if (!isInitialState) {
            this.initialState = new Vertex(x, y, z, rgba, brightness, u, v, normal, true);
        }
    }

    public Vertex(double x, double y, double z, int rgba, int brightness) {
        this(x, y, z, rgba, brightness, 0.0, 0.0, 0, false);
    }

    public Vertex(double x, double y, double z) {
        this(x, y, z, -1, 0xF000F0, 0.0, 0.0, 0, false);
    }

    public Vertex(Vertex vertex) {
        this(vertex.x, vertex.y, vertex.z, vertex.color << 8 | vertex.alpha, vertex.getBrightness(), vertex.u, vertex.v, 0, false);
        this.baseName = vertex.baseName;
    }

    public Vertex(Vertex vertex, int rgba, int brightness) {
        this(vertex.x, vertex.y, vertex.z, rgba, brightness);
    }

    public Vertex(Vertex vertex, int rgba, int brightness, float u, float v) {
        this(vertex.x, vertex.y, vertex.z, rgba, brightness, u, v, 0, false);
    }

    public double getX() {
        return this.x;
    }

    public int getIntX() {
        return (int)Math.round(this.x);
    }

    public Vertex setX(double x) {
        this.x = x;
        return this;
    }

    public double getY() {
        return this.y;
    }

    public int getIntY() {
        return (int)Math.round(this.y);
    }

    public Vertex setY(double y) {
        this.y = y;
        return this;
    }

    public double getZ() {
        return this.z;
    }

    public int getIntZ() {
        return (int)Math.round(this.z);
    }

    public Vertex setZ(double z) {
        this.z = z;
        return this;
    }

    public void set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int getColor() {
        return this.color;
    }

    public Vertex setColor(int color) {
        this.color = color & 0xFFFFFF;
        return this;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public Vertex setAlpha(int alpha) {
        this.alpha = alpha & 0xFF;
        return this;
    }

    public int getRGBA() {
        int r = this.color >> 16 & 0xFF;
        int g = this.color >> 8 & 0xFF;
        int b = this.color & 0xFF;
        return this.alpha << 24 | b << 16 | g << 8 | r;
    }

    public Vertex setRGBA(int rgba) {
        this.color = rgba >>> 8 & 0xFFFFFF;
        this.alpha = rgba & 0xFF;
        return this;
    }

    public int getBlockBrightness() {
        return this.brightness & 0xF0;
    }

    public int getSkyBrightness() {
        return this.brightness >> 16 & 0xF0;
    }

    public int getBrightness() {
        return this.brightness;
    }

    public Vertex setBrightness(int brightness) {
        this.brightness = brightness;
        return this;
    }

    public int getNormal() {
        return this.normal;
    }

    public Vertex setNormal(float x, float y, float z) {
        byte b0 = (byte)(x * 127.0f);
        byte b1 = (byte)(y * 127.0f);
        byte b2 = (byte)(z * 127.0f);
        this.normal = b0 & 0xFF | (b1 & 0xFF) << 8 | (b2 & 0xFF) << 16;
        return this;
    }

    public Vertex setNormal(EnumFacing facing) {
        if (facing == null) {
            return this;
        }
        return this.setNormal(facing.func_82601_c(), facing.func_96559_d(), facing.func_82599_e());
    }

    public double getU() {
        return this.u;
    }

    public double getV() {
        return this.v;
    }

    public void setUV(double u, double v) {
        this.u = u;
        this.v = v;
    }

    public Vertex translate(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Vertex scaleX(float f) {
        return this.scaleX(f, 0.0f);
    }

    public Vertex scaleX(float f, float offset) {
        this.x = (this.x - (double)offset) * (double)f + (double)offset;
        return this;
    }

    public Vertex scaleY(float f) {
        return this.scaleY(f, 0.0f);
    }

    public Vertex scaleY(float f, float offset) {
        this.y = (this.y - (double)offset) * (double)f + (double)offset;
        return this;
    }

    public Vertex scaleZ(float f) {
        return this.scaleZ(f, 0.0f);
    }

    public Vertex scaleZ(float f, float offset) {
        this.z = (this.z - (double)offset) * (double)f + (double)offset;
        return this;
    }

    public Vertex scale(float f) {
        return this.scale(f, 0.0f);
    }

    public Vertex scale(float f, float offset) {
        this.scaleX(f, offset);
        this.scaleY(f, offset);
        this.scaleZ(f, offset);
        return this;
    }

    public Vertex scale(float fx, float fy, float fz, float offsetX, float offsetY, float offsetZ) {
        this.scaleX(fx, offsetX);
        this.scaleY(fy, offsetY);
        this.scaleZ(fz, offsetZ);
        return this;
    }

    public Vertex rotateAroundX(double angle) {
        return this.rotateAroundX(angle, 0.5, 0.5, 0.5);
    }

    public Vertex rotateAroundX(double angle, double centerX, double centerY, double centerZ) {
        angle = Math.toRadians(angle);
        double ty = this.y - centerY;
        double tz = this.z - centerZ;
        this.y = ty * Math.cos(angle) - tz * Math.sin(angle);
        this.z = ty * Math.sin(angle) + tz * Math.cos(angle);
        this.y += centerY;
        this.z += centerZ;
        return this;
    }

    public Vertex rotateAroundY(double angle) {
        return this.rotateAroundY(angle, 0.5, 0.5, 0.5);
    }

    public Vertex rotateAroundY(double angle, double centerX, double centerY, double centerZ) {
        angle = Math.toRadians(angle);
        double tx = this.x - centerX;
        double tz = this.z - centerZ;
        this.x = tx * Math.cos(angle) + tz * Math.sin(angle);
        this.z = -tx * Math.sin(angle) + tz * Math.cos(angle);
        this.x += centerX;
        this.z += centerZ;
        return this;
    }

    public Vertex rotateAroundZ(double angle) {
        return this.rotateAroundZ(angle, 0.5, 0.5, 0.5);
    }

    public Vertex rotateAroundZ(double angle, double centerX, double centerY, double centerZ) {
        angle = Math.toRadians(angle);
        double tx = this.x - centerX;
        double ty = this.y - centerY;
        this.x = tx * Math.cos(angle) - ty * Math.sin(angle);
        this.y = tx * Math.sin(angle) + ty * Math.cos(angle);
        this.x += centerX;
        this.y += centerY;
        return this;
    }

    public void limitU(float min, float max) {
        this.u = Math.max(Math.min(this.u, (double)max), (double)min);
    }

    public void limitV(float min, float max) {
        this.v = Math.max(Math.min(this.v, (double)max), (double)min);
    }

    public boolean isCorner() {
        return !(this.x != 1.0 && this.x != 0.0 || this.y != 1.0 && this.y != 0.0 || this.z != 1.0 && this.z != 0.0);
    }

    public Vertex setBaseName(String name) {
        this.baseName = name;
        return this;
    }

    public String baseName() {
        if (this.baseName == null) {
            this.baseName = "";
            if (this.isCorner()) {
                this.baseName = (this.y == 1.0 ? "Top" : "Bottom") + (this.z == 1.0 ? "South" : "North") + (this.x == 1.0 ? "East" : "West");
            }
        }
        return this.baseName;
    }

    public String name() {
        return this.baseName() + " [" + this.x + ", " + this.y + ", " + this.z + "|" + this.u + ", " + this.v + "]";
    }

    public String toString() {
        return this.name() + " 0x" + Integer.toHexString(this.color) + " (a:" + this.alpha + ", bb:" + this.getBlockBrightness() + ", sb:" + this.getSkyBrightness() + ")";
    }

    public Point toPoint() {
        return new Point(this.x, this.y, this.z);
    }

    public static double clamp(double value) {
        return Vertex.clamp(value, 0.0, 1.0);
    }

    public static double clamp(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public void applyMatrix(Matrix4f transformMatrix) {
        Vector4f vec = new Vector4f((float)this.x, (float)this.y, (float)this.z, 1.0f);
        Matrix4f.transform((Matrix4f)transformMatrix, (Vector4f)vec, (Vector4f)vec);
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
    }

    public int[] getVertexData(VertexFormat vertexFormat, Vec3d offset) {
        float x = (float)this.getX();
        float y = (float)this.getY();
        float z = (float)this.getZ();
        if (offset != null) {
            x = (float)((double)x + offset.field_72450_a);
            y = (float)((double)y + offset.field_72448_b);
            z = (float)((double)z + offset.field_72449_c);
        }
        int[] data = new int[vertexFormat.func_181719_f()];
        int index = 0;
        data[index++] = Float.floatToRawIntBits(x);
        data[index++] = Float.floatToRawIntBits(y);
        data[index++] = Float.floatToRawIntBits(z);
        if (vertexFormat.func_177346_d()) {
            data[index++] = this.getRGBA();
        }
        if (vertexFormat.func_177347_a(0)) {
            data[index++] = Float.floatToRawIntBits((float)this.getU());
            data[index++] = Float.floatToRawIntBits((float)this.getV());
        }
        if (vertexFormat.func_177347_a(1)) {
            data[index++] = this.getBrightness();
        }
        if (vertexFormat.func_177350_b()) {
            data[index++] = this.getNormal();
        }
        return data;
    }

    private void setState(Vertex vertex) {
        this.x = vertex.x;
        this.y = vertex.y;
        this.z = vertex.z;
        this.color = vertex.color;
        this.alpha = vertex.alpha;
        this.brightness = vertex.brightness;
        this.normal = vertex.normal;
        this.u = vertex.u;
        this.v = vertex.v;
    }

    public void setInitialState() {
        this.initialState.setState(this);
    }

    public void resetState() {
        this.setState(this.initialState);
    }

    public int[][] getAoMatrix(EnumFacing offset) {
        int[][] a = new int[3][3];
        if (offset == EnumFacing.WEST || offset == EnumFacing.EAST) {
            int n = offset.func_82601_c();
            a[2][0] = n;
            a[1][0] = n;
            a[0][0] = n;
            int[] nArray = a[1];
            nArray[1] = (int)((long)nArray[1] + Math.round(this.y * 2.0 - 1.0));
            int[] nArray2 = a[2];
            nArray2[1] = (int)((long)nArray2[1] + Math.round(this.y * 2.0 - 1.0));
            int[] nArray3 = a[0];
            nArray3[2] = (int)((long)nArray3[2] + Math.round(this.z * 2.0 - 1.0));
            int[] nArray4 = a[1];
            nArray4[2] = (int)((long)nArray4[2] + Math.round(this.z * 2.0 - 1.0));
        } else if (offset == EnumFacing.UP || offset == EnumFacing.DOWN) {
            int n = offset.func_96559_d();
            a[2][1] = n;
            a[1][1] = n;
            a[0][1] = n;
            int[] nArray = a[1];
            nArray[0] = (int)((long)nArray[0] + Math.round(this.x * 2.0 - 1.0));
            int[] nArray5 = a[2];
            nArray5[0] = (int)((long)nArray5[0] + Math.round(this.x * 2.0 - 1.0));
            int[] nArray6 = a[0];
            nArray6[2] = (int)((long)nArray6[2] + Math.round(this.z * 2.0 - 1.0));
            int[] nArray7 = a[1];
            nArray7[2] = (int)((long)nArray7[2] + Math.round(this.z * 2.0 - 1.0));
        } else if (offset == EnumFacing.NORTH || offset == EnumFacing.SOUTH) {
            int n = offset.func_82599_e();
            a[2][2] = n;
            a[1][2] = n;
            a[0][2] = n;
            int[] nArray = a[1];
            nArray[0] = (int)((long)nArray[0] + Math.round(this.x * 2.0 - 1.0));
            int[] nArray8 = a[2];
            nArray8[0] = (int)((long)nArray8[0] + Math.round(this.x * 2.0 - 1.0));
            int[] nArray9 = a[0];
            nArray9[1] = (int)((long)nArray9[1] + Math.round(this.y * 2.0 - 1.0));
            int[] nArray10 = a[1];
            nArray10[1] = (int)((long)nArray10[1] + Math.round(this.y * 2.0 - 1.0));
        }
        return a;
    }
}

