/*
 * Decompiled with CFR 0.152.
 */
package nihiltres.engineersdoors.common.block.properties;

import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import nihiltres.engineersdoors.common.block.BlockModDoor;

public enum EnumDoorMaterial {
    WOOD(true, 1012, 1006),
    METAL(false, 1011, 1005),
    STONE(true, BlockModDoor.STONE_DOOR_OPEN, BlockModDoor.STONE_DOOR_CLOSE);

    private final boolean defaultManual;
    private Object openSound;
    private Object closeSound;

    private EnumDoorMaterial(boolean defaultManualIn, Object openSoundIn, Object closeSoundIn) {
        this.defaultManual = defaultManualIn;
        this.openSound = openSoundIn;
        this.closeSound = closeSoundIn;
    }

    public final void playSound(World world, EntityPlayer player, BlockPos pos, boolean isOpening) {
        if (this.openSound instanceof SoundEvent && this.closeSound instanceof SoundEvent) {
            world.func_184133_a(player, pos, isOpening ? (SoundEvent)this.openSound : (SoundEvent)this.closeSound, SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else if (this.openSound instanceof Integer && this.closeSound instanceof Integer) {
            world.func_180498_a(player, (isOpening ? (Integer)this.openSound : (Integer)this.closeSound).intValue(), pos, 0);
        } else {
            world.func_180498_a(player, isOpening ? 1012 : 1006, pos, 0);
        }
    }

    public static final EnumDoorMaterial fromMaterial(Material mat) {
        if (mat == Material.field_151573_f) {
            return METAL;
        }
        if (mat == Material.field_151576_e) {
            return STONE;
        }
        return WOOD;
    }

    public final boolean isDefaultManual() {
        return this.defaultManual;
    }

    public static final boolean isSupported(Material mat) {
        return EnumDoorMaterial.fromMaterial(mat) != WOOD || mat == Material.field_151575_d;
    }
}

