/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi;

import amerifrance.guideapi.GuideMod;
import amerifrance.guideapi.api.GuideAPI;
import amerifrance.guideapi.api.IGuideBook;
import amerifrance.guideapi.api.IPage;
import amerifrance.guideapi.api.impl.Book;
import amerifrance.guideapi.api.impl.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.impl.abstraction.EntryAbstract;
import amerifrance.guideapi.item.ItemGuideBook;
import amerifrance.guideapi.page.PageJsonRecipe;
import amerifrance.guideapi.util.APISetter;
import amerifrance.guideapi.util.AnnotationHandler;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber
public class RegistrarGuideAPI {
    @SubscribeEvent
    public static void registerItemsInADifferentRegistryEventBecauseLoadOrderingAndObjectHoldersAreImportant(RegistryEvent.Register<Biome> event) {
        AnnotationHandler.gatherBooks(GuideMod.dataTable);
        for (Book book : GuideAPI.getBooks().values()) {
            ItemGuideBook guideBook = new ItemGuideBook(book);
            guideBook.setRegistryName(book.getRegistryName().toString().replace(":", "-"));
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)guideBook);
            APISetter.setBookForStack(book, new ItemStack((Item)guideBook));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        for (Pair<Book, IGuideBook> guide : AnnotationHandler.BOOK_CLASSES) {
            IRecipe recipe = ((IGuideBook)guide.getRight()).getRecipe(GuideAPI.getStackFromBook((Book)guide.getLeft()));
            if (recipe == null) continue;
            event.getRegistry().register((IForgeRegistryEntry)recipe);
        }
        for (Book book : GuideAPI.getBooks().values()) {
            for (CategoryAbstract cat : book.getCategoryList()) {
                for (EntryAbstract entry : cat.entries.values()) {
                    for (IPage page : entry.pageList) {
                        if (!(page instanceof PageJsonRecipe)) continue;
                        ((PageJsonRecipe)page).init();
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        for (Pair<Book, IGuideBook> guide : AnnotationHandler.BOOK_CLASSES) {
            ((IGuideBook)guide.getRight()).handleModel(GuideAPI.getStackFromBook((Book)guide.getLeft()));
        }
    }
}

