/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.alchemyArray;

import WayofTime.bloodmagic.alchemyArray.AlchemyArrayEffect;
import WayofTime.bloodmagic.api.impl.BloodMagicAPI;
import WayofTime.bloodmagic.api.impl.recipe.RecipeSacrificeCraft;
import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.util.DamageSourceBloodMagic;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class AlchemyArrayEffectMobSacrifice
extends AlchemyArrayEffect {
    public static final AreaDescriptor itemDescriptor = new AreaDescriptor.Rectangle(new BlockPos(-5, -5, -5), 11);
    public static final AreaDescriptor mobDescriptor = new AreaDescriptor.Rectangle(new BlockPos(-5, -5, -5), 11);
    public int craftTime = 0;
    public static final int REQUIRED_CRAFT_TIME = 200;

    public AlchemyArrayEffectMobSacrifice(String key) {
        super(key);
    }

    @Override
    public boolean update(TileEntity tile, int ticksActive) {
        BlockPos pos;
        World world = tile.func_145831_w();
        if (world.field_72995_K && ticksActive < 200 && ticksActive > 40) {
            pos = tile.func_174877_v();
            Random rand = world.field_73012_v;
            for (int i = 0; i < 2; ++i) {
                double d0 = (double)pos.func_177958_n() + 0.5 + (rand.nextDouble() - 0.5) * 2.5;
                double d1 = (double)pos.func_177956_o() + 0.2 + (rand.nextDouble() - 0.5) * 0.2;
                double d2 = (double)pos.func_177952_p() + 0.5 + (rand.nextDouble() - 0.5) * 2.5;
                world.func_175688_a(EnumParticleTypes.SPELL_MOB, d0, d1, d2, 1.0, 0.0, 0.0, new int[0]);
            }
        }
        if (ticksActive >= 200) {
            RecipeSacrificeCraft recipe;
            pos = tile.func_174877_v();
            List itemList = world.func_72872_a(EntityItem.class, itemDescriptor.getAABB(pos));
            ArrayList<ItemStack> inputList = new ArrayList<ItemStack>();
            for (EntityItem entityItem : itemList) {
                if (entityItem.field_70128_L || entityItem.func_92059_d().func_190926_b()) continue;
                inputList.add(entityItem.func_92059_d().func_77946_l());
            }
            if (inputList.isEmpty()) {
                return false;
            }
            if (inputList.size() == 1) {
                // empty if block
            }
            if ((recipe = BloodMagicAPI.INSTANCE.getRecipeRegistrar().getSacrificeCraft(inputList)) != null) {
                double health;
                double healthRequired = recipe.getHealthRequired();
                double healthAvailable = 0.0;
                List livingEntities = world.func_72872_a(EntityLivingBase.class, mobDescriptor.getAABB(pos));
                for (EntityLivingBase living : livingEntities) {
                    health = this.getEffectiveHealth(living);
                    if (!(health > 0.0)) continue;
                    healthAvailable += health;
                }
                if (healthAvailable < healthRequired) {
                    this.craftTime = 0;
                    return false;
                }
                ++this.craftTime;
                if (this.craftTime >= 200) {
                    if (!world.field_72995_K) {
                        for (EntityLivingBase living : livingEntities) {
                            health = this.getEffectiveHealth(living);
                            if (healthAvailable > 0.0 && health > 0.0) {
                                healthAvailable -= health;
                                living.func_130014_f_().func_184148_a(null, living.field_70165_t, living.field_70163_u, living.field_70161_v, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (living.func_130014_f_().field_73012_v.nextFloat() - living.func_130014_f_().field_73012_v.nextFloat()) * 0.8f);
                                living.func_70606_j(-1.0f);
                                living.func_70645_a((DamageSource)DamageSourceBloodMagic.INSTANCE);
                            }
                            if (!(healthAvailable <= 0.0)) continue;
                            break;
                        }
                        for (EntityItem itemEntity : itemList) {
                            itemEntity.func_92059_d().func_190920_e(itemEntity.func_92059_d().func_190916_E() - 1);
                            if (!itemEntity.func_92059_d().func_190926_b()) continue;
                            itemEntity.func_70106_y();
                        }
                        world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 2.5, (double)pos.func_177952_p() + 0.5, recipe.getOutput()));
                        this.craftTime = 0;
                    }
                } else if (world.field_72995_K) {
                    Vec3d spawnPosition = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 2.5, (double)pos.func_177952_p() + 0.5);
                    for (EntityItem itemEntity : itemList) {
                        ItemStack stack = itemEntity.func_92059_d();
                        double velocityFactor = 0.1;
                        Vec3d itemPosition = new Vec3d(itemEntity.field_70165_t, itemEntity.field_70163_u + 0.5, itemEntity.field_70161_v);
                        Vec3d velVec1 = new Vec3d((world.field_73012_v.nextDouble() - 0.5) * velocityFactor, (world.field_73012_v.nextDouble() - 0.5) * velocityFactor, (world.field_73012_v.nextDouble() - 0.5) * velocityFactor);
                        world.func_175688_a(EnumParticleTypes.ITEM_CRACK, itemPosition.field_72450_a + (spawnPosition.field_72450_a - itemPosition.field_72450_a) * (double)this.craftTime / 200.0, itemPosition.field_72448_b + (spawnPosition.field_72448_b - itemPosition.field_72448_b) * (double)this.craftTime / 200.0, itemPosition.field_72449_c + (spawnPosition.field_72449_c - itemPosition.field_72449_c) * (double)this.craftTime / 200.0, velVec1.field_72450_a, velVec1.field_72448_b, velVec1.field_72449_c, new int[]{Item.func_150891_b((Item)stack.func_77973_b()), stack.func_77960_j()});
                    }
                    for (EntityLivingBase living : livingEntities) {
                        double health2 = this.getEffectiveHealth(living);
                        if (health2 <= 0.0) continue;
                        double d0 = living.field_70165_t + (world.field_73012_v.nextDouble() - 0.5) * 0.5;
                        double d1 = living.field_70163_u + 0.5 + (world.field_73012_v.nextDouble() - 0.5) * 1.0;
                        double d2 = living.field_70161_v + (world.field_73012_v.nextDouble() - 0.5) * 0.5;
                        world.func_175688_a(EnumParticleTypes.SPELL_MOB, d0, d1, d2, 1.0, 0.0, 0.0, new int[0]);
                    }
                }
            }
        }
        return false;
    }

    public double getEffectiveHealth(EntityLivingBase living) {
        if (living == null) {
            return 0.0;
        }
        if (!living.func_184222_aU()) {
            return 0.0;
        }
        if (living instanceof EntityPlayer) {
            return 0.0;
        }
        if (living.func_70631_g_() && !(living instanceof IMob)) {
            return 0.0;
        }
        if (living.field_70128_L || living.func_110143_aJ() < 0.5f) {
            return 0.0;
        }
        EntityEntry entityEntry = EntityRegistry.getEntry(living.getClass());
        if (entityEntry == null) {
            return 0.0;
        }
        return living.func_110143_aJ();
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
    }

    @Override
    public AlchemyArrayEffect getNewCopy() {
        return new AlchemyArrayEffectMobSacrifice(this.key);
    }
}

