/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.worldgen;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mrjake.aunis.Aunis;
import mrjake.aunis.AunisProps;
import mrjake.aunis.block.AunisBlocks;
import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.config.StargateDimensionConfig;
import mrjake.aunis.config.StargateSizeEnum;
import mrjake.aunis.fluid.AunisFluids;
import mrjake.aunis.item.AunisItems;
import mrjake.aunis.stargate.merging.StargateMilkyWayMergeHelper;
import mrjake.aunis.stargate.network.StargateAddress;
import mrjake.aunis.stargate.network.SymbolTypeEnum;
import mrjake.aunis.tileentity.stargate.StargateMilkyWayBaseTile;
import mrjake.aunis.util.LinkingHelper;
import mrjake.aunis.worldgen.StargateGenerationHelper;
import mrjake.aunis.worldgen.StargateNetherTemplateProcessor;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class StargateGeneratorNether {
    private static final List<StargateGenerationHelper.Direction> DIRECTIONS = Arrays.asList(new StargateGenerationHelper.Direction(EnumFacing.UP, false, 0).setRequiredMinimum(12).setIgnoreInMaximum(), new StargateGenerationHelper.Direction(EnumFacing.NORTH, true, 2), new StargateGenerationHelper.Direction(EnumFacing.SOUTH, true, 2), new StargateGenerationHelper.Direction(EnumFacing.WEST, true, 2), new StargateGenerationHelper.Direction(EnumFacing.EAST, true, 2));
    private static final List<BlockMatcher> ALLOWED_BLOCKS_BELOW = Arrays.asList(BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL), BlockMatcher.func_177642_a((Block)Blocks.field_150449_bY), BlockMatcher.func_177642_a((Block)Blocks.field_150425_aM));
    private static final ITemplateProcessor TEMPLATE_PROCESSOR = new StargateNetherTemplateProcessor();
    private static final int MINIMAL_FRONT_SPACE = 16;
    private static final int MINIMAL_SIDE_SPACE = 5;

    @Nullable
    public static StargateAddress place(WorldServer world, BlockPos posIn) {
        Rotation rotation;
        BlockPos start;
        BlockPos current = start = posIn;
        int count = 0;
        int pass = 1;
        BlockPos found = null;
        Map.Entry<EnumFacing, StargateGenerationHelper.DirectionResult> frontResult = null;
        while (found == null) {
            Aunis.logger.debug("StargateGeneratorNether: count: " + count + ", pass: " + pass + ", current: " + current);
            for (BlockPos.MutableBlockPos pos : BlockPos.MutableBlockPos.func_177975_b((BlockPos)current, (BlockPos)current.func_177982_a(16, 16, 16))) {
                StargateGenerationHelper.FreeSpace freeSpace;
                if (world.func_175623_d(pos.func_177977_b()) || (freeSpace = StargateGenerationHelper.getFreeSpaceInDirections((IBlockAccess)world, (BlockPos)pos, DIRECTIONS, 16, ALLOWED_BLOCKS_BELOW)) == null || freeSpace.getMaxDistance().getValue().distance < 16) continue;
                int left = freeSpace.getDistance((EnumFacing)freeSpace.getMaxDistance().getKey().func_176735_f()).distance;
                int right = freeSpace.getDistance((EnumFacing)freeSpace.getMaxDistance().getKey().func_176746_e()).distance;
                if (left < 5 || right < 5) continue;
                found = pos.func_185334_h();
                frontResult = freeSpace.getMaxDistance();
                break;
            }
            if (count == 0) {
                current = start.func_177982_a(16, 0, 0);
            } else if (count == 1) {
                current = start.func_177982_a(0, 0, 16);
            } else if (count == 2) {
                current = start.func_177982_a(16, 0, 16);
            } else if (count == 3) {
                if (start.func_177956_o() > 100) {
                    start = posIn.func_177982_a(32 * pass, 0, 32 * pass);
                    ++pass;
                } else {
                    start = start.func_177982_a(0, 16, 0);
                }
                current = start;
            }
            if (++count <= 3) continue;
            count = 0;
        }
        Aunis.logger.debug("StargateGeneratorNether: /tp " + found.func_177958_n() + " " + found.func_177956_o() + " " + found.func_177952_p());
        switch ((EnumFacing)frontResult.getKey()) {
            case SOUTH: {
                rotation = Rotation.CLOCKWISE_180;
                break;
            }
            case WEST: {
                rotation = Rotation.COUNTERCLOCKWISE_90;
                break;
            }
            case NORTH: {
                rotation = Rotation.NONE;
                break;
            }
            case EAST: {
                rotation = Rotation.CLOCKWISE_90;
                break;
            }
            default: {
                rotation = Rotation.NONE;
            }
        }
        int y = Math.min(((StargateGenerationHelper.DirectionResult)frontResult.getValue()).ydiff, 0);
        BlockPos translate = new BlockPos(-7, y -= 2, -16).func_190942_a(rotation);
        found = found.func_177971_a((Vec3i)translate);
        TemplateManager templateManager = world.func_184163_y();
        Template template = templateManager.func_186237_a(world.func_73046_m(), new ResourceLocation("aunis", "sg_nether_" + (AunisConfig.stargateSize == StargateSizeEnum.LARGE ? "large" : "small")));
        if (template != null) {
            PlacementSettings settings = new PlacementSettings().func_186226_b(false).func_186220_a(rotation);
            template.func_189960_a((World)world, found, TEMPLATE_PROCESSOR, settings, 3);
            Map datablocks = template.func_186258_a(found, settings);
            BlockPos basePos = null;
            BlockPos dhdPos = null;
            for (Map.Entry datablock : datablocks.entrySet()) {
                switch ((String)datablock.getValue()) {
                    case "base": {
                        basePos = ((BlockPos)datablock.getKey()).func_177977_b();
                        world.func_175656_a((BlockPos)datablock.getKey(), Blocks.field_150385_bj.func_176223_P());
                        EnumFacing facing = (EnumFacing)world.func_180495_p(basePos).func_177229_b((IProperty)AunisProps.FACING_HORIZONTAL);
                        StargateMilkyWayMergeHelper.INSTANCE.updateMembersBasePos((IBlockAccess)world, ((BlockPos)datablock.getKey()).func_177977_b(), facing);
                        IItemHandler itemHandler = (IItemHandler)world.func_175625_s(basePos).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                        itemHandler.insertItem(4, new ItemStack((Block)AunisBlocks.CAPACITOR_BLOCK), false);
                        itemHandler.insertItem(0, new ItemStack(AunisItems.CRYSTAL_GLYPH_MILKYWAY), false);
                        if (!StargateDimensionConfig.netherOverworld8thSymbol()) break;
                        itemHandler.insertItem(1, new ItemStack(AunisItems.CRYSTAL_GLYPH_STARGATE), false);
                        break;
                    }
                    case "dhd": {
                        dhdPos = ((BlockPos)datablock.getKey()).func_177977_b();
                        world.func_175698_g((BlockPos)datablock.getKey());
                        int fluid = (int)(6000.0 + Math.random() * 3000.0);
                        ((FluidTank)world.func_175625_s(dhdPos).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).fillInternal(new FluidStack((Fluid)AunisFluids.moltenNaquadahRefined, fluid), true);
                        IItemHandler itemHandler = (IItemHandler)world.func_175625_s(dhdPos).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                        itemHandler.insertItem(0, new ItemStack(AunisItems.CRYSTAL_CONTROL_DHD), false);
                        if (!StargateDimensionConfig.netherOverworld8thSymbol()) break;
                        itemHandler.insertItem(1, new ItemStack(AunisItems.CRYSTAL_GLYPH_DHD), false);
                    }
                }
            }
            LinkingHelper.updateLinkedGate((World)world, basePos, dhdPos);
            StargateMilkyWayBaseTile gateTile = (StargateMilkyWayBaseTile)world.func_175625_s(basePos);
            return gateTile.getStargateAddress(SymbolTypeEnum.MILKYWAY);
        }
        return null;
    }
}

