/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.worldgen;

import java.util.Map;
import java.util.Random;
import mrjake.aunis.Aunis;
import mrjake.aunis.block.AunisBlocks;
import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.config.StargateSizeEnum;
import mrjake.aunis.fluid.AunisFluids;
import mrjake.aunis.item.AunisItems;
import mrjake.aunis.stargate.network.StargateAddress;
import mrjake.aunis.stargate.network.StargatePos;
import mrjake.aunis.stargate.network.SymbolTypeEnum;
import mrjake.aunis.tileentity.dialhomedevice.DHDAbstractTile;
import mrjake.aunis.tileentity.stargate.StargateAbstractBaseTile;
import mrjake.aunis.tileentity.stargate.StargateClassicBaseTile;
import mrjake.aunis.util.LinkingHelper;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class StargateGenerator {
    private static final int SG_SIZE_X = 12;
    private static final int SG_SIZE_Z = 13;
    private static final int SG_SIZE_X_PLAINS = 11;
    private static final int SG_SIZE_Z_PLAINS = 11;
    private static final int MAX_CHECK = 100;

    public static GeneratedStargate generateStargate(World world) {
        Rotation rotation;
        int z;
        int x;
        BlockPos pos;
        Random rand = new Random();
        int tries = 0;
        WorldServer worldToSpawn = world.func_73046_m().func_71218_a(0);
        while ((pos = StargateGenerator.checkForPlace((World)worldToSpawn, (x = (int)((float)AunisConfig.mysteriousConfig.minOverworldCoords + rand.nextFloat() * (float)(AunisConfig.mysteriousConfig.maxOverworldCoords - AunisConfig.mysteriousConfig.minOverworldCoords)) * (rand.nextBoolean() ? -1 : 1)) / 16, (z = (int)((float)AunisConfig.mysteriousConfig.minOverworldCoords + rand.nextFloat() * (float)(AunisConfig.mysteriousConfig.maxOverworldCoords - AunisConfig.mysteriousConfig.minOverworldCoords)) * (rand.nextBoolean() ? -1 : 1)) / 16)) == null && ++tries < 100) {
        }
        if (tries == 100) {
            Aunis.logger.debug("StargateGenerator: Failed to find place");
            return null;
        }
        EnumFacing facing = StargateGenerator.findOptimalRotation((World)worldToSpawn, pos);
        switch (facing) {
            case SOUTH: {
                rotation = Rotation.CLOCKWISE_90;
                break;
            }
            case WEST: {
                rotation = Rotation.CLOCKWISE_180;
                break;
            }
            case NORTH: {
                rotation = Rotation.COUNTERCLOCKWISE_90;
                break;
            }
            case EAST: {
                rotation = Rotation.NONE;
                break;
            }
            default: {
                rotation = Rotation.NONE;
            }
        }
        boolean pegasusGate = new Random().nextInt(100) < 50 && AunisConfig.devConfig.pegGatesMyst;
        return StargateGenerator.generateStargateDesert((World)worldToSpawn, pos, facing, rotation, pegasusGate);
    }

    private static BlockPos checkForPlace(World world, int chunkX, int chunkZ) {
        if (world.func_190526_b(chunkX, chunkZ)) {
            return null;
        }
        Chunk chunk = world.func_72964_e(chunkX, chunkZ);
        int y = chunk.func_76611_b(8, 8);
        if (y > 240) {
            return null;
        }
        BlockPos pos = new BlockPos(chunkX * 16, y, chunkZ * 16);
        String biomeName = chunk.func_177411_a(pos, world.func_72959_q()).getRegistryName().func_110623_a();
        boolean desert = biomeName.contains("desert");
        if (!(biomeName.contains("ocean") || biomeName.contains("river") || biomeName.contains("beach"))) {
            int x = desert ? 12 : 11;
            int z = desert ? 13 : 11;
            int y1 = chunk.func_76611_b(0, 0);
            int y2 = chunk.func_76611_b(x, z);
            int y3 = chunk.func_76611_b(x, 0);
            int y4 = chunk.func_76611_b(0, z);
            if (Math.abs(y1 - y2) <= 1 && Math.abs(y3 - y4) <= 1) {
                return pos.func_177973_b((Vec3i)new BlockPos(0, 1, 0));
            }
            Aunis.logger.debug("StargateGenerator: too steep");
        } else {
            Aunis.logger.debug("StargateGenerator: failed, " + biomeName);
        }
        return null;
    }

    private static EnumFacing findOptimalRotation(World world, BlockPos pos) {
        BlockPos start = pos.func_177982_a(0, 5, 5);
        int max = -1;
        EnumFacing maxFacing = EnumFacing.EAST;
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            RayTraceResult rayTraceResult = world.func_72933_a(new Vec3d((Vec3i)start), new Vec3d((Vec3i)start.func_177967_a(facing, 100)));
            if (rayTraceResult != null && rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
                int distance = (int)rayTraceResult.func_178782_a().func_177951_i((Vec3i)start);
                if (distance <= max) continue;
                max = distance;
                maxFacing = facing;
                continue;
            }
            max = 100000;
            maxFacing = facing;
        }
        return maxFacing;
    }

    private static GeneratedStargate generateStargateDesert(World world, BlockPos pos, EnumFacing facing, Rotation rotation, boolean pegasusGate) {
        WorldServer worldServer = (WorldServer)world;
        MinecraftServer server = world.func_73046_m();
        Biome biome = world.func_180494_b(pos);
        boolean desert = biome.getRegistryName().func_110623_a().contains("desert");
        String templateName = "sg_";
        templateName = templateName + (desert ? "desert" : "plains");
        if (pegasusGate) {
            templateName = templateName + "_pg";
        }
        templateName = templateName + (AunisConfig.stargateSize == StargateSizeEnum.LARGE ? "_large" : "_small");
        TemplateManager templateManager = worldServer.func_184163_y();
        Template template = templateManager.func_186237_a(server, new ResourceLocation("aunis", templateName));
        if (template != null) {
            Random rand = new Random();
            PlacementSettings settings = new PlacementSettings().func_186226_b(false).func_186220_a(rotation);
            template.func_186253_b(world, pos, settings);
            Map datablocks = template.func_186258_a(pos, settings);
            BlockPos gatePos = null;
            BlockPos dhdPos = null;
            for (BlockPos dataPos : datablocks.keySet()) {
                String name = (String)datablocks.get(dataPos);
                if (name.equals("base")) {
                    gatePos = dataPos.func_177982_a(0, -3, 0);
                    ((IItemHandler)world.func_175625_s(gatePos).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).insertItem(4, new ItemStack((Block)AunisBlocks.CAPACITOR_BLOCK), false);
                    ((StargateAbstractBaseTile)world.func_175625_s(gatePos)).getMergeHelper().updateMembersBasePos((IBlockAccess)world, gatePos, facing);
                    world.func_175698_g(dataPos);
                    world.func_175698_g(dataPos.func_177977_b());
                    continue;
                }
                if (!name.equals("dhd")) continue;
                dhdPos = dataPos.func_177977_b();
                if ((double)rand.nextFloat() < AunisConfig.mysteriousConfig.despawnDhdChance) {
                    world.func_175698_g(dhdPos);
                } else {
                    int fluid = AunisConfig.powerConfig.stargateEnergyStorage / AunisConfig.dhdConfig.energyPerNaquadah;
                    DHDAbstractTile dhdTile = (DHDAbstractTile)world.func_175625_s(dhdPos);
                    ItemStack crystal = new ItemStack(pegasusGate ? AunisItems.CRYSTAL_CONTROL_PEGASUS_DHD : AunisItems.CRYSTAL_CONTROL_DHD);
                    ((IItemHandler)dhdTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).insertItem(0, crystal, false);
                    if (pegasusGate) {
                        ((IItemHandler)dhdTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).insertItem(1, new ItemStack(AunisItems.CRYSTAL_GLYPH_DHD), false);
                    }
                    ((FluidTank)dhdTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).fillInternal(new FluidStack((Fluid)AunisFluids.moltenNaquadahRefined, fluid), true);
                }
                world.func_175698_g(dataPos);
            }
            LinkingHelper.updateLinkedGate(world, gatePos, dhdPos);
            StargateClassicBaseTile gateTile = (StargateClassicBaseTile)world.func_175625_s(gatePos);
            gateTile.refresh();
            gateTile.func_70296_d();
            StargateAddress address = gateTile.getStargateAddress(SymbolTypeEnum.MILKYWAY);
            if (address != null && !gateTile.getNetwork().isStargateInNetwork(address)) {
                gateTile.getNetwork().addStargate(address, new StargatePos(world.field_73011_w.func_186058_p().func_186068_a(), gatePos, address));
            }
            return new GeneratedStargate(address, biome.getRegistryName().func_110623_a(), pegasusGate);
        }
        Aunis.logger.error("template null");
        return null;
    }

    public static class GeneratedStargate {
        public StargateAddress address;
        public String path;
        public boolean hasUpgrade;

        public GeneratedStargate(StargateAddress address, String path, boolean upgrade) {
            this.address = address;
            this.path = path;
            this.hasUpgrade = upgrade;
        }
    }
}

