/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.worldgen;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class StargateGenerationHelper {
    public static DirectionResult getFreeSpaceInDirection(IBlockAccess blockAccess, BlockPos start, Direction direction, int maxDistance, List<BlockMatcher> allowedBlocksBelow) {
        int distance = 0;
        int ydiff = 0;
        while (distance < maxDistance) {
            BlockPos offset = start.func_177967_a(direction.getDirection(), distance + 1);
            if (!blockAccess.func_175623_d(offset)) {
                if (ydiff == direction.getMaxVertDiff()) break;
                start = start.func_177984_a();
                ++ydiff;
                continue;
            }
            if (blockAccess.func_175623_d(offset.func_177977_b()) && direction.checkDown) {
                if (-ydiff == direction.getMaxVertDiff()) break;
                start = start.func_177977_b();
                --ydiff;
                continue;
            }
            if (!direction.checkDown(blockAccess.func_180495_p(offset.func_177977_b()), allowedBlocksBelow)) break;
            ++distance;
        }
        return new DirectionResult(distance, ydiff);
    }

    @Nullable
    public static FreeSpace getFreeSpaceInDirections(IBlockAccess blockAccess, BlockPos start, List<Direction> directions, int maxDistance, List<BlockMatcher> allowedBlocksBelow) {
        FreeSpace freeSpace = new FreeSpace();
        for (Direction direction : directions) {
            DirectionResult free = StargateGenerationHelper.getFreeSpaceInDirection(blockAccess, start, direction, maxDistance, allowedBlocksBelow);
            if (!direction.checkRequiredMinimum(free.distance)) {
                return null;
            }
            freeSpace.put(direction.getDirection(), free, direction.getIgnoreInMaximum());
        }
        return freeSpace;
    }

    public static class DirectionResult {
        public int distance;
        public int ydiff;

        public DirectionResult(int distance, int ydiff) {
            this.distance = distance;
            this.ydiff = ydiff;
        }

        public String toString() {
            return "[dist=" + this.distance + ", ydiff=" + this.ydiff + "]";
        }
    }

    public static class Direction {
        private EnumFacing direction;
        private boolean checkDown;
        private boolean hasMinDistance = false;
        private int minDistance;
        private boolean ignoreInMaximum = false;
        private int maxVertDiff;

        public Direction(EnumFacing direction, boolean checkDown, int maxVertDiff) {
            this.checkDown = checkDown;
            this.direction = direction;
            this.maxVertDiff = maxVertDiff;
        }

        public EnumFacing getDirection() {
            return this.direction;
        }

        public boolean checkDown(IBlockState blockState, List<BlockMatcher> matchers) {
            if (this.checkDown) {
                for (BlockMatcher matcher : matchers) {
                    if (!matcher.apply(blockState)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }

        public Direction setRequiredMinimum(int distance) {
            this.hasMinDistance = true;
            this.minDistance = distance;
            return this;
        }

        public boolean checkRequiredMinimum(int distance) {
            if (this.hasMinDistance) {
                return distance >= this.minDistance;
            }
            return true;
        }

        public Direction setIgnoreInMaximum() {
            this.ignoreInMaximum = true;
            return this;
        }

        public boolean getIgnoreInMaximum() {
            return this.ignoreInMaximum;
        }

        public int getMaxVertDiff() {
            return this.maxVertDiff;
        }
    }

    public static class FreeSpace {
        private Map<EnumFacing, DirectionResult> freeSpaceMap = new HashMap<EnumFacing, DirectionResult>();
        private Map.Entry<EnumFacing, DirectionResult> maxFreeSpace;

        public void put(EnumFacing direction, DirectionResult distance, boolean ignoreInMaximum) {
            if (!(ignoreInMaximum || this.maxFreeSpace != null && distance.distance <= this.maxFreeSpace.getValue().distance)) {
                this.maxFreeSpace = new AbstractMap.SimpleEntry<EnumFacing, DirectionResult>(direction, distance);
            }
            this.freeSpaceMap.put(direction, distance);
        }

        public DirectionResult getDistance(EnumFacing direction) {
            return this.freeSpaceMap.get(direction);
        }

        public Map.Entry<EnumFacing, DirectionResult> getMaxDistance() {
            return this.maxFreeSpace;
        }

        public String toString() {
            return this.freeSpaceMap.toString();
        }
    }
}

