/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.worldgen;

import com.google.common.base.Predicate;
import java.util.Random;
import mrjake.aunis.block.AunisBlocks;
import mrjake.aunis.config.AunisConfig;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;

public class AunisWorldGen
implements IWorldGenerator {
    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.func_186058_p()) {
            case NETHER: {
                if (!AunisConfig.worldgenConfig.naquadahEnable) break;
                this.runGenerator(AunisBlocks.ORE_NAQUADAH_BLOCK.func_176223_P(), AunisConfig.worldgenConfig.naquadahVeinSize, AunisConfig.worldgenConfig.naquadahMaxVeinInChunk, 0, 128, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL), world, rand, chunkX, chunkZ);
                break;
            }
            case OVERWORLD: {
                if (!AunisConfig.worldgenConfig.titaniumEnable) break;
                this.runGenerator(AunisBlocks.ORE_TITANIUM_BLOCK.func_176223_P(), AunisConfig.worldgenConfig.titaniumVeinSize, AunisConfig.worldgenConfig.titaniumMaxVeinInChunk, 0, 25, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b), world, rand, chunkX, chunkZ);
                break;
            }
            case THE_END: {
                if (!AunisConfig.worldgenConfig.triniumEnabled) break;
                this.runGenerator(AunisBlocks.ORE_TRINIUM_BLOCK.func_176223_P(), AunisConfig.worldgenConfig.triniumVeinSize, AunisConfig.worldgenConfig.triniumMaxVeinInChunk, 0, 128, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150377_bs), world, rand, chunkX, chunkZ);
                break;
            }
        }
    }

    private void runGenerator(IBlockState blockToGen, int blockAmount, int chancesToSpawn, int minHeight, int maxHeight, Predicate<IBlockState> blockToReplace, World world, Random rand, int chunkX, int chunkZ) {
        if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
            throw new IllegalArgumentException("Illegal height arguments for AunisWorldGen::runGenerator()");
        }
        WorldGenMinable generator = new WorldGenMinable(blockToGen, blockAmount, blockToReplace);
        int heightDiff = maxHeight - minHeight;
        int bx = chunkX * 16 + 2;
        int bz = chunkZ * 16 + 2;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int x = bx + rand.nextInt(12);
            int y = minHeight + rand.nextInt(heightDiff);
            int z = bz + rand.nextInt(12);
            generator.func_180709_b(world, rand, new BlockPos(x, y, z));
        }
    }
}

