/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.util;

import javax.annotation.Nullable;
import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.tileentity.dialhomedevice.DHDAbstractTile;
import mrjake.aunis.tileentity.stargate.StargateAbstractBaseTile;
import mrjake.aunis.util.ILinkable;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class LinkingHelper {
    private static int nextLinkId = 0;

    @Nullable
    public static BlockPos findClosestUnlinked(World world, BlockPos startPos, BlockPos radius, Block targetBlock, int linkId) {
        double closestDistance = Double.MAX_VALUE;
        BlockPos closest = null;
        for (BlockPos target : BlockPos.func_177975_b((BlockPos)startPos.func_177973_b((Vec3i)radius), (BlockPos)startPos.func_177971_a((Vec3i)radius))) {
            double distanceSq;
            ILinkable linkedTile;
            if (world.func_180495_p(target).func_177230_c() != targetBlock || !(linkedTile = (ILinkable)world.func_175625_s(target)).canLinkTo() && linkId != linkedTile.getLinkId() || !((distanceSq = startPos.func_177951_i((Vec3i)target)) < closestDistance)) continue;
            closestDistance = distanceSq;
            closest = target.func_185334_h();
        }
        return closest;
    }

    public static BlockPos getDhdRange() {
        int xz = AunisConfig.dhdConfig.rangeFlat;
        int y = AunisConfig.dhdConfig.rangeVertical;
        return new BlockPos(xz, y, xz);
    }

    public static void updateLinkedGate(World world, BlockPos gatePos, BlockPos dhdPos) {
        StargateAbstractBaseTile gateTile = (StargateAbstractBaseTile)world.func_175625_s(gatePos);
        DHDAbstractTile dhdTile = (DHDAbstractTile)world.func_175625_s(dhdPos);
        if (dhdTile != null) {
            int linkId = LinkingHelper.getLinkId();
            dhdTile.setLinkedGate(gatePos, linkId);
            gateTile.setLinkedDHD(dhdPos, linkId);
        }
    }

    public static int getLinkId() {
        return ++nextLinkId;
    }
}

