/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.util;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import mrjake.aunis.Aunis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;

public class FluidColors {
    private static Map<Fluid, FloatColors> fluidColorMap = new HashMap<Fluid, FloatColors>();
    private static Set<Fluid> failedSet = new HashSet<Fluid>();

    @Nullable
    public static FloatColors getAverageColor(Fluid fluid) {
        if (!fluidColorMap.containsKey(fluid)) {
            FluidColors.load(fluid);
        }
        return fluidColorMap.get(fluid);
    }

    private static void load(Fluid fluid) {
        if (failedSet.contains(fluid)) {
            return;
        }
        try {
            ResourceLocation resourceLocation = new ResourceLocation(fluid.getStill().func_110624_b(), "textures/" + fluid.getStill().func_110623_a() + ".png");
            IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(resourceLocation);
            BufferedImage bufferedImage = TextureUtil.func_177053_a((InputStream)resource.func_110527_b());
            WritableRaster raster = bufferedImage.getRaster();
            float[] colorsOut = new float[3];
            float[] clr = new float[4];
            int size = Math.min(raster.getWidth(), raster.getHeight());
            for (int xp = 0; xp < size; ++xp) {
                for (int yp = 0; yp < size; ++yp) {
                    raster.getPixel(xp, yp, clr);
                    for (int i = 0; i < 3; ++i) {
                        int n = i;
                        colorsOut[n] = colorsOut[n] + clr[i];
                    }
                }
            }
            int i = 0;
            while (i < 3) {
                int n = i;
                colorsOut[n] = colorsOut[n] / (float)(size * size);
                int n2 = i++;
                colorsOut[n2] = colorsOut[n2] / 256.0f;
            }
            Aunis.logger.debug("Loaded fluid color for " + fluid);
            fluidColorMap.put(fluid, new FloatColors(colorsOut));
        }
        catch (IOException e) {
            Aunis.logger.error("Failed to get average fluid color for " + fluid);
            e.printStackTrace();
            failedSet.add(fluid);
        }
    }

    public static class FloatColors {
        public final float[] colors;

        public FloatColors(float[] colors) {
            this.colors = colors;
        }
    }
}

