/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.transportrings;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class TransportRings {
    private int address;
    private String name;
    private BlockPos pos;
    private double distance;
    private boolean isClone;

    public int getAddress() {
        return this.address;
    }

    public void setAddress(int address) {
        this.address = address;
    }

    public String getName() {
        if (this.name == null) {
            return "[empty]";
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public double getDistance() {
        return this.distance;
    }

    public TransportRings(BlockPos pos) {
        this(-1, null, pos, false);
    }

    public TransportRings(int address, String name) {
        this(address, name, new BlockPos(0, 0, 0), false);
    }

    public TransportRings(NBTTagCompound compound) {
        this.deserializeNBT(compound);
    }

    private TransportRings(int address, String name, BlockPos pos, boolean isClone) {
        this.address = address;
        this.name = name;
        this.pos = pos;
        this.isClone = isClone;
    }

    public TransportRings cloneWithNewDistance(BlockPos callerPos) {
        return new TransportRings(this.address, this.name, this.pos, true).setDistanceTo(callerPos);
    }

    public boolean isInGrid() {
        return this.address != -1;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    private TransportRings setDistanceTo(BlockPos pos) {
        this.distance = this.pos.func_185332_f(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return this;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.address != -1) {
            compound.func_74768_a("address", this.address);
        }
        if (this.name != null) {
            compound.func_74778_a("name", this.name);
        }
        compound.func_74772_a("pos", this.pos.func_177986_g());
        if (this.isClone) {
            compound.func_74780_a("distance", this.distance);
        }
        return compound;
    }

    public TransportRings deserializeNBT(NBTTagCompound compound) {
        this.address = compound.func_74764_b("address") ? compound.func_74762_e("address") : -1;
        if (compound.func_74764_b("name")) {
            this.name = compound.func_74779_i("name");
        }
        this.pos = BlockPos.func_177969_a((long)compound.func_74763_f("pos"));
        if (compound.func_74764_b("distance")) {
            this.isClone = true;
            this.distance = compound.func_74769_h("distance");
        }
        return this;
    }

    public String toString() {
        return "[pos=" + this.pos.toString() + ", address=" + this.address + ", name=" + this.name + "]";
    }
}

