/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.tileentity.util;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.items.IItemHandler;

public class ComparatorHelper {
    public static int getComparatorLevel(IItemHandler itemHandler, int startingIndex) {
        return ComparatorHelper.calcRedstoneFromInventory(itemHandler, startingIndex);
    }

    public static int getComparatorLevel(FluidTank fluidTank) {
        if (fluidTank.getFluidAmount() == 0) {
            return 0;
        }
        float percent = (float)fluidTank.getFluidAmount() / (float)fluidTank.getCapacity();
        return Math.round(1.0f + percent * 14.0f);
    }

    public static int getComparatorLevel(IEnergyStorage energyStorage) {
        if (energyStorage.getEnergyStored() == 0) {
            return 0;
        }
        float percent = (float)energyStorage.getEnergyStored() / (float)energyStorage.getMaxEnergyStored();
        return Math.round(1.0f + percent * 14.0f);
    }

    public static int calcRedstoneFromInventory(@Nullable IItemHandler inv, int startingIndex) {
        if (inv == null) {
            return 0;
        }
        int itemsFound = 0;
        float proportion = 0.0f;
        for (int j = startingIndex; j < inv.getSlots(); ++j) {
            ItemStack itemstack = inv.getStackInSlot(j);
            if (itemstack.func_190926_b()) continue;
            proportion += (float)itemstack.func_190916_E() / (float)Math.min(inv.getSlotLimit(j), itemstack.func_77976_d());
            ++itemsFound;
        }
        return MathHelper.func_76141_d((float)((proportion /= (float)inv.getSlots()) * 14.0f)) + (itemsFound > 0 ? 1 : 0);
    }
}

