/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.tileentity.transportrings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import mrjake.aunis.Aunis;
import mrjake.aunis.AunisProps;
import mrjake.aunis.block.AunisBlocks;
import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.gui.RingsGUI;
import mrjake.aunis.packet.AunisPacketHandler;
import mrjake.aunis.packet.StateUpdatePacketToClient;
import mrjake.aunis.packet.transportrings.StartPlayerFadeOutToClient;
import mrjake.aunis.renderer.transportrings.TransportRingsAbstractRenderer;
import mrjake.aunis.sound.AunisSoundHelper;
import mrjake.aunis.sound.SoundEventEnum;
import mrjake.aunis.stargate.EnumScheduledTask;
import mrjake.aunis.state.State;
import mrjake.aunis.state.StateProviderInterface;
import mrjake.aunis.state.StateTypeEnum;
import mrjake.aunis.state.transportrings.TransportRingsGuiState;
import mrjake.aunis.state.transportrings.TransportRingsRendererState;
import mrjake.aunis.state.transportrings.TransportRingsStartAnimationRequest;
import mrjake.aunis.tesr.RendererInterface;
import mrjake.aunis.tesr.RendererProviderInterface;
import mrjake.aunis.tileentity.transportrings.TRControllerAbstractTile;
import mrjake.aunis.tileentity.util.ScheduledTask;
import mrjake.aunis.tileentity.util.ScheduledTaskExecutorInterface;
import mrjake.aunis.transportrings.ParamsSetResult;
import mrjake.aunis.transportrings.TransportResult;
import mrjake.aunis.transportrings.TransportRings;
import mrjake.aunis.util.AunisAxisAlignedBB;
import mrjake.aunis.util.ILinkable;
import mrjake.aunis.util.LinkingHelper;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.Environment", modid="opencomputers"), @Optional.Interface(iface="li.cil.oc.api.network.WirelessEndpoint", modid="opencomputers")})
public abstract class TransportRingsAbstractTile
extends TileEntity
implements ITickable,
RendererProviderInterface,
StateProviderInterface,
ScheduledTaskExecutorInterface,
ILinkable,
Environment {
    public static final int FADE_OUT_TOTAL_TIME = 40;
    public static final int TIMEOUT_TELEPORT = 20;
    public static final int TIMEOUT_FADE_OUT = 63;
    public static final int RINGS_CLEAR_OUT = 48;
    protected static final AunisAxisAlignedBB LOCAL_TELEPORT_BOX = new AunisAxisAlignedBB(-1.0, 2.0, -1.0, 2.0, 4.5, 2.0);
    protected AunisAxisAlignedBB globalTeleportBox;
    protected List<Entity> teleportList = new ArrayList<Entity>();
    protected BlockPos lastPos = BlockPos.field_177992_a;
    List<ScheduledTask> scheduledTasks = new ArrayList<ScheduledTask>();
    protected BlockPos targetRingsPos = new BlockPos(0, 0, 0);
    protected List<Entity> excludedEntities = new ArrayList<Entity>();
    protected Object ocContext;
    protected boolean initiating;
    private boolean busy = false;
    private static final List<BlockPos> invisibleBlocksTemplate = Arrays.asList(new BlockPos(0, 2, 2), new BlockPos(1, 2, 2), new BlockPos(2, 2, 1));
    private BlockPos linkedController;
    private int linkId = -1;
    protected TransportRings rings;
    public Map<Integer, TransportRings> ringsMap = new HashMap<Integer, TransportRings>();
    @SideOnly(value=Side.CLIENT)
    private RingsGUI openGui;
    TransportRingsAbstractRenderer renderer;
    TransportRingsRendererState rendererState = new TransportRingsRendererState();
    private Node node = Aunis.ocWrapper.createNode(this, "transportrings");

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ScheduledTask.iterate(this.scheduledTasks, this.field_145850_b.func_82737_E());
            if (!this.lastPos.equals((Object)this.field_174879_c)) {
                this.lastPos = this.field_174879_c;
                this.getRings().setPos(this.field_174879_c);
                this.setRingsParams(this.getRings().getAddress(), this.getRings().getName());
                this.updateLinkStatus();
                this.func_70296_d();
            }
        }
    }

    public void onLoad() {
        Aunis.ocWrapper.joinOrCreateNetwork(this);
    }

    @Override
    public void addTask(ScheduledTask scheduledTask) {
        scheduledTask.setExecutor(this);
        scheduledTask.setTaskCreated(this.field_145850_b.func_82737_E());
        this.scheduledTasks.add(scheduledTask);
        this.func_70296_d();
    }

    @Override
    public void executeTask(EnumScheduledTask scheduledTask, NBTTagCompound customData) {
        switch (scheduledTask) {
            case RINGS_START_ANIMATION: {
                this.animationStart();
                this.setBarrierBlocks(true, true);
                this.addTask(new ScheduledTask(EnumScheduledTask.RINGS_FADE_OUT));
                this.addTask(new ScheduledTask(EnumScheduledTask.RINGS_SOLID_BLOCKS, 35));
                break;
            }
            case RINGS_SOLID_BLOCKS: {
                this.setBarrierBlocks(true, false);
                break;
            }
            case RINGS_FADE_OUT: {
                this.teleportList = this.field_145850_b.func_72872_a(Entity.class, (AxisAlignedBB)this.globalTeleportBox);
                for (Entity entity : this.teleportList) {
                    if (!(entity instanceof EntityPlayerMP)) continue;
                    AunisPacketHandler.INSTANCE.sendTo((IMessage)new StartPlayerFadeOutToClient(), (EntityPlayerMP)entity);
                }
                this.addTask(new ScheduledTask(EnumScheduledTask.RINGS_TELEPORT));
                break;
            }
            case RINGS_TELEPORT: {
                BlockPos teleportVector = this.targetRingsPos.func_177973_b((Vec3i)this.field_174879_c);
                for (Entity entity : this.teleportList) {
                    if (this.excludedEntities.contains(entity)) continue;
                    BlockPos ePos = entity.func_180425_c().func_177971_a((Vec3i)teleportVector);
                    entity.func_70634_a((double)ePos.func_177958_n(), (double)ePos.func_177956_o(), (double)ePos.func_177952_p());
                }
                this.teleportList.clear();
                this.excludedEntities.clear();
                this.addTask(new ScheduledTask(EnumScheduledTask.RINGS_CLEAR_OUT));
                break;
            }
            case RINGS_CLEAR_OUT: {
                this.setBarrierBlocks(false, false);
                this.setBusy(false);
                TransportRingsAbstractTile targetRingsTile = (TransportRingsAbstractTile)this.field_145850_b.func_175625_s(this.targetRingsPos);
                if (targetRingsTile != null) {
                    targetRingsTile.setBusy(false);
                }
                this.sendSignal(this.ocContext, "transportrings_teleport_finished", this.initiating);
                break;
            }
            default: {
                throw new UnsupportedOperationException("EnumScheduledTask." + scheduledTask.name() + " not implemented on " + this.getClass().getName());
            }
        }
    }

    public boolean isBusy() {
        return this.busy;
    }

    public void setBusy(boolean busy) {
        this.busy = busy;
    }

    public List<Entity> startAnimationAndTeleport(BlockPos targetRingsPos, List<Entity> excludedEntities, int waitTime, boolean initiating) {
        this.targetRingsPos = targetRingsPos;
        this.excludedEntities = excludedEntities;
        this.addTask(new ScheduledTask(EnumScheduledTask.RINGS_START_ANIMATION, waitTime));
        this.sendSignal(this.ocContext, "transportrings_teleport_start", initiating);
        this.initiating = initiating;
        return this.field_145850_b.func_72872_a(Entity.class, (AxisAlignedBB)this.globalTeleportBox);
    }

    public void animationStart() {
        this.rendererState.animationStart = this.field_145850_b.func_82737_E();
        this.rendererState.ringsUprising = true;
        this.rendererState.isAnimationActive = true;
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 512.0);
        AunisPacketHandler.INSTANCE.sendToAllTracking((IMessage)new StateUpdatePacketToClient(this.field_174879_c, StateTypeEnum.RINGS_START_ANIMATION, new TransportRingsStartAnimationRequest(this.rendererState.animationStart)), point);
    }

    public TransportResult attemptTransportTo(int address, int waitTime) {
        if (this.checkIfObstructed()) {
            return TransportResult.OBSTRUCTED;
        }
        if (this.isBusy()) {
            return TransportResult.BUSY;
        }
        TransportRings rings = this.ringsMap.get(address);
        if (rings != null) {
            BlockPos targetRingsPos = rings.getPos();
            TransportRingsAbstractTile targetRingsTile = (TransportRingsAbstractTile)this.field_145850_b.func_175625_s(targetRingsPos);
            if (targetRingsTile.checkIfObstructed()) {
                return TransportResult.OBSTRUCTED_TARGET;
            }
            if (targetRingsTile.isBusy()) {
                return TransportResult.BUSY_TARGET;
            }
            this.setBusy(true);
            targetRingsTile.setBusy(true);
            List excludedFromReceivingSite = this.field_145850_b.func_72872_a(Entity.class, (AxisAlignedBB)this.globalTeleportBox);
            List<Entity> excludedEntities = targetRingsTile.startAnimationAndTeleport(this.field_174879_c, excludedFromReceivingSite, waitTime, false);
            this.startAnimationAndTeleport(targetRingsPos, excludedEntities, waitTime, true);
            return TransportResult.OK;
        }
        return TransportResult.NO_SUCH_ADDRESS;
    }

    private boolean checkIfObstructed() {
        if (AunisConfig.ringsConfig.ignoreObstructionCheck) {
            return false;
        }
        for (int y = 0; y < 3; ++y) {
            for (Rotation rotation : Rotation.values()) {
                for (BlockPos invPos : invisibleBlocksTemplate) {
                    BlockPos newPos = new BlockPos((Vec3i)this.field_174879_c).func_177971_a((Vec3i)invPos.func_190942_a(rotation)).func_177982_a(0, y, 0);
                    IBlockState newState = this.field_145850_b.func_180495_p(newPos);
                    Block newBlock = newState.func_177230_c();
                    if (newBlock.isAir(newState, (IBlockAccess)this.field_145850_b, newPos) || newBlock.func_176200_f((IBlockAccess)this.field_145850_b, newPos)) continue;
                    Aunis.logger.info("TransportRings: " + newPos + " obstructed with " + this.field_145850_b.func_180495_p(newPos));
                    return true;
                }
            }
        }
        return false;
    }

    protected void setBarrierBlocks(boolean set, boolean passable) {
        IBlockState invBlockState = AunisBlocks.INVISIBLE_BLOCK.func_176223_P();
        if (passable) {
            invBlockState = invBlockState.func_177226_a((IProperty)AunisProps.HAS_COLLISIONS, (Comparable)Boolean.valueOf(false));
        }
        for (int y = 1; y < 3; ++y) {
            for (Rotation rotation : Rotation.values()) {
                for (BlockPos invPos : invisibleBlocksTemplate) {
                    BlockPos newPos = this.field_174879_c.func_177971_a((Vec3i)invPos.func_190942_a(rotation)).func_177982_a(0, y, 0);
                    if (set) {
                        this.field_145850_b.func_180501_a(newPos, invBlockState, 3);
                        continue;
                    }
                    if (this.field_145850_b.func_180495_p(newPos).func_177230_c() != AunisBlocks.INVISIBLE_BLOCK) continue;
                    this.field_145850_b.func_175698_g(newPos);
                }
            }
        }
    }

    public void setLinkedController(BlockPos pos, int linkId) {
        this.linkedController = pos;
        this.linkId = linkId;
        this.func_70296_d();
    }

    public BlockPos getLinkedController() {
        return this.linkedController;
    }

    public boolean isLinked() {
        return this.linkedController != null && this.field_145850_b.func_175625_s(this.linkedController) instanceof TRControllerAbstractTile;
    }

    public TRControllerAbstractTile getLinkedControllerTile(World world) {
        return this.linkedController != null ? (TRControllerAbstractTile)world.func_175625_s(this.linkedController) : null;
    }

    @Override
    public boolean canLinkTo() {
        return !this.isLinked();
    }

    @Override
    public int getLinkId() {
        return this.linkId;
    }

    protected TransportRings getRings() {
        if (this.rings == null) {
            this.rings = new TransportRings(this.field_174879_c);
        }
        return this.rings;
    }

    public TransportRings getClonedRings(BlockPos callerPos) {
        return this.getRings().cloneWithNewDistance(callerPos);
    }

    public void addRings(TransportRingsAbstractTile caller) {
        TransportRings clonedRings = caller.getClonedRings(this.field_174879_c);
        if (clonedRings.isInGrid()) {
            this.ringsMap.put(clonedRings.getAddress(), clonedRings);
            this.func_70296_d();
        }
    }

    public void removeRingsFromMap(int address) {
        if (this.ringsMap.remove(address) != null) {
            this.func_70296_d();
        }
    }

    public void removeRings(int address) {
        TileEntity tile;
        TransportRings rings = this.ringsMap.get(address);
        if (rings != null && (tile = this.field_145850_b.func_175625_s(rings.getPos())) instanceof TransportRingsAbstractTile) {
            ((TransportRingsAbstractTile)tile).removeRingsFromMap(this.getRings().getAddress());
        }
        this.removeRingsFromMap(address);
    }

    public void removeAllRings() {
        for (int address : new ArrayList<Integer>(this.ringsMap.keySet())) {
            this.removeRings(address);
        }
    }

    public ParamsSetResult setRingsParams(int address, String name) {
        int x = this.field_174879_c.func_177958_n();
        int z = this.field_174879_c.func_177952_p();
        int radius = AunisConfig.ringsConfig.rangeFlat;
        int y = this.field_174879_c.func_177956_o();
        int vertical = AunisConfig.ringsConfig.rangeVertical;
        ArrayList<TransportRingsAbstractTile> ringsTilesInRange = new ArrayList<TransportRingsAbstractTile>();
        for (BlockPos newRingsPos : BlockPos.func_177975_b((BlockPos)new BlockPos(x - radius, y - vertical, z - radius), (BlockPos)new BlockPos(x + radius, y + vertical, z + radius))) {
            if (this.field_145850_b.func_180495_p(newRingsPos).func_177230_c() != AunisBlocks.TRANSPORT_RINGS_BLOCK || this.field_174879_c.equals((Object)newRingsPos)) continue;
            TransportRingsAbstractTile newRingsTile = (TransportRingsAbstractTile)this.field_145850_b.func_175625_s(newRingsPos);
            ringsTilesInRange.add(newRingsTile);
            int newRingsAddress = newRingsTile.getClonedRings(this.field_174879_c).getAddress();
            if (newRingsAddress == -1 || newRingsAddress != address && !newRingsTile.ringsMap.containsKey(address)) continue;
            return ParamsSetResult.DUPLICATE_ADDRESS;
        }
        this.removeAllRings();
        this.getRings().setAddress(address);
        this.getRings().setName(name);
        for (TransportRingsAbstractTile newRingsTile : ringsTilesInRange) {
            this.addRings(newRingsTile);
            newRingsTile.addRings(this);
        }
        this.func_70296_d();
        return ParamsSetResult.OK;
    }

    protected void func_190201_b(World worldIn) {
        this.func_145834_a(worldIn);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        int j;
        compound.func_74782_a("rendererState", (NBTBase)this.rendererState.serializeNBT());
        compound.func_74782_a("ringsData", (NBTBase)this.getRings().serializeNBT());
        if (this.linkedController != null) {
            compound.func_74772_a("linkedController", this.linkedController.func_177986_g());
            compound.func_74768_a("linkId", this.linkId);
        }
        compound.func_74768_a("ringsMapLength", this.ringsMap.size());
        int i = 0;
        for (TransportRings rings : this.ringsMap.values()) {
            compound.func_74782_a("ringsMap" + i, (NBTBase)rings.serializeNBT());
            ++i;
        }
        compound.func_74782_a("scheduledTasks", (NBTBase)ScheduledTask.serializeList(this.scheduledTasks));
        compound.func_74768_a("teleportListSize", this.teleportList.size());
        for (j = 0; j < this.teleportList.size(); ++j) {
            compound.func_74768_a("teleportList" + j, this.teleportList.get(j).func_145782_y());
        }
        compound.func_74768_a("excludedSize", this.excludedEntities.size());
        for (j = 0; j < this.excludedEntities.size(); ++j) {
            compound.func_74768_a("excluded" + j, this.excludedEntities.get(j).func_145782_y());
        }
        compound.func_74772_a("targetRingsPos", this.targetRingsPos.func_177986_g());
        compound.func_74757_a("busy", this.isBusy());
        if (this.node != null) {
            NBTTagCompound nodeCompound = new NBTTagCompound();
            this.node.save(nodeCompound);
            compound.func_74782_a("node", (NBTBase)nodeCompound);
        }
        compound.func_74757_a("initiating", this.initiating);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        try {
            int j;
            this.rendererState.deserializeNBT(compound.func_74775_l("rendererState"));
            ScheduledTask.deserializeList(compound.func_74775_l("scheduledTasks"), this.scheduledTasks, this);
            this.teleportList = new ArrayList<Entity>();
            int size = compound.func_74762_e("teleportListSize");
            for (j = 0; j < size; ++j) {
                this.teleportList.add(this.field_145850_b.func_73045_a(compound.func_74762_e("teleportList" + j)));
            }
            this.excludedEntities = new ArrayList<Entity>();
            size = compound.func_74762_e("excludedSize");
            for (j = 0; j < size; ++j) {
                this.excludedEntities.add(this.field_145850_b.func_73045_a(compound.func_74762_e("excluded" + j)));
            }
            this.targetRingsPos = BlockPos.func_177969_a((long)compound.func_74763_f("targetRingsPos"));
        }
        catch (ClassCastException | IndexOutOfBoundsException | NullPointerException e) {
            Aunis.logger.warn("Exception at reading NBT");
            Aunis.logger.warn("If loading world used with previous version and nothing game-breaking doesn't happen, please ignore it");
            e.printStackTrace();
        }
        if (compound.func_74764_b("ringsData")) {
            this.getRings().deserializeNBT(compound.func_74775_l("ringsData"));
        }
        if (compound.func_74764_b("linkedController")) {
            this.linkedController = BlockPos.func_177969_a((long)compound.func_74763_f("linkedController"));
            this.linkId = compound.func_74762_e("linkId");
        }
        if (compound.func_74764_b("ringsMapLength")) {
            int len = compound.func_74762_e("ringsMapLength");
            this.ringsMap.clear();
            for (int i = 0; i < len; ++i) {
                TransportRings rings = new TransportRings(compound.func_74775_l("ringsMap" + i));
                this.ringsMap.put(rings.getAddress(), rings);
            }
        }
        if (this.node != null && compound.func_74764_b("node")) {
            this.node.load(compound.func_74775_l("node"));
        }
        this.setBusy(compound.func_74767_n("busy"));
        this.initiating = compound.func_74767_n("initiating");
        super.func_145839_a(compound);
    }

    @Override
    public State getState(StateTypeEnum stateType) {
        switch (stateType) {
            case RENDERER_STATE: {
                return this.rendererState;
            }
            case GUI_STATE: {
                return new TransportRingsGuiState(this.getRings(), this.ringsMap.values());
            }
        }
        return null;
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        switch (stateType) {
            case RENDERER_STATE: {
                return new TransportRingsRendererState();
            }
            case RINGS_START_ANIMATION: {
                return new TransportRingsStartAnimationRequest();
            }
            case GUI_STATE: {
                return new TransportRingsGuiState();
            }
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setState(StateTypeEnum stateType, State state) {
        switch (stateType) {
            case RENDERER_STATE: {
                this.renderer.setState((TransportRingsRendererState)state);
                break;
            }
            case RINGS_START_ANIMATION: {
                AunisSoundHelper.playSoundEventClientSide(this.field_145850_b, this.field_174879_c.func_177981_b(3), SoundEventEnum.RINGS_TRANSPORT);
                this.renderer.animationStart(((TransportRingsStartAnimationRequest)state).animationStart);
                break;
            }
            case GUI_STATE: {
                if (this.openGui == null || !this.openGui.isOpen) {
                    this.openGui = new RingsGUI(this.field_174879_c, (TransportRingsGuiState)state);
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)this.openGui);
                    break;
                }
                this.openGui.state = (TransportRingsGuiState)state;
                break;
            }
        }
    }

    public void updateLinkStatus() {
        int linkId;
        BlockPos closestController = LinkingHelper.findClosestUnlinked(this.field_145850_b, this.field_174879_c, new BlockPos(10, 5, 10), AunisBlocks.TR_CONTROLLER_BLOCK, this.linkId);
        int n = linkId = closestController == null ? -1 : LinkingHelper.getLinkId();
        if (closestController != null) {
            TRControllerAbstractTile controllerTile = (TRControllerAbstractTile)this.field_145850_b.func_175625_s(closestController);
            controllerTile.setLinkedRings(this.field_174879_c, linkId);
        }
        this.setLinkedController(closestController, linkId);
    }

    @Override
    public RendererInterface getRenderer() {
        return this.renderer;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-4, 0, -4), this.field_174879_c.func_177982_a(4, 7, 4));
    }

    public void onChunkUnload() {
        if (this.node != null) {
            this.node.remove();
        }
    }

    public void func_145843_s() {
        if (this.node != null) {
            this.node.remove();
        }
        super.func_145843_s();
    }

    @Optional.Method(modid="opencomputers")
    public Node node() {
        return this.node;
    }

    @Optional.Method(modid="opencomputers")
    public void onConnect(Node node) {
    }

    @Optional.Method(modid="opencomputers")
    public void onDisconnect(Node node) {
    }

    @Optional.Method(modid="opencomputers")
    public void onMessage(Message message) {
    }

    public void sendSignal(Object context, String name, Object ... params) {
        Aunis.ocWrapper.sendSignalToReachable(this.node, (Context)context, name, params);
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] isInGrid(Context context, Arguments args) {
        return new Object[]{this.rings.isInGrid()};
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] getAddress(Context context, Arguments args) {
        if (!this.rings.isInGrid()) {
            return new Object[]{"NOT_IN_GRID", "Use setAddressAndName"};
        }
        return new Object[]{this.rings.getAddress()};
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] getName(Context context, Arguments args) {
        if (!this.rings.isInGrid()) {
            return new Object[]{"NOT_IN_GRID", "Use setAddressAndName"};
        }
        return new Object[]{this.rings.getName()};
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] setAddress(Context context, Arguments args) {
        if (!this.rings.isInGrid()) {
            return new Object[]{"NOT_IN_GRID", "Use setAddressAndName"};
        }
        int address = args.checkInteger(0);
        if (address < 1 || address > 6) {
            throw new IllegalArgumentException("bad argument #1 (address out of range, allowed <1..6>)");
        }
        return new Object[]{this.setRingsParams(address, this.rings.getName())};
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] setName(Context context, Arguments args) {
        if (!this.rings.isInGrid()) {
            return new Object[]{"NOT_IN_GRID", "Use setAddressAndName"};
        }
        String name = args.checkString(0);
        this.setRingsParams(this.rings.getAddress(), name);
        return new Object[0];
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] setAddressAndName(Context context, Arguments args) {
        int address = args.checkInteger(0);
        String name = args.checkString(1);
        if (address < 1 || address > 6) {
            throw new IllegalArgumentException("bad argument #1 (address out of range, allowed <1..6>)");
        }
        return new Object[]{this.setRingsParams(address, name)};
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] getAvailableRings(Context context, Arguments args) {
        if (!this.rings.isInGrid()) {
            return new Object[]{"NOT_IN_GRID", "Use setAddressAndName"};
        }
        HashMap<Integer, String> values = new HashMap<Integer, String>(this.ringsMap.size());
        for (Map.Entry<Integer, TransportRings> rings : this.ringsMap.entrySet()) {
            values.put(rings.getKey(), rings.getValue().getName());
        }
        return new Object[]{values};
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] getAvailableRingsAddresses(Context context, Arguments args) {
        if (!this.rings.isInGrid()) {
            return new Object[]{"NOT_IN_GRID", "Use setAddressAndName"};
        }
        return new Object[]{this.ringsMap.keySet()};
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] attemptTransportTo(Context context, Arguments args) {
        if (!this.rings.isInGrid()) {
            return new Object[]{"NOT_IN_GRID", "Use setAddressAndName"};
        }
        int address = args.checkInteger(0);
        if (address < 1 || address > 6) {
            throw new IllegalArgumentException("bad argument #1 (address out of range, allowed <1..6>)");
        }
        this.ocContext = context;
        return new Object[]{this.attemptTransportTo(address, 0)};
    }
}

