/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.tileentity.transportrings;

import java.util.EnumSet;
import mrjake.aunis.block.AunisBlocks;
import mrjake.aunis.renderer.biomes.BiomeOverlayEnum;
import mrjake.aunis.renderer.transportrings.TRControllerAbstractRenderer;
import mrjake.aunis.tesr.RendererInterface;
import mrjake.aunis.tesr.RendererProviderInterface;
import mrjake.aunis.tileentity.transportrings.TransportRingsAbstractTile;
import mrjake.aunis.util.ILinkable;
import mrjake.aunis.util.LinkingHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class TRControllerAbstractTile
extends TileEntity
implements ITickable,
ILinkable,
RendererProviderInterface {
    private BiomeOverlayEnum biomeOverlay = BiomeOverlayEnum.NORMAL;
    private BlockPos lastPos = BlockPos.field_177992_a;
    public static final EnumSet<BiomeOverlayEnum> SUPPORTED_OVERLAYS = EnumSet.of(BiomeOverlayEnum.NORMAL, BiomeOverlayEnum.FROST, BiomeOverlayEnum.MOSSY);
    private BlockPos linkedRings;
    private int linkId = -1;
    private TRControllerAbstractRenderer renderer;

    public BiomeOverlayEnum getBiomeOverlay() {
        return this.biomeOverlay;
    }

    public void setBiomeOverlay(BiomeOverlayEnum biomeOverlay) {
        this.biomeOverlay = biomeOverlay;
    }

    public void onLoad() {
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 40L == 0L) {
                this.biomeOverlay = BiomeOverlayEnum.updateBiomeOverlay(this.field_145850_b, this.field_174879_c, SUPPORTED_OVERLAYS);
            }
            if (!this.lastPos.equals((Object)this.field_174879_c)) {
                this.lastPos = this.field_174879_c;
                this.updateLinkStatus();
                this.func_70296_d();
            }
        }
    }

    public void setLinkedRings(BlockPos pos, int linkId) {
        this.linkedRings = pos;
        this.linkId = linkId;
        this.func_70296_d();
    }

    public BlockPos getLinkedRings() {
        return this.linkedRings;
    }

    public boolean isLinked() {
        return this.linkedRings != null;
    }

    public TransportRingsAbstractTile getLinkedRingsTile(World world) {
        return this.linkedRings != null ? (TransportRingsAbstractTile)world.func_175625_s(this.linkedRings) : null;
    }

    @Override
    public boolean canLinkTo() {
        return !this.isLinked();
    }

    @Override
    public int getLinkId() {
        return this.linkId;
    }

    public void updateLinkStatus() {
        int linkId;
        BlockPos closestRings = LinkingHelper.findClosestUnlinked(this.field_145850_b, this.field_174879_c, new BlockPos(10, 5, 10), AunisBlocks.TRANSPORT_RINGS_BLOCK, this.linkId);
        int n = linkId = closestRings == null ? -1 : LinkingHelper.getLinkId();
        if (closestRings != null) {
            TransportRingsAbstractTile ringsTile = (TransportRingsAbstractTile)this.field_145850_b.func_175625_s(closestRings);
            ringsTile.setLinkedController(this.field_174879_c, linkId);
        }
        this.setLinkedRings(closestRings, linkId);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (this.linkedRings != null) {
            compound.func_74772_a("linkedRings", this.linkedRings.func_177986_g());
            compound.func_74768_a("linkId", this.linkId);
        }
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        if (compound.func_74764_b("linkedRings")) {
            this.linkedRings = BlockPos.func_177969_a((long)compound.func_74763_f("linkedRings"));
            this.linkId = compound.func_74762_e("linkId");
        }
        super.func_145839_a(compound);
    }

    @Override
    public RendererInterface getRenderer() {
        return this.renderer;
    }

    public void setRenderer(TRControllerAbstractRenderer renderer) {
        this.renderer = renderer;
    }
}

