/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.tileentity.stargate;

import java.util.EnumSet;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.config.StargateSizeEnum;
import mrjake.aunis.packet.AunisPacketHandler;
import mrjake.aunis.packet.StateUpdatePacketToClient;
import mrjake.aunis.renderer.biomes.BiomeOverlayEnum;
import mrjake.aunis.renderer.stargate.StargateClassicRendererState;
import mrjake.aunis.renderer.stargate.StargateUniverseRendererState;
import mrjake.aunis.sound.AunisSoundHelper;
import mrjake.aunis.sound.SoundEventEnum;
import mrjake.aunis.sound.SoundPositionedEnum;
import mrjake.aunis.sound.StargateSoundEventEnum;
import mrjake.aunis.sound.StargateSoundPositionedEnum;
import mrjake.aunis.stargate.EnumIrisMode;
import mrjake.aunis.stargate.EnumScheduledTask;
import mrjake.aunis.stargate.EnumStargateState;
import mrjake.aunis.stargate.StargateClassicSpinHelper;
import mrjake.aunis.stargate.StargateOpenResult;
import mrjake.aunis.stargate.merging.StargateAbstractMergeHelper;
import mrjake.aunis.stargate.merging.StargateUniverseMergeHelper;
import mrjake.aunis.stargate.network.StargateAddress;
import mrjake.aunis.stargate.network.StargateAddressDynamic;
import mrjake.aunis.stargate.network.StargatePos;
import mrjake.aunis.stargate.network.SymbolInterface;
import mrjake.aunis.stargate.network.SymbolTypeEnum;
import mrjake.aunis.stargate.network.SymbolUniverseEnum;
import mrjake.aunis.stargate.power.StargateEnergyRequired;
import mrjake.aunis.state.State;
import mrjake.aunis.state.StateTypeEnum;
import mrjake.aunis.state.stargate.StargateRendererActionState;
import mrjake.aunis.state.stargate.StargateUniverseSymbolState;
import mrjake.aunis.tileentity.stargate.StargateClassicBaseTile;
import mrjake.aunis.tileentity.util.ScheduledTask;
import mrjake.aunis.util.AunisAxisAlignedBB;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class StargateUniverseBaseTile
extends StargateClassicBaseTile {
    private long actionsCooldown = 0L;
    public StargateAddress addressToDial;
    private int addressPosition;
    private int maxSymbols;
    private boolean abortDialing;
    private boolean dialingNearby = false;
    public static final EnumSet<BiomeOverlayEnum> SUPPORTED_OVERLAYS = EnumSet.of(BiomeOverlayEnum.NORMAL, BiomeOverlayEnum.FROST, BiomeOverlayEnum.MOSSY, BiomeOverlayEnum.AGED);

    @Override
    public void setLinkedDHD(BlockPos dhdPos, int linkId) {
    }

    public void setUpCooldown() {
        this.actionsCooldown = 60L;
    }

    @Override
    public void func_73660_a() {
        if (this.actionsCooldown > 0L) {
            --this.actionsCooldown;
        }
        super.func_73660_a();
    }

    @Override
    public StargateSizeEnum getStargateSize() {
        return StargateSizeEnum.SMALL;
    }

    public void dial(StargateAddress stargateAddress, int glyphsToDial, boolean nearby) {
        if (this.actionsCooldown > 1L) {
            return;
        }
        this.setUpCooldown();
        this.addressToDial = stargateAddress;
        this.addressPosition = 0;
        this.maxSymbols = glyphsToDial;
        this.abortDialing = false;
        this.dialingNearby = nearby;
        this.stargateState = EnumStargateState.DIALING;
        AunisSoundHelper.playSoundEvent(this.field_145850_b, this.getGateCenterPos(), SoundEventEnum.GATE_UNIVERSE_DIAL_START);
        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_DIAL_NEXT, 35));
        this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.LIGHT_UP_CHEVRONS, 9, true);
        this.updateChevronLight(9, true);
        this.func_70296_d();
    }

    public void abort(boolean force) {
        if (this.actionsCooldown > 1L && !force) {
            return;
        }
        this.setUpCooldown();
        this.abortDialing = true;
        this.func_70296_d();
    }

    public void abort() {
        this.abort(true);
    }

    @Override
    public void failGate() {
        super.failGate();
        if (this.targetRingSymbol != SymbolUniverseEnum.TOP_CHEVRON) {
            this.addSymbolToAddressManual(SymbolUniverseEnum.TOP_CHEVRON, null);
        }
    }

    @Override
    protected void disconnectGate() {
        super.disconnectGate();
        this.addSymbolToAddressManual(SymbolUniverseEnum.TOP_CHEVRON, null);
    }

    @Override
    public void addSymbolToAddressManual(SymbolInterface targetSymbol, Object context) {
        this.stargateState = context != null ? EnumStargateState.DIALING_COMPUTER : EnumStargateState.DIALING;
        if (this.stargateState.dialingComputer() && this.dialedAddress.size() == 0 && !targetSymbol.equals(SymbolUniverseEnum.G37)) {
            AunisSoundHelper.playSoundEvent(this.field_145850_b, this.getGateCenterPos(), SoundEventEnum.GATE_UNIVERSE_DIAL_START);
            this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.LIGHT_UP_CHEVRONS, 9, true);
            NBTTagCompound taskData = new NBTTagCompound();
            taskData.func_74768_a("symbolToDial", targetSymbol.getId());
            this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_DIAL_NEXT, 35, taskData));
            this.ringSpinContext = context;
        } else {
            super.addSymbolToAddressManual(targetSymbol, context);
        }
    }

    @Override
    public void incomingWormhole(int dialedAddressSize) {
        this.prepareGateToConnect(dialedAddressSize, 10);
        super.incomingWormhole(9);
    }

    @Override
    public void incomingWormhole(int dialedAddressSize, int time) {
        this.prepareGateToConnect(dialedAddressSize, time);
        super.incomingWormhole(9, false);
    }

    public void prepareGateToConnect(final int dialedAddressSize, int time) {
        int period = (time *= dialedAddressSize) - 2000;
        if (period < 0) {
            period = 0;
        }
        this.stargateState = EnumStargateState.INCOMING;
        this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CLEAR_CHEVRONS, 9, true);
        int[] i = new int[]{1};
        final Timer timer = new Timer();
        if (time / 1000 * 20 + 40 >= StargateClassicSpinHelper.getAnimationDuration(360.0f)) {
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (StargateUniverseBaseTile.this.irisMode == EnumIrisMode.AUTO && StargateUniverseBaseTile.this.isOpened() && StargateUniverseBaseTile.this.isIncoming) {
                        StargateUniverseBaseTile.this.toggleIris();
                        StargateUniverseBaseTile.this.isIncoming = false;
                    }
                    if (!StargateUniverseBaseTile.this.isIncoming) {
                        StargateUniverseBaseTile.this.stargateState = EnumStargateState.IDLE;
                        StargateUniverseBaseTile.this.func_70296_d();
                    }
                    timer.cancel();
                }
            }, period, 100L);
            this.addSymbolToAddressManual(SymbolUniverseEnum.G37, null);
            this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.LIGHT_UP_CHEVRONS, 9, true);
            this.sendSignal(null, "stargate_incoming_wormhole", dialedAddressSize);
            this.playSoundEvent(StargateSoundEventEnum.INCOMING);
        } else {
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (StargateUniverseBaseTile.this.isIncoming) {
                        if (StargateUniverseBaseTile.this.irisMode == EnumIrisMode.AUTO && StargateUniverseBaseTile.this.isOpened()) {
                            StargateUniverseBaseTile.this.toggleIris();
                        }
                        StargateUniverseBaseTile.this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.LIGHT_UP_CHEVRONS, 9, true);
                        StargateUniverseBaseTile.this.sendSignal(null, "stargate_incoming_wormhole", dialedAddressSize);
                        StargateUniverseBaseTile.this.playSoundEvent(StargateSoundEventEnum.INCOMING);
                    }
                    StargateUniverseBaseTile.this.isIncoming = false;
                    StargateUniverseBaseTile.this.func_70296_d();
                    timer.cancel();
                }
            }, period, 100L);
        }
    }

    @Override
    protected boolean onGateMergeRequested() {
        return StargateUniverseMergeHelper.INSTANCE.checkBlocks((IBlockAccess)this.field_145850_b, this.field_174879_c, this.facing);
    }

    @Override
    protected void addFailedTaskAndPlaySound() {
        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_FAIL, 20));
        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_FAILED_SOUND, 20));
    }

    @Override
    protected int getMaxChevrons() {
        return 9;
    }

    @Override
    protected int getOpenSoundDelay() {
        return super.getOpenSoundDelay() + 10;
    }

    @Override
    public EnumSet<BiomeOverlayEnum> getSupportedOverlays() {
        return SUPPORTED_OVERLAYS;
    }

    @Override
    public void executeTask(EnumScheduledTask scheduledTask, NBTTagCompound customData) {
        switch (scheduledTask) {
            case STARGATE_DIAL_NEXT: {
                if (customData != null && customData.func_74764_b("symbolToDial")) {
                    super.addSymbolToAddressManual(this.getSymbolType().valueOfSymbol(customData.func_74762_e("symbolToDial")), this.ringSpinContext);
                } else {
                    this.addSymbolToAddressManual(this.addressPosition >= this.maxSymbols ? this.getSymbolType().getOrigin() : this.addressToDial.get(this.addressPosition), null);
                }
                ++this.addressPosition;
                break;
            }
            case STARGATE_SPIN_FINISHED: {
                if (this.targetRingSymbol != SymbolUniverseEnum.TOP_CHEVRON) {
                    if (this.canAddSymbol(this.targetRingSymbol) && !this.abortDialing) {
                        this.addSymbolToAddress(this.targetRingSymbol);
                        this.activateSymbolServer(this.targetRingSymbol);
                        if (this.stargateState.dialingComputer()) {
                            this.stargateState = EnumStargateState.IDLE;
                            this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_DIAL_FINISHED, 10));
                        } else if (!this.stargateWillLock(this.targetRingSymbol)) {
                            this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_DIAL_NEXT, 14));
                        } else {
                            this.attemptOpenAndFail();
                        }
                    } else {
                        this.dialingFailed(this.abortDialing ? StargateOpenResult.ABORTED : StargateOpenResult.ADDRESS_MALFORMED);
                        this.stargateState = EnumStargateState.IDLE;
                        this.abortDialing = false;
                    }
                } else if (this.abortDialing) {
                    this.dialingFailed(StargateOpenResult.ABORTED);
                    this.stargateState = EnumStargateState.IDLE;
                    this.abortDialing = false;
                } else {
                    this.stargateState = EnumStargateState.IDLE;
                }
                this.func_70296_d();
                break;
            }
            case STARGATE_FAILED_SOUND: {
                this.playSoundEvent(StargateSoundEventEnum.DIAL_FAILED);
                break;
            }
            case STARGATE_DIAL_FINISHED: {
                this.sendSignal(this.ringSpinContext, "stargate_spin_chevron_engaged", this.dialedAddress.size(), this.stargateWillLock(this.targetRingSymbol), this.targetRingSymbol.getEnglishName());
                break;
            }
        }
        super.executeTask(scheduledTask, customData);
    }

    private void activateSymbolServer(SymbolInterface symbol) {
        AunisPacketHandler.INSTANCE.sendToAllTracking((IMessage)new StateUpdatePacketToClient(this.field_174879_c, StateTypeEnum.STARGATE_UNIVERSE_ACTIVATE_SYMBOL, new StargateUniverseSymbolState((SymbolUniverseEnum)symbol, false)), this.targetPoint);
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        switch (stateType) {
            case STARGATE_UNIVERSE_ACTIVATE_SYMBOL: {
                return new StargateUniverseSymbolState();
            }
        }
        return super.createState(stateType);
    }

    @Override
    public void setState(StateTypeEnum stateType, State state) {
        block0 : switch (stateType) {
            case STARGATE_UNIVERSE_ACTIVATE_SYMBOL: {
                StargateUniverseSymbolState symbolState = (StargateUniverseSymbolState)state;
                if (symbolState.dimAll) {
                    this.getRendererStateClient().clearSymbols(this.field_145850_b.func_82737_E());
                    break;
                }
                this.getRendererStateClient().activateSymbol(this.field_145850_b.func_82737_E(), symbolState.symbol);
                break;
            }
            case RENDERER_UPDATE: {
                StargateRendererActionState gateActionState = (StargateRendererActionState)state;
                switch (gateActionState.action) {
                    case CLEAR_CHEVRONS: {
                        this.getRendererStateClient().clearSymbols(this.field_145850_b.func_82737_E());
                        break block0;
                    }
                }
                break;
            }
        }
        super.setState(stateType, state);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("addressPosition", this.addressPosition);
        if (this.addressToDial != null) {
            compound.func_74782_a("addressToDial", (NBTBase)this.addressToDial.serializeNBT());
        }
        compound.func_74768_a("maxSymbols", this.maxSymbols);
        compound.func_74757_a("abortDialing", this.abortDialing);
        compound.func_74757_a("dialingNearby", this.dialingNearby);
        compound.func_74772_a("actionsCooldown", this.actionsCooldown);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.addressPosition = compound.func_74762_e("addressPosition");
        this.addressToDial = new StargateAddress(compound.func_74775_l("addressToDial"));
        this.maxSymbols = compound.func_74762_e("maxSymbols");
        this.abortDialing = compound.func_74767_n("abortDialing");
        this.dialingNearby = compound.func_74767_n("dialingNearby");
        this.actionsCooldown = compound.func_74763_f("actionsCooldown");
    }

    @Override
    public SymbolTypeEnum getSymbolType() {
        return SymbolTypeEnum.UNIVERSE;
    }

    @Override
    protected StargateEnergyRequired getEnergyRequiredToDial(StargatePos targetGatePos) {
        return super.getEnergyRequiredToDial(targetGatePos).mul(AunisConfig.powerConfig.stargateUniverseEnergyMul);
    }

    @Override
    protected boolean checkAddressLength(StargateAddressDynamic address, StargatePos targetGatePosition) {
        return super.checkAddressLength(address, targetGatePosition);
    }

    @Override
    protected AunisAxisAlignedBB getHorizonTeleportBox(boolean server) {
        return StargateSizeEnum.SMALL.teleportBox;
    }

    @Override
    public BlockPos getGateCenterPos() {
        return this.field_174879_c.func_177981_b(4);
    }

    @Override
    protected AunisAxisAlignedBB getHorizonKillingBox(boolean server) {
        return StargateSizeEnum.SMALL.killingBox;
    }

    @Override
    protected int getHorizonSegmentCount(boolean server) {
        return StargateSizeEnum.SMALL.horizonSegmentCount;
    }

    @Override
    protected List<AunisAxisAlignedBB> getGateVaporizingBoxes(boolean server) {
        return StargateSizeEnum.SMALL.gateVaporizingBoxes;
    }

    @Override
    protected SoundPositionedEnum getPositionedSound(StargateSoundPositionedEnum soundEnum) {
        switch (soundEnum) {
            case GATE_RING_ROLL: {
                return SoundPositionedEnum.UNIVERSE_RING_ROLL;
            }
        }
        return null;
    }

    @Override
    protected SoundEventEnum getSoundEvent(StargateSoundEventEnum soundEnum) {
        switch (soundEnum) {
            case OPEN: {
                return SoundEventEnum.GATE_UNIVERSE_OPEN;
            }
            case CLOSE: {
                return SoundEventEnum.GATE_UNIVERSE_CLOSE;
            }
            case DIAL_FAILED: {
                return SoundEventEnum.GATE_UNIVERSE_DIAL_FAILED;
            }
            case INCOMING: {
                return SoundEventEnum.GATE_UNIVERSE_DIAL_START;
            }
            case CHEVRON_OPEN: {
                return SoundEventEnum.GATE_MILKYWAY_CHEVRON_OPEN;
            }
            case CHEVRON_SHUT: {
                return this.targetRingSymbol == SymbolUniverseEnum.TOP_CHEVRON ? SoundEventEnum.GATE_UNIVERSE_CHEVRON_TOP_LOCK : SoundEventEnum.GATE_UNIVERSE_CHEVRON_LOCK;
            }
        }
        return null;
    }

    @Override
    public StargateAbstractMergeHelper getMergeHelper() {
        return StargateUniverseMergeHelper.INSTANCE;
    }

    @Override
    protected StargateClassicRendererState.StargateClassicRendererStateBuilder getRendererStateServer() {
        return new StargateUniverseRendererState.StargateUniverseRendererStateBuilder(super.getRendererStateServer()).setDialedAddress(this.stargateState.initiating() || this.stargateState.dialing() ? this.dialedAddress : new StargateAddressDynamic(this.getSymbolType())).setActiveChevrons(this.stargateState.idle() ? 0 : 9);
    }

    @Override
    protected StargateUniverseRendererState createRendererStateClient() {
        return new StargateUniverseRendererState();
    }

    @Override
    public StargateUniverseRendererState getRendererStateClient() {
        return (StargateUniverseRendererState)super.getRendererStateClient();
    }

    @Override
    public int getSupportedCapacitors() {
        return AunisConfig.powerConfig.universeCapacitors;
    }
}

