/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.tileentity.stargate;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.Nullable;
import mrjake.aunis.Aunis;
import mrjake.aunis.block.AunisBlocks;
import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.config.StargateSizeEnum;
import mrjake.aunis.gui.container.StargateContainerGuiUpdate;
import mrjake.aunis.packet.AunisPacketHandler;
import mrjake.aunis.packet.StateUpdatePacketToClient;
import mrjake.aunis.renderer.biomes.BiomeOverlayEnum;
import mrjake.aunis.renderer.stargate.ChevronEnum;
import mrjake.aunis.renderer.stargate.StargateAbstractRendererState;
import mrjake.aunis.renderer.stargate.StargatePegasusRendererState;
import mrjake.aunis.sound.SoundEventEnum;
import mrjake.aunis.sound.SoundPositionedEnum;
import mrjake.aunis.sound.StargateSoundEventEnum;
import mrjake.aunis.sound.StargateSoundPositionedEnum;
import mrjake.aunis.stargate.EnumScheduledTask;
import mrjake.aunis.stargate.EnumSpinDirection;
import mrjake.aunis.stargate.EnumStargateState;
import mrjake.aunis.stargate.StargateOpenResult;
import mrjake.aunis.stargate.merging.StargateAbstractMergeHelper;
import mrjake.aunis.stargate.merging.StargatePegasusMergeHelper;
import mrjake.aunis.stargate.network.StargatePos;
import mrjake.aunis.stargate.network.SymbolInterface;
import mrjake.aunis.stargate.network.SymbolPegasusEnum;
import mrjake.aunis.stargate.network.SymbolTypeEnum;
import mrjake.aunis.state.State;
import mrjake.aunis.state.StateTypeEnum;
import mrjake.aunis.state.dialhomedevice.DHDActivateButtonState;
import mrjake.aunis.state.stargate.StargateBiomeOverrideState;
import mrjake.aunis.state.stargate.StargateRendererActionState;
import mrjake.aunis.state.stargate.StargateSpinState;
import mrjake.aunis.tileentity.dialhomedevice.DHDAbstractTile;
import mrjake.aunis.tileentity.dialhomedevice.DHDPegasusTile;
import mrjake.aunis.tileentity.stargate.StargateClassicBaseTile;
import mrjake.aunis.tileentity.util.ScheduledTask;
import mrjake.aunis.util.AunisAxisAlignedBB;
import mrjake.aunis.util.ILinkable;
import mrjake.aunis.util.LinkingHelper;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class StargatePegasusBaseTile
extends StargateClassicBaseTile
implements ILinkable {
    private BlockPos linkedDHD = null;
    private int linkId = -1;
    private BlockPos lastPos = BlockPos.field_177992_a;
    protected List<SymbolPegasusEnum> toDialSymbols = new ArrayList<SymbolPegasusEnum>();
    protected EntityPlayer lastSender;
    protected boolean continueDialing = false;
    public static final EnumSet<BiomeOverlayEnum> SUPPORTED_OVERLAYS = EnumSet.of(BiomeOverlayEnum.NORMAL, BiomeOverlayEnum.FROST, BiomeOverlayEnum.MOSSY, BiomeOverlayEnum.AGED);
    private StargateSizeEnum stargateSize = AunisConfig.stargateSize;

    @Override
    public StargateSizeEnum getStargateSize() {
        return this.stargateSize;
    }

    @Override
    protected void disconnectGate() {
        super.disconnectGate();
        this.resetToDialSymbols();
        if (this.isLinkedAndDHDOperational()) {
            this.getLinkedDHD(this.field_145850_b).clearSymbols();
        }
    }

    @Override
    protected void failGate() {
        super.failGate();
        this.resetToDialSymbols();
        if (this.isLinkedAndDHDOperational()) {
            this.getLinkedDHD(this.field_145850_b).clearSymbols();
        }
    }

    @Override
    protected void dialingFailed(StargateOpenResult reason) {
        this.resetToDialSymbols();
        super.dialingFailed(reason);
    }

    @Override
    protected void addFailedTaskAndPlaySound() {
        if (this.stargateState == EnumStargateState.DIALING || this.stargateState == EnumStargateState.DIALING_COMPUTER || this.stargateState == EnumStargateState.IDLE) {
            this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_FAIL, this.stargateState.dialingComputer() ? 83 : 53));
            this.playSoundEvent(StargateSoundEventEnum.DIAL_FAILED);
        }
    }

    @Override
    public void openGate(StargatePos targetGatePos, boolean isInitiating) {
        super.openGate(targetGatePos, isInitiating);
        this.resetToDialSymbols();
        if (this.isLinkedAndDHDOperational()) {
            this.getLinkedDHD(this.field_145850_b).activateSymbol(SymbolPegasusEnum.BRB);
        }
    }

    @Override
    public void activateDHDSymbolBRB() {
        if (this.isLinkedAndDHDOperational()) {
            this.getLinkedDHD(this.field_145850_b).activateSymbol(SymbolPegasusEnum.BRB);
        }
    }

    public void clearDHDSymbols() {
        if (this.isLinkedAndDHDOperational()) {
            this.getLinkedDHD(this.field_145850_b).clearSymbols();
        }
    }

    @Override
    public SymbolTypeEnum getSymbolType() {
        return SymbolTypeEnum.PEGASUS;
    }

    @Override
    protected AunisAxisAlignedBB getHorizonTeleportBox(boolean server) {
        return this.getStargateSizeConfig((boolean)server).teleportBox;
    }

    @Override
    protected int getMaxChevrons() {
        return this.isLinkedAndDHDOperational() && this.stargateState != EnumStargateState.DIALING_COMPUTER && !this.getLinkedDHD(this.field_145850_b).hasUpgrade(DHDAbstractTile.DHDUpgradeEnum.CHEVRON_UPGRADE) ? 7 : 9;
    }

    @Override
    public void addSymbolToAddress(SymbolInterface symbol) {
        this.addSymbolToAddress(symbol, true);
    }

    public void addSymbolToAddress(SymbolInterface symbol, boolean activateSymbol) {
        if (this.isLinkedAndDHDOperational() && activateSymbol) {
            this.getLinkedDHD(this.field_145850_b).activateSymbol((SymbolPegasusEnum)symbol);
        }
        super.addSymbolToAddress(symbol);
    }

    @Override
    public void incomingWormhole(int dialedAddressSize) {
        super.incomingWormhole(dialedAddressSize);
        if (this.isLinkedAndDHDOperational()) {
            this.getLinkedDHD(this.field_145850_b).clearSymbols();
        }
        this.prepareGateToConnect(dialedAddressSize, 400);
        this.func_70296_d();
    }

    @Override
    public void incomingWormhole(int dialedAddressSize, int time) {
        super.incomingWormhole(dialedAddressSize);
        if (this.isLinkedAndDHDOperational()) {
            this.getLinkedDHD(this.field_145850_b).clearSymbols();
        }
        this.prepareGateToConnect(dialedAddressSize, time);
        this.func_70296_d();
    }

    public void prepareGateToConnect(final int dialedAddressSize, int period) {
        if (this.stargateState == EnumStargateState.DIALING_COMPUTER) {
            this.abortDialingSequence(1);
        }
        this.stargateState = EnumStargateState.INCOMING;
        this.func_70296_d();
        boolean allowIncomingAnimation = AunisConfig.stargateConfig.allowIncomingAnimations;
        if (allowIncomingAnimation) {
            this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CLEAR_CHEVRONS, 0, false);
            period = period * dialedAddressSize / 36;
            this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, true);
            final int[] y = new int[]{1};
            final Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (y[0] <= 37) {
                        int z = y[0];
                        if (z % 4 == 0 && z > 0) {
                            int chevron = z / 4;
                            int[] pattern = new int[]{1, 2, 3, 7, 8, 4, 5, 6, 9};
                            if (!StargatePegasusBaseTile.this.stargateState.idle() && StargatePegasusBaseTile.this.isIncoming) {
                                if (chevron < 9) {
                                    if (pattern[chevron - 1] < dialedAddressSize) {
                                        StargatePegasusBaseTile.this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_ACTIVATE, pattern[chevron - 1] + 9, false);
                                        StargatePegasusBaseTile.this.playSoundEvent(StargateSoundEventEnum.INCOMING);
                                    }
                                } else {
                                    StargatePegasusBaseTile.this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_ACTIVATE, 0, true);
                                    StargatePegasusBaseTile.this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, false);
                                    StargatePegasusBaseTile.this.playSoundEvent(StargateSoundEventEnum.CHEVRON_OPEN);
                                    timer.cancel();
                                }
                            } else {
                                StargatePegasusBaseTile.this.isIncoming = false;
                                StargatePegasusBaseTile.this.stargateState = EnumStargateState.IDLE;
                                StargatePegasusBaseTile.this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CLEAR_CHEVRONS, 10));
                                StargatePegasusBaseTile.this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, false);
                                StargatePegasusBaseTile.this.func_70296_d();
                                timer.cancel();
                            }
                        }
                        StargatePegasusBaseTile.this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.ACTIVATE_GLYPH, y[0], false);
                        y[0] = y[0] + 1;
                    } else {
                        timer.cancel();
                    }
                }
            }, 0L, (long)period);
        } else {
            this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.LIGHT_UP_CHEVRONS, dialedAddressSize, false);
            this.playSoundEvent(StargateSoundEventEnum.INCOMING);
            this.isIncoming = false;
            this.func_70296_d();
        }
    }

    @Override
    public void onGateBroken() {
        super.onGateBroken();
        if (this.isLinked()) {
            this.getLinkedDHD(this.field_145850_b).clearSymbols();
            this.getLinkedDHD(this.field_145850_b).setLinkedGate(null, -1);
            this.setLinkedDHD(null, -1);
        }
    }

    @Override
    protected void onGateMerged() {
        super.onGateMerged();
        this.updateLinkStatus();
    }

    @Override
    public StargateAbstractMergeHelper getMergeHelper() {
        return StargatePegasusMergeHelper.INSTANCE;
    }

    @Override
    public boolean canLinkTo() {
        return this.isMerged() && !this.isLinked();
    }

    @Override
    public int getLinkId() {
        return this.linkId;
    }

    @Nullable
    public DHDPegasusTile getLinkedDHD(World world) {
        if (this.linkedDHD == null) {
            return null;
        }
        return (DHDPegasusTile)world.func_175625_s(this.linkedDHD);
    }

    public boolean isLinked() {
        return this.linkedDHD != null && this.field_145850_b.func_175625_s(this.linkedDHD) instanceof DHDPegasusTile;
    }

    public boolean isLinkedAndDHDOperational() {
        if (!this.isLinked()) {
            return false;
        }
        DHDPegasusTile dhdTile = this.getLinkedDHD(this.field_145850_b);
        return dhdTile.hasControlCrystal();
    }

    @Override
    public void setLinkedDHD(BlockPos dhdPos, int linkId) {
        this.linkedDHD = dhdPos;
        this.linkId = linkId;
        this.func_70296_d();
    }

    public void updateLinkStatus() {
        BlockPos closestDhd = LinkingHelper.findClosestUnlinked(this.field_145850_b, this.field_174879_c, LinkingHelper.getDhdRange(), AunisBlocks.DHD_PEGASUS_BLOCK, this.getLinkId());
        int linkId = LinkingHelper.getLinkId();
        if (closestDhd != null) {
            DHDPegasusTile dhdTile = (DHDPegasusTile)this.field_145850_b.func_175625_s(closestDhd);
            dhdTile.setLinkedGate(this.field_174879_c, linkId);
            this.setLinkedDHD(closestDhd, linkId);
            this.func_70296_d();
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("stargateSize", this.stargateSize.id);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        if (compound.func_74764_b("linkedDHD")) {
            this.linkedDHD = BlockPos.func_177969_a((long)compound.func_74763_f("linkedDHD"));
        }
        if (compound.func_74764_b("linkId")) {
            this.linkId = compound.func_74762_e("linkId");
        }
        this.stargateSize = compound.func_74764_b("patternVersion") ? StargateSizeEnum.SMALL : (compound.func_74764_b("stargateSize") ? StargateSizeEnum.fromId(compound.func_74762_e("stargateSize")) : StargateSizeEnum.LARGE);
        super.func_145839_a(compound);
    }

    @Override
    public boolean prepare(ICommandSender sender, ICommand command) {
        this.setLinkedDHD(null, -1);
        return super.prepare(sender, command);
    }

    @Override
    protected SoundPositionedEnum getPositionedSound(StargateSoundPositionedEnum soundEnum) {
        switch (soundEnum) {
            case GATE_RING_ROLL: {
                return SoundPositionedEnum.PEGASUS_RING_ROLL;
            }
        }
        return null;
    }

    @Override
    protected SoundEventEnum getSoundEvent(StargateSoundEventEnum soundEnum) {
        switch (soundEnum) {
            case OPEN: {
                return SoundEventEnum.GATE_PEGASUS_OPEN;
            }
            case CLOSE: {
                return SoundEventEnum.GATE_MILKYWAY_CLOSE;
            }
            case DIAL_FAILED: {
                return this.stargateState.dialingComputer() ? SoundEventEnum.GATE_PEGASUS_DIAL_FAILED : SoundEventEnum.GATE_PEGASUS_DIAL_FAILED;
            }
            case INCOMING: {
                return SoundEventEnum.GATE_PEGASUS_INCOMING;
            }
            case CHEVRON_OPEN: 
            case CHEVRON_SHUT: {
                return SoundEventEnum.GATE_PEGASUS_CHEVRON_OPEN;
            }
        }
        return null;
    }

    @Override
    public BlockPos getGateCenterPos() {
        return this.field_174879_c.func_177967_a(EnumFacing.UP, 4);
    }

    @Override
    protected boolean onGateMergeRequested() {
        return StargatePegasusMergeHelper.INSTANCE.checkBlocks((IBlockAccess)this.field_145850_b, this.field_174879_c, this.facing);
    }

    public void resetToDialSymbols() {
        this.toDialSymbols.clear();
    }

    @Override
    protected boolean canAddSymbolInternal(SymbolInterface symbol) {
        if (this.dialedAddress.contains(symbol)) {
            return false;
        }
        return this.dialedAddress.size() < this.getMaxChevrons();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.toDialSymbols.size() > 0 && this.field_145850_b.func_82737_E() % 2L == 0L && this.stargateState.idle()) {
            if (this.canAddSymbolInternal(this.toDialSymbols.get(0)) || this.toDialSymbols.get(0) == SymbolPegasusEnum.BRB) {
                SymbolPegasusEnum next = null;
                boolean continueDialing = false;
                for (SymbolPegasusEnum toDialSymbol : this.toDialSymbols) {
                    if (toDialSymbol == this.toDialSymbols.get(0) || toDialSymbol == SymbolPegasusEnum.BRB) continue;
                    next = toDialSymbol;
                    break;
                }
                if (next != null && this.toDialSymbols.size() > 1 && AunisConfig.stargateConfig.pegasContinueDial) {
                    continueDialing = true;
                }
                this.continueDialing = continueDialing;
                this.func_70296_d();
                this.addSymbolToAddressByList(this.toDialSymbols.get(0));
            }
            if (this.toDialSymbols.size() > 0) {
                this.toDialSymbols.remove(0);
            }
        }
        if (!this.lastPos.equals((Object)this.field_174879_c)) {
            this.lastPos = this.field_174879_c;
            this.updateLinkStatus();
            this.func_70296_d();
        }
    }

    @Override
    public EnumSet<BiomeOverlayEnum> getSupportedOverlays() {
        return SUPPORTED_OVERLAYS;
    }

    @Override
    protected AunisAxisAlignedBB getHorizonKillingBox(boolean server) {
        return this.getStargateSizeConfig((boolean)server).killingBox;
    }

    @Override
    protected int getHorizonSegmentCount(boolean server) {
        return this.getStargateSizeConfig((boolean)server).horizonSegmentCount;
    }

    @Override
    protected List<AunisAxisAlignedBB> getGateVaporizingBoxes(boolean server) {
        return this.getStargateSizeConfig((boolean)server).gateVaporizingBoxes;
    }

    private StargateSizeEnum getStargateSizeConfig(boolean server) {
        return server ? AunisConfig.stargateSize : this.getRendererStateClient().stargateSize;
    }

    @Override
    protected StargatePegasusRendererState.StargatePegasusRendererStateBuilder getRendererStateServer() {
        return new StargatePegasusRendererState.StargatePegasusRendererStateBuilder(super.getRendererStateServer()).setStargateSize(this.stargateSize);
    }

    @Override
    protected StargateAbstractRendererState createRendererStateClient() {
        return new StargatePegasusRendererState();
    }

    @Override
    public StargatePegasusRendererState getRendererStateClient() {
        return (StargatePegasusRendererState)super.getRendererStateClient();
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        switch (stateType) {
            case RENDERER_STATE: {
                return new StargatePegasusRendererState();
            }
            case DHD_ACTIVATE_BUTTON: {
                return new DHDActivateButtonState();
            }
            case GUI_UPDATE: {
                return new StargateContainerGuiUpdate();
            }
            case BIOME_OVERRIDE_STATE: {
                return new StargateBiomeOverrideState();
            }
        }
        return super.createState(stateType);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setState(StateTypeEnum stateType, State state) {
        switch (stateType) {
            case RENDERER_UPDATE: {
                StargateRendererActionState gateActionState = (StargateRendererActionState)state;
                switch (gateActionState.action) {
                    case CHEVRON_OPEN: {
                        this.getRendererStateClient().openChevron(this.field_145850_b.func_82737_E());
                        break;
                    }
                    case CHEVRON_CLOSE: {
                        this.getRendererStateClient().closeChevron(this.field_145850_b.func_82737_E());
                        break;
                    }
                    case CLEAR_CHEVRONS: {
                        this.getRendererStateClient().clearChevrons(this.field_145850_b.func_82737_E());
                        return;
                    }
                    case ACTIVATE_GLYPH: {
                        int slot = ((StargateRendererActionState)state).chevronCount;
                        slot = 36 - (slot - 9);
                        if (slot > 36) {
                            slot -= 36;
                        }
                        if (slot < 0) {
                            slot += 36;
                        }
                        if (this.getRendererStateClient() == null) break;
                        this.getRendererStateClient().setGlyphAtSlot(slot, slot);
                        break;
                    }
                    case CHEVRON_ACTIVATE: {
                        this.getRendererStateClient().spinHelper.setIsSpinning(false);
                        if (((StargateRendererActionState)state).chevronCount > 9) break;
                        ChevronEnum chevron = gateActionState.modifyFinal ? ChevronEnum.getFinal() : this.getRendererStateClient().chevronTextureList.getNextChevron();
                        this.getRendererStateClient().lockChevron(this.getRendererStateClient().spinHelper.getTargetSymbol().getId(), chevron);
                        break;
                    }
                }
                break;
            }
            case SPIN_STATE: {
                if (this.getRendererStateClient().chevronTextureList.getNextChevron().rotationIndex != 1) break;
                this.getRendererStateClient().slotToGlyphMap.clear();
                break;
            }
        }
        super.setState(stateType, state);
    }

    @Override
    protected long getSpinStartOffset() {
        return this.slotFromChevron(this.getRendererStateClient().chevronTextureList.getCurrentChevron());
    }

    public int slotFromChevron(ChevronEnum chevron) {
        return (new int[]{9, 5, 1, 33, 29, 25, 21, 17, 13})[chevron.rotationIndex];
    }

    @Override
    public StargateOpenResult attemptOpenAndFail() {
        if (this.stargateState != EnumStargateState.INCOMING) {
            this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, false);
        }
        this.continueDialing = false;
        this.func_70296_d();
        return super.attemptOpenAndFail();
    }

    public void addSymbolToAddressDHD(SymbolInterface targetSymbol, EntityPlayer sender) {
        if (this.isLinkedAndDHDOperational() && (targetSymbol != SymbolPegasusEnum.BRB || this.toDialSymbols.size() > 0)) {
            this.getLinkedDHD(this.field_145850_b).activateSymbol((SymbolPegasusEnum)targetSymbol);
        }
        this.toDialSymbols.add((SymbolPegasusEnum)targetSymbol);
        this.lastSender = sender;
        this.func_70296_d();
    }

    public void addSymbolToAddressDHD(SymbolInterface targetSymbol) {
        this.toDialSymbols.add((SymbolPegasusEnum)targetSymbol);
        if (this.isLinkedAndDHDOperational()) {
            this.getLinkedDHD(this.field_145850_b).activateSymbol((SymbolPegasusEnum)targetSymbol);
        }
    }

    public void addSymbolToAddressByList(SymbolInterface targetSymbol) {
        if (((SymbolPegasusEnum)targetSymbol).brb()) {
            StargateOpenResult openResult = this.attemptOpenAndFail();
            if (openResult == StargateOpenResult.NOT_ENOUGH_POWER && this.lastSender != null) {
                this.lastSender.func_146105_b((ITextComponent)new TextComponentTranslation("tile.aunis.stargatebase_block.not_enough_power", new Object[0]), true);
            }
            return;
        }
        if (AunisConfig.dhdConfig.animatePegDHDDial) {
            float distance;
            int indexDiff;
            EnumSpinDirection counterDirection;
            ChevronEnum currentChevron;
            Object context = null;
            this.stargateState = EnumStargateState.DIALING;
            this.targetRingSymbol = targetSymbol;
            this.spinDirection = this.spinDirection.opposite();
            ChevronEnum targetChevron = targetSymbol.origin() ? ChevronEnum.getFinal() : ChevronEnum.valueOf(this.dialedAddress.size());
            ChevronEnum chevronEnum = currentChevron = this.dialedAddress.size() == 0 ? ChevronEnum.C1 : ChevronEnum.valueOf(targetChevron.index - 1);
            if (targetSymbol.origin() && this.dialedAddress.size() == 6) {
                currentChevron = ChevronEnum.C6;
            }
            EnumSpinDirection enumSpinDirection = counterDirection = (indexDiff = this.slotFromChevron(currentChevron) - this.slotFromChevron(targetChevron)) < 0 ? EnumSpinDirection.COUNTER_CLOCKWISE : EnumSpinDirection.CLOCKWISE;
            if (this.spinDirection == counterDirection) {
                indexDiff = 36 - Math.abs(indexDiff);
            }
            if ((distance = (float)Math.abs(indexDiff)) <= 20.0f) {
                distance += 36.0f;
            }
            int duration = (int)distance;
            this.doIncomingAnimation(duration, true);
            AunisPacketHandler.INSTANCE.sendToAllTracking((IMessage)new StateUpdatePacketToClient(this.field_174879_c, StateTypeEnum.SPIN_STATE, new StargateSpinState(this.targetRingSymbol, this.spinDirection, false, 0)), this.targetPoint);
            this.lastSpinFinished = new ScheduledTask(EnumScheduledTask.STARGATE_SPIN_FINISHED, duration - 1);
            this.addTask(this.lastSpinFinished);
            this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, true);
            this.isSpinning = true;
            this.spinStartTime = this.field_145850_b.func_82737_E();
            this.ringSpinContext = context;
            this.sendSignal(context, "stargate_dhd_chevron_engaged", this.dialedAddress.size(), this.stargateWillLock(this.targetRingSymbol), targetSymbol.getEnglishName());
        } else {
            this.addSymbolToAddress(targetSymbol);
            this.stargateState = EnumStargateState.DIALING;
            if (this.stargateWillLock(targetSymbol)) {
                this.isFinalActive = true;
            }
            this.sendSignal(null, "stargate_dhd_chevron_engaged", this.dialedAddress.size(), this.isFinalActive, targetSymbol.getEnglishName());
            this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_ACTIVATE_CHEVRON, 10));
            this.doIncomingAnimation(10, false);
        }
        this.func_70296_d();
    }

    @Override
    public void addSymbolToAddressManual(SymbolInterface targetSymbol, @Nullable Object context) {
        boolean moveOnly;
        this.stargateState = EnumStargateState.DIALING_COMPUTER;
        this.targetRingSymbol = targetSymbol;
        boolean bl = moveOnly = this.targetRingSymbol == this.currentRingSymbol;
        if (moveOnly) {
            this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_SPIN_FINISHED, 0));
            this.doIncomingAnimation(10, true);
        } else {
            float distance;
            int indexDiff;
            EnumSpinDirection counterDirection;
            ChevronEnum currentChevron;
            this.spinDirection = this.spinDirection.opposite();
            ChevronEnum targetChevron = targetSymbol.origin() ? ChevronEnum.getFinal() : ChevronEnum.valueOf(this.dialedAddress.size());
            ChevronEnum chevronEnum = currentChevron = this.dialedAddress.size() == 0 ? ChevronEnum.C1 : ChevronEnum.valueOf(targetChevron.index - 1);
            if (targetSymbol.origin() && this.dialedAddress.size() == 6) {
                currentChevron = ChevronEnum.C6;
            }
            EnumSpinDirection enumSpinDirection = counterDirection = (indexDiff = this.slotFromChevron(currentChevron) - this.slotFromChevron(targetChevron)) < 0 ? EnumSpinDirection.COUNTER_CLOCKWISE : EnumSpinDirection.CLOCKWISE;
            if (this.spinDirection == counterDirection) {
                indexDiff = 36 - Math.abs(indexDiff);
            }
            if ((distance = (float)Math.abs(indexDiff)) <= 20.0f) {
                distance += 36.0f;
            }
            int duration = (int)distance;
            this.doIncomingAnimation(duration, true);
            Aunis.logger.debug("addSymbolToAddressManual: current:" + this.currentRingSymbol + ", target:" + targetSymbol + ", direction:" + (Object)((Object)this.spinDirection) + ", distance:" + distance + ", duration:" + duration + ", moveOnly:" + moveOnly);
            AunisPacketHandler.INSTANCE.sendToAllTracking((IMessage)new StateUpdatePacketToClient(this.field_174879_c, StateTypeEnum.SPIN_STATE, new StargateSpinState(this.targetRingSymbol, this.spinDirection, false, 0)), this.targetPoint);
            this.lastSpinFinished = new ScheduledTask(EnumScheduledTask.STARGATE_SPIN_FINISHED, duration - 1);
            this.addTask(this.lastSpinFinished);
            this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, true);
            this.isSpinning = true;
            this.spinStartTime = this.field_145850_b.func_82737_E();
            this.ringSpinContext = context;
            if (context != null) {
                this.sendSignal(context, "stargate_spin_start", this.dialedAddress.size(), this.stargateWillLock(this.targetRingSymbol), targetSymbol.getEnglishName());
            }
        }
        this.func_70296_d();
    }

    @Override
    public void executeTask(EnumScheduledTask scheduledTask, NBTTagCompound customData) {
        switch (scheduledTask) {
            case STARGATE_ACTIVATE_CHEVRON: {
                this.stargateState = EnumStargateState.IDLE;
                this.func_70296_d();
                this.playSoundEvent(StargateSoundEventEnum.CHEVRON_OPEN);
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_ACTIVATE, -1, this.isFinalActive);
                this.updateChevronLight(this.dialedAddress.size(), this.isFinalActive);
                break;
            }
            case STARGATE_SPIN_FINISHED: {
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_OPEN, 0));
                break;
            }
            case STARGATE_CHEVRON_OPEN: {
                this.playSoundEvent(StargateSoundEventEnum.CHEVRON_OPEN);
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_OPEN, 0, false);
                if (this.canAddSymbol(this.targetRingSymbol)) {
                    if (this.stargateState == EnumStargateState.DIALING_COMPUTER) {
                        this.addSymbolToAddress(this.targetRingSymbol, true);
                    } else {
                        this.addSymbolToAddress(this.targetRingSymbol, false);
                    }
                    this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_OPEN_SECOND, 0));
                    break;
                }
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_FAIL, 60));
                break;
            }
            case STARGATE_CHEVRON_OPEN_SECOND: {
                this.playSoundEvent(StargateSoundEventEnum.CHEVRON_OPEN);
                this.playSoundEvent(StargateSoundEventEnum.CHEVRON_OPEN);
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_LIGHT_UP, 0));
                break;
            }
            case STARGATE_CHEVRON_LIGHT_UP: {
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_ACTIVATE, 0, this.stargateWillLock(this.targetRingSymbol));
                this.updateChevronLight(this.dialedAddress.size(), this.isFinalActive);
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_CLOSE, 1));
                break;
            }
            case STARGATE_CHEVRON_CLOSE: {
                if (this.stargateWillLock(this.targetRingSymbol)) {
                    this.stargateState = EnumStargateState.IDLE;
                    this.sendSignal(this.ringSpinContext, "stargate_spin_chevron_engaged", this.dialedAddress.size(), true, this.targetRingSymbol.getEnglishName());
                    break;
                }
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_DIM, 1));
                break;
            }
            case STARGATE_CHEVRON_DIM: {
                this.stargateState = EnumStargateState.IDLE;
                this.sendSignal(this.ringSpinContext, "stargate_spin_chevron_engaged", this.dialedAddress.size(), false, this.targetRingSymbol.getEnglishName());
                break;
            }
            case STARGATE_CHEVRON_FAIL: {
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_CLOSE, 0, false);
                this.dialingFailed(this.checkAddressAndEnergy(this.dialedAddress));
                break;
            }
            case STARGATE_CLEAR_CHEVRONS: {
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CLEAR_CHEVRONS, 0, false);
            }
        }
        super.executeTask(scheduledTask, customData);
    }

    @Override
    public int getSupportedCapacitors() {
        return 3;
    }
}

