/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.tileentity.stargate;

import java.util.EnumSet;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.Nullable;
import mrjake.aunis.block.AunisBlocks;
import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.config.StargateDimensionConfig;
import mrjake.aunis.config.StargateSizeEnum;
import mrjake.aunis.renderer.biomes.BiomeOverlayEnum;
import mrjake.aunis.renderer.stargate.StargateAbstractRendererState;
import mrjake.aunis.renderer.stargate.StargateMilkyWayRendererState;
import mrjake.aunis.sound.SoundEventEnum;
import mrjake.aunis.sound.SoundPositionedEnum;
import mrjake.aunis.sound.StargateSoundEventEnum;
import mrjake.aunis.sound.StargateSoundPositionedEnum;
import mrjake.aunis.stargate.EnumScheduledTask;
import mrjake.aunis.stargate.EnumStargateState;
import mrjake.aunis.stargate.StargateClassicSpinHelper;
import mrjake.aunis.stargate.merging.StargateAbstractMergeHelper;
import mrjake.aunis.stargate.merging.StargateMilkyWayMergeHelper;
import mrjake.aunis.stargate.network.StargateAddressDynamic;
import mrjake.aunis.stargate.network.StargateNetwork;
import mrjake.aunis.stargate.network.StargatePos;
import mrjake.aunis.stargate.network.SymbolInterface;
import mrjake.aunis.stargate.network.SymbolMilkyWayEnum;
import mrjake.aunis.stargate.network.SymbolTypeEnum;
import mrjake.aunis.state.State;
import mrjake.aunis.state.StateTypeEnum;
import mrjake.aunis.state.stargate.StargateRendererActionState;
import mrjake.aunis.tileentity.dialhomedevice.DHDAbstractTile;
import mrjake.aunis.tileentity.dialhomedevice.DHDMilkyWayTile;
import mrjake.aunis.tileentity.stargate.StargateClassicBaseTile;
import mrjake.aunis.tileentity.util.ScheduledTask;
import mrjake.aunis.util.AunisAxisAlignedBB;
import mrjake.aunis.util.ILinkable;
import mrjake.aunis.util.LinkingHelper;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class StargateMilkyWayBaseTile
extends StargateClassicBaseTile
implements ILinkable {
    private BlockPos linkedDHD = null;
    private int linkId = -1;
    private BlockPos lastPos = BlockPos.field_177992_a;
    public static final EnumSet<BiomeOverlayEnum> SUPPORTED_OVERLAYS = EnumSet.of(BiomeOverlayEnum.NORMAL, BiomeOverlayEnum.FROST, BiomeOverlayEnum.MOSSY, BiomeOverlayEnum.AGED, BiomeOverlayEnum.SOOTY);
    private StargateSizeEnum stargateSize = AunisConfig.stargateSize;

    @Override
    public StargateSizeEnum getStargateSize() {
        return this.stargateSize;
    }

    @Override
    protected void disconnectGate() {
        super.disconnectGate();
        if (this.isLinkedAndDHDOperational()) {
            this.getLinkedDHD(this.field_145850_b).clearSymbols();
        }
    }

    @Override
    protected void failGate() {
        super.failGate();
        if (this.isLinkedAndDHDOperational()) {
            this.getLinkedDHD(this.field_145850_b).clearSymbols();
        }
    }

    @Override
    protected void addFailedTaskAndPlaySound() {
        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_FAIL, this.stargateState.dialingComputer() ? 83 : 53));
        this.playSoundEvent(StargateSoundEventEnum.DIAL_FAILED);
    }

    @Override
    public void openGate(StargatePos targetGatePos, boolean isInitiating) {
        super.openGate(targetGatePos, isInitiating);
        if (this.isLinkedAndDHDOperational()) {
            this.getLinkedDHD(this.field_145850_b).activateSymbol(SymbolMilkyWayEnum.BRB);
        }
    }

    @Override
    public void activateDHDSymbolBRB() {
        if (this.isLinkedAndDHDOperational()) {
            this.getLinkedDHD(this.field_145850_b).activateSymbol(SymbolMilkyWayEnum.BRB);
        }
    }

    public void clearDHDSymbols() {
        if (this.isLinkedAndDHDOperational()) {
            this.getLinkedDHD(this.field_145850_b).clearSymbols();
        }
    }

    @Override
    public SymbolTypeEnum getSymbolType() {
        return SymbolTypeEnum.MILKYWAY;
    }

    @Override
    protected AunisAxisAlignedBB getHorizonTeleportBox(boolean server) {
        return this.getStargateSizeConfig((boolean)server).teleportBox;
    }

    public void addSymbolToAddressDHD(SymbolMilkyWayEnum symbol) {
        this.stargateState = EnumStargateState.DIALING;
        this.func_70296_d();
        this.addSymbolToAddress(symbol);
        this.doIncomingAnimation(10, false);
        if (this.stargateWillLock(symbol)) {
            this.isFinalActive = true;
            if (AunisConfig.stargateConfig.dhdLastOpen) {
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_OPEN, 5));
            } else {
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_ACTIVATE_CHEVRON, 10));
            }
        } else {
            this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_ACTIVATE_CHEVRON, 10));
        }
        this.sendSignal(null, "stargate_dhd_chevron_engaged", this.dialedAddress.size(), this.isFinalActive, symbol.englishName);
        this.func_70296_d();
    }

    @Override
    protected int getMaxChevrons() {
        return this.isLinkedAndDHDOperational() && this.stargateState != EnumStargateState.DIALING_COMPUTER && !this.getLinkedDHD(this.field_145850_b).hasUpgrade(DHDAbstractTile.DHDUpgradeEnum.CHEVRON_UPGRADE) ? 7 : 9;
    }

    @Override
    public void addSymbolToAddress(SymbolInterface symbol) {
        StargateAddressDynamic dialAddr_backup = new StargateAddressDynamic(this.getSymbolType());
        dialAddr_backup.clear();
        dialAddr_backup.addAll(this.dialedAddress);
        this.dialedAddress.addSymbol(symbol);
        boolean isEarth = this.tryDialEarth();
        if (isEarth) {
            super.addSymbolToAddress(symbol, 0);
        } else {
            this.dialedAddress.clear();
            this.dialedAddress.addAll(dialAddr_backup);
            super.addSymbolToAddress(symbol);
        }
        if (this.isLinkedAndDHDOperational()) {
            this.getLinkedDHD(this.field_145850_b).activateSymbol((SymbolMilkyWayEnum)symbol);
        }
    }

    public boolean tryDialEarth() {
        if (this.dialedAddress.size() >= 6 && this.dialedAddress.equalsV2(StargateNetwork.EARTH_ADDRESS) && !this.network.isStargateInNetwork(StargateNetwork.EARTH_ADDRESS)) {
            if (StargateDimensionConfig.netherOverworld8thSymbol()) {
                if (this.dialedAddress.size() == 7 && this.dialedAddress.getLast() == SymbolMilkyWayEnum.SERPENSCAPUT) {
                    this.dialedAddress.clear();
                    this.dialedAddress.addAll(this.network.getLastActivatedOrlins().subList(0, 7));
                    this.func_70296_d();
                    return true;
                }
            } else {
                this.dialedAddress.clear();
                this.dialedAddress.addAll(this.network.getLastActivatedOrlins().subList(0, 6));
                this.func_70296_d();
                return true;
            }
        }
        return false;
    }

    @Override
    public void addSymbolToAddressManual(SymbolInterface targetSymbol, Object context) {
        this.stargateState = EnumStargateState.DIALING_COMPUTER;
        super.addSymbolToAddressManual(targetSymbol, context);
    }

    @Override
    public void incomingWormhole(int dialedAddressSize) {
        super.incomingWormhole(dialedAddressSize);
        if (this.isLinkedAndDHDOperational()) {
            this.getLinkedDHD(this.field_145850_b).clearSymbols();
        }
        this.prepareGateToConnect(dialedAddressSize, 400);
        this.func_70296_d();
    }

    @Override
    public void incomingWormhole(int dialedAddressSize, int time) {
        super.incomingWormhole(dialedAddressSize);
        if (this.isLinkedAndDHDOperational()) {
            this.getLinkedDHD(this.field_145850_b).clearSymbols();
        }
        this.prepareGateToConnect(dialedAddressSize, time);
        this.func_70296_d();
    }

    public void prepareGateToConnect(final int dialedAddressSize, int period) {
        if (this.stargateState == EnumStargateState.DIALING_COMPUTER) {
            this.abortDialingSequence(1);
        }
        period -= 1000 / dialedAddressSize;
        this.stargateState = EnumStargateState.INCOMING;
        this.func_70296_d();
        boolean allowIncomingAnimation = AunisConfig.stargateConfig.allowIncomingAnimations;
        if (allowIncomingAnimation) {
            this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CLEAR_CHEVRONS, 0, false);
            final int[] i = new int[]{1};
            final Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (!StargateMilkyWayBaseTile.this.stargateState.idle()) {
                        if (i[0] < dialedAddressSize && StargateMilkyWayBaseTile.this.isIncoming) {
                            StargateMilkyWayBaseTile.this.playSoundEvent(StargateSoundEventEnum.INCOMING);
                            StargateMilkyWayBaseTile.this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_ACTIVATE, i[0] + 9, false);
                            i[0] = i[0] + 1;
                        } else {
                            StargateMilkyWayBaseTile.this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_OPEN, 1));
                            timer.cancel();
                        }
                    } else {
                        StargateMilkyWayBaseTile.this.stargateState = EnumStargateState.IDLE;
                        StargateMilkyWayBaseTile.this.func_70296_d();
                        StargateMilkyWayBaseTile.this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CLEAR_CHEVRONS, 0, false);
                        timer.cancel();
                    }
                }
            }, 0L, (long)period);
        } else {
            this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.LIGHT_UP_CHEVRONS, dialedAddressSize, false);
            this.playSoundEvent(StargateSoundEventEnum.INCOMING);
            this.isIncoming = false;
            this.func_70296_d();
        }
    }

    @Override
    public void onGateBroken() {
        if (this.getStargateAddress(SymbolTypeEnum.MILKYWAY) == this.network.getNetherGate()) {
            this.network.deleteNetherGate();
        }
        super.onGateBroken();
        if (this.isLinked()) {
            this.getLinkedDHD(this.field_145850_b).clearSymbols();
            this.getLinkedDHD(this.field_145850_b).setLinkedGate(null, -1);
            this.setLinkedDHD(null, -1);
        }
    }

    @Override
    protected void onGateMerged() {
        super.onGateMerged();
        this.updateLinkStatus();
    }

    @Override
    public StargateAbstractMergeHelper getMergeHelper() {
        return StargateMilkyWayMergeHelper.INSTANCE;
    }

    @Nullable
    public DHDMilkyWayTile getLinkedDHD(World world) {
        if (this.linkedDHD == null) {
            return null;
        }
        return (DHDMilkyWayTile)world.func_175625_s(this.linkedDHD);
    }

    public boolean isLinked() {
        return this.linkedDHD != null && this.field_145850_b.func_175625_s(this.linkedDHD) instanceof DHDMilkyWayTile;
    }

    public boolean isLinkedAndDHDOperational() {
        if (!this.isLinked()) {
            return false;
        }
        DHDMilkyWayTile dhdMilkyWayTile = this.getLinkedDHD(this.field_145850_b);
        return dhdMilkyWayTile.hasControlCrystal();
    }

    @Override
    public void setLinkedDHD(BlockPos dhdPos, int linkId) {
        this.linkedDHD = dhdPos;
        this.linkId = linkId;
        this.func_70296_d();
    }

    public void updateLinkStatus() {
        BlockPos closestDhd = LinkingHelper.findClosestUnlinked(this.field_145850_b, this.field_174879_c, LinkingHelper.getDhdRange(), AunisBlocks.DHD_BLOCK, this.getLinkId());
        int linkId = LinkingHelper.getLinkId();
        if (closestDhd != null) {
            DHDMilkyWayTile dhdMilkyWayTile = (DHDMilkyWayTile)this.field_145850_b.func_175625_s(closestDhd);
            dhdMilkyWayTile.setLinkedGate(this.field_174879_c, linkId);
            this.setLinkedDHD(closestDhd, linkId);
            this.func_70296_d();
        }
    }

    @Override
    public boolean canLinkTo() {
        return this.isMerged() && !this.isLinked();
    }

    @Override
    public int getLinkId() {
        return this.linkId;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (this.isLinked()) {
            compound.func_74772_a("linkedDHD", this.linkedDHD.func_177986_g());
            compound.func_74768_a("linkId", this.linkId);
        }
        compound.func_74768_a("stargateSize", this.stargateSize.id);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        if (compound.func_74764_b("linkedDHD")) {
            this.linkedDHD = BlockPos.func_177969_a((long)compound.func_74763_f("linkedDHD"));
        }
        if (compound.func_74764_b("linkId")) {
            this.linkId = compound.func_74762_e("linkId");
        }
        this.stargateSize = compound.func_74764_b("patternVersion") ? StargateSizeEnum.SMALL : (compound.func_74764_b("stargateSize") ? StargateSizeEnum.fromId(compound.func_74762_e("stargateSize")) : StargateSizeEnum.LARGE);
        super.func_145839_a(compound);
    }

    @Override
    public boolean prepare(ICommandSender sender, ICommand command) {
        this.setLinkedDHD(null, -1);
        return super.prepare(sender, command);
    }

    @Override
    protected SoundPositionedEnum getPositionedSound(StargateSoundPositionedEnum soundEnum) {
        switch (soundEnum) {
            case GATE_RING_ROLL: {
                return SoundPositionedEnum.MILKYWAY_RING_ROLL;
            }
        }
        return null;
    }

    @Override
    protected SoundEventEnum getSoundEvent(StargateSoundEventEnum soundEnum) {
        switch (soundEnum) {
            case OPEN: {
                return SoundEventEnum.GATE_MILKYWAY_OPEN;
            }
            case CLOSE: {
                return SoundEventEnum.GATE_MILKYWAY_CLOSE;
            }
            case DIAL_FAILED: {
                return this.stargateState.dialingComputer() ? SoundEventEnum.GATE_MILKYWAY_DIAL_FAILED_COMPUTER : SoundEventEnum.GATE_MILKYWAY_DIAL_FAILED;
            }
            case INCOMING: {
                return SoundEventEnum.GATE_MILKYWAY_INCOMING;
            }
            case CHEVRON_OPEN: {
                return SoundEventEnum.GATE_MILKYWAY_CHEVRON_OPEN;
            }
            case CHEVRON_SHUT: {
                return SoundEventEnum.GATE_MILKYWAY_CHEVRON_SHUT;
            }
        }
        return null;
    }

    @Override
    public BlockPos getGateCenterPos() {
        return this.field_174879_c.func_177967_a(EnumFacing.UP, 4);
    }

    @Override
    protected boolean onGateMergeRequested() {
        if (this.stargateSize != AunisConfig.stargateSize) {
            StargateMilkyWayMergeHelper.INSTANCE.convertToPattern(this.field_145850_b, this.field_174879_c, this.facing, this.stargateSize, AunisConfig.stargateSize);
            this.stargateSize = AunisConfig.stargateSize;
        }
        return StargateMilkyWayMergeHelper.INSTANCE.checkBlocks((IBlockAccess)this.field_145850_b, this.field_174879_c, this.facing);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if (StargateClassicSpinHelper.A_ANGLE_PER_TICK != AunisConfig.stargateConfig.classicGateSpinSpeed) {
                StargateClassicSpinHelper.A_ANGLE_PER_TICK = AunisConfig.stargateConfig.classicGateSpinSpeed;
            }
            if (!this.lastPos.equals((Object)this.field_174879_c)) {
                this.lastPos = this.field_174879_c;
                this.updateLinkStatus();
                this.func_70296_d();
            }
        }
    }

    @Override
    public EnumSet<BiomeOverlayEnum> getSupportedOverlays() {
        return SUPPORTED_OVERLAYS;
    }

    @Override
    protected AunisAxisAlignedBB getHorizonKillingBox(boolean server) {
        return this.getStargateSizeConfig((boolean)server).killingBox;
    }

    @Override
    protected int getHorizonSegmentCount(boolean server) {
        return this.getStargateSizeConfig((boolean)server).horizonSegmentCount;
    }

    @Override
    protected List<AunisAxisAlignedBB> getGateVaporizingBoxes(boolean server) {
        return this.getStargateSizeConfig((boolean)server).gateVaporizingBoxes;
    }

    private StargateSizeEnum getStargateSizeConfig(boolean server) {
        return server ? AunisConfig.stargateSize : this.getRendererStateClient().stargateSize;
    }

    @Override
    protected StargateMilkyWayRendererState.StargateMilkyWayRendererStateBuilder getRendererStateServer() {
        return new StargateMilkyWayRendererState.StargateMilkyWayRendererStateBuilder(super.getRendererStateServer()).setStargateSize(this.stargateSize);
    }

    @Override
    protected StargateAbstractRendererState createRendererStateClient() {
        return new StargateMilkyWayRendererState();
    }

    @Override
    public StargateMilkyWayRendererState getRendererStateClient() {
        return (StargateMilkyWayRendererState)super.getRendererStateClient();
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        return super.createState(stateType);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setState(StateTypeEnum stateType, State state) {
        block0 : switch (stateType) {
            case RENDERER_UPDATE: {
                StargateRendererActionState gateActionState = (StargateRendererActionState)state;
                switch (gateActionState.action) {
                    case CHEVRON_OPEN: {
                        this.getRendererStateClient().openChevron(this.field_145850_b.func_82737_E());
                        break block0;
                    }
                    case CHEVRON_CLOSE: {
                        this.getRendererStateClient().closeChevron(this.field_145850_b.func_82737_E());
                        break block0;
                    }
                }
                break;
            }
        }
        super.setState(stateType, state);
    }

    @Override
    public void executeTask(EnumScheduledTask scheduledTask, NBTTagCompound customData) {
        switch (scheduledTask) {
            case STARGATE_ACTIVATE_CHEVRON: {
                this.stargateState = EnumStargateState.IDLE;
                this.func_70296_d();
                this.playSoundEvent(StargateSoundEventEnum.CHEVRON_OPEN);
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_ACTIVATE, -1, this.isFinalActive);
                this.updateChevronLight(this.dialedAddress.size(), this.isFinalActive);
                break;
            }
            case STARGATE_SPIN_FINISHED: {
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_OPEN, 7));
                break;
            }
            case STARGATE_CHEVRON_OPEN: {
                this.playSoundEvent(StargateSoundEventEnum.CHEVRON_OPEN);
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_OPEN, 0, false);
                if (this.stargateState.incoming() || this.stargateState.unstable() || this.stargateState.dialingDHD() || this.isIncoming) {
                    this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_OPEN_SECOND, 7));
                    return;
                }
                if (this.canAddSymbol(this.targetRingSymbol)) {
                    this.addSymbolToAddress(this.targetRingSymbol);
                    if (this.stargateWillLock(this.targetRingSymbol)) {
                        if (this.checkAddressAndEnergy(this.dialedAddress).ok()) {
                            this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_OPEN_SECOND, 13));
                            break;
                        }
                        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_FAIL, 70));
                        break;
                    }
                    this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_OPEN_SECOND, 7));
                    break;
                }
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_FAIL, 70));
                break;
            }
            case STARGATE_CHEVRON_OPEN_SECOND: {
                this.playSoundEvent(StargateSoundEventEnum.CHEVRON_OPEN);
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_LIGHT_UP, 3));
                break;
            }
            case STARGATE_CHEVRON_LIGHT_UP: {
                if (this.stargateState.incoming() || this.stargateState.unstable() || this.stargateState.dialingDHD() || this.isIncoming) {
                    this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_ACTIVATE, 0, true);
                    this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_CLOSE, 10));
                    return;
                }
                if (this.stargateWillLock(this.targetRingSymbol)) {
                    this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_ACTIVATE, 0, true);
                } else {
                    this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_ACTIVATE_BOTH, 0, false);
                }
                this.updateChevronLight(this.dialedAddress.size(), this.isFinalActive);
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_CLOSE, 10));
                break;
            }
            case STARGATE_CHEVRON_CLOSE: {
                if (this.stargateState.incoming() || this.stargateState.dialingDHD() || this.isIncoming) {
                    this.playSoundEvent(StargateSoundEventEnum.CHEVRON_SHUT);
                    this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_CLOSE, 0, false);
                    if (this.stargateState.dialingDHD()) {
                        this.stargateState = EnumStargateState.IDLE;
                    }
                    this.func_70296_d();
                    return;
                }
                this.playSoundEvent(StargateSoundEventEnum.CHEVRON_SHUT);
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_CLOSE, 0, false);
                if (this.stargateWillLock(this.targetRingSymbol)) {
                    this.stargateState = EnumStargateState.IDLE;
                    this.sendSignal(this.ringSpinContext, "stargate_spin_chevron_engaged", this.dialedAddress.size(), true, this.targetRingSymbol.getEnglishName());
                    break;
                }
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CHEVRON_DIM, 10));
                break;
            }
            case STARGATE_CHEVRON_DIM: {
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_DIM, 0, false);
                this.stargateState = EnumStargateState.IDLE;
                this.sendSignal(this.ringSpinContext, "stargate_spin_chevron_engaged", this.dialedAddress.size(), false, this.targetRingSymbol.getEnglishName());
                break;
            }
            case STARGATE_CHEVRON_FAIL: {
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CHEVRON_CLOSE, 0, false);
                this.dialingFailed(this.checkAddressAndEnergy(this.dialedAddress));
                break;
            }
        }
        super.executeTask(scheduledTask, customData);
    }

    @Override
    public int getSupportedCapacitors() {
        return 3;
    }
}

