/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.tileentity.stargate;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import mrjake.aunis.Aunis;
import mrjake.aunis.beamer.BeamerLinkingHelper;
import mrjake.aunis.block.AunisBlocks;
import mrjake.aunis.chunkloader.ChunkManager;
import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.config.StargateSizeEnum;
import mrjake.aunis.gui.container.StargateContainerGuiState;
import mrjake.aunis.gui.container.StargateContainerGuiUpdate;
import mrjake.aunis.item.AunisItems;
import mrjake.aunis.item.UpgradeIris;
import mrjake.aunis.item.gdo.GDOMessages;
import mrjake.aunis.item.notebook.PageNotebookItem;
import mrjake.aunis.packet.AunisPacketHandler;
import mrjake.aunis.packet.StateUpdatePacketToClient;
import mrjake.aunis.renderer.biomes.BiomeOverlayEnum;
import mrjake.aunis.renderer.stargate.StargateClassicRendererState;
import mrjake.aunis.sound.AunisSoundHelper;
import mrjake.aunis.sound.SoundEventEnum;
import mrjake.aunis.sound.StargateSoundEventEnum;
import mrjake.aunis.sound.StargateSoundPositionedEnum;
import mrjake.aunis.stargate.EnumIrisMode;
import mrjake.aunis.stargate.EnumIrisState;
import mrjake.aunis.stargate.EnumIrisType;
import mrjake.aunis.stargate.EnumScheduledTask;
import mrjake.aunis.stargate.EnumSpinDirection;
import mrjake.aunis.stargate.EnumStargateState;
import mrjake.aunis.stargate.StargateClassicSpinHelper;
import mrjake.aunis.stargate.StargateClosedReasonEnum;
import mrjake.aunis.stargate.StargateOpenResult;
import mrjake.aunis.stargate.codesender.CodeSender;
import mrjake.aunis.stargate.codesender.CodeSenderType;
import mrjake.aunis.stargate.codesender.ComputerCodeSender;
import mrjake.aunis.stargate.network.StargateAddress;
import mrjake.aunis.stargate.network.StargateAddressDynamic;
import mrjake.aunis.stargate.network.StargateNetwork;
import mrjake.aunis.stargate.network.StargatePos;
import mrjake.aunis.stargate.network.SymbolInterface;
import mrjake.aunis.stargate.network.SymbolMilkyWayEnum;
import mrjake.aunis.stargate.network.SymbolPegasusEnum;
import mrjake.aunis.stargate.network.SymbolTypeEnum;
import mrjake.aunis.stargate.network.SymbolUniverseEnum;
import mrjake.aunis.stargate.power.StargateAbstractEnergyStorage;
import mrjake.aunis.stargate.power.StargateClassicEnergyStorage;
import mrjake.aunis.stargate.power.StargateEnergyRequired;
import mrjake.aunis.state.State;
import mrjake.aunis.state.StateTypeEnum;
import mrjake.aunis.state.stargate.StargateBiomeOverrideState;
import mrjake.aunis.state.stargate.StargateRendererActionState;
import mrjake.aunis.state.stargate.StargateSpinState;
import mrjake.aunis.tileentity.BeamerTile;
import mrjake.aunis.tileentity.stargate.StargateAbstractBaseTile;
import mrjake.aunis.tileentity.stargate.StargateClassicMemberTile;
import mrjake.aunis.tileentity.stargate.StargateMilkyWayBaseTile;
import mrjake.aunis.tileentity.stargate.StargatePegasusBaseTile;
import mrjake.aunis.tileentity.stargate.StargateUniverseBaseTile;
import mrjake.aunis.tileentity.util.IUpgradable;
import mrjake.aunis.tileentity.util.ScheduledTask;
import mrjake.aunis.util.AunisAxisAlignedBB;
import mrjake.aunis.util.AunisItemStackHandler;
import mrjake.aunis.util.EnumKeyInterface;
import mrjake.aunis.util.EnumKeyMap;
import mrjake.aunis.util.FacingToRotation;
import mrjake.aunis.util.ItemHandlerHelper;
import mrjake.aunis.util.ItemMetaPair;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextComponentBase;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class StargateClassicBaseTile
extends StargateAbstractBaseTile
implements IUpgradable {
    private EnumIrisState irisState = EnumIrisState.OPENED;
    private EnumIrisType irisType = EnumIrisType.NULL;
    private int irisCode = -1;
    protected EnumIrisMode irisMode = EnumIrisMode.OPENED;
    private long irisAnimation = 0L;
    public int shieldKeepAlive = 0;
    private int irisDurability = 0;
    private int irisMaxDurability = 0;
    protected boolean isFinalActive;
    private BlockPos lastPos = BlockPos.field_177992_a;
    boolean isFacingFixed = false;
    public static final AunisAxisAlignedBB RENDER_BOX = new AunisAxisAlignedBB(-5.5, 0.0, -0.5, 5.5, 10.5, 0.5);
    protected boolean isSpinning;
    protected long spinStartTime;
    protected SymbolInterface currentRingSymbol = this.getSymbolType().getTopSymbol();
    protected SymbolInterface targetRingSymbol = this.getSymbolType().getTopSymbol();
    protected EnumSpinDirection spinDirection = EnumSpinDirection.COUNTER_CLOCKWISE;
    protected Object ringSpinContext;
    private short pageProgress = 0;
    private int pageSlotId;
    private boolean doPageProgress;
    private ScheduledTask givePageTask;
    private boolean lockPage;
    public static final int BIOME_OVERRIDE_SLOT = 10;
    private final AunisItemStackHandler itemStackHandler = new AunisItemStackHandler(12){

        public boolean isItemValid(int slot, ItemStack stack) {
            Item item = stack.func_77973_b();
            boolean isItemCapacitor = item == Item.func_150898_a((Block)AunisBlocks.CAPACITOR_BLOCK);
            switch (slot) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    return StargateUpgradeEnum.contains(item) && !StargateClassicBaseTile.this.hasUpgrade(item);
                }
                case 4: {
                    return isItemCapacitor && StargateClassicBaseTile.this.getSupportedCapacitors() >= 1;
                }
                case 5: {
                    return isItemCapacitor && StargateClassicBaseTile.this.getSupportedCapacitors() >= 2;
                }
                case 6: {
                    return isItemCapacitor && StargateClassicBaseTile.this.getSupportedCapacitors() >= 3;
                }
                case 7: 
                case 8: {
                    return item == AunisItems.PAGE_NOTEBOOK_ITEM;
                }
                case 9: {
                    return item == AunisItems.PAGE_NOTEBOOK_ITEM || item == AunisItems.UNIVERSE_DIALER;
                }
                case 10: {
                    BiomeOverlayEnum override = AunisConfig.stargateConfig.getBiomeOverrideItemMetaPairs().get(new ItemMetaPair(stack));
                    if (override == null) {
                        return false;
                    }
                    return StargateClassicBaseTile.this.getSupportedOverlays().contains((Object)override);
                }
                case 11: {
                    return StargateIrisUpgradeEnum.contains(item);
                }
            }
            return true;
        }

        protected int getStackLimit(int slot, ItemStack stack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            switch (slot) {
                case 4: 
                case 5: 
                case 6: {
                    StargateClassicBaseTile.this.updatePowerTier();
                    break;
                }
                case 10: {
                    StargateClassicBaseTile.this.sendState(StateTypeEnum.BIOME_OVERRIDE_STATE, new StargateBiomeOverrideState(StargateClassicBaseTile.this.determineBiomeOverride()));
                    break;
                }
                case 11: {
                    StargateClassicBaseTile.this.updateIrisType();
                    break;
                }
            }
            StargateClassicBaseTile.this.func_70296_d();
        }
    };
    protected CodeSender codeSender;
    private Runnable afterIrisDone = null;
    private static final List<Integer> UPGRADE_SLOTS_IDS = new ArrayList<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 11));
    private final StargateClassicEnergyStorage energyStorage = new StargateClassicEnergyStorage(){

        @Override
        protected void onEnergyChanged() {
            StargateClassicBaseTile.this.func_70296_d();
        }
    };
    private int currentPowerTier = 1;
    private final List<BlockPos> linkedBeamers = new ArrayList<BlockPos>();

    @Override
    protected void engageGate() {
        super.engageGate();
        for (BlockPos beamerPos : this.linkedBeamers) {
            if (this.field_145850_b.func_175625_s(beamerPos) == null) continue;
            ((BeamerTile)Objects.requireNonNull(this.field_145850_b.func_175625_s(beamerPos))).gateEngaged(this.targetGatePos);
        }
    }

    @Override
    public void closeGate(StargateClosedReasonEnum reason) {
        super.closeGate(reason);
        for (BlockPos beamerPos : this.linkedBeamers) {
            if (this.field_145850_b.func_175625_s(beamerPos) == null) continue;
            ((BeamerTile)Objects.requireNonNull(this.field_145850_b.func_175625_s(beamerPos))).gateClosed();
        }
    }

    @Override
    protected void disconnectGate() {
        super.disconnectGate();
        if (this.irisMode == EnumIrisMode.AUTO && this.isClosed()) {
            this.toggleIris();
        }
        this.isFinalActive = false;
        if (this.codeSender != null) {
            this.codeSender = null;
        }
        this.updateChevronLight(0, false);
        this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CLEAR_CHEVRONS, this.dialedAddress.size(), this.isFinalActive);
    }

    @Override
    protected void failGate() {
        super.failGate();
        this.isFinalActive = false;
        if (this.stargateState != EnumStargateState.INCOMING && !this.isIncoming) {
            this.updateChevronLight(0, false);
            this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CLEAR_CHEVRONS, this.dialedAddress.size(), this.isFinalActive);
        }
    }

    @Override
    public void openGate(StargatePos targetGatePos, boolean isInitiating) {
        super.openGate(targetGatePos, isInitiating);
        this.isFinalActive = true;
    }

    public void abortDialingSequence(int type) {
        if (this instanceof StargateUniverseBaseTile) {
            ((StargateUniverseBaseTile)this).abort(true);
            return;
        }
        if (this.stargateState.dialingComputer() || this.stargateState.idle() || this.stargateState.dialing()) {
            this.spinStartTime = this.field_145850_b.func_82737_E() + 3000L;
            this.isSpinning = false;
            AunisPacketHandler.INSTANCE.sendToAllTracking((IMessage)new StateUpdatePacketToClient(this.field_174879_c, StateTypeEnum.SPIN_STATE, new StargateSpinState(this.targetRingSymbol, this.spinDirection, true, 0)), this.targetPoint);
            this.addFailedTaskAndPlaySound();
            this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, false);
            if (this.lastSpinFinished != null && this.scheduledTasks.contains(this.lastSpinFinished)) {
                this.removeTask(this.lastSpinFinished);
            }
            this.failGate();
            if (!this.isIncoming) {
                this.disconnectGate();
            }
            if (type == 2 && this instanceof StargateUniverseBaseTile) {
                this.addSymbolToAddressManual(SymbolUniverseEnum.G37, null);
                this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, true);
            }
            this.func_70296_d();
            if (type == 1) {
                this.abortDialingSequence(2);
            }
        }
    }

    @Override
    public void incomingWormhole(int dialedAddressSize) {
        this.incomingWormhole(dialedAddressSize, true);
    }

    public void incomingWormhole(int dialedAddressSize, boolean toggleIris) {
        if (this.irisMode == EnumIrisMode.AUTO && this.isOpened() && toggleIris) {
            this.toggleIris();
        }
        super.incomingWormhole(dialedAddressSize);
        this.isFinalActive = true;
        this.updateChevronLight(dialedAddressSize, this.isFinalActive);
    }

    @Override
    public void onGateBroken() {
        super.onGateBroken();
        this.updateChevronLight(0, false);
        if (this.irisType != EnumIrisType.NULL && this.irisState == EnumIrisState.CLOSED) {
            this.setIrisBlocks(false);
        }
        this.isSpinning = false;
        this.irisState = EnumIrisState.OPENED;
        this.irisType = EnumIrisType.NULL;
        this.currentRingSymbol = this.getSymbolType().getTopSymbol();
        AunisPacketHandler.INSTANCE.sendToAllTracking((IMessage)new StateUpdatePacketToClient(this.field_174879_c, StateTypeEnum.SPIN_STATE, new StargateSpinState(this.currentRingSymbol, this.spinDirection, true, 0)), this.targetPoint);
        this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, false);
        ItemHandlerHelper.dropInventoryItems(this.field_145850_b, this.field_174879_c, (IItemHandler)this.itemStackHandler);
        for (BlockPos beamerPos : this.linkedBeamers) {
            if (this.field_145850_b.func_175625_s(beamerPos) == null) continue;
            BeamerTile beamerTile = (BeamerTile)this.field_145850_b.func_175625_s(beamerPos);
            beamerTile.setLinkedGate(null, null);
        }
        this.linkedBeamers.clear();
    }

    @Override
    protected void onGateMerged() {
        super.onGateMerged();
        BeamerLinkingHelper.findBeamersInFront(this.field_145850_b, this.field_174879_c, this.facing);
        this.updateBeamers();
        this.updateIrisType();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.lastPos = this.field_174879_c;
        if (!this.field_145850_b.field_72995_K) {
            boolean set;
            this.updateBeamers();
            this.updatePowerTier();
            this.updateIrisType();
            boolean bl = set = this.irisType != EnumIrisType.NULL;
            if (this.isMerged()) {
                this.setIrisBlocks(set && this.irisState == EnumIrisState.CLOSED);
            }
        }
    }

    protected abstract boolean onGateMergeRequested();

    @Override
    public void func_73660_a() {
        block62: {
            block59: {
                block61: {
                    block60: {
                        if (!this.field_145850_b.field_72995_K) {
                            int chanceToRandom;
                            String[] entityListString = AunisConfig.randomIncoming.entitiesToSpawn;
                            ArrayList<Entity> entityList = new ArrayList<Entity>();
                            for (String entityString : entityListString) {
                                String[] entityTemporallyList = entityString.split(":");
                                if (entityTemporallyList.length < 2) continue;
                                String entityStringNew = entityTemporallyList[0].equals("minecraft") ? entityTemporallyList[1] : entityTemporallyList[0] + ":" + entityTemporallyList[1];
                                ResourceLocation rlString = new ResourceLocation(entityStringNew);
                                entityList.add(EntityList.func_188429_b((ResourceLocation)rlString, (World)this.field_145850_b));
                            }
                            Random rand = new Random();
                            if (AunisConfig.randomIncoming.enableRandomIncoming && this.field_145850_b.func_175697_a(this.field_174879_c, 10) && this.field_145850_b.func_82737_E() % 200L == 0L && (chanceToRandom = rand.nextInt(1000)) <= AunisConfig.randomIncoming.chance) {
                                int entities = rand.nextInt(25);
                                int delay = rand.nextInt(200);
                                if (this instanceof StargateUniverseBaseTile && (delay = rand.nextInt(300)) < 120) {
                                    delay = 120;
                                }
                                if (delay < 80) {
                                    delay = 80;
                                }
                                if (entities < 3) {
                                    entities = 3;
                                }
                                this.generateIncoming(entities, 7, delay);
                            }
                            if (this.randomIncomingIsActive) {
                                int wait = 80;
                                int waitOpen = this.randomIncomingOpenDelay + 20;
                                if (waitOpen < 80) {
                                    waitOpen = 80;
                                }
                                if (this.isMerged()) {
                                    if (this.randomIncomingState == 0.0f) {
                                        this.randomIncomingState += 1.0f;
                                        int period = waitOpen / 20 * 1000 / this.randomIncomingAddrSize;
                                        this.stargateState = EnumStargateState.INCOMING;
                                        this.isIncoming = true;
                                        this.func_70296_d();
                                        if (AunisConfig.stargateConfig.allowIncomingAnimations) {
                                            this.incomingWormhole(this.randomIncomingAddrSize, period);
                                        } else {
                                            this.incomingWormhole(this.randomIncomingAddrSize);
                                        }
                                        this.sendSignal(null, "stargate_incoming_wormhole", this.randomIncomingAddrSize);
                                        this.failGate();
                                    } else if (this.randomIncomingState < (float)waitOpen) {
                                        this.stargateState = EnumStargateState.INCOMING;
                                        this.randomIncomingState += 1.0f;
                                    } else if (this.randomIncomingState == (float)waitOpen) {
                                        this.randomIncomingState += 1.0f;
                                        this.targetGatePos = null;
                                        ChunkManager.forceChunk(this.field_145850_b, new ChunkPos(this.field_174879_c));
                                        this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.OPEN_GATE, 0, false);
                                        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_OPEN_SOUND, this.getOpenSoundDelay()));
                                        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_HORIZON_LIGHT_BLOCK, EnumScheduledTask.STARGATE_OPEN_SOUND.waitTicks + 19 + this.getTicksPerHorizonSegment(true)));
                                        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_HORIZON_WIDEN, EnumScheduledTask.STARGATE_OPEN_SOUND.waitTicks + 23 + this.getTicksPerHorizonSegment(true)));
                                        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_ENGAGE));
                                        this.sendSignal(null, "stargate_open", false);
                                        this.activateDHDSymbolBRB();
                                        this.func_70296_d();
                                        this.isFinalActive = true;
                                    } else if (this.randomIncomingState < (float)(waitOpen + wait)) {
                                        this.randomIncomingState += 1.0f;
                                    } else if (this.randomIncomingState >= (float)(waitOpen + wait) && this.randomIncomingEntities > 0 && (this.stargateState == EnumStargateState.ENGAGED || this.stargateState == EnumStargateState.INCOMING)) {
                                        this.randomIncomingState += 1.0f;
                                        int randomDelay = new Random().nextInt(16);
                                        if (randomDelay <= 0) {
                                            randomDelay = 1;
                                        }
                                        if (this.randomIncomingState % (float)(5 * randomDelay) == 0.0f) {
                                            int randomEntity;
                                            --this.randomIncomingEntities;
                                            int posX = this.getGateCenterPos().func_177958_n();
                                            int posY = this.getGateCenterPos().func_177956_o();
                                            int posZ = this.getGateCenterPos().func_177952_p();
                                            EntityZombie mobEntity = new EntityZombie(this.field_145850_b);
                                            int entitiesLength = entityList.size();
                                            if (entitiesLength > 0 && entityList.get(randomEntity = rand.nextInt(entitiesLength)) != null) {
                                                mobEntity = (Entity)entityList.get(randomEntity);
                                            }
                                            mobEntity.func_70012_b((double)posX, (double)posY, (double)posZ, 0.0f, 0.0f);
                                            if (this.isOpened() || this.irisType.equals((Object)EnumIrisType.NULL)) {
                                                this.field_145850_b.func_72838_d((Entity)mobEntity);
                                                AunisSoundHelper.playSoundEvent(this.field_145850_b, this.getGateCenterPos(), SoundEventEnum.WORMHOLE_GO);
                                            } else {
                                                if (this.isPhysicalIris()) {
                                                    AunisSoundHelper.playSoundEvent(this.field_145850_b, this.getGateCenterPos(), SoundEventEnum.IRIS_HIT);
                                                } else if (this.isShieldIris()) {
                                                    AunisSoundHelper.playSoundEvent(this.field_145850_b, this.getGateCenterPos(), SoundEventEnum.SHIELD_HIT);
                                                }
                                                ItemStack irisItem = this.getItemHandler().getStackInSlot(11);
                                                if (irisItem.func_77973_b() instanceof UpgradeIris) {
                                                    int chance = EnchantmentHelper.func_82781_a((ItemStack)irisItem).containsKey(Enchantments.field_185307_s) ? AunisConfig.irisConfig.unbreakingChance * EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)irisItem) : 0;
                                                    int random = rand.nextInt(100);
                                                    if (random > chance) {
                                                        AunisItems.UPGRADE_IRIS.setDamage(irisItem, AunisItems.UPGRADE_IRIS.getDamage(irisItem) + 1);
                                                    }
                                                    if (irisItem.func_190916_E() == 0) {
                                                        this.updateIrisType();
                                                    }
                                                } else {
                                                    IEnergyStorage energyStorage = (IEnergyStorage)this.getCapability(CapabilityEnergy.ENERGY, null);
                                                    if (energyStorage != null) {
                                                        energyStorage.extractEnergy(500, false);
                                                    }
                                                }
                                                this.sendSignal(null, "stargate_event_iris_hit", "Something just hit the IRIS!");
                                            }
                                        }
                                    } else if (this.randomIncomingEntities <= 0 && this.randomIncomingState >= (float)(waitOpen + wait) || this.stargateState != EnumStargateState.ENGAGED) {
                                        this.resetRandomIncoming();
                                        this.closeGate(StargateClosedReasonEnum.AUTOCLOSE);
                                        if (this instanceof StargatePegasusBaseTile) {
                                            ((StargatePegasusBaseTile)this).clearDHDSymbols();
                                        }
                                        if (this instanceof StargateMilkyWayBaseTile) {
                                            ((StargateMilkyWayBaseTile)this).clearDHDSymbols();
                                        }
                                    }
                                } else {
                                    this.resetRandomIncoming();
                                }
                            }
                        }
                        super.extractEnergyByShield(0);
                        if (!this.field_145850_b.field_72995_K && this.isShieldIris()) {
                            this.shieldKeepAlive = AunisConfig.irisConfig.shieldPowerDraw;
                            if (this.isClosed()) {
                                super.extractEnergyByShield(this.shieldKeepAlive);
                            }
                            if (this.getEnergyStorage().getEnergyStored() < this.shieldKeepAlive) {
                                this.toggleIris();
                                this.sendSignal(null, "stargate_iris_out_of_power", "Shield runs out of power! Opening shield...");
                            } else if (this.irisMode == EnumIrisMode.CLOSED && this.isOpened()) {
                                this.toggleIris();
                            }
                        }
                        super.func_73660_a();
                        if (this.field_145850_b.field_72995_K) break block59;
                        if (!this.lastPos.equals((Object)this.field_174879_c)) {
                            this.lastPos = this.field_174879_c;
                            this.generateAddresses(!this.hasUpgrade(StargateUpgradeEnum.CHEVRON_UPGRADE));
                            if (this.isMerged()) {
                                this.updateMergeState(this.onGateMergeRequested(), this.facing);
                            }
                        }
                        if (this.givePageTask != null && this.givePageTask.update(this.field_145850_b.func_82737_E())) {
                            this.givePageTask = null;
                        }
                        if (!this.doPageProgress) break block60;
                        if (this.field_145850_b.func_82737_E() % 2L == 0L) {
                            this.pageProgress = (short)(this.pageProgress + 1);
                            if (this.pageProgress > 18) {
                                this.pageProgress = 0;
                                this.doPageProgress = false;
                            }
                        }
                        if (!this.itemStackHandler.getStackInSlot(this.pageSlotId).func_190926_b()) break block61;
                        this.lockPage = false;
                        this.doPageProgress = false;
                        this.pageProgress = 0;
                        this.givePageTask = null;
                        break block61;
                    }
                    if (this.lockPage && this.itemStackHandler.getStackInSlot(this.pageSlotId).func_190926_b()) {
                        this.lockPage = false;
                    }
                    if (!this.lockPage) {
                        for (int i = 7; i < 10; ++i) {
                            if (this.itemStackHandler.getStackInSlot(i).func_190926_b()) continue;
                            this.doPageProgress = true;
                            this.lockPage = true;
                            this.pageSlotId = i;
                            this.givePageTask = new ScheduledTask(EnumScheduledTask.STARGATE_GIVE_PAGE, 36);
                            this.givePageTask.setTaskCreated(this.field_145850_b.func_82737_E());
                            this.givePageTask.setExecutor(this);
                            break;
                        }
                    }
                }
                if (!this.isClosed() && !this.isOpened() && this.field_145850_b.func_82737_E() - this.irisAnimation > (long)(this.isPhysicalIris() ? 60 : 10)) {
                    switch (this.irisState) {
                        case OPENING: {
                            this.irisState = EnumIrisState.OPENED;
                            this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.IRIS_UPDATE, 0, false, this.irisType, this.irisState, this.irisAnimation);
                            if (this.afterIrisDone != null) {
                                this.afterIrisDone.run();
                            }
                            this.afterIrisDone = null;
                            this.sendSignal(null, "stargate_iris_opened", "Iris is opened");
                            break;
                        }
                        case CLOSING: {
                            this.irisState = EnumIrisState.CLOSED;
                            this.setIrisBlocks(true);
                            this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.IRIS_UPDATE, 0, false, this.irisType, this.irisState, this.irisAnimation);
                            if (this.afterIrisDone != null) {
                                this.afterIrisDone.run();
                            }
                            this.afterIrisDone = null;
                            this.sendSignal(null, "stargate_iris_closed", "Iris is closed");
                            break;
                        }
                    }
                    this.func_70296_d();
                }
                break block62;
            }
            if (this.field_145850_b.func_82737_E() % 40L == 0L && this.rendererStateClient != null && this.getRendererStateClient().biomeOverride == null) {
                this.rendererStateClient.setBiomeOverlay(BiomeOverlayEnum.updateBiomeOverlay(this.field_145850_b, this.getMergeHelper().getTopBlock().func_177971_a((Vec3i)this.field_174879_c), this.getSupportedOverlays()));
            }
        }
    }

    @Override
    protected void kawooshDestruction() {
        if (!this.isClosed() || this.irisType == EnumIrisType.NULL) {
            super.kawooshDestruction();
        }
    }

    private BiomeOverlayEnum determineBiomeOverride() {
        ItemStack stack = this.itemStackHandler.getStackInSlot(10);
        if (stack.func_190926_b()) {
            return null;
        }
        BiomeOverlayEnum biomeOverlay = AunisConfig.stargateConfig.getBiomeOverrideItemMetaPairs().get(new ItemMetaPair(stack));
        if (this.getSupportedOverlays().contains((Object)biomeOverlay)) {
            return biomeOverlay;
        }
        return null;
    }

    @Override
    protected boolean shouldAutoclose() {
        boolean beamerActive = false;
        for (BlockPos beamerPos : this.linkedBeamers) {
            if (this.field_145850_b.func_175625_s(beamerPos) != null) {
                BeamerTile beamerTile = (BeamerTile)this.field_145850_b.func_175625_s(beamerPos);
                beamerActive = beamerTile.isActive();
            }
            if (!beamerActive) continue;
            break;
        }
        return !beamerActive && super.shouldAutoclose();
    }

    protected void func_190201_b(World world) {
        this.func_145834_a(world);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("itemHandler", (NBTBase)this.itemStackHandler.serializeNBT());
        compound.func_74757_a("isFinalActive", this.isFinalActive);
        compound.func_74757_a("isSpinning", this.isSpinning);
        compound.func_74772_a("spinStartTime", this.spinStartTime);
        compound.func_74768_a("currentRingSymbol", this.currentRingSymbol.getId());
        compound.func_74768_a("targetRingSymbol", this.targetRingSymbol.getId());
        compound.func_74768_a("spinDirection", this.spinDirection.id);
        NBTTagList linkedBeamersTagList = new NBTTagList();
        for (BlockPos vect : this.linkedBeamers) {
            linkedBeamersTagList.func_74742_a((NBTBase)new NBTTagLong(vect.func_177986_g()));
        }
        compound.func_74782_a("linkedBeamers", (NBTBase)linkedBeamersTagList);
        if (this.irisState == null) {
            if (this.codeSender != null) {
                this.codeSender.sendMessage((TextComponentBase)GDOMessages.OPENED.textComponent);
                this.codeSender = null;
            }
            this.irisState = EnumIrisState.OPENED;
        }
        compound.func_74774_a("irisState", this.irisState.id);
        compound.func_74768_a("irisCode", this.irisCode);
        compound.func_74774_a("irisMode", this.irisMode.id);
        if (this.codeSender != null && !this.field_145850_b.field_72995_K) {
            compound.func_74782_a("codeSender", (NBTBase)this.codeSender.serializeNBT());
        }
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.itemStackHandler.deserializeNBT(compound.func_74775_l("itemHandler"));
        if (compound.func_74767_n("hasUpgrade")) {
            this.itemStackHandler.setStackInSlot(0, new ItemStack(AunisItems.CRYSTAL_GLYPH_STARGATE));
        }
        this.isFinalActive = compound.func_74767_n("isFinalActive");
        this.isSpinning = compound.func_74767_n("isSpinning");
        this.spinStartTime = compound.func_74763_f("spinStartTime");
        this.currentRingSymbol = this.getSymbolType().valueOfSymbol(compound.func_74762_e("currentRingSymbol"));
        this.targetRingSymbol = this.getSymbolType().valueOfSymbol(compound.func_74762_e("targetRingSymbol"));
        this.spinDirection = EnumSpinDirection.valueOf(compound.func_74762_e("spinDirection"));
        for (NBTBase tag : compound.func_150295_c("linkedBeamers", 4)) {
            this.linkedBeamers.add(BlockPos.func_177969_a((long)((NBTTagLong)tag).func_150291_c()));
        }
        this.irisState = EnumIrisState.getValue(compound.func_74771_c("irisState"));
        this.irisCode = compound.func_74762_e("irisCode") != 0 ? compound.func_74762_e("irisCode") : -1;
        this.irisMode = EnumIrisMode.getValue(compound.func_74771_c("irisMode"));
        if (compound.func_74764_b("codeSender") && !this.field_145850_b.field_72995_K) {
            NBTTagCompound nbt = compound.func_74775_l("codeSender");
            this.codeSender = this.codeSenderFromNBT(nbt);
        }
        super.func_145839_a(compound);
    }

    private CodeSender codeSenderFromNBT(NBTTagCompound compound) {
        this.codeSender = CodeSenderType.fromId((int)compound.func_74762_e((String)"type")).constructor.get();
        switch (this.codeSender.getType()) {
            case PLAYER: {
                this.codeSender.prepareToLoad(new Object[]{this.field_145850_b});
                break;
            }
            case COMPUTER: {
                this.codeSender.prepareToLoad(null);
            }
        }
        this.codeSender.deserializeNBT((NBTBase)compound);
        return this.codeSender;
    }

    protected void updateChevronLight(int lightUp, boolean isFinalActive) {
        if (isFinalActive) {
            --lightUp;
        }
        for (int i = 0; i < 9; ++i) {
            BlockPos chevPos = this.getMergeHelper().getChevronBlocks().get(i).func_190942_a(FacingToRotation.get(this.facing)).func_177971_a((Vec3i)this.field_174879_c);
            if (!this.getMergeHelper().matchMember(this.field_145850_b.func_180495_p(chevPos))) continue;
            StargateClassicMemberTile memberTile = (StargateClassicMemberTile)this.field_145850_b.func_175625_s(chevPos);
            memberTile.setLitUp(i == 8 ? isFinalActive : lightUp > i);
        }
    }

    @Override
    protected StargateClassicRendererState.StargateClassicRendererStateBuilder getRendererStateServer() {
        return new StargateClassicRendererState.StargateClassicRendererStateBuilder(super.getRendererStateServer()).setSymbolType(this.getSymbolType()).setActiveChevrons(this.dialedAddress.size()).setFinalActive(this.isFinalActive).setCurrentRingSymbol(this.currentRingSymbol).setSpinDirection(this.spinDirection).setSpinning(this.isSpinning).setTargetRingSymbol(this.targetRingSymbol).setSpinStartTime(this.spinStartTime).setBiomeOverride(this.determineBiomeOverride()).setIrisState(this.irisState).setIrisType(this.irisType).setIrisMode(this.irisMode).setIrisCode(this.irisCode).setIrisAnimation(this.irisAnimation);
    }

    @Override
    public StargateClassicRendererState getRendererStateClient() {
        return (StargateClassicRendererState)super.getRendererStateClient();
    }

    @Override
    protected AunisAxisAlignedBB getRenderBoundingBoxRaw() {
        return RENDER_BOX;
    }

    protected long getSpinStartOffset() {
        return 0L;
    }

    @Override
    public State getState(StateTypeEnum stateType) {
        switch (stateType) {
            case GUI_STATE: {
                return new StargateContainerGuiState(this.gateAddressMap);
            }
            case GUI_UPDATE: {
                return new StargateContainerGuiUpdate(this.energyStorage.getEnergyStoredInternally(), this.energyTransferedLastTick, this.energySecondsToClose, this.irisMode, this.irisCode, this.getOpenedSecondsToDisplay());
            }
        }
        return super.getState(stateType);
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        switch (stateType) {
            case GUI_STATE: {
                return new StargateContainerGuiState();
            }
            case GUI_UPDATE: {
                return new StargateContainerGuiUpdate();
            }
            case SPIN_STATE: {
                return new StargateSpinState();
            }
            case BIOME_OVERRIDE_STATE: {
                return new StargateBiomeOverrideState();
            }
        }
        return super.createState(stateType);
    }

    @Override
    public void setState(StateTypeEnum stateType, State state) {
        block0 : switch (stateType) {
            case RENDERER_UPDATE: {
                if (this.getRendererStateClient() == null) {
                    return;
                }
                StargateRendererActionState gateActionState = (StargateRendererActionState)state;
                switch (gateActionState.action) {
                    case CHEVRON_ACTIVATE: {
                        if (gateActionState.modifyFinal) {
                            this.getRendererStateClient().chevronTextureList.activateFinalChevron(this.field_145850_b.func_82737_E());
                            break block0;
                        }
                        this.getRendererStateClient().chevronTextureList.activateNextChevron(this.field_145850_b.func_82737_E(), gateActionState.chevronCount);
                        break block0;
                    }
                    case CLEAR_CHEVRONS: {
                        this.getRendererStateClient().clearChevrons(this.field_145850_b.func_82737_E());
                        break block0;
                    }
                    case LIGHT_UP_CHEVRONS: {
                        this.getRendererStateClient().chevronTextureList.lightUpChevrons(this.field_145850_b.func_82737_E(), gateActionState.chevronCount);
                        break block0;
                    }
                    case CHEVRON_ACTIVATE_BOTH: {
                        this.getRendererStateClient().chevronTextureList.activateNextChevron(this.field_145850_b.func_82737_E());
                        this.getRendererStateClient().chevronTextureList.activateFinalChevron(this.field_145850_b.func_82737_E());
                        break block0;
                    }
                    case CHEVRON_DIM: {
                        this.getRendererStateClient().chevronTextureList.deactivateFinalChevron(this.field_145850_b.func_82737_E());
                        break block0;
                    }
                    case IRIS_UPDATE: {
                        this.getRendererStateClient().irisState = gateActionState.irisState;
                        this.getRendererStateClient().irisType = gateActionState.irisType;
                        if (gateActionState.irisState != EnumIrisState.CLOSING && gateActionState.irisState != EnumIrisState.OPENING) break block0;
                        this.getRendererStateClient().irisAnimation = this.field_145850_b.func_82737_E();
                        break block0;
                    }
                }
                break;
            }
            case GUI_STATE: {
                StargateContainerGuiState guiState = (StargateContainerGuiState)state;
                this.gateAddressMap = guiState.gateAdddressMap;
                break;
            }
            case GUI_UPDATE: {
                StargateContainerGuiUpdate guiUpdate = (StargateContainerGuiUpdate)state;
                this.energyStorage.setEnergyStoredInternally(guiUpdate.energyStored);
                this.energyTransferedLastTick = guiUpdate.transferedLastTick;
                this.energySecondsToClose = guiUpdate.secondsToClose;
                this.irisMode = guiUpdate.irisMode;
                this.irisCode = guiUpdate.irisCode;
                this.secondsOpened = guiUpdate.openedSeconds;
                break;
            }
            case SPIN_STATE: {
                StargateSpinState spinState = (StargateSpinState)state;
                if (spinState.setOnly) {
                    this.getRendererStateClient().spinHelper.setIsSpinning(false);
                    this.getRendererStateClient().spinHelper.setCurrentSymbol(spinState.targetSymbol);
                    break;
                }
                this.getRendererStateClient().spinHelper.initRotation(this.field_145850_b.func_82737_E(), spinState.targetSymbol, spinState.direction, this.getSpinStartOffset(), spinState.plusRounds);
                break;
            }
            case BIOME_OVERRIDE_STATE: {
                StargateBiomeOverrideState overrideState = (StargateBiomeOverrideState)state;
                if (this.rendererStateClient == null) break;
                this.getRendererStateClient().biomeOverride = overrideState.biomeOverride;
                break;
            }
        }
        super.setState(stateType, state);
    }

    @Override
    public void executeTask(EnumScheduledTask scheduledTask, NBTTagCompound customData) {
        switch (scheduledTask) {
            case STARGATE_HORIZON_LIGHT_BLOCK: {
                if (this.irisType == EnumIrisType.NULL || !this.isClosed()) {
                    super.executeTask(scheduledTask, customData);
                    break;
                }
                if (!this.isClosed()) break;
                this.field_145850_b.func_180495_p(this.getGateCenterPos()).func_177230_c().func_149715_a(0.7f);
                break;
            }
            case STARGATE_CLOSE: {
                if (this.irisType == EnumIrisType.NULL || !this.isClosed()) {
                    super.executeTask(scheduledTask, customData);
                    break;
                }
                if (!this.isClosed()) break;
                this.field_145850_b.func_180495_p(this.getGateCenterPos()).func_177230_c().func_149715_a(0.0f);
                this.disconnectGate();
                break;
            }
            case STARGATE_SPIN_FINISHED: {
                this.isSpinning = false;
                this.currentRingSymbol = this.targetRingSymbol;
                if (!(this instanceof StargatePegasusBaseTile)) {
                    this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, false);
                } else if (!((StargatePegasusBaseTile)this).continueDialing) {
                    this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, false);
                }
                this.playSoundEvent(StargateSoundEventEnum.CHEVRON_SHUT);
                this.func_70296_d();
                break;
            }
            case STARGATE_GIVE_PAGE: {
                SymbolTypeEnum symbolType = SymbolTypeEnum.valueOf(this.pageSlotId - 7);
                ItemStack stack = this.itemStackHandler.getStackInSlot(this.pageSlotId);
                if (stack.func_77973_b() == AunisItems.UNIVERSE_DIALER) {
                    NBTTagList saved = stack.func_77978_p().func_150295_c("saved", 10);
                    NBTTagCompound compound = ((StargateAddress)this.gateAddressMap.get(symbolType)).serializeNBT();
                    compound.func_74757_a("hasUpgrade", this.hasUpgrade(StargateUpgradeEnum.CHEVRON_UPGRADE));
                    saved.func_74742_a((NBTBase)compound);
                    break;
                }
                Aunis.logger.debug("Giving Notebook page of address " + symbolType);
                NBTTagCompound compound = PageNotebookItem.getCompoundFromAddress((StargateAddress)this.gateAddressMap.get(symbolType), this.hasUpgrade(StargateUpgradeEnum.CHEVRON_UPGRADE), PageNotebookItem.getRegistryPathFromWorld(this.field_145850_b, this.field_174879_c));
                stack = new ItemStack((Item)AunisItems.PAGE_NOTEBOOK_ITEM, 1, 1);
                stack.func_77982_d(compound);
                this.itemStackHandler.setStackInSlot(this.pageSlotId, stack);
                break;
            }
            default: {
                super.executeTask(scheduledTask, customData);
            }
        }
    }

    public void addSymbolToAddressManual(SymbolInterface targetSymbol, @Nullable Object context) {
        this.targetRingSymbol = targetSymbol;
        boolean moveOnly = this.targetRingSymbol == this.currentRingSymbol;
        int plusRounds = 0;
        if (moveOnly && targetSymbol instanceof SymbolUniverseEnum && !targetSymbol.equals(SymbolUniverseEnum.G37)) {
            this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_SPIN_FINISHED, 0));
            this.doIncomingAnimation(10, true);
        } else if (targetSymbol instanceof SymbolUniverseEnum && targetSymbol.equals(SymbolUniverseEnum.G37)) {
            this.spinDirection = this.spinDirection.opposite();
            float distance = 360.0f;
            int duration = StargateClassicSpinHelper.getAnimationDuration(distance);
            this.doIncomingAnimation(duration, true);
            AunisPacketHandler.INSTANCE.sendToAllTracking((IMessage)new StateUpdatePacketToClient(this.field_174879_c, StateTypeEnum.SPIN_STATE, new StargateSpinState(this.targetRingSymbol, this.spinDirection, false, 0)), this.targetPoint);
            this.lastSpinFinished = new ScheduledTask(EnumScheduledTask.STARGATE_SPIN_FINISHED, duration - 5);
            this.addTask(this.lastSpinFinished);
            this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, true);
            this.targetRingSymbol = SymbolUniverseEnum.TOP_CHEVRON;
            this.isSpinning = true;
            this.spinStartTime = this.field_145850_b.func_82737_E();
            this.ringSpinContext = null;
            this.func_70296_d();
        } else {
            this.spinDirection = this.spinDirection.opposite();
            float distance = this.spinDirection.getDistance(this.currentRingSymbol, this.targetRingSymbol);
            if (moveOnly) {
                distance = 360.0f;
                ++plusRounds;
            }
            if (!AunisConfig.stargateConfig.fasterMWGateDial) {
                if (distance < 90.0f) {
                    distance += 360.0f;
                    ++plusRounds;
                }
                if (distance < 270.0f) {
                    if (this instanceof StargateMilkyWayBaseTile && this.targetRingSymbol == SymbolMilkyWayEnum.getOrigin()) {
                        distance += 360.0f;
                        ++plusRounds;
                    }
                    if (this instanceof StargateUniverseBaseTile && this.targetRingSymbol == SymbolUniverseEnum.getOrigin()) {
                        distance += 360.0f;
                        ++plusRounds;
                    }
                }
            } else if (distance > 180.0f) {
                this.spinDirection = this.spinDirection.opposite();
                distance = this.spinDirection.getDistance(this.currentRingSymbol, this.targetRingSymbol);
                plusRounds = 0;
            }
            int duration = StargateClassicSpinHelper.getAnimationDuration(distance);
            this.doIncomingAnimation(duration, true);
            AunisPacketHandler.INSTANCE.sendToAllTracking((IMessage)new StateUpdatePacketToClient(this.field_174879_c, StateTypeEnum.SPIN_STATE, new StargateSpinState(this.targetRingSymbol, this.spinDirection, false, plusRounds)), this.targetPoint);
            this.lastSpinFinished = new ScheduledTask(EnumScheduledTask.STARGATE_SPIN_FINISHED, duration - 5);
            this.addTask(this.lastSpinFinished);
            this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, true);
            this.isSpinning = true;
            this.spinStartTime = this.field_145850_b.func_82737_E();
            this.ringSpinContext = context;
            if (context != null) {
                this.sendSignal(context, "stargate_spin_start", this.dialedAddress.size(), this.stargateWillLock(this.targetRingSymbol), targetSymbol.getEnglishName());
            }
            this.func_70296_d();
        }
    }

    public short getPageProgress() {
        return this.pageProgress;
    }

    public void setPageProgress(int pageProgress) {
        this.pageProgress = (short)pageProgress;
    }

    public abstract int getSupportedCapacitors();

    public void updateIrisType() {
        this.updateIrisType(true);
    }

    public void updateIrisType(boolean markDirty) {
        this.irisType = EnumIrisType.byItem(this.itemStackHandler.getStackInSlot(11).func_77973_b());
        this.irisAnimation = this.func_145831_w().func_82737_E();
        if (this.irisType == EnumIrisType.NULL) {
            this.irisState = EnumIrisState.OPENED;
        }
        this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.IRIS_UPDATE, 0, false, this.irisType, this.irisState, this.irisAnimation);
        this.updateIrisDurability();
        if (markDirty) {
            this.func_70296_d();
        }
        if (!this.field_145850_b.field_72995_K && this.isOpened()) {
            this.setIrisBlocks(false);
        }
    }

    public void updateIrisDurability() {
        this.irisDurability = 0;
        this.irisMaxDurability = 0;
        if (this.isPhysicalIris()) {
            this.irisMaxDurability = this.irisType == EnumIrisType.IRIS_TITANIUM ? AunisConfig.irisConfig.titaniumIrisDurability : AunisConfig.irisConfig.triniumIrisDurability;
            this.irisDurability = this.irisMaxDurability - this.itemStackHandler.getStackInSlot(11).func_77973_b().getDamage(this.itemStackHandler.getStackInSlot(11));
        }
    }

    public int getIrisDurability() {
        this.updateIrisDurability();
        return this.irisDurability;
    }

    public int getIrisMaxDurability() {
        this.updateIrisDurability();
        return this.irisDurability;
    }

    public EnumIrisType getIrisType() {
        return this.irisType;
    }

    public EnumIrisState getIrisState() {
        return this.irisState;
    }

    public boolean isClosed() {
        return this.irisState == EnumIrisState.CLOSED;
    }

    public boolean isOpened() {
        return this.irisState == EnumIrisState.OPENED;
    }

    public boolean isPhysicalIris() {
        switch (this.irisType) {
            case IRIS_TITANIUM: 
            case IRIS_TRINIUM: {
                return true;
            }
        }
        return false;
    }

    public boolean hasIris() {
        return this.irisType != EnumIrisType.NULL;
    }

    public boolean isShieldIris() {
        return this.irisType == EnumIrisType.SHIELD;
    }

    public boolean toggleIris() {
        SoundEventEnum closeSound;
        SoundEventEnum openSound;
        if (this.irisType == EnumIrisType.NULL) {
            return false;
        }
        if (this.isClosed() || this.isOpened()) {
            this.irisAnimation = this.func_145831_w().func_82737_E();
        }
        if (this.isPhysicalIris()) {
            openSound = SoundEventEnum.IRIS_OPENING;
            closeSound = SoundEventEnum.IRIS_CLOSING;
        } else {
            openSound = SoundEventEnum.SHIELD_OPENING;
            closeSound = SoundEventEnum.SHIELD_CLOSING;
        }
        switch (this.irisState) {
            case OPENED: {
                if (this.isShieldIris() && this.getEnergyStorage().getEnergyStored() < this.shieldKeepAlive * 3) {
                    return false;
                }
                this.irisState = EnumIrisState.CLOSING;
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.IRIS_UPDATE, 0, true, this.irisType, this.irisState, this.irisAnimation);
                this.sendSignal(null, "stargate_iris_closing", "Iris is closing");
                this.func_70296_d();
                this.playSoundEvent(closeSound);
                if (this.targetGatePos == null) break;
                this.executeTask(EnumScheduledTask.STARGATE_HORIZON_LIGHT_BLOCK, null);
                break;
            }
            case CLOSED: {
                this.irisState = EnumIrisState.OPENING;
                this.setIrisBlocks(false);
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.IRIS_UPDATE, 0, true, this.irisType, this.irisState, this.irisAnimation);
                this.sendSignal(null, "stargate_iris_opening", "Iris is opening");
                this.func_70296_d();
                this.playSoundEvent(openSound);
                if (this.targetGatePos == null) break;
                this.executeTask(EnumScheduledTask.STARGATE_HORIZON_LIGHT_BLOCK, null);
                break;
            }
            default: {
                return false;
            }
        }
        this.func_70296_d();
        return true;
    }

    public void receiveIrisCode(CodeSender sender, int code) {
        this.sendSignal(null, "received_code", code);
        if (this.irisMode != EnumIrisMode.AUTO) {
            sender.sendMessage((TextComponentBase)GDOMessages.SEND_TO_COMPUTER.textComponent);
            this.codeSender = sender;
            return;
        }
        if (code == this.irisCode) {
            switch (this.irisState) {
                case OPENED: {
                    sender.sendMessage((TextComponentBase)GDOMessages.OPENED.textComponent);
                    break;
                }
                case CLOSED: {
                    sender.sendMessage((TextComponentBase)GDOMessages.CODE_ACCEPTED.textComponent);
                    this.codeSender = sender;
                    this.toggleIris();
                    break;
                }
                case OPENING: 
                case CLOSING: {
                    sender.sendMessage((TextComponentBase)GDOMessages.BUSY.textComponent);
                    break;
                }
            }
        } else {
            sender.sendMessage((TextComponentBase)GDOMessages.CODE_REJECTED.textComponent);
        }
        this.func_70296_d();
    }

    public void setIrisCode(int code) {
        this.irisCode = code;
        this.func_70296_d();
    }

    public void setIrisMode(EnumIrisMode irisMode) {
        if (this.irisMode != irisMode && this.hasIris()) {
            switch (irisMode) {
                case OPENED: 
                case CLOSED: {
                    this.irisModeAction(irisMode);
                    break;
                }
                case AUTO: {
                    if (this.getStargateState().engaged()) {
                        if (this.irisState != EnumIrisState.OPENED) break;
                        this.toggleIris();
                        break;
                    }
                    if (!this.isClosed()) break;
                    this.toggleIris();
                    break;
                }
            }
        }
        this.irisMode = irisMode;
        this.func_70296_d();
    }

    private void irisModeAction(EnumIrisMode mode) {
        EnumIrisState p2;
        EnumIrisState p;
        if (mode == EnumIrisMode.OPENED) {
            p = EnumIrisState.CLOSED;
            p2 = EnumIrisState.CLOSING;
        } else if (mode == EnumIrisMode.CLOSED) {
            p = EnumIrisState.OPENED;
            p2 = EnumIrisState.OPENING;
        } else {
            return;
        }
        if (this.irisState == p) {
            this.toggleIris();
        } else if (this.irisState == p2) {
            this.afterIrisDone = this::toggleIris;
        }
    }

    public int getIrisCode() {
        return this.irisCode;
    }

    public EnumIrisMode getIrisMode() {
        return this.irisMode;
    }

    private void setIrisBlocks(boolean set) {
        IBlockState invBlockState = AunisBlocks.IRIS_BLOCK.func_176223_P();
        if (set) {
            invBlockState = AunisBlocks.IRIS_BLOCK.func_176203_a(this.getFacing().func_176736_b());
        }
        Rotation invBlocksRotation = FacingToRotation.get(this.facing);
        BlockPos startPos = this.field_174879_c;
        for (BlockPos invPos : Objects.requireNonNull(StargateSizeEnum.getIrisBLocksPatter(this.getStargateSize()))) {
            BlockPos newPos = startPos.func_177971_a((Vec3i)invPos.func_190942_a(invBlocksRotation));
            if (set) {
                if (this.field_145850_b.func_180495_p(newPos).func_185904_a() != Material.field_151579_a) {
                    if (!AunisConfig.irisConfig.irisDestroysBlocks) continue;
                    this.field_145850_b.func_175655_b(newPos, true);
                }
                this.field_145850_b.func_180501_a(newPos, invBlockState, 3);
                if (newPos != this.getGateCenterPos() || this.targetGatePos == null) continue;
                this.field_145850_b.func_180495_p(newPos).func_177230_c().func_149715_a(1.0f);
                continue;
            }
            if (newPos == this.getGateCenterPos() && this.targetGatePos != null) {
                this.executeTask(EnumScheduledTask.STARGATE_HORIZON_LIGHT_BLOCK, null);
            }
            if (this.field_145850_b.func_180495_p(newPos).func_177230_c() != AunisBlocks.IRIS_BLOCK) continue;
            this.field_145850_b.func_175698_g(newPos);
        }
    }

    @Nonnull
    abstract StargateSizeEnum getStargateSize();

    @Override
    public Iterator<Integer> getUpgradeSlotsIterator() {
        return UPGRADE_SLOTS_IDS.iterator();
    }

    @Override
    protected StargateAbstractEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public int getPowerTier() {
        return this.currentPowerTier;
    }

    private void updatePowerTier() {
        int i;
        int powerTier = 1;
        for (i = 4; i < 7; ++i) {
            if (this.itemStackHandler.getStackInSlot(i).func_190926_b()) continue;
            ++powerTier;
        }
        if (powerTier != this.currentPowerTier) {
            this.currentPowerTier = powerTier;
            this.energyStorage.clearStorages();
            for (i = 4; i < 7; ++i) {
                ItemStack stack = this.itemStackHandler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                this.energyStorage.addStorage((IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null));
            }
            Aunis.logger.debug("Updated to power tier: " + powerTier);
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == null || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == null) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemStackHandler);
        }
        return super.getCapability(capability, facing);
    }

    public void addLinkedBeamer(BlockPos pos) {
        if (this.stargateState.engaged()) {
            ((BeamerTile)this.field_145850_b.func_175625_s(pos)).gateEngaged(this.targetGatePos);
        }
        this.linkedBeamers.add(pos.func_185334_h());
        this.func_70296_d();
    }

    public void removeLinkedBeamer(BlockPos pos) {
        this.linkedBeamers.remove(pos);
        this.func_70296_d();
    }

    private void updateBeamers() {
        if (this.stargateState.engaged()) {
            for (BlockPos beamerPos : this.linkedBeamers) {
                if (this.field_145850_b.func_175625_s(beamerPos) == null) continue;
                ((BeamerTile)Objects.requireNonNull(this.field_145850_b.func_175625_s(beamerPos))).gateEngaged(this.targetGatePos);
            }
        }
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] getOpenedTime(Context context, Arguments args) {
        if (this.stargateState.engaged()) {
            String secondsString;
            int minutes;
            float openedSeconds = this.getOpenedSecondsToDisplay();
            int seconds = (int)(openedSeconds - (float)(60 * (minutes = (int)Math.floor(openedSeconds / 60.0f))));
            String string = secondsString = seconds < 10 ? "0" + seconds : "" + seconds;
            if (openedSeconds > 0.0f) {
                return new Object[]{true, "stargate_time", "" + minutes, "" + secondsString};
            }
            return new Object[]{false, "stargate_not_connected"};
        }
        return new Object[]{false, "stargate_not_connected"};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function() -- close/open the iris/shield")
    public Object[] toggleIris(Context context, Arguments args) {
        if (this.irisType == EnumIrisType.NULL) {
            return new Object[]{false, "stargate_iris_missing", "Iris is not installed!"};
        }
        if (this.irisMode != EnumIrisMode.OC) {
            return new Object[]{false, "stargate_iris_error_mode", "Iris mode must be set to OC"};
        }
        boolean result = this.toggleIris();
        this.func_70296_d();
        if (!result && this.isShieldIris() && this.isOpened() && this.getEnergyStorage().getEnergyStored() < this.shieldKeepAlive * 3) {
            return new Object[]{false, "stargate_iris_not_power", "Not enough power to close shield"};
        }
        if (!result) {
            return new Object[]{false, "stargate_iris_busy", "Iris is busy"};
        }
        if (result) {
            return new Object[]{true};
        }
        return new Object[]{false, "stargate_iris_error_unknown", "Unknow error while toggling iris!"};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function() -- get info about iris")
    public Object[] getIrisState(Context context, Arguments args) {
        return new Object[]{this.irisState.toString()};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function() -- get info about iris")
    public Object[] getIrisType(Context context, Arguments args) {
        return new Object[]{this.irisType.toString()};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function() -- get info about iris")
    public Object[] getIrisDurability(Context context, Arguments args) {
        this.updateIrisDurability();
        return new Object[]{this.irisDurability + "/" + this.irisMaxDurability, this.irisDurability, this.irisMaxDurability};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function(message:string) -- Sends message to last person, who sent code for iris")
    public Object[] sendMessageToIncoming(Context context, Arguments args) {
        if (!this.isMerged()) {
            return new Object[]{null, "stargate_failure_not_merged", "Stargate is not merged"};
        }
        if (!this.stargateState.engaged()) {
            return new Object[]{null, "stargate_failure_not_engaged", "Stargate is not engaged"};
        }
        if (!args.isString(0)) {
            return new Object[]{false, "wrong_argument_type"};
        }
        if (this.codeSender != null && this.codeSender.canReceiveMessage()) {
            this.codeSender.sendMessage((TextComponentBase)new TextComponentString(args.checkString(0)));
            return new Object[]{true, "success"};
        }
        return new Object[]{false, "no_listener_available"};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function(code:integer) -- send code like GDO")
    public Object[] sendIrisCode(Context context, Arguments args) {
        StargatePos destinationPos = StargateNetwork.get(this.field_145850_b).getStargate(this.dialedAddress);
        if (!args.isInteger(0)) {
            throw new IllegalArgumentException("code must be integer!");
        }
        if (destinationPos == null) {
            return new Object[]{false, "stargate_not_engaged"};
        }
        StargateAbstractBaseTile te = destinationPos.getTileEntity();
        if (!(te instanceof StargateClassicBaseTile)) {
            return new Object[]{false, "invalid_target_gate"};
        }
        ((StargateClassicBaseTile)te).receiveIrisCode(new ComputerCodeSender(StargateNetwork.get(this.field_145850_b).getStargate(this.getStargateAddress(SymbolTypeEnum.MILKYWAY))), args.checkInteger(0));
        return new Object[]{true, "success"};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function(symbolName:string) -- Spins the ring to the given symbol and engages/locks it")
    public Object[] engageSymbol(Context context, Arguments args) {
        if (!this.isMerged()) {
            return new Object[]{null, "stargate_failure_not_merged", "Stargate is not merged"};
        }
        if (!this.stargateState.idle()) {
            return new Object[]{null, "stargate_failure_busy", "Stargate is busy, state: " + this.stargateState.toString()};
        }
        if (this.dialedAddress.size() == 9) {
            return new Object[]{null, "stargate_failure_full", "Already dialed 9 chevrons"};
        }
        SymbolInterface targetSymbol = this.getSymbolFromNameIndex(args.checkAny(0));
        if (targetSymbol == SymbolPegasusEnum.UNKNOW1 || targetSymbol == SymbolPegasusEnum.UNKNOW2) {
            throw new IllegalArgumentException("bad argument (symbol name/index invalid)");
        }
        this.addSymbolToAddressManual(targetSymbol, context);
        this.func_70296_d();
        return new Object[]{"stargate_spin"};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function() - aborts dialing")
    public Object[] abortDialing(Context context, Arguments args) {
        if (!this.isMerged()) {
            return new Object[]{null, "stargate_failure_not_merged", "Stargate is not merged"};
        }
        if (this.stargateState.dialingComputer() || this.stargateState.idle()) {
            this.abortDialingSequence(1);
            this.func_70296_d();
            return new Object[]{null, "stargate_aborting", "Aborting dialing"};
        }
        return new Object[]{null, "stargate_aborting_failed", "Aborting dialing failed"};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function() -- Tries to open the gate")
    public Object[] engageGate(Context context, Arguments args) {
        if (!this.isMerged()) {
            return new Object[]{null, "stargate_failure_not_merged", "Stargate is not merged"};
        }
        if (this.stargateState.idle()) {
            StargateOpenResult gateState = this.attemptOpenAndFail();
            if (gateState.ok()) {
                return new Object[]{"stargate_engage"};
            }
            this.sendSignal(null, "stargate_failed", new Object[0]);
            return new Object[]{null, "stargate_failure_opening", "Stargate failed to open", gateState.toString()};
        }
        return new Object[]{null, "stargate_failure_busy", "Stargate is busy", this.stargateState.toString()};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function() -- Tries to close the gate")
    public Object[] disengageGate(Context context, Arguments args) {
        if (!this.isMerged()) {
            return new Object[]{null, "stargate_failure_not_merged", "Stargate is not merged"};
        }
        if (this.stargateState.engaged()) {
            if (this.getStargateState().initiating()) {
                this.attemptClose(StargateClosedReasonEnum.REQUESTED);
                return new Object[]{"stargate_disengage"};
            }
            return new Object[]{null, "stargate_failure_wrong_end", "Unable to close the gate on this end"};
        }
        return new Object[]{null, "stargate_failure_not_open", "The gate is closed"};
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] getCapacitorsInstalled(Context context, Arguments args) {
        return new Object[]{this.isMerged() ? Integer.valueOf(this.currentPowerTier - 1) : null};
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] getGateType(Context context, Arguments args) {
        return new Object[]{this.isMerged() ? this.getSymbolType() : null};
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] getGateStatus(Context context, Arguments args) {
        if (!this.isMerged()) {
            return new Object[]{"not_merged"};
        }
        if (this.stargateState.engaged()) {
            return new Object[]{"open", this.stargateState.initiating()};
        }
        return new Object[]{this.stargateState.toString().toLowerCase()};
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] getEnergyRequiredToDial(Context context, Arguments args) {
        if (!this.isMerged()) {
            return new Object[]{"not_merged"};
        }
        StargateAddressDynamic stargateAddress = new StargateAddressDynamic(this.getSymbolType());
        Iterator iter = null;
        iter = args.isTable(0) ? args.checkTable(0).values().iterator() : args.iterator();
        while (iter.hasNext()) {
            Object symbolObj = iter.next();
            if (stargateAddress.size() == 9) {
                throw new IllegalArgumentException("Too much glyphs");
            }
            SymbolInterface symbol = this.getSymbolFromNameIndex(symbolObj);
            if (stargateAddress.contains(symbol)) {
                throw new IllegalArgumentException("Duplicate glyph");
            }
            stargateAddress.addSymbol(symbol);
        }
        if (!stargateAddress.getLast().origin() && stargateAddress.size() < 9) {
            stargateAddress.addOrigin();
        }
        if (!stargateAddress.validate()) {
            return new Object[]{"address_malformed"};
        }
        if (!this.canDialAddress(stargateAddress)) {
            return new Object[]{"address_malformed"};
        }
        StargateEnergyRequired energyRequired = this.getEnergyRequiredToDial(this.network.getStargate(stargateAddress));
        HashMap<String, Constable> energyMap = new HashMap<String, Constable>(2);
        energyMap.put("open", Integer.valueOf(energyRequired.energyToOpen));
        energyMap.put("keepAlive", Integer.valueOf(energyRequired.keepAlive));
        energyMap.put("canOpen", Boolean.valueOf(this.getEnergyStorage().getEnergyStored() >= energyRequired.energyToOpen));
        return new Object[]{energyMap};
    }

    public static enum StargateIrisUpgradeEnum implements EnumKeyInterface<Item>
    {
        IRIS_UPGRADE_CLASSIC(AunisItems.UPGRADE_IRIS),
        IRIS_UPGRADE_TRINIUM(AunisItems.UPGRADE_IRIS_TRINIUM),
        IRIS_UPGRADE_SHIELD(AunisItems.UPGRADE_SHIELD);

        public Item item;
        private static final EnumKeyMap<Item, StargateIrisUpgradeEnum> idMap;

        private StargateIrisUpgradeEnum(Item item) {
            this.item = item;
        }

        @Override
        public Item getKey() {
            return this.item;
        }

        public static StargateIrisUpgradeEnum valueOf(Item item) {
            return idMap.valueOf(item);
        }

        public static boolean contains(Item item) {
            return idMap.contains(item);
        }

        static {
            idMap = new EnumKeyMap((EnumKeyInterface[])StargateIrisUpgradeEnum.values());
        }
    }

    public static enum StargateUpgradeEnum implements EnumKeyInterface<Item>
    {
        MILKYWAY_GLYPHS(AunisItems.CRYSTAL_GLYPH_MILKYWAY),
        PEGASUS_GLYPHS(AunisItems.CRYSTAL_GLYPH_PEGASUS),
        UNIVERSE_GLYPHS(AunisItems.CRYSTAL_GLYPH_UNIVERSE),
        CHEVRON_UPGRADE(AunisItems.CRYSTAL_GLYPH_STARGATE);

        public Item item;
        private static final EnumKeyMap<Item, StargateUpgradeEnum> idMap;

        private StargateUpgradeEnum(Item item) {
            this.item = item;
        }

        @Override
        public Item getKey() {
            return this.item;
        }

        public static StargateUpgradeEnum valueOf(Item item) {
            return idMap.valueOf(item);
        }

        public static boolean contains(Item item) {
            return idMap.contains(item);
        }

        static {
            idMap = new EnumKeyMap((EnumKeyInterface[])StargateUpgradeEnum.values());
        }
    }
}

