/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.tileentity.energy;

import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.gui.container.zpm.ZPMContainerGuiUpdate;
import mrjake.aunis.packet.AunisPacketHandler;
import mrjake.aunis.packet.StateUpdatePacketToClient;
import mrjake.aunis.packet.StateUpdateRequestToServer;
import mrjake.aunis.renderer.energy.ZPMRendererState;
import mrjake.aunis.stargate.power.StargateAbstractEnergyStorage;
import mrjake.aunis.state.State;
import mrjake.aunis.state.StateTypeEnum;
import mrjake.aunis.tileentity.energy.CapacitorTile;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ZPMTile
extends CapacitorTile {
    private ZPMRendererState rendererStateClient;
    protected StargateAbstractEnergyStorage energyStorage;

    public ZPMTile() {
        this.energyStorage = new StargateAbstractEnergyStorage(AunisConfig.powerConfig.zpmEnergyStorage){

            @Override
            protected void onEnergyChanged() {
                ZPMTile.this.func_70296_d();
            }
        };
    }

    @Override
    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            AunisPacketHandler.INSTANCE.sendToServer((IMessage)new StateUpdateRequestToServer(this.field_174879_c, StateTypeEnum.RENDERER_UPDATE));
            AunisPacketHandler.INSTANCE.sendToServer((IMessage)new StateUpdateRequestToServer(this.field_174879_c, StateTypeEnum.RENDERER_STATE));
        } else {
            super.onLoad();
        }
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.setPowerLevel(Math.round((float)this.getEnergyStorage().getEnergyStored() / (float)AunisConfig.powerConfig.zpmEnergyStorage * 10.0f));
            if (this.getPowerLevel() != this.getLastPowerLevel()) {
                AunisPacketHandler.INSTANCE.sendToAllTracking((IMessage)new StateUpdatePacketToClient(this.field_174879_c, StateTypeEnum.RENDERER_UPDATE, this.getState(StateTypeEnum.RENDERER_UPDATE)), this.getTargetPoint());
                this.setLastPowerLevel(this.getPowerLevel());
            }
            this.energyTransferedLastTick = this.getEnergyStorage().getEnergyStored() - this.energyStoredLastTick;
            this.energyStoredLastTick = this.getEnergyStorage().getEnergyStored();
        }
    }

    public ZPMRendererState getRendererStateClient() {
        return this.rendererStateClient;
    }

    @Override
    public StargateAbstractEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return false;
    }

    @Override
    public State getState(StateTypeEnum stateType) {
        switch (stateType) {
            case GUI_UPDATE: {
                return new ZPMContainerGuiUpdate(this.getEnergyStorage().getEnergyStored(), this.energyTransferedLastTick);
            }
            case RENDERER_STATE: 
            case RENDERER_UPDATE: {
                return new ZPMRendererState(Math.round((float)this.getPowerLevel() / 2.0f));
            }
        }
        return super.getState(stateType);
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        switch (stateType) {
            case GUI_UPDATE: {
                return new ZPMContainerGuiUpdate();
            }
            case RENDERER_STATE: 
            case RENDERER_UPDATE: {
                return new ZPMRendererState();
            }
        }
        return super.createState(stateType);
    }

    @Override
    public void setState(StateTypeEnum stateType, State state) {
        switch (stateType) {
            case GUI_UPDATE: {
                ZPMContainerGuiUpdate guiUpdate = (ZPMContainerGuiUpdate)state;
                this.energyStorage.setEnergyStored(guiUpdate.energyStored);
                this.energyTransferedLastTick = guiUpdate.energyTransferedLastTick;
                break;
            }
            case RENDERER_STATE: {
                this.rendererStateClient = ((ZPMRendererState)state).initClient(this.field_174879_c, Math.round((float)this.getPowerLevel() / 2.0f));
                break;
            }
            case RENDERER_UPDATE: {
                this.setPowerLevel(((ZPMRendererState)state).powerLevel);
                break;
            }
            default: {
                super.setState(stateType, state);
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
    }
}

