/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.tileentity.energy;

import java.util.ArrayList;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.stream.IntStream;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Packet;
import li.cil.oc.api.network.WirelessEndpoint;
import mrjake.aunis.Aunis;
import mrjake.aunis.AunisProps;
import mrjake.aunis.block.AunisBlocks;
import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.gui.container.zpmhub.ZPMHubContainerGuiUpdate;
import mrjake.aunis.packet.AunisPacketHandler;
import mrjake.aunis.packet.StateUpdatePacketToClient;
import mrjake.aunis.packet.StateUpdateRequestToServer;
import mrjake.aunis.renderer.energy.ZPMHubRendererState;
import mrjake.aunis.sound.AunisSoundHelper;
import mrjake.aunis.sound.SoundPositionedEnum;
import mrjake.aunis.stargate.power.StargateAbstractEnergyStorage;
import mrjake.aunis.state.State;
import mrjake.aunis.state.StateProviderInterface;
import mrjake.aunis.state.StateTypeEnum;
import mrjake.aunis.util.AunisItemStackHandler;
import mrjake.aunis.zpm.EnumZPMState;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.Environment", modid="opencomputers"), @Optional.Interface(iface="li.cil.oc.api.network.WirelessEndpoint", modid="opencomputers")})
public class ZPMHubTile
extends TileEntity
implements ITickable,
ICapabilityProvider,
StateProviderInterface,
Environment,
WirelessEndpoint {
    private long animationStart;
    private boolean isPutting = false;
    private int zpmsCount = 0;
    public int zpmAnimated = 0;
    private ArrayList<EnumZPMState> zpmStates = new ArrayList(3);
    public ArrayList<Integer> lastZPMPowerLevel = new ArrayList(3);
    public ArrayList<Integer> lastZPMPower = new ArrayList(3);
    public final AunisItemStackHandler itemStackHandler = new AunisItemStackHandler(3){

        public boolean isItemValid(int slot, ItemStack stack) {
            Item item = stack.func_77973_b();
            switch (slot) {
                case 0: 
                case 1: 
                case 2: {
                    if (ZPMHubTile.this.zpmAnimated != 0) {
                        return false;
                    }
                    return item == Item.func_150898_a((Block)AunisBlocks.ZPM);
                }
            }
            return true;
        }

        protected int getStackLimit(int slot, ItemStack stack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            switch (slot) {
                case 0: 
                case 1: 
                case 2: {
                    boolean putting = !this.getStackInSlot(slot).func_190926_b();
                    int zpmsCount = 0;
                    for (int i = 0; i < 3; ++i) {
                        if (ZPMHubTile.this.lastZPMPowerLevel.size() < i + 1) {
                            ZPMHubTile.this.lastZPMPowerLevel.add(0);
                        }
                        if (ZPMHubTile.this.lastZPMPower.size() < i + 1) {
                            ZPMHubTile.this.lastZPMPower.add(-1);
                        }
                        if (!this.getStackInSlot(i).func_190926_b()) {
                            ++zpmsCount;
                            ZPMHubTile.this.lastZPMPowerLevel.set(i, ((IEnergyStorage)this.getStackInSlot(i).getCapability(CapabilityEnergy.ENERGY, null)).getEnergyStored());
                            continue;
                        }
                        ZPMHubTile.this.lastZPMPower.set(i, -1);
                    }
                    if (ZPMHubTile.this.getZpmsCount() == zpmsCount) break;
                    ZPMHubTile.this.initAnimation(putting, zpmsCount, slot);
                }
            }
            ZPMHubTile.this.func_70296_d();
        }
    };
    private ZPMHubRendererState rendererStateClient;
    private NetworkRegistry.TargetPoint targetPoint;
    private BlockPos lastPos = BlockPos.field_177992_a;
    private boolean addedToNetwork;
    protected long energyStoredLastTick = 0L;
    protected long energyTransferedLastTick = 0L;
    private StargateAbstractEnergyStorage energyStorage = new StargateAbstractEnergyStorage(){

        @Override
        protected void onEnergyChanged() {
            ZPMHubTile.this.func_70296_d();
        }
    };
    private Node node = Aunis.ocWrapper.createNode(this, "zpmhub");

    public boolean tryInsertZPM(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b()) {
            return false;
        }
        PrimitiveIterator.OfInt iter = IntStream.range(0, this.itemStackHandler.getSlots()).iterator();
        while (iter.hasNext()) {
            int slot = (Integer)iter.next();
            if (!this.itemStackHandler.getStackInSlot(slot).func_190926_b() || !this.itemStackHandler.isItemValid(slot, stack)) continue;
            player.func_184611_a(hand, this.itemStackHandler.insertItem(slot, stack, false));
            return true;
        }
        return false;
    }

    public boolean tryGetZPM(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b()) {
            return false;
        }
        PrimitiveIterator.OfInt iter = IntStream.range(0, this.itemStackHandler.getSlots()).iterator();
        while (iter.hasNext()) {
            int slot = (Integer)iter.next();
            if (this.itemStackHandler.getStackInSlot(slot).func_190926_b() || !stack.func_190926_b()) continue;
            player.func_184611_a(hand, this.itemStackHandler.extractItem(slot, 1, false));
            return true;
        }
        return false;
    }

    public int getZpmsCount() {
        return this.zpmsCount;
    }

    public int getEnergyLevelOfZPM(int zpm) {
        ItemStack zpmStack = this.itemStackHandler.getStackInSlot(zpm);
        for (int i = 0; i < 3; ++i) {
            if (this.lastZPMPowerLevel.size() >= i + 1) continue;
            this.lastZPMPowerLevel.add(0);
        }
        if (zpmStack.func_190926_b()) {
            return this.lastZPMPowerLevel.get(zpm);
        }
        int energyStored = ((IEnergyStorage)Objects.requireNonNull(zpmStack.getCapability(CapabilityEnergy.ENERGY, null))).getEnergyStored();
        int maxEnergyStored = AunisConfig.powerConfig.zpmEnergyStorage;
        this.lastZPMPowerLevel.set(zpm, Math.round((float)energyStored / (float)maxEnergyStored * 10.0f / 2.0f));
        return Math.round((float)energyStored / (float)maxEnergyStored * 10.0f / 2.0f);
    }

    public long getEnergyInZPM(int zpm) {
        ItemStack zpmStack = this.itemStackHandler.getStackInSlot(zpm - 1);
        if (zpmStack.func_190926_b()) {
            return 0L;
        }
        return ((IEnergyStorage)Objects.requireNonNull(zpmStack.getCapability(CapabilityEnergy.ENERGY, null))).getEnergyStored();
    }

    public int extractEnergyFromZPM(int zpm, int energy, boolean simulate) {
        if (this.zpmsCount >= zpm) {
            ItemStack zpmStack = this.itemStackHandler.getStackInSlot(zpm - 1);
            return ((IEnergyStorage)Objects.requireNonNull(zpmStack.getCapability(CapabilityEnergy.ENERGY, null))).extractEnergy(energy * 3, simulate);
        }
        return 0;
    }

    public void initAnimation(boolean isPutting, int zpmsCount, int slot) {
        this.animationStart = this.field_145850_b.func_82737_E();
        this.isPutting = isPutting;
        this.zpmsCount = zpmsCount;
        this.zpmAnimated = slot + 1;
        this.func_70296_d();
    }

    public void setZPMStatus(int slot, boolean down) {
        if (!down) {
            this.lastZPMPower.set(slot, -1);
        } else {
            this.lastZPMPower.set(slot, (int)this.getEnergyInZPM(slot + 1));
        }
        this.zpmAnimated = 0;
        if (down && ((IEnergyStorage)Objects.requireNonNull(this.itemStackHandler.getStackInSlot(slot).getCapability(CapabilityEnergy.ENERGY, null))).getEnergyStored() > 0) {
            AunisSoundHelper.playPositionedSound(this.field_145850_b, this.field_174879_c, SoundPositionedEnum.ZPMHUB_ZPM_ACTIVATED, true);
        }
        this.func_70296_d();
    }

    public void initZPMSound(boolean down) {
        if (down) {
            AunisSoundHelper.playPositionedSound(this.field_145850_b, this.field_174879_c, SoundPositionedEnum.ZPMHUB_ZPM_SLIDE_IN, true);
        } else {
            AunisSoundHelper.playPositionedSound(this.field_145850_b, this.field_174879_c, SoundPositionedEnum.ZPMHUB_ZPM_SLIDE_OUT, true);
        }
    }

    public void func_189667_a(Rotation rotation) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        int rotationOrig = (Integer)state.func_177229_b((IProperty)AunisProps.ROTATION_HORIZONTAL);
        this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)AunisProps.ROTATION_HORIZONTAL, (Comparable)Integer.valueOf(rotation.func_185833_a(rotationOrig, 16))));
    }

    public ZPMHubRendererState getRendererStateClient() {
        return this.rendererStateClient;
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            this.targetPoint = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 512.0);
        } else {
            AunisPacketHandler.INSTANCE.sendToServer((IMessage)new StateUpdateRequestToServer(this.field_174879_c, StateTypeEnum.RENDERER_STATE));
        }
    }

    public void func_73660_a() {
        int i;
        if (this.lastZPMPowerLevel.size() < 3) {
            for (i = 0; i < 3 - this.lastZPMPowerLevel.size(); ++i) {
                this.lastZPMPowerLevel.add(0);
            }
        }
        if (this.lastZPMPower.size() < 3) {
            for (i = 0; i < 3 - this.lastZPMPower.size(); ++i) {
                this.lastZPMPower.add(-1);
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            if (!this.addedToNetwork) {
                this.addedToNetwork = true;
                Aunis.ocWrapper.joinWirelessNetwork(this);
                Aunis.ocWrapper.joinOrCreateNetwork(this);
            }
            if (!this.lastPos.equals((Object)this.field_174879_c)) {
                this.lastPos = this.field_174879_c;
            }
            if (this.field_145850_b.func_82737_E() - this.animationStart > 20L) {
                this.zpmAnimated = 0;
            }
            if (this.zpmAnimated == 0) {
                int zpmsCount = 0;
                for (int i2 = 0; i2 < 3; ++i2) {
                    if (this.itemStackHandler.getStackInSlot(i2).func_190926_b()) continue;
                    ++zpmsCount;
                }
                if (this.zpmsCount != zpmsCount) {
                    this.zpmsCount = zpmsCount;
                }
            }
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                TileEntity tile;
                if (facing == EnumFacing.UP || (tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing))) == null || !tile.hasCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())) continue;
                for (int i3 = 0; i3 < 3; ++i3) {
                    ItemStack zpmStack = this.itemStackHandler.getStackInSlot(i3);
                    if (this.lastZPMPower.size() < i3 + 1) {
                        this.lastZPMPower.add(-1);
                    }
                    if (zpmStack.func_190926_b()) continue;
                    int extracted = this.extractEnergyFromZPM(i3 + 1, AunisConfig.powerConfig.stargateMaxEnergyTransfer, true);
                    extracted = ((IEnergyStorage)Objects.requireNonNull(tile.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d()))).receiveEnergy(extracted, false);
                    this.extractEnergyFromZPM(i3 + 1, extracted, false);
                }
            }
            long energyStored = 0L;
            for (int i4 = 0; i4 < 3; ++i4) {
                if (this.lastZPMPowerLevel.size() < i4 + 1) {
                    this.lastZPMPowerLevel.add(0);
                }
                if (this.itemStackHandler.getStackInSlot(i4).func_190926_b()) continue;
                int energyStoredTemp = ((IEnergyStorage)Objects.requireNonNull(this.itemStackHandler.getStackInSlot(i4).getCapability(CapabilityEnergy.ENERGY, null))).getEnergyStored();
                this.lastZPMPower.set(i4, energyStoredTemp);
                energyStored += (long)energyStoredTemp;
            }
            this.energyTransferedLastTick = energyStored - this.energyStoredLastTick;
            this.energyStoredLastTick = energyStored;
            this.func_70296_d();
        } else {
            AunisPacketHandler.INSTANCE.sendToServer((IMessage)new StateUpdateRequestToServer(this.field_174879_c, StateTypeEnum.RENDERER_UPDATE));
        }
    }

    protected void sendState(StateTypeEnum type) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.targetPoint != null) {
            State state = this.getState(type);
            AunisPacketHandler.INSTANCE.sendToAllTracking((IMessage)new StateUpdatePacketToClient(this.field_174879_c, type, state), this.targetPoint);
        } else {
            Aunis.logger.debug("targetPoint was null trying to send " + (Object)((Object)type) + " from " + this.getClass().getCanonicalName());
        }
    }

    @Override
    public State getState(StateTypeEnum stateType) {
        switch (stateType) {
            case RENDERER_STATE: 
            case RENDERER_UPDATE: {
                return new ZPMHubRendererState();
            }
            case GUI_UPDATE: {
                return new ZPMHubContainerGuiUpdate(this.zpmsCount, this.energyTransferedLastTick);
            }
        }
        throw new UnsupportedOperationException("EnumStateType." + stateType.name() + " not implemented on " + this.getClass().getName());
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        switch (stateType) {
            case RENDERER_STATE: 
            case RENDERER_UPDATE: {
                return new ZPMHubRendererState();
            }
            case GUI_UPDATE: {
                return new ZPMHubContainerGuiUpdate();
            }
        }
        throw new UnsupportedOperationException("EnumStateType." + stateType.name() + " not implemented on " + this.getClass().getName());
    }

    @Override
    public void setState(StateTypeEnum stateType, State state) {
        switch (stateType) {
            case RENDERER_STATE: {
                this.rendererStateClient = ((ZPMHubRendererState)state).initClient(this.field_174879_c, this.animationStart, this.isPutting, this.zpmsCount, this.zpmAnimated, this.energyTransferedLastTick, this.lastZPMPowerLevel, this.lastZPMPower);
                break;
            }
            case RENDERER_UPDATE: {
                this.rendererStateClient = this.getRendererStateClient() == null ? ((ZPMHubRendererState)state).initClient(this.field_174879_c, this.animationStart, this.isPutting, this.zpmsCount, this.zpmAnimated, this.energyTransferedLastTick, this.lastZPMPowerLevel, this.lastZPMPower) : this.getRendererStateClient();
                this.rendererStateClient.energyTransferedLastTick = this.energyTransferedLastTick;
                this.rendererStateClient.isPutting = this.isPutting;
                this.rendererStateClient.zpmsCount = this.zpmsCount;
                this.rendererStateClient.animationStart = this.animationStart;
                this.rendererStateClient.zpmAnimated = this.zpmAnimated;
                this.rendererStateClient.lastZPMPowerLevel = this.lastZPMPowerLevel;
                this.rendererStateClient.lastZPMPower = this.lastZPMPower;
                break;
            }
            case GUI_UPDATE: {
                if (!(state instanceof ZPMHubContainerGuiUpdate)) break;
                ZPMHubContainerGuiUpdate guiUpdate = (ZPMHubContainerGuiUpdate)state;
                this.zpmsCount = guiUpdate.zpmsCount;
                this.func_70296_d();
                break;
            }
            default: {
                throw new UnsupportedOperationException("EnumStateType." + stateType.name() + " not implemented on " + this.getClass().getName());
            }
        }
        this.func_70296_d();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemStackHandler);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.getEnergyStorage());
        }
        return (T)super.getCapability(capability, facing);
    }

    public StargateAbstractEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public long getEnergyTransferedLastTick() {
        return this.energyTransferedLastTick;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("itemHandler", (NBTBase)this.itemStackHandler.serializeNBT());
        compound.func_74772_a("animationStart", this.animationStart);
        compound.func_74768_a("zpmsCount", this.zpmsCount);
        compound.func_74757_a("isPutting", this.isPutting);
        for (int i = 0; i < 3; ++i) {
            if (this.lastZPMPower.size() < i + 1) {
                this.lastZPMPower.add(-1);
            }
            if (this.lastZPMPowerLevel.size() < i + 1) {
                this.lastZPMPowerLevel.add(-1);
            }
            compound.func_74768_a("zpmPower_" + i, this.lastZPMPower.get(i).intValue());
            compound.func_74768_a("zpmLevel_" + i, this.lastZPMPowerLevel.get(i).intValue());
        }
        if (this.node != null) {
            NBTTagCompound nodeCompound = new NBTTagCompound();
            this.node.save(nodeCompound);
            compound.func_74782_a("node", (NBTBase)nodeCompound);
        }
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.itemStackHandler.deserializeNBT(compound.func_74775_l("itemHandler"));
        this.animationStart = compound.func_74763_f("animationStart");
        this.zpmsCount = compound.func_74762_e("zpmsCount");
        this.isPutting = compound.func_74767_n("isPutting");
        this.lastZPMPower.clear();
        this.lastZPMPowerLevel.clear();
        for (int i = 0; i < 3; ++i) {
            this.lastZPMPower.add(compound.func_74762_e("zpmPower_" + i));
            this.lastZPMPowerLevel.add(compound.func_74762_e("zpmLevel_" + i));
        }
        if (this.node != null && compound.func_74764_b("node")) {
            this.node.load(compound.func_74775_l("node"));
        }
        this.func_70296_d();
        super.func_145839_a(compound);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v().func_177982_a(-1, 0, -1), this.func_174877_v().func_177982_a(1, 2, 1));
    }

    public double func_145833_n() {
        return 65536.0;
    }

    public void onChunkUnload() {
        if (this.node != null) {
            this.node.remove();
        }
        Aunis.ocWrapper.leaveWirelessNetwork(this);
    }

    public void func_145843_s() {
        if (this.node != null) {
            this.node.remove();
        }
        Aunis.ocWrapper.leaveWirelessNetwork(this);
        super.func_145843_s();
    }

    public int x() {
        return this.field_174879_c.func_177958_n();
    }

    public int y() {
        return this.field_174879_c.func_177956_o();
    }

    public int z() {
        return this.field_174879_c.func_177952_p();
    }

    public World world() {
        return this.field_145850_b;
    }

    @Optional.Method(modid="opencomputers")
    public void receivePacket(Packet packet, WirelessEndpoint sender) {
    }

    @Optional.Method(modid="opencomputers")
    public Node node() {
        return this.node;
    }

    @Optional.Method(modid="opencomputers")
    public void onConnect(Node node) {
    }

    @Optional.Method(modid="opencomputers")
    public void onDisconnect(Node node) {
    }

    @Optional.Method(modid="opencomputers")
    public void onMessage(Message message) {
    }

    public void sendSignal(Object context, String name, Object ... params) {
        Aunis.ocWrapper.sendSignalToReachable(this.node, (Context)context, name, params);
    }
}

