/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.tileentity.energy;

import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.gui.container.CapacitorContainerGuiUpdate;
import mrjake.aunis.packet.AunisPacketHandler;
import mrjake.aunis.packet.StateUpdatePacketToClient;
import mrjake.aunis.packet.StateUpdateRequestToServer;
import mrjake.aunis.stargate.power.StargateAbstractEnergyStorage;
import mrjake.aunis.state.CapacitorPowerLevelUpdate;
import mrjake.aunis.state.State;
import mrjake.aunis.state.StateProviderInterface;
import mrjake.aunis.state.StateTypeEnum;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CapacitorTile
extends TileEntity
implements ITickable,
ICapabilityProvider,
StateProviderInterface {
    private NetworkRegistry.TargetPoint targetPoint;
    private int powerLevel;
    private int lastPowerLevel;
    protected int energyStoredLastTick = 0;
    protected int energyTransferedLastTick = 0;
    private StargateAbstractEnergyStorage energyStorage = new StargateAbstractEnergyStorage(){

        @Override
        protected void onEnergyChanged() {
            CapacitorTile.this.func_70296_d();
        }
    };

    public NetworkRegistry.TargetPoint getTargetPoint() {
        return this.targetPoint;
    }

    public int getPowerLevel() {
        return this.powerLevel;
    }

    public void setPowerLevel(int pl) {
        this.powerLevel = pl;
    }

    public void setLastPowerLevel(int pl) {
        this.lastPowerLevel = pl;
    }

    public int getLastPowerLevel() {
        return this.lastPowerLevel;
    }

    public StargateAbstractEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            this.targetPoint = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 512.0);
        } else {
            AunisPacketHandler.INSTANCE.sendToServer((IMessage)new StateUpdateRequestToServer(this.field_174879_c, StateTypeEnum.RENDERER_UPDATE));
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
                if (tile == null || !tile.hasCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())) continue;
                int extracted = this.energyStorage.extractEnergy(AunisConfig.powerConfig.stargateMaxEnergyTransfer, true);
                extracted = ((IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())).receiveEnergy(extracted, false);
                this.energyStorage.extractEnergy(extracted, false);
            }
            this.powerLevel = Math.round((float)this.energyStorage.getEnergyStored() / (float)this.energyStorage.getMaxEnergyStored() * 10.0f);
            if (this.powerLevel != this.lastPowerLevel) {
                AunisPacketHandler.INSTANCE.sendToAllTracking((IMessage)new StateUpdatePacketToClient(this.field_174879_c, StateTypeEnum.RENDERER_UPDATE, this.getState(StateTypeEnum.RENDERER_UPDATE)), this.targetPoint);
                this.lastPowerLevel = this.powerLevel;
            }
            this.energyTransferedLastTick = this.energyStorage.getEnergyStored() - this.energyStoredLastTick;
            this.energyStoredLastTick = this.energyStorage.getEnergyStored();
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("energyStorage", (NBTBase)this.getEnergyStorage().serializeNBT());
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.getEnergyStorage().deserializeNBT(compound.func_74775_l("energyStorage"));
        super.func_145839_a(compound);
    }

    public int getEnergyTransferedLastTick() {
        return this.energyTransferedLastTick;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.getEnergyStorage());
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public State getState(StateTypeEnum stateType) {
        switch (stateType) {
            case RENDERER_UPDATE: {
                return new CapacitorPowerLevelUpdate(this.powerLevel);
            }
            case GUI_UPDATE: {
                return new CapacitorContainerGuiUpdate(this.energyStorage.getEnergyStored(), this.energyTransferedLastTick);
            }
        }
        return null;
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        switch (stateType) {
            case RENDERER_UPDATE: {
                return new CapacitorPowerLevelUpdate();
            }
            case GUI_UPDATE: {
                return new CapacitorContainerGuiUpdate();
            }
        }
        return null;
    }

    @Override
    public void setState(StateTypeEnum stateType, State state) {
        switch (stateType) {
            case RENDERER_UPDATE: {
                this.powerLevel = ((CapacitorPowerLevelUpdate)state).powerLevel;
                this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
                break;
            }
            case GUI_UPDATE: {
                CapacitorContainerGuiUpdate guiUpdate = (CapacitorContainerGuiUpdate)state;
                this.energyStorage.setEnergyStored(guiUpdate.energyStored);
                this.energyTransferedLastTick = guiUpdate.energyTransferedLastTick;
                break;
            }
        }
    }
}

