/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.tileentity.dialhomedevice;

import java.util.EnumSet;
import mrjake.aunis.AunisProps;
import mrjake.aunis.block.AunisBlocks;
import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.fluid.AunisFluids;
import mrjake.aunis.item.AunisItems;
import mrjake.aunis.renderer.biomes.BiomeOverlayEnum;
import mrjake.aunis.renderer.dialhomedevice.DHDPegasusRendererState;
import mrjake.aunis.sound.AunisSoundHelper;
import mrjake.aunis.sound.SoundEventEnum;
import mrjake.aunis.stargate.network.StargateAddressDynamic;
import mrjake.aunis.stargate.network.SymbolInterface;
import mrjake.aunis.stargate.network.SymbolPegasusEnum;
import mrjake.aunis.stargate.network.SymbolTypeEnum;
import mrjake.aunis.state.State;
import mrjake.aunis.state.StateTypeEnum;
import mrjake.aunis.state.dialhomedevice.DHDActivateButtonState;
import mrjake.aunis.state.stargate.StargateBiomeOverrideState;
import mrjake.aunis.tileentity.dialhomedevice.DHDAbstractTile;
import mrjake.aunis.tileentity.stargate.StargateAbstractBaseTile;
import mrjake.aunis.tileentity.stargate.StargatePegasusBaseTile;
import mrjake.aunis.util.LinkingHelper;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class DHDPegasusTile
extends DHDAbstractTile {
    public static final EnumSet<BiomeOverlayEnum> SUPPORTED_OVERLAYS = EnumSet.of(BiomeOverlayEnum.NORMAL, BiomeOverlayEnum.FROST, BiomeOverlayEnum.MOSSY, BiomeOverlayEnum.AGED);
    private DHDPegasusRendererState rendererStateClient;

    @Override
    public EnumSet<BiomeOverlayEnum> getSupportedOverlays() {
        return SUPPORTED_OVERLAYS;
    }

    public DHDPegasusRendererState getRendererStateClient() {
        return this.rendererStateClient;
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 40L == 0L && this.rendererStateClient != null && this.getRendererStateClient().biomeOverride == null) {
            this.rendererStateClient.setBiomeOverlay(BiomeOverlayEnum.updateBiomeOverlay(this.field_145850_b, this.field_174879_c, SUPPORTED_OVERLAYS));
        }
        super.func_73660_a();
    }

    @Override
    public void activateSymbol(SymbolInterface symbolInt) {
        StargateAbstractBaseTile gateTile = this.getLinkedGate((IBlockAccess)this.field_145850_b);
        SymbolPegasusEnum symbol = SymbolPegasusEnum.valueOf(symbolInt.getId());
        if (!gateTile.getStargateState().dialingComputer()) {
            if (symbol.brb()) {
                AunisSoundHelper.playSoundEvent(this.field_145850_b, this.field_174879_c, SoundEventEnum.DHD_PEGASUS_PRESS_BRB);
            } else {
                AunisSoundHelper.playSoundEvent(this.field_145850_b, this.field_174879_c, SoundEventEnum.DHD_PEGASUS_PRESS);
            }
        }
        this.field_145850_b.func_175685_c(this.field_174879_c, (Block)AunisBlocks.DHD_PEGASUS_BLOCK, true);
        this.sendState(StateTypeEnum.DHD_ACTIVATE_BUTTON, new DHDActivateButtonState(symbol));
    }

    @Override
    public void updateLinkStatus(World world, BlockPos pos) {
        BlockPos closestGate = LinkingHelper.findClosestUnlinked(world, pos, LinkingHelper.getDhdRange(), AunisBlocks.STARGATE_PEGASUS_BASE_BLOCK, this.getLinkId());
        int linkId = LinkingHelper.getLinkId();
        if (closestGate != null) {
            StargatePegasusBaseTile gateTile = (StargatePegasusBaseTile)world.func_175625_s(closestGate);
            gateTile.setLinkedDHD(pos, linkId);
        }
        this.setLinkedGate(closestGate, linkId);
    }

    @Override
    public State getState(StateTypeEnum stateType) {
        if (stateType == StateTypeEnum.RENDERER_STATE) {
            StargateAddressDynamic address = new StargateAddressDynamic(SymbolTypeEnum.PEGASUS);
            if (this.isLinked()) {
                StargateAbstractBaseTile gateTile = this.getLinkedGate((IBlockAccess)this.field_145850_b);
                address.addAll(gateTile.getDialedAddress());
                boolean brbActive = false;
                switch (gateTile.getStargateState()) {
                    case ENGAGED_INITIATING: {
                        brbActive = true;
                        break;
                    }
                    case ENGAGED: {
                        address.clear();
                        brbActive = true;
                        break;
                    }
                }
                return new DHDPegasusRendererState(address, brbActive, this.determineBiomeOverride());
            }
            return new DHDPegasusRendererState(address, false, this.determineBiomeOverride());
        }
        throw new UnsupportedOperationException("EnumStateType." + stateType.name() + " not implemented on " + this.getClass().getName());
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        if (stateType == StateTypeEnum.RENDERER_STATE) {
            return new DHDPegasusRendererState();
        }
        return super.createState(stateType);
    }

    @Override
    public void setState(StateTypeEnum stateType, State state) {
        switch (stateType) {
            case RENDERER_STATE: {
                float horizontalRotation = (float)((Integer)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)AunisProps.ROTATION_HORIZONTAL)).intValue() * -22.5f;
                this.rendererStateClient = ((DHDPegasusRendererState)state).initClient(this.field_174879_c, horizontalRotation, BiomeOverlayEnum.updateBiomeOverlay(this.field_145850_b, this.field_174879_c, SUPPORTED_OVERLAYS));
                break;
            }
            case DHD_ACTIVATE_BUTTON: {
                if (state == null) break;
                DHDActivateButtonState activateState = (DHDActivateButtonState)state;
                if (activateState.clearAll) {
                    this.getRendererStateClient().clearSymbols(this.field_145850_b.func_82737_E());
                    break;
                }
                this.getRendererStateClient().activateSymbol(this.field_145850_b.func_82737_E(), SymbolPegasusEnum.valueOf(activateState.symbol));
                break;
            }
            case BIOME_OVERRIDE_STATE: {
                StargateBiomeOverrideState overrideState = (StargateBiomeOverrideState)state;
                if (this.rendererStateClient == null) break;
                this.getRendererStateClient().biomeOverride = overrideState.biomeOverride;
                break;
            }
            default: {
                super.setState(stateType, state);
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        NBTTagCompound inventoryTag;
        NBTTagList tagList;
        if (compound.func_74764_b("inventory") && (tagList = (inventoryTag = compound.func_74775_l("inventory")).func_150295_c("Items", 10)).func_74745_c() > 0) {
            this.itemStackHandler.setStackInSlot(0, new ItemStack(AunisItems.CRYSTAL_CONTROL_PEGASUS_DHD));
            int energy = tagList.func_150305_b(0).func_74775_l("ForgeCaps").func_74775_l("Parent").func_74762_e("energy");
            int fluidAmount = energy / AunisConfig.dhdConfig.energyPerNaquadah;
            this.fluidHandler.fillInternal(new FluidStack((Fluid)AunisFluids.moltenNaquadahRefined, fluidAmount), true);
        }
        super.func_145839_a(compound);
    }
}

