/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.tileentity.dialhomedevice;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Packet;
import li.cil.oc.api.network.WirelessEndpoint;
import mrjake.aunis.Aunis;
import mrjake.aunis.AunisProps;
import mrjake.aunis.block.AunisBlocks;
import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.fluid.AunisFluids;
import mrjake.aunis.gui.container.DHDContainerGuiUpdate;
import mrjake.aunis.item.AunisItems;
import mrjake.aunis.packet.AunisPacketHandler;
import mrjake.aunis.packet.StateUpdatePacketToClient;
import mrjake.aunis.packet.StateUpdateRequestToServer;
import mrjake.aunis.renderer.biomes.BiomeOverlayEnum;
import mrjake.aunis.stargate.StargateClosedReasonEnum;
import mrjake.aunis.stargate.StargateOpenResult;
import mrjake.aunis.stargate.network.SymbolInterface;
import mrjake.aunis.stargate.network.SymbolMilkyWayEnum;
import mrjake.aunis.stargate.network.SymbolPegasusEnum;
import mrjake.aunis.state.State;
import mrjake.aunis.state.StateProviderInterface;
import mrjake.aunis.state.StateTypeEnum;
import mrjake.aunis.state.dialhomedevice.DHDActivateButtonState;
import mrjake.aunis.state.stargate.StargateBiomeOverrideState;
import mrjake.aunis.tileentity.dialhomedevice.DHDMilkyWayTile;
import mrjake.aunis.tileentity.dialhomedevice.DHDPegasusTile;
import mrjake.aunis.tileentity.stargate.StargateAbstractBaseTile;
import mrjake.aunis.tileentity.stargate.StargateMilkyWayBaseTile;
import mrjake.aunis.tileentity.stargate.StargatePegasusBaseTile;
import mrjake.aunis.tileentity.util.IUpgradable;
import mrjake.aunis.tileentity.util.ReactorStateEnum;
import mrjake.aunis.util.AunisItemStackHandler;
import mrjake.aunis.util.EnumKeyInterface;
import mrjake.aunis.util.ILinkable;
import mrjake.aunis.util.ItemMetaPair;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.Environment", modid="opencomputers"), @Optional.Interface(iface="li.cil.oc.api.network.WirelessEndpoint", modid="opencomputers")})
public abstract class DHDAbstractTile
extends TileEntity
implements ILinkable,
IUpgradable,
StateProviderInterface,
ITickable,
Environment,
WirelessEndpoint {
    private BlockPos linkedGate = null;
    private int linkId = -1;
    protected NetworkRegistry.TargetPoint targetPoint;
    protected ReactorStateEnum reactorState = ReactorStateEnum.STANDBY;
    private BlockPos lastPos = BlockPos.field_177992_a;
    private boolean firstTick = true;
    private boolean addedToNetwork;
    public static final EnumSet<BiomeOverlayEnum> SUPPORTED_OVERLAYS = EnumSet.of(BiomeOverlayEnum.NORMAL, BiomeOverlayEnum.FROST, BiomeOverlayEnum.MOSSY, BiomeOverlayEnum.SOOTY, BiomeOverlayEnum.AGED);
    private boolean hadControlCrystal;
    public boolean isLinkedClient;
    public static final List<Item> SUPPORTED_UPGRADES = Arrays.asList(AunisItems.CRYSTAL_GLYPH_DHD);
    public static final int BIOME_OVERRIDE_SLOT = 5;
    private DHDAbstractTile instance = this;
    protected final ItemStackHandler itemStackHandler = new AunisItemStackHandler(6){

        public boolean isItemValid(int slot, ItemStack stack) {
            Item item = stack.func_77973_b();
            switch (slot) {
                case 0: {
                    if (DHDAbstractTile.this.instance instanceof DHDMilkyWayTile) {
                        return item == AunisItems.CRYSTAL_CONTROL_DHD;
                    }
                    if (DHDAbstractTile.this.instance instanceof DHDPegasusTile) {
                        return item == AunisItems.CRYSTAL_CONTROL_PEGASUS_DHD;
                    }
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return SUPPORTED_UPGRADES.contains(item) && !DHDAbstractTile.this.hasUpgrade(item);
                }
                case 5: {
                    BiomeOverlayEnum override = AunisConfig.stargateConfig.getBiomeOverrideItemMetaPairs().get(new ItemMetaPair(stack));
                    if (override == null) {
                        return false;
                    }
                    return DHDAbstractTile.this.getSupportedOverlays().contains((Object)override);
                }
            }
            return true;
        }

        protected int getStackLimit(int slot, ItemStack stack) {
            return 1;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            super.setStackInSlot(slot, stack);
            if (!((DHDAbstractTile)DHDAbstractTile.this).field_145850_b.field_72995_K && slot == 0) {
                DHDAbstractTile.this.updateCrystal();
            }
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack out = super.extractItem(slot, amount, simulate);
            if (!((DHDAbstractTile)DHDAbstractTile.this).field_145850_b.field_72995_K && slot == 0 && amount > 0 && !simulate) {
                DHDAbstractTile.this.updateCrystal();
            }
            return out;
        }

        protected void onContentsChanged(int slot) {
            switch (slot) {
                case 5: {
                    DHDAbstractTile.this.sendState(StateTypeEnum.BIOME_OVERRIDE_STATE, new StargateBiomeOverrideState(DHDAbstractTile.this.determineBiomeOverride()));
                    break;
                }
            }
            super.onContentsChanged(slot);
            DHDAbstractTile.this.func_70296_d();
        }
    };
    protected final FluidTank fluidHandler;
    private Node node;

    public DHDAbstractTile() {
        this.fluidHandler = new FluidTank(new FluidStack((Fluid)AunisFluids.moltenNaquadahRefined, 0), AunisConfig.dhdConfig.fluidCapacity){

            public boolean canFillFluidType(FluidStack fluid) {
                if (fluid == null) {
                    return false;
                }
                return fluid.getFluid() == AunisFluids.moltenNaquadahRefined;
            }

            protected void onContentsChanged() {
                DHDAbstractTile.this.func_70296_d();
            }
        };
        this.node = Aunis.ocWrapper.createNode(this, "dhd");
    }

    public void func_189667_a(Rotation rotation) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        int rotationOrig = (Integer)state.func_177229_b((IProperty)AunisProps.ROTATION_HORIZONTAL);
        this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)AunisProps.ROTATION_HORIZONTAL, (Comparable)Integer.valueOf(rotation.func_185833_a(rotationOrig, 16))));
    }

    public void setLinkedGate(BlockPos gate, int linkId) {
        this.linkedGate = gate;
        this.linkId = linkId;
        this.func_70296_d();
    }

    public boolean isLinked() {
        return this.linkedGate != null;
    }

    public StargateAbstractBaseTile getLinkedGate(IBlockAccess world) {
        if (this.linkedGate == null) {
            return null;
        }
        return (StargateAbstractBaseTile)world.func_175625_s(this.linkedGate);
    }

    public abstract void updateLinkStatus(World var1, BlockPos var2);

    @Override
    public boolean canLinkTo() {
        return !this.isLinked();
    }

    @Override
    public int getLinkId() {
        return this.linkId;
    }

    public ReactorStateEnum getReactorState() {
        return this.reactorState;
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            this.targetPoint = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 512.0);
            this.hadControlCrystal = this.hasControlCrystal();
        } else {
            AunisPacketHandler.INSTANCE.sendToServer((IMessage)new StateUpdateRequestToServer(this.field_174879_c, StateTypeEnum.RENDERER_STATE));
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (!this.addedToNetwork) {
                this.addedToNetwork = true;
                Aunis.ocWrapper.joinWirelessNetwork(this);
                Aunis.ocWrapper.joinOrCreateNetwork(this);
            }
            if (!this.lastPos.equals((Object)this.field_174879_c)) {
                this.lastPos = this.field_174879_c;
                this.updateLinkStatus(this.field_145850_b, this.field_174879_c);
            }
            if (this.hasControlCrystal()) {
                if (this.isLinked()) {
                    StargateAbstractBaseTile gateTile = this.getLinkedGate((IBlockAccess)this.field_145850_b);
                    if (gateTile == null) {
                        this.setLinkedGate(null, -1);
                        Aunis.logger.error("Gate didn't unlink properly, forcing...");
                        return;
                    }
                    IEnergyStorage energyStorage = (IEnergyStorage)gateTile.getCapability(CapabilityEnergy.ENERGY, null);
                    int amount = AunisConfig.dhdConfig.powerGenerationMultiplier;
                    if (this.reactorState != ReactorStateEnum.STANDBY) {
                        FluidStack simulatedDrain = this.fluidHandler.drainInternal(amount, false);
                        this.reactorState = simulatedDrain != null && simulatedDrain.amount >= amount ? ReactorStateEnum.ONLINE : ReactorStateEnum.NO_FUEL;
                    }
                    if (this.reactorState == ReactorStateEnum.ONLINE || this.reactorState == ReactorStateEnum.STANDBY) {
                        float percent = (float)energyStorage.getEnergyStored() / (float)energyStorage.getMaxEnergyStored();
                        if ((double)percent < AunisConfig.dhdConfig.activationLevel) {
                            this.reactorState = ReactorStateEnum.ONLINE;
                        } else if ((double)percent >= AunisConfig.dhdConfig.deactivationLevel) {
                            this.reactorState = ReactorStateEnum.STANDBY;
                        }
                    }
                    if (this.reactorState == ReactorStateEnum.ONLINE) {
                        this.fluidHandler.drainInternal(amount, true);
                        energyStorage.receiveEnergy(AunisConfig.dhdConfig.energyPerNaquadah * AunisConfig.dhdConfig.powerGenerationMultiplier, false);
                    }
                } else {
                    this.reactorState = ReactorStateEnum.NOT_LINKED;
                }
            } else {
                this.reactorState = ReactorStateEnum.NO_CRYSTAL;
            }
        }
    }

    protected BiomeOverlayEnum determineBiomeOverride() {
        ItemStack stack = this.itemStackHandler.getStackInSlot(5);
        if (stack.func_190926_b()) {
            return null;
        }
        BiomeOverlayEnum biomeOverlay = AunisConfig.stargateConfig.getBiomeOverrideItemMetaPairs().get(new ItemMetaPair(stack));
        if (this.getSupportedOverlays().contains((Object)biomeOverlay)) {
            return biomeOverlay;
        }
        return null;
    }

    public EnumSet<BiomeOverlayEnum> getSupportedOverlays() {
        return SUPPORTED_OVERLAYS;
    }

    public boolean hasControlCrystal() {
        return !this.itemStackHandler.getStackInSlot(0).func_190926_b();
    }

    private void updateCrystal() {
        boolean hasControlCrystal = this.hasControlCrystal();
        if (this.hadControlCrystal != hasControlCrystal) {
            if (hasControlCrystal) {
                this.sendState(StateTypeEnum.RENDERER_STATE, this.getState(StateTypeEnum.RENDERER_STATE));
            } else {
                this.clearSymbols();
            }
            this.hadControlCrystal = hasControlCrystal;
        }
    }

    public abstract void activateSymbol(SymbolInterface var1);

    public void clearSymbols() {
        this.field_145850_b.func_175685_c(this.field_174879_c, (Block)AunisBlocks.DHD_BLOCK, true);
        this.sendState(StateTypeEnum.DHD_ACTIVATE_BUTTON, new DHDActivateButtonState(true));
    }

    protected void sendState(StateTypeEnum type, State state) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.targetPoint != null) {
            AunisPacketHandler.INSTANCE.sendToAllTracking((IMessage)new StateUpdatePacketToClient(this.field_174879_c, type, state), this.targetPoint);
        } else {
            Aunis.logger.debug("targetPoint was null trying to send " + (Object)((Object)type) + " from " + this.getClass().getCanonicalName());
        }
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        switch (stateType) {
            case DHD_ACTIVATE_BUTTON: {
                return new DHDActivateButtonState();
            }
            case GUI_UPDATE: {
                return new DHDContainerGuiUpdate();
            }
            case BIOME_OVERRIDE_STATE: {
                return new StargateBiomeOverrideState();
            }
        }
        throw new UnsupportedOperationException("EnumStateType." + stateType.name() + " not implemented on " + this.getClass().getName());
    }

    @Override
    public void setState(StateTypeEnum stateType, State state) {
        if (stateType != StateTypeEnum.GUI_UPDATE) {
            throw new UnsupportedOperationException("EnumStateType." + stateType.name() + " not implemented on " + this.getClass().getName());
        }
        DHDContainerGuiUpdate guiState = (DHDContainerGuiUpdate)state;
        this.fluidHandler.setFluid(new FluidStack((Fluid)AunisFluids.moltenNaquadahRefined, guiState.fluidAmount));
        this.fluidHandler.setCapacity(guiState.tankCapacity);
        this.reactorState = guiState.reactorState;
        this.isLinkedClient = guiState.isLinked;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing == null || facing == EnumFacing.DOWN) || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemStackHandler);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing == null || facing == EnumFacing.DOWN)) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.fluidHandler);
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (this.linkedGate != null) {
            compound.func_74772_a("linkedGate", this.linkedGate.func_177986_g());
            compound.func_74768_a("linkId", this.linkId);
        }
        compound.func_74782_a("itemStackHandler", (NBTBase)this.itemStackHandler.serializeNBT());
        NBTTagCompound fluidHandlerCompound = new NBTTagCompound();
        this.fluidHandler.writeToNBT(fluidHandlerCompound);
        compound.func_74782_a("fluidHandler", (NBTBase)fluidHandlerCompound);
        if (this.node != null) {
            NBTTagCompound nodeCompound = new NBTTagCompound();
            this.node.save(nodeCompound);
            compound.func_74782_a("node", (NBTBase)nodeCompound);
        }
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("linkedGate")) {
            this.linkedGate = BlockPos.func_177969_a((long)compound.func_74763_f("linkedGate"));
            if (this.linkedGate.equals((Object)new BlockPos(0, 0, 0))) {
                this.linkedGate = null;
            }
        }
        if (compound.func_74764_b("linkId")) {
            this.linkId = compound.func_74762_e("linkId");
        }
        this.itemStackHandler.deserializeNBT(compound.func_74775_l("itemStackHandler"));
        if (compound.func_74767_n("hasUpgrade") || compound.func_74767_n("insertAnimation")) {
            this.itemStackHandler.setStackInSlot(1, new ItemStack(AunisItems.CRYSTAL_GLYPH_DHD));
        }
        this.fluidHandler.readFromNBT(compound.func_74775_l("fluidHandler"));
        if (this.node != null && compound.func_74764_b("node")) {
            this.node.load(compound.func_74775_l("node"));
        }
    }

    public void onChunkUnload() {
        if (this.node != null) {
            this.node.remove();
        }
        Aunis.ocWrapper.leaveWirelessNetwork(this);
    }

    public void func_145843_s() {
        if (this.node != null) {
            this.node.remove();
        }
        Aunis.ocWrapper.leaveWirelessNetwork(this);
        super.func_145843_s();
    }

    public int x() {
        return this.field_174879_c.func_177958_n();
    }

    public int y() {
        return this.field_174879_c.func_177956_o();
    }

    public int z() {
        return this.field_174879_c.func_177952_p();
    }

    public World world() {
        return this.field_145850_b;
    }

    @Optional.Method(modid="opencomputers")
    public void receivePacket(Packet packet, WirelessEndpoint sender) {
    }

    @Optional.Method(modid="opencomputers")
    public Node node() {
        return this.node;
    }

    @Optional.Method(modid="opencomputers")
    public void onConnect(Node node) {
    }

    @Optional.Method(modid="opencomputers")
    public void onDisconnect(Node node) {
    }

    @Optional.Method(modid="opencomputers")
    public void onMessage(Message message) {
    }

    public void sendSignal(Object context, String name, Object ... params) {
        Aunis.ocWrapper.sendSignalToReachable(this.node, (Context)context, name, params);
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function(symbolName:string) -- Activates DHD symbol")
    public Object[] pressButton(Context context, Arguments args) {
        Enum targetSymbol;
        StargateAbstractBaseTile gateTile = this.getLinkedGate((IBlockAccess)this.field_145850_b);
        if (gateTile == null) {
            return new Object[]{null, "dhd_not_connected", "DHD is not connected to stargate"};
        }
        if (this instanceof DHDMilkyWayTile && !(gateTile instanceof StargateMilkyWayBaseTile)) {
            return new Object[]{null, "dhd_wrong_stargate", "Wrong type of stargate detected, this is a bug!"};
        }
        if (this instanceof DHDPegasusTile && !(gateTile instanceof StargatePegasusBaseTile)) {
            return new Object[]{null, "dhd_wrong_stargate", "Wrong type of stargate detected, this is a bug!"};
        }
        if (!gateTile.getStargateState().idle() && !gateTile.getStargateState().dialingDHD()) {
            return new Object[]{null, "dhd_failure_busy", "Linked stargate is busy, state: " + gateTile.getStargateState().toString()};
        }
        if (gateTile.getDialedAddress().size() == 9) {
            return new Object[]{null, "dhd_failure_full", "Already dialed 9 chevrons"};
        }
        if (this instanceof DHDMilkyWayTile) {
            targetSymbol = (SymbolMilkyWayEnum)gateTile.getSymbolFromNameIndex(args.checkAny(0));
            if (targetSymbol == SymbolMilkyWayEnum.BRB) {
                StargateOpenResult result = gateTile.attemptOpenAndFail();
                if (result.ok()) {
                    return new Object[]{null, "dhd_engage", "Opening gate"};
                }
                if (result == StargateOpenResult.NOT_ENOUGH_POWER) {
                    return new Object[]{null, "dhd_engage_failed", "Not enough power to open gate"};
                }
                if (result == StargateOpenResult.ADDRESS_MALFORMED) {
                    return new Object[]{null, "dhd_engage_failed", "Wrong address"};
                }
                return new Object[]{null, "dhd_engage_failed_unknown", "Unknown error! This is a bug!"};
            }
            ((StargateMilkyWayBaseTile)gateTile).addSymbolToAddressDHD((SymbolMilkyWayEnum)targetSymbol);
        }
        if (this instanceof DHDPegasusTile) {
            targetSymbol = (SymbolPegasusEnum)gateTile.getSymbolFromNameIndex(args.checkAny(0));
            if (targetSymbol == SymbolPegasusEnum.BRB) {
                StargateOpenResult result = gateTile.attemptOpenAndFail();
                if (result.ok()) {
                    return new Object[]{null, "dhd_engage", "Opening gate"};
                }
                if (result == StargateOpenResult.NOT_ENOUGH_POWER) {
                    return new Object[]{null, "dhd_engage_failed", "Not enough power to open gate"};
                }
                if (result == StargateOpenResult.ADDRESS_MALFORMED) {
                    return new Object[]{null, "dhd_engage_failed", "Wrong address"};
                }
                return new Object[]{null, "dhd_engage_failed_unknown", "Unknown error! This is a bug!"};
            }
            ((StargatePegasusBaseTile)gateTile).addSymbolToAddressDHD((SymbolInterface)((Object)targetSymbol));
        }
        this.func_70296_d();
        return new Object[]{null, "dhd_pressed"};
    }

    @Optional.Method(modid="opencomputers")
    @Callback(doc="function(symbolName:string) -- Activates DHD\u00c2\u00b4s BRB")
    public Object[] pressBRB(Context context, Arguments args) {
        StargateAbstractBaseTile gateTile = this.getLinkedGate((IBlockAccess)this.field_145850_b);
        if (gateTile == null) {
            return new Object[]{null, "dhd_not_connected", "DHD is not connected to stargate"};
        }
        if (!(gateTile instanceof StargateMilkyWayBaseTile) && !(gateTile instanceof StargatePegasusBaseTile)) {
            return new Object[]{null, "dhd_wrong_stargate", "Wrong type of stargate detected, this is a bug!"};
        }
        if (gateTile.getStargateState().initiating()) {
            gateTile.attemptClose(StargateClosedReasonEnum.REQUESTED);
            return new Object[]{null, "dhd_disengage", "Closing gate..."};
        }
        if (!gateTile.getStargateState().idle() && !gateTile.getStargateState().dialingDHD()) {
            return new Object[]{null, "dhd_failure_busy", "Linked stargate is busy, state: " + gateTile.getStargateState().toString()};
        }
        StargateOpenResult result = gateTile.attemptOpenAndFail();
        if (result.ok()) {
            return new Object[]{null, "dhd_engage", "Opening gate"};
        }
        if (result == StargateOpenResult.NOT_ENOUGH_POWER) {
            return new Object[]{null, "dhd_engage_failed", "Not enough power to open gate"};
        }
        if (result == StargateOpenResult.ADDRESS_MALFORMED) {
            return new Object[]{null, "dhd_engage_failed", "Wrong address"};
        }
        return new Object[]{null, "dhd_engage_failed_unknown", "Unknown error! This is a bug!"};
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v().func_177982_a(-1, 0, -1), this.func_174877_v().func_177982_a(1, 2, 1));
    }

    public double func_145833_n() {
        return 65536.0;
    }

    public static enum DHDUpgradeEnum implements EnumKeyInterface<Item>
    {
        CHEVRON_UPGRADE(AunisItems.CRYSTAL_GLYPH_DHD);

        public Item item;

        private DHDUpgradeEnum(Item item) {
            this.item = item;
        }

        @Override
        public Item getKey() {
            return this.item;
        }
    }
}

