/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.tileentity;

import com.google.common.collect.Iterators;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import mrjake.aunis.Aunis;
import mrjake.aunis.AunisProps;
import mrjake.aunis.beamer.BeamerModeEnum;
import mrjake.aunis.beamer.BeamerRendererAction;
import mrjake.aunis.beamer.BeamerRoleEnum;
import mrjake.aunis.beamer.BeamerStatusEnum;
import mrjake.aunis.block.AunisBlocks;
import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.gui.container.BeamerContainerGui;
import mrjake.aunis.gui.container.BeamerContainerGuiUpdate;
import mrjake.aunis.item.AunisItems;
import mrjake.aunis.packet.AunisPacketHandler;
import mrjake.aunis.packet.StateUpdatePacketToClient;
import mrjake.aunis.packet.StateUpdateRequestToServer;
import mrjake.aunis.sound.AunisSoundHelper;
import mrjake.aunis.sound.AunisSoundHelperClient;
import mrjake.aunis.sound.SoundEventEnum;
import mrjake.aunis.sound.SoundPositionedEnum;
import mrjake.aunis.stargate.EnumScheduledTask;
import mrjake.aunis.stargate.EnumStargateState;
import mrjake.aunis.stargate.network.StargatePos;
import mrjake.aunis.stargate.power.StargateAbstractEnergyStorage;
import mrjake.aunis.state.State;
import mrjake.aunis.state.StateProviderInterface;
import mrjake.aunis.state.StateTypeEnum;
import mrjake.aunis.state.beamer.BeamerFluidUpdate;
import mrjake.aunis.state.beamer.BeamerRendererActionState;
import mrjake.aunis.state.beamer.BeamerRendererState;
import mrjake.aunis.state.beamer.BeamerRendererUpdate;
import mrjake.aunis.tileentity.stargate.StargateClassicBaseTile;
import mrjake.aunis.tileentity.util.ComparatorHelper;
import mrjake.aunis.tileentity.util.IUpgradable;
import mrjake.aunis.tileentity.util.RedstoneModeEnum;
import mrjake.aunis.tileentity.util.ScheduledTask;
import mrjake.aunis.tileentity.util.ScheduledTaskExecutorInterface;
import mrjake.aunis.util.AunisAxisAlignedBB;
import mrjake.aunis.util.FacingToRotation;
import mrjake.aunis.util.NBTHelper;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

@Optional.Interface(iface="li.cil.oc.api.network.Environment", modid="opencomputers")
public class BeamerTile
extends TileEntity
implements ITickable,
IUpgradable,
StateProviderInterface,
ScheduledTaskExecutorInterface,
Environment {
    private EnumFacing facing;
    private NetworkRegistry.TargetPoint targetPoint;
    private AunisAxisAlignedBB renderBox;
    private AunisAxisAlignedBB renderBoxOffsetted;
    private static final BlockMatcher BEAMER_MATCHER = BlockMatcher.func_177642_a((Block)AunisBlocks.BEAMER_BLOCK);
    private boolean addedToNetwork;
    private int powerTransferredSinceLastSignal;
    private List<FluidStack> fluidsTransferredSinceLastSignal;
    private List<ItemStack> itemsTransferredSinceLastSignal;
    private boolean firstCheck;
    private BeamerModeEnum beamerMode;
    private BeamerRoleEnum beamerRole;
    private BeamerStatusEnum beamerStatus;
    private World targetBeamerWorld;
    private BlockPos targetBeamerPos;
    private int comparatorOutput;
    private RedstoneModeEnum redstoneMode;
    private int start;
    private int stop;
    private int inactivity;
    private int timeWithoutItemTransfer;
    private boolean ocLocked;
    private boolean isObstructed;
    private BlockPos baseVect;
    private BlockPos basePos;
    private final ItemStackHandlerBeamer itemStackHandler;
    private Fluid previouslyStoredFluid;
    private FluidTank fluidHandler;
    private StargateAbstractEnergyStorage energyStorage;
    private int energyStoredLastTick;
    private int energyTransferredLastTick;
    private boolean loopSoundPlaying;
    List<ScheduledTask> scheduledTasks;
    @Nullable
    public Fluid lastFluidTransferred;
    public int beamLengthClient;
    public float beamRadiusClient;
    private boolean beamRadiusWiden;
    private boolean beamRadiusShrink;
    private Node node;

    public BeamerTile() {
        this.renderBoxOffsetted = this.renderBox = new AunisAxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        this.addedToNetwork = false;
        this.powerTransferredSinceLastSignal = 0;
        this.fluidsTransferredSinceLastSignal = new ArrayList<FluidStack>();
        this.itemsTransferredSinceLastSignal = new ArrayList<ItemStack>();
        this.firstCheck = true;
        this.beamerMode = BeamerModeEnum.NONE;
        this.beamerRole = BeamerRoleEnum.TRANSMIT;
        this.beamerStatus = BeamerStatusEnum.OBSTRUCTED;
        this.targetBeamerWorld = null;
        this.targetBeamerPos = null;
        this.redstoneMode = RedstoneModeEnum.AUTO;
        this.start = 10;
        this.stop = 90;
        this.inactivity = 5;
        this.itemStackHandler = new ItemStackHandlerBeamer(5);
        this.previouslyStoredFluid = null;
        this.fluidHandler = new FluidTank(null, AunisConfig.beamerConfig.fluidCapacity){

            protected void onContentsChanged() {
                if (BeamerTile.this.beamerRole == BeamerRoleEnum.TRANSMIT && (this.fluid == null || this.fluid.getFluid() != BeamerTile.this.previouslyStoredFluid)) {
                    Fluid fluidContained = this.fluid != null ? this.fluid.getFluid() : null;
                    BeamerFluidUpdate update = new BeamerFluidUpdate(fluidContained);
                    BeamerTile.this.sendState(StateTypeEnum.BEAMER_FLUID_UPDATE, update);
                    if (BeamerTile.this.targetBeamerWorld != null && BeamerTile.this.targetBeamerPos != null) {
                        BeamerTile targetTile = (BeamerTile)BeamerTile.this.targetBeamerWorld.func_175625_s(BeamerTile.this.targetBeamerPos);
                        targetTile.sendState(StateTypeEnum.BEAMER_FLUID_UPDATE, update);
                    }
                    BeamerTile.this.previouslyStoredFluid = fluidContained;
                }
                BeamerTile.this.func_70296_d();
            }

            public boolean canFill() {
                return BeamerTile.this.beamerRole == BeamerRoleEnum.TRANSMIT;
            }
        };
        this.energyStorage = new StargateAbstractEnergyStorage(AunisConfig.beamerConfig.energyCapacity, AunisConfig.beamerConfig.energyTransfer){

            @Override
            protected void onEnergyChanged() {
                BeamerTile.this.func_70296_d();
            }

            public boolean canReceive() {
                return BeamerTile.this.beamerRole == BeamerRoleEnum.TRANSMIT;
            }
        };
        this.energyStoredLastTick = 0;
        this.energyTransferredLastTick = 0;
        this.scheduledTasks = new ArrayList<ScheduledTask>();
        this.node = Aunis.ocWrapper.createNode(this, "beamer");
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public AunisAxisAlignedBB getRenderBoxForDisplay() {
        return this.renderBox;
    }

    public void onLoad() {
        this.updateFacing((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)AunisProps.FACING_HORIZONTAL));
        if (!this.field_145850_b.field_72995_K) {
            this.targetPoint = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 512.0);
        } else {
            AunisPacketHandler.INSTANCE.sendToServer((IMessage)new StateUpdateRequestToServer(this.field_174879_c, StateTypeEnum.RENDERER_STATE));
            AunisPacketHandler.INSTANCE.sendToServer((IMessage)new StateUpdateRequestToServer(this.field_174879_c, StateTypeEnum.RENDERER_UPDATE));
        }
    }

    public void updateFacing(EnumFacing facing) {
        this.facing = facing;
        this.renderBox = new AunisAxisAlignedBB(-0.5, 0.0, -0.5, 0.5, 1.0, AunisConfig.beamerConfig.reach).rotate(facing).offset(0.5, 0.0, 0.5);
        this.renderBoxOffsetted = this.renderBox.offset(this.field_174879_c);
    }

    private BeamerStatusEnum updateBeamerStatus() {
        if (this.beamerMode == BeamerModeEnum.NONE) {
            return BeamerStatusEnum.NO_CRYSTAL;
        }
        if (!this.isLinked()) {
            return BeamerStatusEnum.NOT_LINKED;
        }
        StargateClassicBaseTile gateTile = this.getLinkedGateTile();
        if (!gateTile.getStargateState().engaged()) {
            return BeamerStatusEnum.CLOSED;
        }
        if (this.isObstructed) {
            return BeamerStatusEnum.OBSTRUCTED;
        }
        if (this.targetBeamerWorld == null || this.targetBeamerPos == null || !BEAMER_MATCHER.apply(this.targetBeamerWorld.func_180495_p(this.targetBeamerPos))) {
            return BeamerStatusEnum.NO_BEAMER;
        }
        BeamerTile targetBeamerTile = (BeamerTile)this.targetBeamerWorld.func_175625_s(this.targetBeamerPos);
        if (targetBeamerTile.isObstructed) {
            return BeamerStatusEnum.OBSTRUCTED_TARGET;
        }
        if (this.beamerRole == BeamerRoleEnum.DISABLED) {
            return BeamerStatusEnum.BEAMER_DISABLED;
        }
        if (targetBeamerTile.getRole() == BeamerRoleEnum.DISABLED) {
            return BeamerStatusEnum.BEAMER_DISABLED_TARGET;
        }
        if (targetBeamerTile.getStatus() == BeamerStatusEnum.BEAMER_DISABLED_BY_LOGIC) {
            return BeamerStatusEnum.BEAMER_DISABLED_BY_LOGIC_TARGET;
        }
        if (this.beamerRole == targetBeamerTile.getRole()) {
            if (this.beamerRole == BeamerRoleEnum.TRANSMIT) {
                return BeamerStatusEnum.TWO_TRANSMITTERS;
            }
            return BeamerStatusEnum.TWO_RECEIVERS;
        }
        if (this.beamerMode != targetBeamerTile.getMode()) {
            return BeamerStatusEnum.MODE_MISMATCH;
        }
        if (this.beamerMode != BeamerModeEnum.POWER && (gateTile.getStargateState().initiating() && this.beamerRole != BeamerRoleEnum.TRANSMIT || gateTile.getStargateState() == EnumStargateState.ENGAGED && this.beamerRole != BeamerRoleEnum.RECEIVE)) {
            return BeamerStatusEnum.INCOMING;
        }
        switch (this.redstoneMode) {
            case AUTO: {
                if (this.beamerRole == BeamerRoleEnum.RECEIVE && (this.beamerMode == BeamerModeEnum.POWER || this.beamerMode == BeamerModeEnum.FLUID)) {
                    float level = 0.0f;
                    level = this.beamerMode == BeamerModeEnum.POWER ? (float)this.energyStorage.getEnergyStored() / (float)this.energyStorage.getMaxEnergyStored() : (float)this.fluidHandler.getFluidAmount() / (float)this.fluidHandler.getCapacity();
                    level *= 100.0f;
                    if (this.beamerStatus == BeamerStatusEnum.OK) {
                        if (level > (float)this.stop) {
                            return BeamerStatusEnum.BEAMER_DISABLED_BY_LOGIC;
                        }
                        return BeamerStatusEnum.OK;
                    }
                    if (this.beamerStatus == BeamerStatusEnum.BEAMER_DISABLED_BY_LOGIC) {
                        if (level < (float)this.start) {
                            return BeamerStatusEnum.OK;
                        }
                        return BeamerStatusEnum.BEAMER_DISABLED_BY_LOGIC;
                    }
                }
                if (this.beamerMode != BeamerModeEnum.ITEMS) break;
                if (this.beamerStatus == BeamerStatusEnum.OK) {
                    if (this.timeWithoutItemTransfer > this.inactivity) {
                        return BeamerStatusEnum.BEAMER_DISABLED_BY_LOGIC;
                    }
                    return BeamerStatusEnum.OK;
                }
                if (this.beamerStatus != BeamerStatusEnum.BEAMER_DISABLED_BY_LOGIC) break;
                for (int i = 1; i < 5; ++i) {
                    if ((this.beamerRole != BeamerRoleEnum.RECEIVE || targetBeamerTile.itemStackHandler.getStackInSlot(i).func_190926_b()) && (this.beamerRole != BeamerRoleEnum.TRANSMIT || this.itemStackHandler.getStackInSlot(i).func_190926_b())) continue;
                    return BeamerStatusEnum.OK;
                }
                return BeamerStatusEnum.BEAMER_DISABLED_BY_LOGIC;
            }
            case ON_HIGH: {
                return this.field_145850_b.func_175640_z(this.field_174879_c) ? BeamerStatusEnum.OK : BeamerStatusEnum.BEAMER_DISABLED_BY_LOGIC;
            }
            case ON_LOW: {
                return this.field_145850_b.func_175640_z(this.field_174879_c) ? BeamerStatusEnum.BEAMER_DISABLED_BY_LOGIC : BeamerStatusEnum.OK;
            }
            case IGNORED: {
                return this.ocLocked ? BeamerStatusEnum.BEAMER_DISABLED_BY_LOGIC : BeamerStatusEnum.OK;
            }
        }
        return BeamerStatusEnum.OK;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ScheduledTask.iterate(this.scheduledTasks, this.field_145850_b.func_82737_E());
            if (!this.addedToNetwork) {
                Aunis.ocWrapper.joinOrCreateNetwork(this);
                this.addedToNetwork = true;
            }
            BeamerStatusEnum lastBeamerStatus = this.beamerStatus;
            if (this.firstCheck || this.field_145850_b.func_82737_E() % 20L == 0L) {
                StargateClassicBaseTile gateTile;
                this.firstCheck = false;
                int lastComp = this.comparatorOutput;
                this.comparatorOutput = this.updateComparatorOutput();
                if (lastComp != this.comparatorOutput) {
                    this.field_145850_b.func_175666_e(this.field_174879_c, (Block)AunisBlocks.BEAMER_BLOCK);
                }
                if (this.isLinked() && (gateTile = this.getLinkedGateTile()).getStargateState().engaged()) {
                    this.updateObstructed();
                }
            }
            this.beamerStatus = this.updateBeamerStatus();
            if (this.beamerStatus == BeamerStatusEnum.OK && this.beamerRole == BeamerRoleEnum.TRANSMIT) {
                BeamerTile targetBeamerTile = (BeamerTile)this.targetBeamerWorld.func_175625_s(this.targetBeamerPos);
                switch (this.beamerMode) {
                    case POWER: {
                        int tx = this.energyStorage.extractEnergy(AunisConfig.beamerConfig.energyTransfer, true);
                        tx = targetBeamerTile.energyStorage.receiveEnergyInternal(tx, false);
                        this.energyStorage.extractEnergy(tx, false);
                        this.powerTransferredSinceLastSignal += tx;
                        break;
                    }
                    case FLUID: {
                        FluidStack fluid = this.fluidHandler.drainInternal(AunisConfig.beamerConfig.fluidTransfer, false);
                        int filled = targetBeamerTile.fluidHandler.fillInternal(fluid, true);
                        this.fluidHandler.drainInternal(filled, true);
                        if (filled <= 0) break;
                        int index = this.fluidsTransferredSinceLastSignal.indexOf(fluid);
                        if (index != -1) {
                            FluidStack fluidStack = this.fluidsTransferredSinceLastSignal.get(index);
                            fluidStack.amount += filled;
                            break;
                        }
                        this.fluidsTransferredSinceLastSignal.add(fluid.copy());
                        break;
                    }
                    case ITEMS: {
                        int toTransfer = AunisConfig.beamerConfig.itemTransfer;
                        for (int i = 1; i < 5; ++i) {
                            ItemStack stack = this.itemStackHandler.extractItem(i, toTransfer, true);
                            if (stack.func_190926_b()) continue;
                            for (int k = 1; k < 5; ++k) {
                                int accepted = stack.func_190916_E() - targetBeamerTile.itemStackHandler.insertItemInternal(k, stack.func_77946_l(), false).func_190916_E();
                                this.itemStackHandler.extractItem(i, accepted, false);
                                if (accepted > 0) {
                                    boolean found = false;
                                    for (ItemStack itemStack : this.itemsTransferredSinceLastSignal) {
                                        if (!itemStack.func_77969_a(stack)) continue;
                                        itemStack.func_190917_f(accepted);
                                        found = true;
                                        break;
                                    }
                                    if (!found) {
                                        ItemStack itemStack = stack.func_77946_l();
                                        itemStack.func_190920_e(accepted);
                                        this.itemsTransferredSinceLastSignal.add(itemStack);
                                    }
                                }
                                this.timeWithoutItemTransfer = 0;
                                stack.func_190918_g(accepted);
                                if (stack.func_190926_b() || (toTransfer -= accepted) == 0) break;
                            }
                            if (toTransfer == 0) break;
                        }
                        if (toTransfer != AunisConfig.beamerConfig.itemTransfer || this.field_145850_b.func_82737_E() % 20L != 0L) break;
                        ++this.timeWithoutItemTransfer;
                        break;
                    }
                }
                if (this.field_145850_b.func_82737_E() % (long)AunisConfig.beamerConfig.signalIntervalTicks == 0L) {
                    HashMap<String, Integer> map = new HashMap<String, Integer>();
                    switch (this.beamerMode) {
                        case POWER: {
                            if (this.powerTransferredSinceLastSignal <= 0) break;
                            map.put("power", this.powerTransferredSinceLastSignal);
                            this.sendSignal(null, "beamer_transfers", map);
                            this.powerTransferredSinceLastSignal = 0;
                            break;
                        }
                        case FLUID: {
                            if (this.fluidsTransferredSinceLastSignal.isEmpty()) break;
                            for (FluidStack stack : this.fluidsTransferredSinceLastSignal) {
                                map.put(stack.getLocalizedName(), stack.amount);
                            }
                            this.sendSignal(null, "beamer_transfers", map);
                            this.fluidsTransferredSinceLastSignal.clear();
                            break;
                        }
                        case ITEMS: {
                            if (this.itemsTransferredSinceLastSignal.isEmpty()) break;
                            for (ItemStack stack : this.itemsTransferredSinceLastSignal) {
                                map.put(stack.func_82833_r(), stack.func_190916_E());
                            }
                            this.sendSignal(null, "beamer_transfers", map);
                            this.itemsTransferredSinceLastSignal.clear();
                            break;
                        }
                    }
                    this.func_70296_d();
                }
            }
            if (this.beamerRole == BeamerRoleEnum.RECEIVE) {
                block20: for (EnumFacing side : EnumFacing.values()) {
                    TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side));
                    if (tileEntity == null) continue;
                    switch (this.beamerMode) {
                        case POWER: {
                            if (!tileEntity.hasCapability(CapabilityEnergy.ENERGY, side.func_176734_d())) continue block20;
                            IEnergyStorage targetEnergyStorage = (IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY, side.func_176734_d());
                            int tx = this.energyStorage.extractEnergy(AunisConfig.beamerConfig.energyTransfer, true);
                            tx = targetEnergyStorage.receiveEnergy(tx, false);
                            this.energyStorage.extractEnergy(tx, false);
                            continue block20;
                        }
                        case FLUID: {
                            if (!tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d())) continue block20;
                            IFluidHandler targetFluidHandler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d());
                            FluidStack drained = this.fluidHandler.drain(AunisConfig.beamerConfig.fluidTransfer, false);
                            int filled = targetFluidHandler.fill(drained, true);
                            this.fluidHandler.drain(filled, true);
                            continue block20;
                        }
                        case ITEMS: {
                            if (this.beamerStatus == BeamerStatusEnum.OK && this.field_145850_b.func_82737_E() % 20L == 0L) {
                                ++this.timeWithoutItemTransfer;
                            }
                            if (!tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d())) continue block20;
                            IItemHandler targetItemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d());
                            int toTransfer = AunisConfig.beamerConfig.itemTransfer;
                            for (int i = 1; i < 5; ++i) {
                                ItemStack stack = this.itemStackHandler.extractItem(i, toTransfer, true);
                                if (stack.func_190926_b()) continue;
                                for (int k = 0; k < targetItemHandler.getSlots(); ++k) {
                                    int accepted = stack.func_190916_E() - targetItemHandler.insertItem(k, stack, false).func_190916_E();
                                    this.itemStackHandler.extractItem(i, accepted, false);
                                    if ((toTransfer -= accepted) == 0) break;
                                }
                                if (toTransfer == 0) continue block20;
                            }
                            continue block20;
                        }
                    }
                }
            }
            if (this.beamerMode == BeamerModeEnum.POWER) {
                this.energyTransferredLastTick = this.energyStorage.getEnergyStored() - this.energyStoredLastTick;
                this.energyStoredLastTick = this.energyStorage.getEnergyStored();
            }
            if (lastBeamerStatus != this.beamerStatus) {
                this.syncToClient();
                if (this.beamerStatus == BeamerStatusEnum.OK) {
                    this.sendSignal(null, "beamer_started", new Object[0]);
                    AunisSoundHelper.playSoundEvent(this.field_145850_b, this.field_174879_c, SoundEventEnum.BEAMER_START);
                    this.addTask(new ScheduledTask(EnumScheduledTask.BEAMER_TOGGLE_SOUND, 12));
                    this.sendRenderingAction(BeamerRendererAction.BEAM_ON);
                } else if (lastBeamerStatus == BeamerStatusEnum.OK) {
                    this.sendSignal(null, "beamer_stopped", new Object[0]);
                    AunisSoundHelper.playSoundEvent(this.field_145850_b, this.field_174879_c, SoundEventEnum.BEAMER_STOP);
                    this.addTask(new ScheduledTask(EnumScheduledTask.BEAMER_TOGGLE_SOUND, 12));
                    this.sendRenderingAction(BeamerRendererAction.BEAM_OFF);
                }
            }
        } else {
            float speed = 0.005f;
            if (this.beamRadiusShrink) {
                if (this.beamRadiusClient > 0.0f) {
                    this.beamRadiusClient -= speed;
                } else {
                    this.beamRadiusShrink = false;
                    this.beamRadiusClient = 0.0f;
                }
            } else if (this.beamRadiusWiden) {
                if (this.beamRadiusClient < 0.1375f) {
                    this.beamRadiusClient += speed;
                } else {
                    this.beamRadiusWiden = false;
                    this.beamRadiusClient = 0.1375f;
                }
            }
        }
    }

    private void syncToClient() {
        this.sendState(StateTypeEnum.RENDERER_STATE, this.getState(StateTypeEnum.RENDERER_STATE));
    }

    private void sendRenderingAction(BeamerRendererAction action) {
        this.sendState(StateTypeEnum.RENDERER_ACTION, new BeamerRendererActionState(action));
    }

    public void gateEngaged(StargatePos targetGatePos) {
        BlockPos remoteBeamerPos = this.findTargetBeamerPos(targetGatePos);
        if (remoteBeamerPos != null) {
            this.targetBeamerWorld = targetGatePos.getWorld();
            this.targetBeamerPos = remoteBeamerPos;
            BeamerTile remoteBeamerTile = (BeamerTile)this.targetBeamerWorld.func_175625_s(this.targetBeamerPos);
            remoteBeamerTile.targetBeamerWorld = this.field_145850_b;
            remoteBeamerTile.targetBeamerPos = this.field_174879_c;
        }
    }

    public void gateClosed() {
        this.clearTargetBeamerPos();
    }

    @Nullable
    private BlockPos findTargetBeamerPos(StargatePos targetGatePos) {
        if (targetGatePos == null) {
            return null;
        }
        World targetWorld = targetGatePos.getWorld();
        EnumFacing targetFacing = (EnumFacing)targetWorld.func_180495_p(targetGatePos.gatePos).func_177229_b((IProperty)AunisProps.FACING_HORIZONTAL);
        Rotation rotation = FacingToRotation.get(targetFacing);
        BlockPos origVec = this.baseVect.func_190942_a(rotation);
        BlockPos startingVec = null;
        switch (targetFacing.func_176740_k()) {
            case X: {
                startingVec = new BlockPos(0, origVec.func_177956_o(), -origVec.func_177952_p());
                break;
            }
            case Z: {
                startingVec = new BlockPos(-origVec.func_177958_n(), origVec.func_177956_o(), 0);
                break;
            }
        }
        BlockPos beamerPos = targetGatePos.gatePos.func_177971_a(startingVec);
        for (int i = 1; i <= AunisConfig.beamerConfig.reach; ++i) {
            if (!BEAMER_MATCHER.apply(targetWorld.func_180495_p(beamerPos = beamerPos.func_177972_a(targetFacing)))) continue;
            BeamerTile targetBeamerTile = (BeamerTile)targetWorld.func_175625_s(beamerPos);
            if (!targetGatePos.gatePos.equals((Object)targetBeamerTile.basePos)) continue;
            return beamerPos.func_185334_h();
        }
        return null;
    }

    public void clearTargetBeamerPos() {
        BeamerTile targetBeamerTile;
        if (this.targetBeamerPos != null && (targetBeamerTile = (BeamerTile)this.targetBeamerWorld.func_175625_s(this.targetBeamerPos)) != null) {
            targetBeamerTile.targetBeamerPos = null;
        }
    }

    public BeamerModeEnum getMode() {
        return this.beamerMode;
    }

    public BeamerRoleEnum getRole() {
        return this.beamerRole;
    }

    public BeamerStatusEnum getStatus() {
        return this.beamerStatus;
    }

    public int getComparatorOutput() {
        return this.comparatorOutput;
    }

    public RedstoneModeEnum getRedstoneMode() {
        return this.redstoneMode;
    }

    public void setRedstoneMode(RedstoneModeEnum redstoneMode) {
        this.redstoneMode = redstoneMode;
        this.ocLocked = false;
        this.func_70296_d();
    }

    public void setStartStop(int start, int stop) {
        this.start = start;
        this.stop = stop;
        this.func_70296_d();
    }

    public int getStart() {
        return this.start;
    }

    public int getStop() {
        return this.stop;
    }

    public void setInactivity(int inactivity) {
        this.inactivity = inactivity;
        this.func_70296_d();
    }

    public int getInactivity() {
        return this.inactivity;
    }

    public boolean isActive() {
        return this.beamerStatus == BeamerStatusEnum.OK;
    }

    public void setNextRole() {
        this.beamerRole = this.beamerRole.next();
        this.func_70296_d();
    }

    public void updateObstructed() {
        if (this.basePos == null) {
            return;
        }
        this.isObstructed = false;
        int diff = 0;
        switch (this.facing.func_176740_k()) {
            case X: {
                diff = this.basePos.func_177958_n() - this.field_174879_c.func_177958_n();
                break;
            }
            case Z: {
                diff = this.basePos.func_177952_p() - this.field_174879_c.func_177952_p();
                break;
            }
        }
        if (diff < 0) {
            diff *= -1;
        }
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)this.field_174879_c.func_177972_a(this.facing), (BlockPos)this.field_174879_c.func_177967_a(this.facing, diff))) {
            IBlockState state = this.field_145850_b.func_180495_p(pos);
            Block block = state.func_177230_c();
            if ((block.isAir(state, (IBlockAccess)this.field_145850_b, pos) || block.func_176200_f((IBlockAccess)this.field_145850_b, pos) || !state.func_185914_p()) && block != AunisBlocks.IRIS_BLOCK) continue;
            this.isObstructed = true;
            break;
        }
    }

    public int updateComparatorOutput() {
        switch (this.beamerMode) {
            case POWER: {
                return ComparatorHelper.getComparatorLevel((IEnergyStorage)this.energyStorage);
            }
            case FLUID: {
                return ComparatorHelper.getComparatorLevel(this.fluidHandler);
            }
            case ITEMS: {
                return ComparatorHelper.getComparatorLevel((IItemHandler)this.itemStackHandler, 1);
            }
        }
        return 0;
    }

    public boolean isLinked() {
        return this.basePos != null;
    }

    public BlockPos getLinkedGate() {
        return this.basePos;
    }

    public StargateClassicBaseTile getLinkedGateTile() {
        return (StargateClassicBaseTile)this.field_145850_b.func_175625_s(this.basePos);
    }

    public void setLinkedGate(BlockPos basePos, BlockPos baseVect) {
        if (basePos == null || baseVect == null) {
            this.basePos = null;
            this.baseVect = null;
        } else {
            this.basePos = basePos.func_185334_h();
            this.baseVect = baseVect.func_185334_h();
        }
        this.func_70296_d();
    }

    private void updateMode() {
        this.beamerMode = BeamerTile.getModeFromItem(this.itemStackHandler.getStackInSlot(0).func_77973_b());
        this.func_70296_d();
        this.syncToClient();
    }

    @Override
    public Iterator<Integer> getUpgradeSlotsIterator() {
        return Iterators.singletonIterator((Object)0);
    }

    public static BeamerModeEnum getModeFromItem(Item crystal) {
        if (crystal == AunisItems.BEAMER_CRYSTAL_POWER) {
            return BeamerModeEnum.POWER;
        }
        if (crystal == AunisItems.BEAMER_CRYSTAL_FLUID) {
            return BeamerModeEnum.FLUID;
        }
        if (crystal == AunisItems.BEAMER_CRYSTAL_ITEMS) {
            return BeamerModeEnum.ITEMS;
        }
        return BeamerModeEnum.NONE;
    }

    public int getEnergyTransferredLastTick() {
        return this.energyTransferredLastTick;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (facing != this.facing) {
            return this.beamerMode == BeamerModeEnum.ITEMS && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || this.beamerMode == BeamerModeEnum.POWER && capability == CapabilityEnergy.ENERGY || this.beamerMode == BeamerModeEnum.FLUID && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing != this.facing) {
            if ((this.beamerMode == BeamerModeEnum.ITEMS || facing == null) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemStackHandler);
            }
            if ((this.beamerMode == BeamerModeEnum.POWER || facing == null) && capability == CapabilityEnergy.ENERGY) {
                return (T)CapabilityEnergy.ENERGY.cast((Object)this.energyStorage);
            }
            if ((this.beamerMode == BeamerModeEnum.FLUID || facing == null) && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.fluidHandler);
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void addTask(ScheduledTask scheduledTask) {
        scheduledTask.setExecutor(this);
        scheduledTask.setTaskCreated(this.field_145850_b.func_82737_E());
        this.scheduledTasks.add(scheduledTask);
        this.func_70296_d();
    }

    @Override
    public void executeTask(EnumScheduledTask scheduledTask, NBTTagCompound customData) {
        switch (scheduledTask) {
            case BEAMER_TOGGLE_SOUND: {
                if (this.loopSoundPlaying) {
                    AunisSoundHelper.playPositionedSound(this.field_145850_b, this.field_174879_c, SoundPositionedEnum.BEAMER_LOOP, false);
                } else {
                    AunisSoundHelper.playPositionedSound(this.field_145850_b, this.field_174879_c, SoundPositionedEnum.BEAMER_LOOP, true);
                }
                this.loopSoundPlaying ^= true;
                this.func_70296_d();
                break;
            }
        }
    }

    protected void sendState(StateTypeEnum type, State state) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.targetPoint != null) {
            AunisPacketHandler.INSTANCE.sendToAllTracking((IMessage)new StateUpdatePacketToClient(this.field_174879_c, type, state), this.targetPoint);
        } else {
            Aunis.logger.debug("targetPoint was null trying to send " + (Object)((Object)type) + " from " + this.getClass().getCanonicalName());
        }
    }

    @Override
    public State getState(StateTypeEnum stateType) {
        switch (stateType) {
            case RENDERER_UPDATE: {
                return new BeamerRendererUpdate(this.beamerStatus);
            }
            case RENDERER_STATE: {
                int distance = 0;
                if (this.baseVect != null && (distance = this.baseVect.func_177952_p()) < 0) {
                    distance = -distance;
                }
                return new BeamerRendererState(this.beamerMode, this.beamerRole, this.beamerStatus, this.isObstructed, distance);
            }
            case GUI_UPDATE: {
                return new BeamerContainerGuiUpdate(this.energyStorage.getEnergyStored(), this.energyTransferredLastTick, this.fluidHandler.getFluid(), this.beamerRole, this.redstoneMode, this.start, this.stop, this.inactivity);
            }
            case BEAMER_FLUID_UPDATE: {
                FluidStack fluidStack = this.fluidHandler.getFluid();
                return new BeamerFluidUpdate(fluidStack != null ? fluidStack.getFluid() : null);
            }
        }
        return null;
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        switch (stateType) {
            case RENDERER_ACTION: {
                return new BeamerRendererActionState();
            }
            case RENDERER_STATE: {
                return new BeamerRendererState();
            }
            case RENDERER_UPDATE: {
                return new BeamerRendererUpdate();
            }
            case GUI_UPDATE: {
                return new BeamerContainerGuiUpdate();
            }
            case BEAMER_FLUID_UPDATE: {
                return new BeamerFluidUpdate();
            }
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setState(StateTypeEnum stateType, State state) {
        switch (stateType) {
            case RENDERER_STATE: {
                BeamerRendererState rendererState = (BeamerRendererState)state;
                this.beamerMode = rendererState.beamerMode;
                this.beamerRole = rendererState.beamerRole;
                this.beamerStatus = rendererState.beamerStatus;
                this.isObstructed = rendererState.isObstructed;
                this.beamLengthClient = rendererState.beamLength;
                this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
                break;
            }
            case RENDERER_UPDATE: {
                BeamerRendererUpdate update = (BeamerRendererUpdate)state;
                this.beamRadiusClient = update.beamerStatus == BeamerStatusEnum.OK ? 0.1375f : 0.0f;
                AunisSoundHelperClient.playPositionedSoundClientSide(this.field_174879_c, SoundPositionedEnum.BEAMER_LOOP, update.beamerStatus == BeamerStatusEnum.OK);
                break;
            }
            case RENDERER_ACTION: {
                BeamerRendererActionState rendererAction = (BeamerRendererActionState)state;
                switch (rendererAction.action) {
                    case BEAM_ON: {
                        this.beamRadiusClient = 0.0f;
                        this.beamRadiusWiden = true;
                        this.beamRadiusShrink = false;
                        break;
                    }
                    case BEAM_OFF: {
                        this.beamRadiusClient = 0.1375f;
                        this.beamRadiusWiden = false;
                        this.beamRadiusShrink = true;
                    }
                }
                break;
            }
            case GUI_UPDATE: {
                BeamerContainerGuiUpdate guiUpdate = (BeamerContainerGuiUpdate)state;
                this.energyStorage.setEnergyStored(guiUpdate.energyStored);
                this.energyTransferredLastTick = guiUpdate.transferredLastTick;
                this.fluidHandler.setFluid(guiUpdate.fluidStack);
                this.beamerRole = guiUpdate.beamerRole;
                this.redstoneMode = guiUpdate.mode;
                this.start = guiUpdate.start;
                this.stop = guiUpdate.stop;
                this.inactivity = guiUpdate.inactivity;
                GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
                if (!(screen instanceof BeamerContainerGui)) break;
                ((BeamerContainerGui)screen).updateStartStopInactivity();
                break;
            }
            case BEAMER_FLUID_UPDATE: {
                BeamerFluidUpdate fluidUpdate = (BeamerFluidUpdate)state;
                this.lastFluidTransferred = fluidUpdate.fluidContained;
                Aunis.logger.debug("Received beamer fluid update: " + this.lastFluidTransferred);
                break;
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (this.baseVect != null && this.basePos != null) {
            compound.func_74772_a("baseVect", this.baseVect.func_177986_g());
            compound.func_74772_a("basePos", this.basePos.func_177986_g());
        }
        compound.func_74782_a("itemStackHandler", (NBTBase)this.itemStackHandler.serializeNBT());
        compound.func_74782_a("energyStorage", (NBTBase)this.energyStorage.serializeNBT());
        NBTTagCompound fluidHandlerCompound = new NBTTagCompound();
        this.fluidHandler.writeToNBT(fluidHandlerCompound);
        compound.func_74782_a("fluidHandler", (NBTBase)fluidHandlerCompound);
        compound.func_74768_a("beamerMode", this.beamerMode.getKey().intValue());
        compound.func_74768_a("beamerRole", this.beamerRole.getKey().intValue());
        compound.func_74768_a("redstoneMode", this.redstoneMode.getKey().intValue());
        compound.func_74768_a("start", this.start);
        compound.func_74768_a("stop", this.stop);
        compound.func_74768_a("inactivity", this.inactivity);
        compound.func_74757_a("ocLocked", this.ocLocked);
        compound.func_74757_a("loopSoundPlaying", this.loopSoundPlaying);
        compound.func_74782_a("scheduledTasks", (NBTBase)ScheduledTask.serializeList(this.scheduledTasks));
        if (this.node != null) {
            NBTTagCompound nodeCompound = new NBTTagCompound();
            this.node.save(nodeCompound);
            compound.func_74782_a("node", (NBTBase)nodeCompound);
        }
        compound.func_74768_a("powerTransferredSinceLastSignal", this.powerTransferredSinceLastSignal);
        compound.func_74782_a("fluidsTransferredSinceLastSignal", (NBTBase)NBTHelper.serializeFluidStackList(this.fluidsTransferredSinceLastSignal));
        compound.func_74782_a("itemsTransferredSinceLastSignal", (NBTBase)NBTHelper.serializeItemStackList(this.itemsTransferredSinceLastSignal));
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("baseVect") && compound.func_74764_b("basePos")) {
            this.baseVect = BlockPos.func_177969_a((long)compound.func_74763_f("baseVect"));
            this.basePos = BlockPos.func_177969_a((long)compound.func_74763_f("basePos"));
        }
        this.itemStackHandler.deserializeNBT(compound.func_74775_l("itemStackHandler"));
        this.energyStorage.deserializeNBT(compound.func_74775_l("energyStorage"));
        this.fluidHandler.readFromNBT(compound.func_74775_l("fluidHandler"));
        this.beamerMode = BeamerModeEnum.valueOf(compound.func_74762_e("beamerMode"));
        this.beamerRole = BeamerRoleEnum.valueOf(compound.func_74762_e("beamerRole"));
        this.redstoneMode = RedstoneModeEnum.valueOf(compound.func_74762_e("redstoneMode"));
        this.start = compound.func_74762_e("start");
        this.stop = compound.func_74762_e("stop");
        this.inactivity = compound.func_74762_e("inactivity");
        this.ocLocked = compound.func_74767_n("ocLocked");
        this.loopSoundPlaying = compound.func_74767_n("loopSoundPlaying");
        this.powerTransferredSinceLastSignal = compound.func_74762_e("powerTransferredSinceLastSignal");
        this.fluidsTransferredSinceLastSignal.clear();
        this.itemsTransferredSinceLastSignal.clear();
        NBTHelper.deserializeFluidStackList(compound.func_150295_c("fluidsTransferredSinceLastSignal", 10), this.fluidsTransferredSinceLastSignal);
        NBTHelper.deserializeItemStackList(compound.func_150295_c("itemsTransferredSinceLastSignal", 10), this.itemsTransferredSinceLastSignal);
        if (this.node != null && compound.func_74764_b("node")) {
            this.node.load(compound.func_74775_l("node"));
        }
        ScheduledTask.deserializeList(compound.func_74775_l("scheduledTasks"), this.scheduledTasks, this);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.renderBoxOffsetted;
    }

    public double func_145833_n() {
        return 65536.0;
    }

    public void onChunkUnload() {
        if (this.node != null) {
            this.node.remove();
        }
    }

    public void func_145843_s() {
        if (this.node != null) {
            this.node.remove();
        }
        super.func_145843_s();
    }

    @Optional.Method(modid="opencomputers")
    public Node node() {
        return this.node;
    }

    @Optional.Method(modid="opencomputers")
    public void onConnect(Node node) {
    }

    @Optional.Method(modid="opencomputers")
    public void onDisconnect(Node node) {
    }

    @Optional.Method(modid="opencomputers")
    public void onMessage(Message message) {
    }

    public void sendSignal(Object context, String name, Object ... params) {
        Aunis.ocWrapper.sendSignalToReachable(this.node, (Context)context, name, params);
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] isActive(Context context, Arguments args) {
        return new Object[]{this.isActive()};
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] setActive(Context context, Arguments args) {
        this.ocLocked = !args.checkBoolean(0);
        this.func_70296_d();
        return new Object[0];
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] start(Context context, Arguments args) {
        this.ocLocked = false;
        this.func_70296_d();
        return new Object[0];
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] stop(Context context, Arguments args) {
        this.ocLocked = true;
        this.func_70296_d();
        return new Object[0];
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] getBeamerMode(Context context, Arguments args) {
        return new Object[]{this.beamerMode.toString().toLowerCase()};
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] getBeamerRole(Context context, Arguments args) {
        return new Object[]{this.beamerRole.toString().toLowerCase()};
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] setBeamerRole(Context context, Arguments args) {
        try {
            this.beamerRole = BeamerRoleEnum.valueOf(args.checkString(0).toUpperCase());
            this.func_70296_d();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Wrong Role name");
        }
        return new Object[0];
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] getBeamerRedstoneMode(Context context, Arguments args) {
        return new Object[]{this.redstoneMode.toString().toLowerCase()};
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] setBeamerRedstoneMode(Context context, Arguments args) {
        try {
            this.redstoneMode = RedstoneModeEnum.valueOf(args.checkString(0).toUpperCase());
            this.func_70296_d();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Wrong Mode name");
        }
        return new Object[0];
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] toggleBeamerRole(Context context, Arguments args) {
        switch (this.beamerRole) {
            case RECEIVE: {
                this.beamerRole = BeamerRoleEnum.TRANSMIT;
                return new Object[]{this.beamerRole.toString().toLowerCase()};
            }
            case TRANSMIT: {
                this.beamerRole = BeamerRoleEnum.RECEIVE;
                return new Object[]{this.beamerRole.toString().toLowerCase()};
            }
            case DISABLED: {
                return new Object[]{"err_beamer_disabled"};
            }
        }
        return null;
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] getBeamerStatus(Context context, Arguments args) {
        return new Object[]{this.beamerStatus.toString().toLowerCase()};
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] getBufferStored(Context context, Arguments args) {
        switch (this.beamerMode) {
            case POWER: {
                return new Object[]{this.energyStorage.getEnergyStored()};
            }
            case FLUID: {
                return new Object[]{this.fluidHandler.getFluidAmount(), this.fluidHandler.getFluid() != null ? Aunis.proxy.localize(this.fluidHandler.getFluid().getFluid().getUnlocalizedName(), new Object[0]) : null};
            }
            case ITEMS: {
                ArrayList<AbstractMap.SimpleEntry<String, Integer>> stackList = new ArrayList<AbstractMap.SimpleEntry<String, Integer>>(4);
                for (int i = 1; i < 5; ++i) {
                    ItemStack stack = this.itemStackHandler.getStackInSlot(i);
                    stackList.add(new AbstractMap.SimpleEntry<String, Integer>(stack.func_82833_r(), stack.func_190916_E()));
                }
                return new Object[]{stackList};
            }
        }
        return new Object[]{"no_mode_set"};
    }

    @Optional.Method(modid="opencomputers")
    @Callback
    public Object[] getBufferCapacity(Context context, Arguments args) {
        switch (this.beamerMode) {
            case POWER: {
                return new Object[]{this.energyStorage.getMaxEnergyStored()};
            }
            case FLUID: {
                return new Object[]{this.fluidHandler.getCapacity()};
            }
            case ITEMS: {
                ArrayList<AbstractMap.SimpleEntry<String, Integer>> stackList = new ArrayList<AbstractMap.SimpleEntry<String, Integer>>(4);
                for (int i = 1; i < 5; ++i) {
                    ItemStack stack = this.itemStackHandler.getStackInSlot(i);
                    stackList.add(new AbstractMap.SimpleEntry<String, Integer>(stack.func_82833_r(), stack.func_77976_d()));
                }
                return new Object[]{stackList};
            }
        }
        return new Object[]{"no_mode_set"};
    }

    private class ItemStackHandlerBeamer
    extends ItemStackHandler {
        public ItemStackHandlerBeamer(int slots) {
            super(slots);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            Item item = stack.func_77973_b();
            switch (slot) {
                case 0: {
                    return item == AunisItems.BEAMER_CRYSTAL_POWER || item == AunisItems.BEAMER_CRYSTAL_FLUID || item == AunisItems.BEAMER_CRYSTAL_ITEMS;
                }
            }
            return true;
        }

        protected int getStackLimit(int slot, ItemStack stack) {
            if (slot == 0) {
                return 1;
            }
            return super.getStackLimit(slot, stack);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (!((BeamerTile)BeamerTile.this).field_145850_b.field_72995_K && slot == 0) {
                BeamerTile.this.updateMode();
            }
            BeamerTile.this.func_70296_d();
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack stack = super.extractItem(slot, amount, simulate);
            if (!((BeamerTile)BeamerTile.this).field_145850_b.field_72995_K && slot == 0 && !simulate) {
                BeamerTile.this.updateMode();
            }
            return stack;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (BeamerTile.this.beamerRole != BeamerRoleEnum.TRANSMIT && slot != 0) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack insertItemInternal(int slot, ItemStack stack, boolean simulate) {
            BeamerTile.this.timeWithoutItemTransfer = 0;
            return super.insertItem(slot, stack, simulate);
        }
    }
}

