/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.state.transportrings;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mrjake.aunis.state.State;
import mrjake.aunis.transportrings.TransportRings;

public class TransportRingsGuiState
extends State {
    private boolean inGrid;
    private int address;
    private String name;
    private List<TransportRings> ringsList = new ArrayList<TransportRings>();

    public boolean isInGrid() {
        return this.inGrid;
    }

    public int getAddress() {
        return this.address;
    }

    public String getName() {
        return this.name != null ? this.name : "";
    }

    public List<TransportRings> getRings() {
        return this.ringsList;
    }

    public TransportRingsGuiState() {
    }

    public TransportRingsGuiState(TransportRings rings, Collection<TransportRings> ringsList) {
        this.inGrid = rings.isInGrid();
        if (this.inGrid) {
            this.address = rings.getAddress();
            this.name = rings.getName();
            this.ringsList.addAll(ringsList);
        }
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.inGrid);
        if (this.inGrid) {
            buf.writeInt(this.address);
            buf.writeInt(this.name.length());
            buf.writeCharSequence((CharSequence)this.name, StandardCharsets.UTF_8);
            buf.writeInt(this.ringsList.size());
            for (TransportRings rings : this.ringsList) {
                buf.writeInt(rings.getAddress());
                buf.writeInt(rings.getName().length());
                buf.writeCharSequence((CharSequence)rings.getName(), StandardCharsets.UTF_8);
            }
        }
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.inGrid = buf.readBoolean();
        if (this.inGrid) {
            this.address = buf.readInt();
            int length = buf.readInt();
            this.name = buf.readCharSequence(length, StandardCharsets.UTF_8).toString();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                int address = buf.readInt();
                length = buf.readInt();
                String name = buf.readCharSequence(length, StandardCharsets.UTF_8).toString();
                this.ringsList.add(new TransportRings(address, name));
            }
        }
    }
}

