/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.state.stargate;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import mrjake.aunis.stargate.EnumIrisState;
import mrjake.aunis.stargate.EnumIrisType;
import mrjake.aunis.state.State;

public class StargateRendererActionState
extends State {
    public static final StargateRendererActionState STARGATE_HORIZON_WIDEN_ACTION = new StargateRendererActionState(EnumGateAction.STARGATE_HORIZON_WIDEN);
    public static final StargateRendererActionState STARGATE_HORIZON_SHRINK_ACTION = new StargateRendererActionState(EnumGateAction.STARGATE_HORIZON_SHRINK);
    public EnumGateAction action;
    public int chevronCount;
    public boolean modifyFinal;
    public EnumIrisState irisState = null;
    public EnumIrisType irisType = null;
    public long irisAnimation = 0L;

    public StargateRendererActionState() {
    }

    public StargateRendererActionState(EnumGateAction action) {
        this.action = action;
    }

    public StargateRendererActionState(EnumGateAction action, int chevronCount, boolean modifyFinal) {
        this.action = action;
        this.chevronCount = chevronCount;
        this.modifyFinal = modifyFinal;
    }

    public StargateRendererActionState(EnumGateAction action, int chevronCount, boolean modifyFinal, EnumIrisType irisType, EnumIrisState irisState, long irisAnimation) {
        this.action = action;
        this.chevronCount = chevronCount;
        this.modifyFinal = modifyFinal;
        this.irisState = irisState;
        this.irisType = irisType;
        this.irisAnimation = irisAnimation;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.action.actionID);
        buf.writeInt(this.chevronCount);
        buf.writeBoolean(this.modifyFinal);
        if (this.irisType != null) {
            buf.writeBoolean(true);
            buf.writeByte((int)this.irisState.id);
            buf.writeByte((int)this.irisType.id);
            buf.writeLong(this.irisAnimation);
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.action = EnumGateAction.valueOf(buf.readInt());
        this.chevronCount = buf.readInt();
        this.modifyFinal = buf.readBoolean();
        if (buf.readBoolean()) {
            this.irisState = EnumIrisState.getValue(buf.readByte());
            this.irisType = EnumIrisType.byId(buf.readByte());
            this.irisAnimation = buf.readLong();
        }
    }

    public static enum EnumGateAction {
        CHEVRON_ACTIVATE(1),
        OPEN_GATE(3),
        CLOSE_GATE(4),
        CLEAR_CHEVRONS(5),
        LIGHT_UP_CHEVRONS(6),
        STARGATE_HORIZON_WIDEN(7),
        STARGATE_HORIZON_SHRINK(8),
        CHEVRON_OPEN(9),
        CHEVRON_CLOSE(10),
        CHEVRON_ACTIVATE_BOTH(11),
        CHEVRON_DIM(12),
        IRIS_UPDATE(13),
        ACTIVATE_GLYPH(14);

        public int actionID;
        private static Map<Integer, EnumGateAction> map;

        private EnumGateAction(int actionID) {
            this.actionID = actionID;
        }

        public static EnumGateAction valueOf(int actionID) {
            return map.get(actionID);
        }

        static {
            map = new HashMap<Integer, EnumGateAction>();
            for (EnumGateAction action : EnumGateAction.values()) {
                map.put(action.actionID, action);
            }
        }
    }
}

