/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.stargate.teleportation;

import javax.vecmath.Vector2f;
import mrjake.aunis.sound.AunisSoundHelper;
import mrjake.aunis.sound.SoundEventEnum;
import mrjake.aunis.stargate.network.StargatePos;
import mrjake.aunis.stargate.teleportation.TeleportHelper;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;

public class TeleportPacket {
    private BlockPos sourceGatePos;
    private StargatePos targetGatePos;
    private Entity entity;
    private float rotation;
    private Vector2f motionVector;

    public TeleportPacket(Entity entity, BlockPos source, StargatePos target, float rotation) {
        this.entity = entity;
        this.sourceGatePos = source;
        this.targetGatePos = target;
        this.rotation = rotation;
    }

    public StargatePos getTargetGatePos() {
        return this.targetGatePos;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void teleport() {
        this.teleport(true);
    }

    public void teleport(boolean playSound) {
        TeleportHelper.teleportEntity(this.entity, this.sourceGatePos, this.targetGatePos, this.rotation, this.motionVector);
        if (playSound) {
            AunisSoundHelper.playSoundEvent(this.targetGatePos.getWorld(), this.targetGatePos.getTileEntity().getGateCenterPos(), SoundEventEnum.WORMHOLE_GO);
        }
    }

    public TeleportPacket setMotion(Vector2f motion) {
        this.motionVector = motion;
        return this;
    }
}

