/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.stargate.teleportation;

import java.util.List;
import javax.vecmath.Vector2f;
import mrjake.aunis.stargate.network.StargatePos;
import mrjake.aunis.tileentity.stargate.StargateAbstractBaseTile;
import mrjake.aunis.tileentity.stargate.StargateOrlinBaseTile;
import mrjake.vector.Matrix2f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ITeleporter;

public class TeleportHelper {
    private static void translateTo00(Vector2f center, Vector2f v) {
        v.x -= center.x;
        v.y -= center.y;
    }

    public static void rotateAround00(Vector2f v, float rotation, int flip) {
        Matrix2f m = new Matrix2f();
        Matrix2f p = new Matrix2f();
        float sin = MathHelper.func_76126_a((float)rotation);
        float cos = MathHelper.func_76134_b((float)rotation);
        if (EnumFlipAxis.masked(EnumFlipAxis.X, flip)) {
            v.x *= -1.0f;
        }
        if (EnumFlipAxis.masked(EnumFlipAxis.Z, flip)) {
            v.y *= -1.0f;
        }
        m.m00 = cos;
        m.m10 = -sin;
        m.m01 = sin;
        m.m11 = cos;
        p.m00 = v.x;
        p.m10 = 0.0f;
        p.m01 = v.y;
        p.m11 = 0.0f;
        Matrix2f out = Matrix2f.mul(m, p, null);
        v.x = out.m00;
        v.y = out.m01;
    }

    private static void translateToDest(Vector2f v, Vector2f dest) {
        v.x += dest.x;
        v.y += dest.y;
    }

    public static void teleportEntity(Entity entity, BlockPos sourceGatePos, StargatePos targetGatePos, float rotation, Vector2f motionVector) {
        List passengers = null;
        if (entity.func_184218_aH()) {
            return;
        }
        if (entity.func_184207_aI()) {
            passengers = entity.func_184188_bt();
            entity.func_184226_ay();
            for (Entity passenger : passengers) {
                TeleportHelper.teleportEntity(passenger, sourceGatePos, targetGatePos, rotation, motionVector);
            }
        }
        World world = entity.func_130014_f_();
        int sourceDim = world.field_73011_w.getDimension();
        StargateAbstractBaseTile sourceTile = (StargateAbstractBaseTile)world.func_175625_s(sourceGatePos);
        StargateAbstractBaseTile targetTile = targetGatePos.getTileEntity();
        int flipAxis = 0;
        flipAxis = sourceTile.getFacing().func_176740_k() == targetTile.getFacing().func_176740_k() ? (flipAxis |= EnumFlipAxis.X.mask) : (flipAxis |= EnumFlipAxis.Z.mask);
        Vec3d pos = null;
        BlockPos tPos = targetGatePos.gatePos;
        pos = sourceTile instanceof StargateOrlinBaseTile ? new Vec3d((double)tPos.func_177958_n() + 0.5, (double)tPos.func_177956_o() + 2.0, (double)tPos.func_177952_p() + 0.5) : (targetTile instanceof StargateOrlinBaseTile ? new Vec3d((double)tPos.func_177958_n() + 0.5, (double)tPos.func_177956_o() + 0.5, (double)tPos.func_177952_p() + 0.5) : TeleportHelper.getPosition(entity, sourceTile.getGateCenterPos(), targetTile.getGateCenterPos(), rotation, targetTile.getFacing().func_176740_k() == EnumFacing.Axis.Z ? ~flipAxis : flipAxis));
        final float yawRotated = TeleportHelper.getRotation(entity.func_184207_aI() ? entity.func_184179_bs() : entity, rotation, flipAxis);
        boolean isPlayer = entity instanceof EntityPlayerMP;
        if (sourceDim == targetGatePos.dimensionID) {
            TeleportHelper.setRotationAndPosition(entity, yawRotated, pos);
        } else {
            if (!ForgeHooks.onTravelToDimension((Entity)entity, (int)targetGatePos.dimensionID)) {
                return;
            }
            final Vec3d posFinal = pos;
            ITeleporter teleporter = new ITeleporter(){

                public void placeEntity(World world, Entity entity, float yaw) {
                    TeleportHelper.setRotationAndPosition(entity, yawRotated, posFinal);
                }
            };
            if (isPlayer) {
                EntityPlayerMP player = (EntityPlayerMP)entity;
                player.func_184102_h().func_184103_al().transferPlayerToDimension(player, targetGatePos.dimensionID, teleporter);
            } else {
                entity = entity.changeDimension(targetGatePos.dimensionID, teleporter);
            }
        }
        TeleportHelper.setMotion(entity, rotation, motionVector);
        sourceTile.entityPassing(entity, false);
        targetTile.entityPassing(entity, true);
        if (passengers != null) {
            for (Entity passenger : passengers) {
                passenger.func_184220_m(entity);
            }
        }
    }

    public static void teleportWithRiders(Entity entity, float yawRotated, Vec3d pos) {
        if (entity.func_184207_aI()) {
            for (Entity entity2 : entity.func_184188_bt()) {
                TeleportHelper.setRotationAndPosition(entity2, yawRotated, pos);
            }
        }
        TeleportHelper.setRotationAndPosition(entity, yawRotated, pos);
    }

    public static void setRotationAndPosition(Entity entity, float yawRotated, Vec3d pos) {
        entity.field_70177_z = yawRotated;
        entity.func_70634_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        entity.func_130014_f_().func_72866_a(entity, true);
    }

    public static float getRotation(Entity player, float rotation, int flipAxis) {
        Vec3d lookVec = player.func_70040_Z();
        Vector2f lookVec2f = new Vector2f((float)lookVec.field_72450_a, (float)lookVec.field_72449_c);
        TeleportHelper.rotateAround00(lookVec2f, rotation, flipAxis);
        return (float)Math.toDegrees(MathHelper.func_181159_b((double)lookVec2f.x, (double)lookVec2f.y));
    }

    public static void setMotion(Entity player, float rotation, Vector2f motionVec2f) {
        if (motionVec2f != null) {
            TeleportHelper.rotateAround00(motionVec2f, rotation, 0);
            if (motionVec2f != null) {
                player.field_70159_w = motionVec2f.x;
            }
            if (motionVec2f != null) {
                player.field_70179_y = motionVec2f.y;
            }
            player.field_70133_I = true;
        }
    }

    public static Vec3d getPosition(Entity player, BlockPos sourceGatePos, BlockPos targetGatePos, float rotation, int flipAxis) {
        Vector2f sourceCenter = new Vector2f((float)sourceGatePos.func_177958_n() + 0.5f, (float)sourceGatePos.func_177952_p() + 0.5f);
        Vector2f destCenter = new Vector2f((float)targetGatePos.func_177958_n() + 0.5f, (float)targetGatePos.func_177952_p() + 0.5f);
        Vector2f playerPosition = new Vector2f((float)player.field_70165_t, (float)player.field_70161_v);
        TeleportHelper.translateTo00(sourceCenter, playerPosition);
        TeleportHelper.rotateAround00(playerPosition, rotation, flipAxis);
        TeleportHelper.translateToDest(playerPosition, destCenter);
        float y = (float)((double)targetGatePos.func_177956_o() + (player.field_70163_u - (double)sourceGatePos.func_177956_o()));
        return new Vec3d((double)playerPosition.x, (double)y, (double)playerPosition.y);
    }

    public static World getWorld(int dimension) {
        WorldServer world = DimensionManager.getWorld((int)0);
        if (dimension == 0) {
            return world;
        }
        return world.func_73046_m().func_71218_a(dimension);
    }

    public static boolean frontSide(EnumFacing sourceFacing, Vector2f motionVec) {
        EnumFacing.Axis axis = sourceFacing.func_176740_k();
        EnumFacing.AxisDirection direction = sourceFacing.func_176743_c();
        float motion = axis == EnumFacing.Axis.X ? motionVec.x : motionVec.y;
        if (direction == EnumFacing.AxisDirection.POSITIVE) {
            return motion <= 0.0f;
        }
        return motion >= 0.0f;
    }

    static enum EnumFlipAxis {
        X(1),
        Z(2);

        public int mask;

        private EnumFlipAxis(int mask) {
            this.mask = mask;
        }

        public static boolean masked(EnumFlipAxis flipAxis, int in) {
            return (in & flipAxis.mask) != 0;
        }
    }
}

