/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.stargate.teleportation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.vecmath.Vector2f;
import mrjake.aunis.AunisDamageSources;
import mrjake.aunis.AunisProps;
import mrjake.aunis.api.event.StargateTeleportEntityEvent;
import mrjake.aunis.config.AunisConfig;
import mrjake.aunis.item.AunisItems;
import mrjake.aunis.item.UpgradeIris;
import mrjake.aunis.packet.AunisPacketHandler;
import mrjake.aunis.packet.stargate.StargateMotionToClient;
import mrjake.aunis.sound.AunisSoundHelper;
import mrjake.aunis.sound.SoundEventEnum;
import mrjake.aunis.stargate.network.StargatePos;
import mrjake.aunis.stargate.teleportation.TeleportHelper;
import mrjake.aunis.stargate.teleportation.TeleportPacket;
import mrjake.aunis.tileentity.stargate.StargateAbstractBaseTile;
import mrjake.aunis.tileentity.stargate.StargateClassicBaseTile;
import mrjake.aunis.util.AunisAxisAlignedBB;
import net.minecraft.block.properties.IProperty;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EventHorizon {
    private World world;
    private BlockPos pos;
    private BlockPos gateCenter;
    private AunisAxisAlignedBB localBox;
    private AunisAxisAlignedBB globalBox;
    public static Random randomGenerator = new Random();
    private Map<Integer, TeleportPacket> scheduledTeleportMap = new HashMap<Integer, TeleportPacket>();
    private Map<Integer, Integer> timeoutMap = new HashMap<Integer, Integer>();

    public EventHorizon(World world, BlockPos pos, BlockPos gateCenter, EnumFacing facing, AunisAxisAlignedBB localBox) {
        this.world = world;
        this.pos = pos;
        this.gateCenter = gateCenter;
        this.localBox = localBox.rotate(facing).offset(0.5, 0.0, 0.5);
        this.globalBox = this.localBox.offset(pos);
    }

    public void reset() {
        this.scheduledTeleportMap.clear();
    }

    public AunisAxisAlignedBB getLocalBox() {
        return this.localBox;
    }

    public void scheduleTeleportation(StargatePos targetGate) {
        if (this.world.func_175625_s(this.pos) instanceof StargateClassicBaseTile && ((StargateClassicBaseTile)this.world.func_175625_s(this.pos)).isClosed()) {
            return;
        }
        List entities = this.world.func_72872_a(Entity.class, (AxisAlignedBB)this.globalBox);
        for (int entityId : this.timeoutMap.keySet()) {
            this.timeoutMap.put(entityId, this.timeoutMap.get(entityId) - 1);
        }
        this.timeoutMap.entrySet().removeIf(entry -> (Integer)entry.getValue() < 0);
        for (Entity entity : entities) {
            int entityId = entity.func_145782_y();
            if (this.scheduledTeleportMap.containsKey(entityId) || this.timeoutMap.containsKey(entityId) || entity.func_184218_aH()) continue;
            EnumFacing sourceFacing = (EnumFacing)this.world.func_180495_p(this.pos).func_177229_b((IProperty)AunisProps.FACING_HORIZONTAL);
            EnumFacing targetFacing = (EnumFacing)targetGate.getBlockState().func_177229_b((IProperty)AunisProps.FACING_HORIZONTAL);
            float rotation = (float)Math.toRadians(EnumFacing.func_176733_a((double)(targetFacing.func_185119_l() - sourceFacing.func_185119_l())).func_176734_d().func_185119_l());
            TeleportPacket packet = new TeleportPacket(entity, this.pos, targetGate, rotation);
            if (entity instanceof EntityPlayerMP) {
                this.scheduledTeleportMap.put(entityId, packet);
                AunisPacketHandler.INSTANCE.sendTo((IMessage)new StargateMotionToClient(this.pos), (EntityPlayerMP)entity);
                continue;
            }
            Vector2f motion = new Vector2f((float)entity.field_70159_w, (float)entity.field_70179_y);
            if (!TeleportHelper.frontSide(sourceFacing, motion)) continue;
            for (Entity passenger : entity.func_184188_bt()) {
                this.timeoutMap.put(passenger.func_145782_y(), 40);
            }
            this.timeoutMap.put(entityId, 40);
            this.scheduledTeleportMap.put(entityId, packet.setMotion(motion));
            this.teleportEntity(entityId);
        }
    }

    private void irisKill(Entity e) {
        e.func_70097_a(AunisDamageSources.DAMAGE_EVENT_IRIS_CREATIVE, Float.MAX_VALUE);
    }

    public void teleportEntity(int entityId) {
        TeleportPacket packet = this.scheduledTeleportMap.get(entityId);
        if (!new StargateTeleportEntityEvent((StargateAbstractBaseTile)this.world.func_175625_s(this.pos), packet.getTargetGatePos().getTileEntity(), packet.getEntity()).post()) {
            StargatePos targetGatePos = packet.getTargetGatePos();
            if (targetGatePos.getTileEntity() instanceof StargateClassicBaseTile && ((StargateClassicBaseTile)targetGatePos.getTileEntity()).isClosed()) {
                if (packet.getEntity() instanceof IProjectile) {
                    Entity projectile = packet.getEntity();
                    projectile.func_70016_h(0.0, 0.0, 0.0);
                    projectile.func_70106_y();
                } else {
                    if (AunisConfig.irisConfig.killAtDestination) {
                        packet.teleport(false);
                    }
                    if (AunisConfig.irisConfig.allowCreative && packet.getEntity() instanceof EntityPlayer && ((EntityPlayer)packet.getEntity()).field_71075_bZ.field_75098_d) {
                        if (!AunisConfig.irisConfig.killAtDestination) {
                            packet.teleport();
                        }
                    } else {
                        if (!packet.getEntity().func_184188_bt().isEmpty()) {
                            for (Entity passenger : packet.getEntity().func_184188_bt()) {
                                this.irisKill(passenger);
                            }
                        }
                        this.irisKill(packet.getEntity());
                        packet.getEntity().func_70106_y();
                    }
                }
                if (((StargateClassicBaseTile)targetGatePos.getTileEntity()).isPhysicalIris()) {
                    AunisSoundHelper.playSoundEvent(packet.getTargetGatePos().getWorld(), targetGatePos.getTileEntity().getGateCenterPos(), SoundEventEnum.IRIS_HIT);
                } else if (((StargateClassicBaseTile)packet.getTargetGatePos().getTileEntity()).isShieldIris()) {
                    AunisSoundHelper.playSoundEvent(packet.getTargetGatePos().getWorld(), targetGatePos.getTileEntity().getGateCenterPos(), SoundEventEnum.SHIELD_HIT);
                }
                ItemStack irisItem = ((StargateClassicBaseTile)targetGatePos.getTileEntity()).getItemHandler().getStackInSlot(11);
                if (irisItem.func_77973_b() instanceof UpgradeIris) {
                    int chance = EnchantmentHelper.func_82781_a((ItemStack)irisItem).containsKey(Enchantments.field_185307_s) ? AunisConfig.irisConfig.unbreakingChance * EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)irisItem) : 0;
                    int random = randomGenerator.nextInt(100);
                    if (random > chance) {
                        AunisItems.UPGRADE_IRIS.setDamage(irisItem, AunisItems.UPGRADE_IRIS.getDamage(irisItem) + 1);
                    }
                    if (irisItem.func_190916_E() == 0) {
                        ((StargateClassicBaseTile)targetGatePos.getTileEntity()).updateIrisType();
                    }
                } else {
                    IEnergyStorage energyStorage = (IEnergyStorage)targetGatePos.getTileEntity().getCapability(CapabilityEnergy.ENERGY, null);
                    if (energyStorage != null) {
                        energyStorage.extractEnergy(500, false);
                    }
                }
                targetGatePos.getTileEntity().sendSignal(null, "stargate_event_iris_hit", "Something just hit the IRIS!");
            } else {
                AunisSoundHelper.playSoundEvent(this.world, this.gateCenter, SoundEventEnum.WORMHOLE_GO);
                packet.teleport();
            }
        }
        this.scheduledTeleportMap.remove(entityId);
    }

    public void removeEntity(int entityId) {
        this.scheduledTeleportMap.remove(entityId);
    }

    public void setMotion(int entityId, Vector2f motionVector) {
        this.scheduledTeleportMap.get(entityId).setMotion(motionVector);
    }
}

