/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.stargate.power;

import mrjake.aunis.config.AunisConfig;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.IEnergyStorage;

public class StargateItemEnergyStorage
implements IEnergyStorage {
    private final ItemStack stack;

    public StargateItemEnergyStorage(ItemStack stack) {
        this.stack = stack;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyStored = this.getEnergyStored();
        int energyReceived = Math.min(this.getMaxEnergyStored() - energyStored, Math.min(AunisConfig.powerConfig.stargateMaxEnergyTransfer, maxReceive));
        if (!simulate) {
            this.setEnergyStored(energyStored + energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (maxExtract > this.getEnergyStored()) {
            maxExtract = this.getEnergyStored();
        }
        if (!simulate) {
            this.setEnergyStored(this.getEnergyStored() - maxExtract);
        }
        return maxExtract;
    }

    public void setEnergyStored(int energy) {
        this.getOrCreateCompound(this.stack).func_74768_a("energy", energy);
    }

    public int getEnergyStored() {
        return this.getOrCreateCompound(this.stack).func_74762_e("energy");
    }

    public int getMaxEnergyStored() {
        return AunisConfig.powerConfig.stargateEnergyStorage / 4;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    private final NBTTagCompound getOrCreateCompound(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }
}

