/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.stargate.power;

import mrjake.aunis.config.AunisConfig;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.EnergyStorage;

public class StargateAbstractEnergyStorage
extends EnergyStorage
implements INBTSerializable<NBTTagCompound> {
    public StargateAbstractEnergyStorage() {
        super(AunisConfig.powerConfig.stargateEnergyStorage / 4, AunisConfig.powerConfig.stargateMaxEnergyTransfer, 0);
    }

    public StargateAbstractEnergyStorage(int capacity, int maxTransfer) {
        super(capacity, maxTransfer);
    }

    public StargateAbstractEnergyStorage(int capacity) {
        super(capacity, AunisConfig.powerConfig.stargateMaxEnergyTransfer);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74768_a("energy", this.energy);
        return tagCompound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt != null && nbt.func_74764_b("energy")) {
            this.energy = nbt.func_74762_e("energy");
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyReceived = super.receiveEnergy(maxReceive, simulate);
        if (energyReceived > 0) {
            this.onEnergyChanged();
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!simulate) {
            this.energy -= maxExtract;
            if (this.energy < 0) {
                this.energy = 0;
            }
            this.onEnergyChanged();
        } else if (maxExtract > this.energy) {
            maxExtract = this.energy;
        }
        return maxExtract;
    }

    public int receiveEnergyInternal(int maxReceive, boolean simulate) {
        int energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate && energyReceived > 0) {
            this.energy += energyReceived;
            this.onEnergyChanged();
        }
        return energyReceived;
    }

    public void setEnergyStored(int energyStored) {
        this.energy = Math.min(energyStored, this.capacity);
        this.onEnergyChanged();
    }

    protected void onEnergyChanged() {
    }
}

