/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.stargate.network;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import mrjake.aunis.datafixer.StargateNetworkReader18;
import mrjake.aunis.stargate.network.StargateAddress;
import mrjake.aunis.stargate.network.StargateAddressDynamic;
import mrjake.aunis.stargate.network.StargatePos;
import mrjake.aunis.stargate.network.SymbolMilkyWayEnum;
import mrjake.aunis.stargate.network.SymbolTypeEnum;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class StargateNetwork
extends WorldSavedData {
    private static final String DATA_NAME = "aunis_StargateNetworkData";
    private Map<SymbolTypeEnum, Map<StargateAddress, StargatePos>> stargateNetworkMap = new HashMap<SymbolTypeEnum, Map<StargateAddress, StargatePos>>();
    public static StargateAddressDynamic EARTH_ADDRESS = new StargateAddressDynamic(SymbolTypeEnum.MILKYWAY);
    private StargateAddress netherGateAddress;
    private StargateAddress lastActivatedOrlins;

    public StargateNetwork() {
        super(DATA_NAME);
        this.init();
    }

    public StargateNetwork(String dataName) {
        super(dataName);
        this.init();
    }

    private void init() {
        for (SymbolTypeEnum symbolType : SymbolTypeEnum.values()) {
            this.stargateNetworkMap.put(symbolType, new ConcurrentHashMap());
        }
    }

    private Map<StargateAddress, StargatePos> getMapFromAddress(StargateAddress address) {
        return this.stargateNetworkMap.get(address.getSymbolType());
    }

    public Map<SymbolTypeEnum, Map<StargateAddress, StargatePos>> getMap() {
        return this.stargateNetworkMap;
    }

    public boolean isStargateInNetwork(StargateAddress gateAddress) {
        return this.getMapFromAddress(gateAddress).containsKey(gateAddress);
    }

    @Nullable
    public StargatePos getStargate(StargateAddress address) {
        if (address == null) {
            return null;
        }
        return this.getMapFromAddress(address).get(address);
    }

    public void addStargate(StargateAddress gateAddress, StargatePos stargatePos) {
        if (gateAddress == null) {
            return;
        }
        this.getMapFromAddress(gateAddress).put(gateAddress, stargatePos);
        this.func_76185_a();
    }

    public void removeStargate(StargateAddress gateAddress) {
        if (gateAddress == null) {
            return;
        }
        this.getMapFromAddress(gateAddress).remove(gateAddress);
        this.func_76185_a();
    }

    public boolean hasNetherGate() {
        return this.netherGateAddress != null;
    }

    public void setNetherGate(StargateAddress address) {
        this.netherGateAddress = address;
        this.func_76185_a();
    }

    public void deleteNetherGate() {
        this.netherGateAddress = null;
        this.func_76185_a();
    }

    public StargateAddress getNetherGate() {
        return this.netherGateAddress;
    }

    public void setLastActivatedOrlins(StargateAddress address) {
        this.lastActivatedOrlins = address;
        this.func_76185_a();
    }

    public StargateAddress getLastActivatedOrlins() {
        return this.lastActivatedOrlins;
    }

    public void func_76184_a(NBTTagCompound compound) {
        if (compound.func_74764_b("size")) {
            StargateNetworkReader18.readOldMap(compound, this);
        }
        NBTTagList stargateTagList = compound.func_150295_c("stargates", 10);
        for (NBTBase baseTag : stargateTagList) {
            NBTTagCompound stargateCompound = (NBTTagCompound)baseTag;
            StargateAddress stargateAddress = new StargateAddress(stargateCompound.func_74775_l("address"));
            StargatePos stargatePos = new StargatePos(stargateAddress.getSymbolType(), stargateCompound.func_74775_l("pos"));
            this.getMapFromAddress(stargateAddress).put(stargateAddress, stargatePos);
        }
        if (compound.func_74764_b("netherGateAddress")) {
            this.netherGateAddress = new StargateAddress(compound.func_74775_l("netherGateAddress"));
        }
        if (compound.func_74764_b("lastActivatedOrlins")) {
            this.lastActivatedOrlins = new StargateAddress(compound.func_74775_l("lastActivatedOrlins"));
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList stargateTagList = new NBTTagList();
        for (Map<StargateAddress, StargatePos> stargateMap : this.stargateNetworkMap.values()) {
            for (Map.Entry<StargateAddress, StargatePos> stargateEntry : stargateMap.entrySet()) {
                NBTTagCompound stargateCompound = new NBTTagCompound();
                stargateCompound.func_74782_a("address", (NBTBase)stargateEntry.getKey().serializeNBT());
                stargateCompound.func_74782_a("pos", (NBTBase)stargateEntry.getValue().serializeNBT());
                stargateTagList.func_74742_a((NBTBase)stargateCompound);
            }
        }
        compound.func_74782_a("stargates", (NBTBase)stargateTagList);
        if (this.netherGateAddress != null) {
            compound.func_74782_a("netherGateAddress", (NBTBase)this.netherGateAddress.serializeNBT());
        }
        if (this.lastActivatedOrlins != null) {
            compound.func_74782_a("lastActivatedOrlins", (NBTBase)this.lastActivatedOrlins.serializeNBT());
        }
        return compound;
    }

    public static StargateNetwork get(World world) {
        MapStorage storage = world.func_175693_T();
        StargateNetwork instance = (StargateNetwork)storage.func_75742_a(StargateNetwork.class, DATA_NAME);
        if (instance == null) {
            instance = new StargateNetwork();
            storage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
        }
        return instance;
    }

    static {
        EARTH_ADDRESS.addSymbol(SymbolMilkyWayEnum.AURIGA);
        EARTH_ADDRESS.addSymbol(SymbolMilkyWayEnum.CETUS);
        EARTH_ADDRESS.addSymbol(SymbolMilkyWayEnum.CENTAURUS);
        EARTH_ADDRESS.addSymbol(SymbolMilkyWayEnum.CANCER);
        EARTH_ADDRESS.addSymbol(SymbolMilkyWayEnum.SCUTUM);
        EARTH_ADDRESS.addSymbol(SymbolMilkyWayEnum.ERIDANUS);
    }
}

