/*
 * Decompiled with CFR 0.152.
 */
package mrjake.aunis.stargate.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mrjake.aunis.Aunis;
import mrjake.aunis.stargate.network.StargateAddressDynamic;
import mrjake.aunis.stargate.network.SymbolInterface;
import mrjake.aunis.stargate.network.SymbolTypeEnum;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public class StargateAddress
implements INBTSerializable<NBTTagCompound> {
    protected SymbolTypeEnum symbolType;
    protected List<SymbolInterface> address = new ArrayList<SymbolInterface>(8);

    public StargateAddress(SymbolTypeEnum symbolType) {
        this.symbolType = symbolType;
    }

    public StargateAddress(NBTTagCompound compound) {
        this.deserializeNBT(compound);
    }

    protected int getSavedSymbols() {
        return 8;
    }

    public SymbolTypeEnum getSymbolType() {
        return this.symbolType;
    }

    public StargateAddress generate(Random random) {
        if (!this.address.isEmpty()) {
            Aunis.logger.error("Tried to regenerate address already containing symbols");
            return this;
        }
        while (this.address.size() < 8) {
            SymbolInterface symbol = this.symbolType.getRandomSymbol(random);
            if (this.address.contains(symbol)) continue;
            this.address.add(symbol);
        }
        return this;
    }

    public SymbolInterface get(int pos) {
        return this.address.get(pos);
    }

    public SymbolInterface getLast() {
        if (this.address.size() == 0) {
            return null;
        }
        return this.address.get(this.address.size() - 1);
    }

    public int getSize() {
        return this.address.size();
    }

    public List<String> getNameList() {
        ArrayList<String> out = new ArrayList<String>(this.address.size());
        for (SymbolInterface symbol : this.address) {
            out.add(symbol.getEnglishName());
        }
        return out;
    }

    public List<SymbolInterface> subList(int start, int end) {
        return this.address.subList(start, end);
    }

    public List<SymbolInterface> getAdditional() {
        return this.address.subList(6, 8);
    }

    public boolean hasAddress() {
        return this.address.size() > 0;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("symbolType", this.symbolType.id);
        for (int i = 0; i < this.getSavedSymbols(); ++i) {
            compound.func_74768_a("symbol" + i, this.address.get(i).getId());
        }
        return compound;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        if (!this.address.isEmpty()) {
            Aunis.logger.error("Tried to deserialize address already containing symbols");
            return;
        }
        this.symbolType = SymbolTypeEnum.valueOf(compound.func_74762_e("symbolType"));
        for (int i = 0; i < this.getSavedSymbols(); ++i) {
            this.address.add(this.symbolType.valueOfSymbol(compound.func_74762_e("symbol" + i)));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.symbolType.id);
        for (int i = 0; i < this.getSavedSymbols(); ++i) {
            buf.writeByte(this.address.get(i).getId());
        }
    }

    public void fromBytes(ByteBuf buf) {
        if (!this.address.isEmpty()) {
            Aunis.logger.error("Tried to deserialize address already containing symbols");
            return;
        }
        this.symbolType = SymbolTypeEnum.valueOf(buf.readByte());
        for (int i = 0; i < this.getSavedSymbols(); ++i) {
            this.address.add(this.symbolType.valueOfSymbol(buf.readByte()));
        }
    }

    public String toString() {
        return this.address.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.subList(0, 6).hashCode());
        result = 31 * result + (this.symbolType == null ? 0 : this.symbolType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StargateAddress)) {
            return false;
        }
        StargateAddress other = (StargateAddress)obj;
        if (this.address == null) {
            if (other.address != null) {
                return false;
            }
        } else {
            if (this.address.size() < 7) {
                return false;
            }
            if (other.address.size() < 7) {
                return false;
            }
            if (!this.address.subList(0, 6).equals(other.address.subList(0, 6))) {
                return false;
            }
        }
        return this.symbolType == other.symbolType;
    }

    public boolean equalsV2(StargateAddressDynamic address) {
        for (int i = 0; i < address.getSize(); ++i) {
            if (this.address.size() >= i + 1) {
                if (this.address.get(i) == address.get(i)) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

